/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.crypto.asymmetric;

import cn.hutool.crypto.CryptoException;
import cn.hutool.crypto.SecureUtil;
import cn.hutool.crypto.asymmetric.AbstractAsymmetricCrypto;
import cn.hutool.crypto.asymmetric.KeyType;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.PublicKey;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.engines.SM2Engine;
import org.bouncycastle.crypto.params.ParametersWithID;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.crypto.signers.SM2Signer;
import org.bouncycastle.jcajce.provider.asymmetric.util.ECUtil;

public class SM2
extends AbstractAsymmetricCrypto<SM2> {
    private static final String ALGORITHM_SM2 = "SM2";
    protected SM2Engine engine;
    protected SM2Signer signer;

    public SM2() {
        this((byte[])null, (byte[])null);
    }

    public SM2(String privateKeyStr, String publicKeyStr) {
        this(SecureUtil.decodeKey(privateKeyStr), SecureUtil.decodeKey(publicKeyStr));
    }

    public SM2(byte[] privateKey, byte[] publicKey) {
        this(SecureUtil.generatePrivateKey(ALGORITHM_SM2, privateKey), SecureUtil.generatePublicKey(ALGORITHM_SM2, publicKey));
    }

    public SM2(PrivateKey privateKey, PublicKey publicKey) {
        super(ALGORITHM_SM2, privateKey, publicKey);
    }

    public SM2 init(PrivateKey privateKey, PublicKey publicKey) {
        return (SM2)this.init(ALGORITHM_SM2, privateKey, publicKey);
    }

    @Override
    public byte[] encrypt(byte[] data, KeyType keyType) throws CryptoException {
        this.lock.lock();
        if (null == this.engine) {
            this.engine = new SM2Engine();
        }
        SM2Engine engine = this.engine;
        try {
            engine.init(true, (CipherParameters)new ParametersWithRandom(this.generateCipherParameters(keyType)));
            byte[] byArray = engine.processBlock(data, 0, data.length);
            return byArray;
        }
        catch (Exception e) {
            throw new CryptoException(e);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public byte[] decrypt(byte[] data, KeyType keyType) throws CryptoException {
        this.lock.lock();
        if (null == this.engine) {
            this.engine = new SM2Engine();
        }
        SM2Engine engine = this.engine;
        try {
            engine.init(false, this.generateCipherParameters(keyType));
            byte[] byArray = engine.processBlock(data, 0, data.length);
            return byArray;
        }
        catch (Exception e) {
            throw new CryptoException(e);
        }
        finally {
            this.lock.unlock();
        }
    }

    public byte[] sign(byte[] data) {
        return this.sign(data, null);
    }

    public byte[] sign(byte[] data, byte[] id) {
        this.lock.lock();
        if (null == this.signer) {
            this.signer = new SM2Signer();
        }
        SM2Signer signer = this.signer;
        try {
            ParametersWithRandom param = new ParametersWithRandom(this.generateCipherParameters(KeyType.PrivateKey));
            if (id != null) {
                param = new ParametersWithID((CipherParameters)param, id);
            }
            signer.init(true, (CipherParameters)param);
            signer.update(data, 0, data.length);
            byte[] byArray = signer.generateSignature();
            return byArray;
        }
        catch (Exception e) {
            throw new CryptoException(e);
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean verify(byte[] data, byte[] sign) {
        return this.verify(data, sign, null);
    }

    public boolean verify(byte[] data, byte[] sign, byte[] id) {
        this.lock.lock();
        if (null == this.signer) {
            this.signer = new SM2Signer();
        }
        SM2Signer signer = this.signer;
        try {
            CipherParameters param = this.generateCipherParameters(KeyType.PublicKey);
            if (id != null) {
                param = new ParametersWithID(param, id);
            }
            signer.init(false, param);
            signer.update(data, 0, data.length);
            boolean bl = signer.verifySignature(sign);
            return bl;
        }
        catch (Exception e) {
            throw new CryptoException(e);
        }
        finally {
            this.lock.unlock();
        }
    }

    private CipherParameters generateCipherParameters(KeyType keyType) {
        try {
            switch (keyType) {
                case PublicKey: {
                    return ECUtil.generatePublicKeyParameter((PublicKey)this.publicKey);
                }
                case PrivateKey: {
                    return ECUtil.generatePrivateKeyParameter((PrivateKey)this.privateKey);
                }
            }
        }
        catch (InvalidKeyException e) {
            throw new CryptoException(e);
        }
        return null;
    }
}

