/*
 * Decompiled with CFR 0.152.
 */
package com.byh.auth.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.byh.auth.entity.SysMenuEntity;
import com.byh.auth.entity.vo.menu.SysMenuVo;
import com.byh.auth.mapper.SysMenuMapper;
import com.byh.auth.mapper.SysUserMapper;
import com.byh.auth.service.MenuService;
import com.byh.auth.util.BeanUtil;
import com.byh.auth.util.CommonRequest;
import com.byh.auth.util.TreeUtils;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MenuServiceImpl
implements MenuService {
    @Resource
    private SysMenuMapper sysMenuMapper;
    @Resource
    private SysUserMapper sysUserMapper;
    @Autowired
    private CommonRequest commonRequest;

    public List<SysMenuVo> getUserMenu(Integer id, Integer tenantId) {
        List sysMenuList = this.sysMenuMapper.selectList((Wrapper)Wrappers.lambdaQuery().eq(SysMenuEntity::getDelFlag, (Object)"0"));
        List sysMenuVoList = BeanUtil.copyList((List)sysMenuList, SysMenuVo.class);
        List powerList = this.sysUserMapper.getUserPower(id, this.commonRequest.getTenant());
        List menuList = TreeUtils.recursionMenu((List)sysMenuVoList, (List)powerList);
        List temp = sysMenuVoList.stream().filter(n -> "home".equals(n.getPermission())).collect(Collectors.toList());
        menuList.addAll(temp);
        return menuList;
    }

    public List<SysMenuVo> getAdminMenu(Integer tenantId) {
        List sysMenuList = this.sysMenuMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysMenuEntity::getDelFlag, (Object)"0")).eq(SysMenuEntity::getTenantId, (Object)tenantId));
        List sysMenuVoList = BeanUtil.copyList((List)sysMenuList, SysMenuVo.class);
        List parentList = sysMenuVoList.stream().filter(n -> 0 == Integer.parseInt(n.getParentId())).collect(Collectors.toList());
        Map<String, List<SysMenuVo>> mapList = sysMenuVoList.stream().collect(Collectors.groupingBy(SysMenuVo::getParentId));
        List menuList = TreeUtils.setChildren(mapList, parentList);
        return menuList;
    }
}

