/*
 * Decompiled with CFR 0.152.
 */
package com.byh.server.controller;

import com.byh.server.pojo.dto.QueryCartDto;
import com.byh.server.pojo.vo.QueryCartItemVo;
import com.byh.server.pojo.vo.SaveCartItemVo;
import com.byh.server.service.CartItemService;
import com.ebaiyihui.framework.response.BaseResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/server/cart-item"})
@Api(tags={"\u8d2d\u7269\u8f66\u7ba1\u7406API"})
public class CartItemController {
    @Autowired
    private CartItemService cartItemService;

    @ApiOperation(value="\u67e5\u8be2\u7528\u6237\u7684\u8d2d\u7269\u8f66\u8be6\u60c5")
    @PostMapping(value={"/select-cart-item-by-user"})
    BaseResponse<QueryCartDto> selectCartItemByUser(@RequestBody @Validated QueryCartItemVo queryCartItemVo) {
        QueryCartDto queryCartDto = this.cartItemService.selectCartItemByUser(queryCartItemVo);
        return BaseResponse.success((Object)queryCartDto);
    }

    @ApiOperation(value="\u4fdd\u5b58\u7528\u6237\u8d2d\u7269\u8f66\u8be6\u60c5\u9879")
    @PostMapping(value={"/save-cart-item"})
    BaseResponse<String> saveCartItem(@RequestBody @Validated SaveCartItemVo saveCartItemVo) {
        String str = this.cartItemService.saveCartItem(saveCartItemVo);
        return BaseResponse.success((Object)str);
    }

    @ApiOperation(value="\u5220\u9664\u7528\u6237\u8d2d\u7269\u8f66\u8be6\u60c5\u9879")
    @PostMapping(value={"/delete-cart-item"})
    BaseResponse<String> deleteCartItem(@RequestBody List<Long> cartItemIdList) {
        String str = this.cartItemService.deleteCartItem(cartItemIdList);
        return BaseResponse.success((Object)str);
    }

    @ApiOperation(value="\u4fee\u6539\u7528\u6237\u8d2d\u7269\u8f66\u8be6\u60c5\u9879\u6570\u91cf")
    @GetMapping(value={"/update-cart-item-count"})
    BaseResponse updateCartItemCount(@RequestParam(value="cartItemId", required=true) Long cartItemId, @RequestParam(value="count", required=true) int count) {
        this.cartItemService.updateCartItemCount(cartItemId, count);
        return BaseResponse.success();
    }
}

