/*
 * Decompiled with CFR 0.152.
 */
package com.byh.server.controller;

import com.byh.server.pojo.dto.QueryUserAddressDto;
import com.byh.server.pojo.vo.SaveUserAddressVo;
import com.byh.server.pojo.vo.UpdateUserAddressVo;
import com.byh.server.service.UserAddressService;
import com.ebaiyihui.framework.response.BaseResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/server/user-address"})
@Api(tags={"\u7528\u6237\u5730\u5740\u7ba1\u7406API"})
public class UserAddressController {
    @Autowired
    private UserAddressService userAddressService;

    @PostMapping(value={"/save/user/address"})
    @ApiOperation(value="\u7528\u6237\u65b0\u589e\u5730\u5740\u4fe1\u606f")
    public BaseResponse<String> saveUserAddress(@RequestBody @Validated SaveUserAddressVo saveUserAddressVo) {
        String ret = this.userAddressService.saveUserAddress(saveUserAddressVo);
        return BaseResponse.success((Object)ret);
    }

    @GetMapping(value={"/select/user/address/by/userId"})
    @ApiOperation(value="\u83b7\u53d6\u7528\u6237\u7684\u5730\u5740\u5217\u8868")
    public BaseResponse<List<QueryUserAddressDto>> selectUserAddressByUserId(@RequestParam(value="userId") Long userId) {
        List queryUserAddressDtoList = this.userAddressService.selectUserAddressByUserId(userId);
        return BaseResponse.success((Object)queryUserAddressDtoList);
    }

    @GetMapping(value={"/select/user/address/by/id"})
    @ApiOperation(value="\u6839\u636e\u5730\u5740\u552f\u4e00\u6807\u8bc6\u83b7\u53d6\u5730\u5740\u8be6\u60c5")
    public BaseResponse<QueryUserAddressDto> selectUserAddressByAddrId(@RequestParam(value="addrId") Long addrId) {
        QueryUserAddressDto queryUserAddressDto = this.userAddressService.selectUserAddressByAddrId(addrId);
        if (Objects.isNull(queryUserAddressDto)) {
            return BaseResponse.error((String)"\u7528\u6237\u5730\u5740\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        return BaseResponse.success((Object)queryUserAddressDto);
    }

    @GetMapping(value={"/delete/user/address"})
    @ApiOperation(value="\u5220\u9664\u7528\u6237\u5730\u5740\u4fe1\u606f")
    public BaseResponse<String> deleteUserAddress(@RequestParam(value="addrId") Long addrId) {
        String str = this.userAddressService.deleteUserAddress(addrId);
        return BaseResponse.success((Object)str);
    }

    @GetMapping(value={"/update/user/address/isDefault"})
    @ApiOperation(value="\u7528\u6237\u4fee\u6539\u5730\u5740\u4e3a\u9ed8\u8ba4/\u975e\u9ed8\u8ba4")
    public BaseResponse<String> updateUserAddressIsDefault(@RequestParam(value="addrId") Long addrId, @RequestParam(value="isDefault") Integer isDefault) {
        String str = this.userAddressService.updateUserAddressIsDefault(addrId, isDefault);
        return BaseResponse.success((Object)str);
    }

    @PostMapping(value={"/update/user/address"})
    @ApiOperation(value="\u7528\u6237\u4fee\u6539\u5730\u5740\u4fe1\u606f")
    public BaseResponse<String> updateUserAddress(@RequestBody @Validated UpdateUserAddressVo updateUserAddressVo) {
        String str = this.userAddressService.updateUserAddress(updateUserAddressVo);
        return BaseResponse.success((Object)str);
    }
}

