/*
 * Decompiled with CFR 0.152.
 */
package com.byh.server.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.byh.server.mapper.AppointmentMapper;
import com.byh.server.mapper.OrderMapper;
import com.byh.server.mapper.ProductMapper;
import com.byh.server.mapper.ProductSubitemMapper;
import com.byh.server.mapper.UserAddressMapper;
import com.byh.server.pojo.dto.AppointmentListDto;
import com.byh.server.pojo.dto.AppointmentListPageDto;
import com.byh.server.pojo.dto.DetailAppointmentAddressDto;
import com.byh.server.pojo.dto.DetailAppointmentDto;
import com.byh.server.pojo.dto.DetailAppointmentOrderDto;
import com.byh.server.pojo.dto.DetailAppointmentProductDto;
import com.byh.server.pojo.dto.DetailAppointmentUseRecordDto;
import com.byh.server.pojo.entity.Appointment;
import com.byh.server.pojo.entity.Order;
import com.byh.server.pojo.entity.Product;
import com.byh.server.pojo.entity.ProductSubitem;
import com.byh.server.pojo.entity.UserAddress;
import com.byh.server.pojo.enums.AppointmentStatusEnum;
import com.byh.server.pojo.enums.OrderStatusEnum;
import com.byh.server.pojo.vo.AppointmentDoctorVo;
import com.byh.server.pojo.vo.AppointmentListVo;
import com.byh.server.pojo.vo.SaveAppointmentVo;
import com.byh.server.service.AppointmentService;
import com.byh.server.utils.UniqueKeyGenerator;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AppointmentServiceImpl
extends ServiceImpl<AppointmentMapper, Appointment>
implements AppointmentService {
    @Autowired
    private AppointmentMapper appointmentMapper;
    @Autowired
    private OrderMapper orderMapper;
    @Autowired
    private ProductSubitemMapper productSubitemMapper;
    @Autowired
    private ProductMapper productMapper;
    @Autowired
    private UserAddressMapper userAddressMapper;

    @Transactional(rollbackFor={Exception.class})
    public String doctorNotAuditAppointment(Long appointmentId) {
        Appointment appointment = new Appointment();
        appointment.setId(appointmentId);
        appointment.setStatus(AppointmentStatusEnum.APPOINTMENT_STATUS_YTK.getValue());
        this.appointmentMapper.updateById((Object)appointment);
        Appointment selectById = (Appointment)this.appointmentMapper.selectById((Serializable)appointmentId);
        Order order = (Order)this.orderMapper.selectById((Serializable)selectById.getId());
        Order orderDb = new Order();
        orderDb.setId(order.getId());
        orderDb.setStatus(OrderStatusEnum.ORDER_STATUS_YTK.getValue());
        this.orderMapper.updateById((Object)orderDb);
        return null;
    }

    public String doctorAuditAppointment(Long appointmentId) {
        Appointment appointment = new Appointment();
        appointment.setId(appointmentId);
        appointment.setStatus(AppointmentStatusEnum.APPOINTMENT_STATUS_DFW.getValue());
        this.appointmentMapper.updateById((Object)appointment);
        return null;
    }

    public String doctorRobAppointment(AppointmentDoctorVo appointmentDoctorVo) {
        Appointment appointment = new Appointment();
        BeanUtils.copyProperties((Object)appointmentDoctorVo, (Object)appointment);
        appointment.setId(appointmentDoctorVo.getAppointmentId());
        this.appointmentMapper.updateById((Object)appointment);
        return null;
    }

    public String doctorStartAppointment(Long appointmentId) {
        Appointment appointment = new Appointment();
        appointment.setId(appointmentId);
        appointment.setServerBeginTime(this.getDate());
        this.appointmentMapper.updateById((Object)appointment);
        return null;
    }

    @Transactional(rollbackFor={Exception.class})
    public String doctorEndAppointment(Long appointmentId) {
        int count = 0;
        Appointment appointment = new Appointment();
        appointment.setId(appointmentId);
        appointment.setServerEndTime(this.getDate());
        this.appointmentMapper.updateById((Object)appointment);
        Appointment appointmentDb = (Appointment)this.appointmentMapper.selectById((Serializable)appointmentId);
        Order order = (Order)this.orderMapper.selectById((Serializable)appointmentDb.getServiceOrderId());
        List appointmentList = this.appointmentMapper.selectList((Wrapper)new QueryWrapper().eq((Object)"service_order_id", (Object)order.getId()));
        boolean isEnd = true;
        for (Appointment appoint : appointmentList) {
            if (!AppointmentStatusEnum.APPOINTMENT_STATUS_DFW.getValue().equals(appoint.getStatus()) && !AppointmentStatusEnum.APPOINTMENT_STATUS_FWZ.getValue().equals(appoint.getStatus())) continue;
            isEnd = false;
        }
        if (count >= order.getQuantity() && isEnd) {
            Order orderDb = new Order();
            orderDb.setId(order.getId());
            orderDb.setStatus(OrderStatusEnum.ORDER_STATUS_YWC.getValue());
            this.orderMapper.updateById((Object)orderDb);
        }
        return null;
    }

    public String doctorIsCommunication(Long appointmentId, int communicate) {
        Appointment appointment = new Appointment();
        appointment.setId(appointmentId);
        appointment.setCommunicate(Integer.valueOf(communicate));
        this.appointmentMapper.updateById((Object)appointment);
        return null;
    }

    public String userSaveAppointment(SaveAppointmentVo saveAppointmentVo) {
        int count = 0;
        List appointmentList = this.appointmentMapper.selectList((Wrapper)new QueryWrapper().eq((Object)"service_order_id", (Object)saveAppointmentVo.getServiceOrderId()));
        for (Appointment appoint : appointmentList) {
            if (!AppointmentStatusEnum.APPOINTMENT_STATUS_DSH.getValue().equals(appoint.getStatus())) continue;
            return "\u8ba2\u5355\u5ba1\u6838\u901a\u8fc7\u540e\u53ef\u518d\u6b21\u9884\u7ea6";
        }
        Order order = (Order)this.orderMapper.selectById((Serializable)saveAppointmentVo.getServiceOrderId());
        if (count >= order.getQuantity()) {
            return "\u8ba2\u5355\u53ef\u4f7f\u7528\u6b21\u6570\u5df2\u7528\u5b8c,\u8bf7\u91cd\u65b0\u8d2d\u4e70";
        }
        Appointment appointment = new Appointment();
        BeanUtils.copyProperties((Object)saveAppointmentVo, (Object)appointment);
        appointment.setViewId(UniqueKeyGenerator.generateViewId().toString());
        appointment.setStatus(AppointmentStatusEnum.APPOINTMENT_STATUS_DFW.getValue());
        this.appointmentMapper.insert((Object)appointment);
        int quantity = order.getQuantity();
        Order orderDb = new Order();
        orderDb.setId(order.getId());
        orderDb.setQuantity(Integer.valueOf(quantity--));
        this.orderMapper.updateById((Object)orderDb);
        return null;
    }

    public String userCancelAppointment(Long appointmentId) {
        Appointment appointment = (Appointment)this.appointmentMapper.selectById((Serializable)appointmentId);
        if (AppointmentStatusEnum.APPOINTMENT_STATUS_FWZ.getValue().equals(appointment.getStatus())) {
            return "\u672c\u6b21\u670d\u52a1\u5df2\u5f00\u59cb,\u65e0\u6cd5\u53d6\u6d88";
        }
        return null;
    }

    public AppointmentListPageDto getListAppointment(AppointmentListVo appointmentListVo) {
        AppointmentListPageDto appointmentListPageDto = new AppointmentListPageDto();
        QueryWrapper appointmentQueryWrapper = new QueryWrapper();
        if (StringUtils.isNotEmpty((CharSequence)appointmentListVo.getAppointmentTimeBegin()) && StringUtils.isNotEmpty((CharSequence)appointmentListVo.getAppointmentTimeEnd())) {
            appointmentQueryWrapper.between((Object)"appointment_time", (Object)appointmentListVo.getAppointmentTimeBegin(), (Object)appointmentListVo.getAppointmentTimeEnd());
        }
        if (appointmentListVo.getAppointmentStatus() != null && appointmentListVo.getAppointmentStatus() != 0) {
            appointmentQueryWrapper.eq((Object)"status", (Object)appointmentListVo.getAppointmentStatus());
        }
        List appointments = this.appointmentMapper.selectList((Wrapper)appointmentQueryWrapper);
        ArrayList<AppointmentListDto> appointmentListDtos = new ArrayList<AppointmentListDto>();
        for (Appointment appointment : appointments) {
            Order order = (Order)this.orderMapper.selectById((Serializable)appointment.getServiceOrderId());
            ProductSubitem productSubitem = this.productSubitemMapper.selectById(order.getProductSubitemId());
            Product product = (Product)this.productMapper.selectById((Serializable)order.getProductId());
            AppointmentListDto appointmentListDto2 = new AppointmentListDto();
            appointmentListDto2.setAppointmentTime(appointment.getAppointmentTime());
            appointmentListDto2.setAppointmentStatus(appointment.getStatus());
            appointmentListDto2.setAppointmentViewId(appointment.getViewId());
            appointmentListDto2.setAppointmentDoctorName(appointment.getDoctorName());
            appointmentListDto2.setPatientName(order.getPatientName());
            appointmentListDto2.setPatientPhone(order.getPatientPhone());
            appointmentListDto2.setProductName(product.getName());
            appointmentListDto2.setMaterialName(productSubitem.getMaterialName());
            appointmentListDto2.setSpecificationValueName(productSubitem.getSpecificationValueName());
            appointmentListDtos.add(appointmentListDto2);
        }
        List appointmentListDtoList = appointmentListDtos.stream().filter(appointmentListDto -> appointmentListDto.getAppointmentViewId().contains(appointmentListVo.getSearch()) || appointmentListDto.getAppointmentDoctorName().contains(appointmentListVo.getSearch()) || appointmentListDto.getPatientName().contains(appointmentListVo.getSearch()) || appointmentListDto.getPatientPhone().contains(appointmentListVo.getSearch()) || appointmentListDto.getProductName().contains(appointmentListVo.getSearch())).collect(Collectors.toList());
        List appointmentListDtoLists = appointmentListDtoList.stream().skip(appointmentListVo.getPageIndex() * appointmentListVo.getPageSize()).limit(appointmentListVo.getPageSize()).collect(Collectors.toList());
        Integer fForServiceNum = appointmentListDtoList.stream().filter(appointmentListDto -> appointmentListDto.getAppointmentStatus() == 10).collect(Collectors.toList()).size();
        appointmentListPageDto.setAppointmentListDtoList(appointmentListDtoLists);
        appointmentListPageDto.setPageIndex(appointmentListVo.getPageIndex());
        appointmentListPageDto.setPageSize(appointmentListVo.getPageSize());
        appointmentListPageDto.setTotal(Integer.valueOf(appointmentListDtoList.size()));
        BigDecimal bigDecimal = new BigDecimal(appointmentListDtoList.size());
        BigDecimal bigDecimal1 = new BigDecimal(appointmentListVo.getPageSize());
        BigDecimal divide = bigDecimal.divide(bigDecimal1);
        double ceil = Math.ceil(Double.valueOf(divide.toString()));
        appointmentListPageDto.setPageNum(Integer.valueOf(Integer.parseInt(String.valueOf(ceil))));
        appointmentListPageDto.setForServiceNum(fForServiceNum);
        return appointmentListPageDto;
    }

    public DetailAppointmentDto detailAppointment(String appointmentViewId) {
        DetailAppointmentDto detailAppointmentDto = new DetailAppointmentDto();
        QueryWrapper appointmentQueryWrapper = (QueryWrapper)new QueryWrapper().eq((Object)"view_id", (Object)appointmentViewId);
        Appointment appointment = (Appointment)this.appointmentMapper.selectOne((Wrapper)appointmentQueryWrapper);
        Order order = (Order)this.orderMapper.selectById((Serializable)appointment.getServiceOrderId());
        DetailAppointmentOrderDto detailAppointmentOrderDto = new DetailAppointmentOrderDto();
        detailAppointmentOrderDto.setCreateTime(order.getCreateTime());
        detailAppointmentOrderDto.setOrderViewId(order.getViewId());
        detailAppointmentOrderDto.setOrderStatus(order.getStatus());
        detailAppointmentOrderDto.setMedicalCertificate(order.getMedicalCertificate());
        detailAppointmentOrderDto.setServerResidueNum(order.getServerResidueNum());
        detailAppointmentOrderDto.setServerTotalNum(order.getServerTotalNum());
        detailAppointmentOrderDto.setPatientId(order.getPatientId());
        detailAppointmentOrderDto.setPatientName(order.getPatientName());
        detailAppointmentOrderDto.setPatientAge(order.getPatientAge());
        detailAppointmentOrderDto.setPatientSex(order.getPatientSex());
        detailAppointmentOrderDto.setPatientPhone(order.getPatientPhone());
        detailAppointmentOrderDto.setAppointmentRemark(appointment.getRemark());
        detailAppointmentDto.setDetailAppointmentOrderDto(detailAppointmentOrderDto);
        Product product = (Product)this.productMapper.selectById((Serializable)order.getProductId());
        ProductSubitem productSubitem = this.productSubitemMapper.selectById(order.getProductSubitemId());
        DetailAppointmentProductDto detailAppointmentProductDto = new DetailAppointmentProductDto();
        detailAppointmentProductDto.setProductId(product.getId());
        detailAppointmentProductDto.setProductName(product.getName());
        detailAppointmentProductDto.setProductImage(product.getImage());
        detailAppointmentProductDto.setMaterialName(productSubitem.getMaterialName());
        detailAppointmentProductDto.setSpecificationValueName(productSubitem.getSpecificationValueName());
        detailAppointmentProductDto.setUsefulLife(productSubitem.getUsefulLife());
        detailAppointmentDto.setDetailAppointmentProductDto(detailAppointmentProductDto);
        UserAddress userAddress = (UserAddress)this.userAddressMapper.selectById((Serializable)order.getUserAddressId());
        DetailAppointmentAddressDto detailAppointmentAddressDto = new DetailAppointmentAddressDto();
        detailAppointmentAddressDto.setAddress(userAddress.getAddress());
        detailAppointmentAddressDto.setCustomAddress(userAddress.getCustomAddress());
        detailAppointmentDto.setDetailAppointmentAddressDto(detailAppointmentAddressDto);
        QueryWrapper queryWrapper = (QueryWrapper)new QueryWrapper().eq((Object)"service_order_id", (Object)order.getId());
        List appointmentS = this.appointmentMapper.selectList((Wrapper)queryWrapper);
        ArrayList<DetailAppointmentUseRecordDto> list = new ArrayList<DetailAppointmentUseRecordDto>();
        for (Appointment appointmentEntity : appointmentS) {
            DetailAppointmentUseRecordDto detailAppointmentUseRecordDto = new DetailAppointmentUseRecordDto();
            detailAppointmentUseRecordDto.setUseRecordViewId(appointmentEntity.getViewId());
            detailAppointmentUseRecordDto.setUseRecordStatus(appointmentEntity.getStatus());
            detailAppointmentUseRecordDto.setUseRecordAppointmentTime(appointmentEntity.getAppointmentTime());
            detailAppointmentUseRecordDto.setUseRecordDoctorId(appointmentEntity.getDoctorId());
            detailAppointmentUseRecordDto.setUseRecordDoctorName(appointmentEntity.getDoctorName());
            detailAppointmentUseRecordDto.setServerBeginTime(appointmentEntity.getServerBeginTime());
            detailAppointmentUseRecordDto.setServerEndTime(appointmentEntity.getServerEndTime());
            list.add(detailAppointmentUseRecordDto);
        }
        detailAppointmentDto.setDetailAppointmentUseRecordDtoList(list);
        return detailAppointmentDto;
    }

    private String getDate() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
        return simpleDateFormat.format(new Date());
    }
}

