/*
 * Decompiled with CFR 0.152.
 */
package com.byh.server.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.byh.server.config.HospitalConfig;
import com.byh.server.mapper.CartItemMapper;
import com.byh.server.mapper.ProductSubitemMapper;
import com.byh.server.pojo.dto.QueryCartDto;
import com.byh.server.pojo.dto.QueryCartItemDto;
import com.byh.server.pojo.entity.Cart;
import com.byh.server.pojo.entity.CartItem;
import com.byh.server.pojo.entity.ProductSubitem;
import com.byh.server.pojo.vo.QueryCartItemVo;
import com.byh.server.pojo.vo.SaveCartItemVo;
import com.byh.server.service.CartItemService;
import com.byh.server.service.CartService;
import com.byh.server.utils.DistanceUtil;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class CartItemServiceImpl
extends ServiceImpl<CartItemMapper, CartItem>
implements CartItemService {
    private static final Logger log = LoggerFactory.getLogger(CartItemServiceImpl.class);
    @Autowired
    private CartService cartService;
    @Autowired
    private CartItemMapper cartItemMapper;
    @Autowired
    private ProductSubitemMapper productSubitemMapper;

    public QueryCartDto selectCartItemByUser(QueryCartItemVo queryCartItemVo) {
        QueryCartDto queryCartDto = new QueryCartDto();
        Cart cart = this.cartService.saveCart(queryCartItemVo.getUserId());
        List cartItemList = this.cartItemMapper.selectList((Wrapper)new QueryWrapper().eq((Object)"cart_id", (Object)cart.getId()));
        if (CollectionUtils.isEmpty((Collection)cartItemList)) {
            return queryCartDto;
        }
        double distance = 0.0;
        if (queryCartItemVo.getLat() != null && queryCartItemVo.getLng() != null) {
            distance = DistanceUtil.distance((double)queryCartItemVo.getLat(), (double)queryCartItemVo.getLng(), (double)HospitalConfig.HOS_LAT, (double)HospitalConfig.HOS_LNG);
        }
        BigDecimal tripPrice = new BigDecimal("0");
        if (distance != 0.0) {
            if (distance > 10000.0) {
                queryCartDto.setIsDistribution(Integer.valueOf(3));
            } else if (distance < 5000.0) {
                queryCartDto.setIsDistribution(Integer.valueOf(1));
            } else {
                queryCartDto.setIsDistribution(Integer.valueOf(2));
                BigDecimal subtract = BigDecimal.valueOf(distance).subtract(new BigDecimal(5000.0)).divide(new BigDecimal("1000"), 0, RoundingMode.HALF_UP);
                tripPrice = tripPrice.add(subtract.multiply(new BigDecimal(12)));
            }
        }
        ArrayList<QueryCartItemDto> queryCartItemDtoList = new ArrayList<QueryCartItemDto>();
        for (CartItem cartItem : cartItemList) {
            QueryCartItemDto queryCartItemDto = new QueryCartItemDto();
            ProductSubitem productSubitem = this.productSubitemMapper.selectById(cartItem.getProductSubitemId());
            BeanUtils.copyProperties((Object)cartItem, (Object)queryCartItemDto);
            BeanUtils.copyProperties((Object)productSubitem, (Object)queryCartItemDto);
            queryCartItemDto.setCartItemId(cartItem.getId());
            queryCartItemDto.setTotalPrice(productSubitem.getPrice().multiply(new BigDecimal(cartItem.getQuantity())));
            queryCartItemDto.setTripPrice(tripPrice.multiply(new BigDecimal(cartItem.getQuantity())));
            queryCartItemDtoList.add(queryCartItemDto);
        }
        queryCartDto.setQueryCartItemDtoList(queryCartItemDtoList);
        return queryCartDto;
    }

    @Transactional(rollbackFor={Exception.class})
    public String saveCartItem(SaveCartItemVo saveCartItemVo) {
        Cart cart = this.cartService.saveCart(saveCartItemVo.getUserId());
        CartItem cartItem = new CartItem();
        cartItem.setCartId(cart.getId().toString());
        cartItem.setQuantity(saveCartItemVo.getQuantity());
        cartItem.setProductSubitemId(saveCartItemVo.getProductSubitemId());
        cartItem.setProductId(saveCartItemVo.getProductId());
        int insert = this.cartItemMapper.insert((Object)cartItem);
        return "\u5546\u54c1\u6dfb\u52a0\u6210\u529f";
    }

    public String deleteCartItem(List<Long> cartItemIdList) {
        this.cartItemMapper.deleteBatchIds(cartItemIdList);
        return "\u5546\u54c1\u5220\u9664\u6210\u529f";
    }

    public void updateCartItemCount(Long cartItemId, int count) {
        CartItem cartItem = new CartItem();
        cartItem.setQuantity(Integer.valueOf(count));
        this.cartItemMapper.update((Object)cartItem, (Wrapper)new UpdateWrapper().eq((Object)"id", (Object)cartItemId));
    }
}

