/*
 * Decompiled with CFR 0.152.
 */
package com.byh.server.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.byh.server.mapper.MaterialItemMapper;
import com.byh.server.mapper.MaterialPackageMapper;
import com.byh.server.pojo.dto.DetailMaterialDto;
import com.byh.server.pojo.dto.DetailMaterialItemDto;
import com.byh.server.pojo.dto.DetailMaterialPackageDto;
import com.byh.server.pojo.dto.QueryListItemDto;
import com.byh.server.pojo.dto.QueryListMaterialDto;
import com.byh.server.pojo.dto.QueryListPackageDto;
import com.byh.server.pojo.entity.MaterialItem;
import com.byh.server.pojo.entity.MaterialPackage;
import com.byh.server.pojo.vo.DeleteMaterialItemVo;
import com.byh.server.pojo.vo.SaveMaterialItemVo;
import com.byh.server.pojo.vo.SaveMaterialPackageVo;
import com.byh.server.pojo.vo.SaveMaterialVo;
import com.byh.server.service.MaterialPackageService;
import com.byh.server.utils.UniqueKeyGenerator;
import com.ebaiyihui.framework.page.PageResult;
import com.ebaiyihui.framework.response.BaseResponse;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class MaterialPackageServiceImpl
extends ServiceImpl<MaterialPackageMapper, MaterialPackage>
implements MaterialPackageService {
    @Autowired
    private MaterialPackageMapper materialPackageMapper;
    @Autowired
    private MaterialItemMapper materialItemMapper;

    @Transactional
    public void saveMaterialPackage(SaveMaterialVo saveMaterialVo) {
        SaveMaterialPackageVo saveMaterialPackageVo = saveMaterialVo.getSaveMaterialPackageVo();
        MaterialPackage materialPackage = new MaterialPackage();
        materialPackage.setViewId(UniqueKeyGenerator.generateUUID());
        materialPackage.setAppCode(saveMaterialPackageVo.getAppCode());
        materialPackage.setName(saveMaterialPackageVo.getPackageName());
        materialPackage.setTotalPrice(saveMaterialPackageVo.getTotalPrice());
        int insert = this.materialPackageMapper.insert((Object)materialPackage);
        List saveMaterialItemVoList = saveMaterialVo.getSaveMaterialItemVoList();
        if (!CollectionUtils.isEmpty((Collection)saveMaterialItemVoList)) {
            for (SaveMaterialItemVo saveMaterialItemVo : saveMaterialItemVoList) {
                MaterialItem materialItem = new MaterialItem();
                materialItem.setMaterialPackageId(materialPackage.getId());
                materialItem.setName(saveMaterialItemVo.getItemName());
                materialItem.setPrice(saveMaterialItemVo.getPrice());
                materialItem.setQuantity(saveMaterialItemVo.getQuantity());
                int n = this.materialItemMapper.insert((Object)materialItem);
            }
        }
    }

    public BaseResponse<PageResult<QueryListMaterialDto>> queryListMaterial(String search, Long pageIndex, Long pageSize) {
        PageResult pageResult = new PageResult();
        Page page = new Page(pageIndex.longValue(), pageSize.longValue(), true);
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.like((Object)"name", (Object)search);
        wrapper.orderByDesc((Object)"create_time");
        Page materialPackagePage = (Page)this.materialPackageMapper.selectPage((IPage)page, (Wrapper)wrapper);
        List materialPackagesList = materialPackagePage.getRecords();
        ArrayList<QueryListMaterialDto> list = new ArrayList<QueryListMaterialDto>();
        for (MaterialPackage materialPackage : materialPackagesList) {
            QueryListMaterialDto queryListMaterialDto = new QueryListMaterialDto();
            QueryListPackageDto queryListPackageDto = new QueryListPackageDto();
            queryListPackageDto.setPackageName(materialPackage.getName());
            queryListPackageDto.setPackageViewId(materialPackage.getViewId());
            queryListPackageDto.setPackageCreateTime(materialPackage.getCreateTime());
            queryListPackageDto.setPackageTotalPrice(materialPackage.getTotalPrice());
            queryListMaterialDto.setQueryListPackageDto(queryListPackageDto);
            ArrayList<QueryListItemDto> queryListItemDtoList = new ArrayList<QueryListItemDto>();
            QueryWrapper wrapperItem = new QueryWrapper();
            wrapperItem.eq((Object)"material_package_id", (Object)materialPackage.getId());
            List materialItems = this.materialItemMapper.selectList((Wrapper)wrapperItem);
            for (MaterialItem materialItem : materialItems) {
                QueryListItemDto queryListItemDto = new QueryListItemDto();
                queryListItemDto.setItemName(materialItem.getName());
                queryListItemDto.setItemPrice(materialItem.getPrice());
                queryListItemDto.setItemQuantity(materialItem.getQuantity());
                queryListItemDtoList.add(queryListItemDto);
            }
            queryListMaterialDto.setQueryListItemDtoList(queryListItemDtoList);
            list.add(queryListMaterialDto);
        }
        pageResult.setContent(list);
        pageResult.setTotal(Integer.parseInt(Long.toString(materialPackagePage.getTotal())));
        pageResult.setTotalPages(Integer.parseInt(Long.toString(materialPackagePage.getPages())));
        pageResult.setPageSize(pageSize.intValue());
        pageResult.setPageNum(pageIndex.intValue());
        return BaseResponse.success((Object)pageResult);
    }

    @Transactional
    public BaseResponse<String> deleteMaterialPackage(List<String> packageViewIds) {
        for (String viewId : packageViewIds) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"view_id", (Object)viewId);
            MaterialPackage materialPackage = (MaterialPackage)this.materialPackageMapper.selectOne((Wrapper)queryWrapper);
            QueryWrapper deleteWrapper = new QueryWrapper();
            deleteWrapper.eq((Object)"material_package_id", (Object)materialPackage.getId());
            int delete = this.materialItemMapper.delete((Wrapper)deleteWrapper);
            int n = this.materialPackageMapper.delete((Wrapper)queryWrapper);
        }
        return BaseResponse.success();
    }

    public BaseResponse<DetailMaterialDto> detailMaterialPackage(String packageViewId) {
        DetailMaterialDto detailMaterialDto = new DetailMaterialDto();
        QueryWrapper materialPackageQueryWrapper = new QueryWrapper();
        materialPackageQueryWrapper.eq((Object)"view_id", (Object)packageViewId);
        MaterialPackage materialPackage = (MaterialPackage)this.materialPackageMapper.selectOne((Wrapper)materialPackageQueryWrapper);
        DetailMaterialPackageDto detailMaterialPackageDto = new DetailMaterialPackageDto();
        detailMaterialPackageDto.setAppCode(materialPackage.getAppCode());
        detailMaterialPackageDto.setName(materialPackage.getName());
        detailMaterialPackageDto.setTotalPrice(materialPackage.getTotalPrice());
        detailMaterialPackageDto.setId(materialPackage.getId());
        detailMaterialPackageDto.setViewId(materialPackage.getViewId());
        detailMaterialPackageDto.setCreateTime(materialPackage.getCreateTime());
        detailMaterialPackageDto.setUpdateTime(materialPackage.getUpdateTime());
        detailMaterialDto.setDetailMaterialPackageDto(detailMaterialPackageDto);
        QueryWrapper materialItemQueryWrapper = new QueryWrapper();
        materialItemQueryWrapper.eq((Object)"material_package_id", (Object)materialPackage.getId());
        List materialItems = this.materialItemMapper.selectList((Wrapper)materialItemQueryWrapper);
        ArrayList<DetailMaterialItemDto> detailMaterialItemDtos = new ArrayList<DetailMaterialItemDto>();
        for (MaterialItem materialItem : materialItems) {
            DetailMaterialItemDto detailMaterialItemDto = new DetailMaterialItemDto();
            detailMaterialItemDto.setId(materialItem.getId());
            detailMaterialItemDto.setMaterialPackageId(materialItem.getMaterialPackageId());
            detailMaterialItemDto.setName(materialItem.getName());
            detailMaterialItemDto.setPrice(materialItem.getPrice());
            detailMaterialItemDto.setQuantity(materialItem.getQuantity());
            detailMaterialItemDtos.add(detailMaterialItemDto);
        }
        detailMaterialDto.setDetailMaterialItemDtoList(detailMaterialItemDtos);
        return BaseResponse.success((Object)detailMaterialDto);
    }

    @Transactional
    public BaseResponse<String> deleteMaterialItem(DeleteMaterialItemVo deleteMaterialItemVo) {
        List itemIds = deleteMaterialItemVo.getItemIds();
        itemIds.stream().forEach(itemId -> this.materialItemMapper.deleteById((Serializable)itemId));
        return BaseResponse.success();
    }
}

