/*
 * Decompiled with CFR 0.152.
 */
package com.byh.server.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.byh.server.config.HospitalConfig;
import com.byh.server.mapper.AppointmentMapper;
import com.byh.server.mapper.CartItemMapper;
import com.byh.server.mapper.OrderMapper;
import com.byh.server.mapper.ProductMapper;
import com.byh.server.mapper.ProductSubitemMapper;
import com.byh.server.mapper.UserAddressMapper;
import com.byh.server.pojo.dto.DetailOrderAddressDto;
import com.byh.server.pojo.dto.DetailOrderDto;
import com.byh.server.pojo.dto.DetailOrderInfoDto;
import com.byh.server.pojo.dto.DetailOrderProductDto;
import com.byh.server.pojo.dto.DetailOrderUseRecordDto;
import com.byh.server.pojo.dto.OrderListDto;
import com.byh.server.pojo.dto.OrderListPageDto;
import com.byh.server.pojo.entity.Appointment;
import com.byh.server.pojo.entity.Order;
import com.byh.server.pojo.entity.Product;
import com.byh.server.pojo.entity.ProductSubitem;
import com.byh.server.pojo.entity.UserAddress;
import com.byh.server.pojo.enums.AppointmentStatusEnum;
import com.byh.server.pojo.enums.OrderStatusEnum;
import com.byh.server.pojo.vo.OrderListVo;
import com.byh.server.pojo.vo.SaveOrderProductVo;
import com.byh.server.pojo.vo.SaveOrderVo;
import com.byh.server.service.OrderService;
import com.byh.server.utils.DistanceUtil;
import com.byh.server.utils.UniqueKeyGenerator;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class OrderServiceImpl
extends ServiceImpl<OrderMapper, Order>
implements OrderService {
    @Autowired
    private OrderMapper orderMapper;
    @Autowired
    private ProductSubitemMapper productSubitemMapper;
    @Autowired
    private AppointmentMapper appointmentMapper;
    @Autowired
    private UserAddressMapper userAddressMapper;
    @Autowired
    private CartItemMapper cartItemMapper;
    @Autowired
    private ProductMapper productMapper;

    @Transactional(rollbackFor={Exception.class})
    public String saveOrder(SaveOrderVo saveOrderVo) {
        String uuid = UniqueKeyGenerator.generateUUID();
        UserAddress userAddress = (UserAddress)this.userAddressMapper.selectById((Serializable)saveOrderVo.getUserAddressId());
        for (SaveOrderProductVo saveOrderProductVo : saveOrderVo.getSaveOrderProductVoList()) {
            ProductSubitem productSubitem = this.productSubitemMapper.selectById(saveOrderProductVo.getProductSubitemId());
            Order order = new Order();
            BeanUtils.copyProperties((Object)saveOrderVo, (Object)order);
            BeanUtils.copyProperties((Object)saveOrderProductVo, (Object)order);
            double distance = 0.0;
            if (userAddress.getLatitude() != null && userAddress.getLongitude() != null) {
                distance = DistanceUtil.distance((double)userAddress.getLatitude(), (double)userAddress.getLongitude(), (double)HospitalConfig.HOS_LAT, (double)HospitalConfig.HOS_LNG);
            }
            BigDecimal tripPrice = new BigDecimal("0");
            if (distance != 0.0) {
                if (distance > 10000.0) {
                    return "\u5730\u5740\u8d85\u51fa\u914d\u9001\u8ddd\u79bb,\u8bf7\u91cd\u65b0\u9009\u62e9";
                }
                if (distance < 5000.0) {
                    order.setRoadPrice(new BigDecimal("0"));
                } else {
                    BigDecimal subtract = BigDecimal.valueOf(distance).subtract(new BigDecimal(5000.0)).divide(new BigDecimal("1000"), 0, RoundingMode.HALF_UP);
                    tripPrice = tripPrice.add(subtract.multiply(new BigDecimal(12)));
                }
            }
            order.setRoadPrice(tripPrice);
            order.setPackagePrice(productSubitem.getPrice());
            order.setPrice(productSubitem.getPrice().multiply(new BigDecimal(saveOrderProductVo.getQuantity())));
            int totalNum = saveOrderProductVo.getQuantity() * productSubitem.getServiceTimes();
            order.setServerTotalNum(Integer.valueOf(totalNum));
            order.setServerResidueNum(Integer.valueOf(totalNum--));
            order.setRefundPrice(new BigDecimal("0"));
            order.setSame(uuid);
            order.setViewId(UniqueKeyGenerator.generateViewId().toString());
            order.setStatus(OrderStatusEnum.ORDER_STATUS_SYZ.getValue());
            this.orderMapper.insertOrder(order);
            Appointment appointment = new Appointment();
            appointment.setViewId(UniqueKeyGenerator.generateViewId().toString());
            appointment.setServiceOrderId(order.getId());
            appointment.setStatus(AppointmentStatusEnum.APPOINTMENT_STATUS_DSH.getValue());
            appointment.setAppointmentTime(saveOrderProductVo.getAppointmentTime());
            appointment.setRemark(saveOrderProductVo.getRemark());
            this.appointmentMapper.insert((Object)appointment);
        }
        if (!CollectionUtils.isEmpty((Collection)saveOrderVo.getCartItemIdList())) {
            for (Long cartItemId : saveOrderVo.getCartItemIdList()) {
                this.cartItemMapper.deleteById((Serializable)cartItemId);
            }
        }
        return "\u8d2d\u4e70\u6210\u529f";
    }

    public OrderListPageDto getListOrder(OrderListVo orderListVo) {
        OrderListPageDto result = new OrderListPageDto();
        Page orderPage = new Page();
        orderPage.setSize(orderListVo.getPageSize().longValue());
        orderPage.setCurrent(orderListVo.getPageIndex().longValue());
        QueryWrapper orderQueryWrapper = new QueryWrapper();
        if (StringUtils.isNotEmpty((CharSequence)orderListVo.getSearch())) {
            orderQueryWrapper.eq((Object)"patient_name", (Object)orderListVo.getSearch());
        }
        if (orderListVo.getOrderStatus() != null && orderListVo.getOrderStatus() != 0) {
            orderQueryWrapper.eq((Object)"status", (Object)orderListVo.getOrderStatus());
        }
        if (StringUtils.isNotEmpty((CharSequence)orderListVo.getCreateTimeBegin()) && StringUtils.isNotEmpty((CharSequence)orderListVo.getCreateTimeEnd())) {
            orderQueryWrapper.between((Object)"create_time", (Object)orderListVo.getCreateTimeBegin(), (Object)orderListVo.getCreateTimeEnd());
        }
        Page orderPageResult = (Page)this.orderMapper.selectPage((IPage)orderPage, (Wrapper)orderQueryWrapper);
        List orderList = orderPageResult.getRecords();
        ArrayList<OrderListDto> orders = new ArrayList<OrderListDto>();
        for (Order order : orderList) {
            OrderListDto orderListDto2 = new OrderListDto();
            orderListDto2.setOrderId(order.getId());
            orderListDto2.setOrderViewId(order.getViewId());
            orderListDto2.setCreateTime(order.getCreateTime());
            orderListDto2.setPatientName(order.getPatientName());
            orderListDto2.setPatientPhone(order.getPatientPhone());
            orderListDto2.setOrderStatus(order.getStatus());
            orders.add(orderListDto2);
        }
        Integer useNum = orders.stream().filter(orderListDto -> orderListDto.getOrderStatus().intValue() == OrderStatusEnum.ORDER_STATUS_SYZ.getValue().intValue()).collect(Collectors.toList()).size();
        result.setUseNum(useNum);
        result.setOrderListDtoList(orders);
        result.setPageIndex(orderListVo.getPageIndex());
        result.setPageSize(orderListVo.getPageSize());
        result.setPageNum(Long.valueOf(orderPage.getPages()));
        result.setTotal(Long.valueOf(orderPage.getTotal()));
        return result;
    }

    public DetailOrderDto detailOrder(String orderViewId) {
        DetailOrderDto detailOrderDto = new DetailOrderDto();
        QueryWrapper orderQueryWrapper = (QueryWrapper)new QueryWrapper().eq((Object)"view_id", (Object)orderViewId);
        Order order = (Order)this.orderMapper.selectOne((Wrapper)orderQueryWrapper);
        DetailOrderInfoDto detailOrderInfoDto = new DetailOrderInfoDto();
        detailOrderInfoDto.setCreateTime(order.getCreateTime());
        detailOrderInfoDto.setOrderViewId(order.getViewId());
        detailOrderInfoDto.setOrderStatus(order.getStatus());
        detailOrderInfoDto.setMedicalCertificate(order.getMedicalCertificate());
        detailOrderInfoDto.setServerResidueNum(order.getServerResidueNum());
        detailOrderInfoDto.setServerTotalNum(order.getServerTotalNum());
        detailOrderInfoDto.setPatientId(order.getPatientId());
        detailOrderInfoDto.setPatientName(order.getPatientName());
        detailOrderInfoDto.setPatientAge(order.getPatientAge());
        detailOrderInfoDto.setPatientSex(order.getPatientSex());
        detailOrderInfoDto.setPatientPhone(order.getPatientPhone());
        detailOrderDto.setDetailOrderInfoDto(detailOrderInfoDto);
        Product product = (Product)this.productMapper.selectById((Serializable)order.getProductId());
        ProductSubitem productSubitem = this.productSubitemMapper.selectById(order.getProductSubitemId());
        DetailOrderProductDto detailOrderProductDto = new DetailOrderProductDto();
        detailOrderProductDto.setProductId(product.getId());
        detailOrderProductDto.setProductName(product.getName());
        detailOrderProductDto.setProductImage(product.getImage());
        detailOrderProductDto.setMaterialName(productSubitem.getMaterialName());
        detailOrderProductDto.setSpecificationValueName(productSubitem.getSpecificationValueName());
        detailOrderProductDto.setUsefulLife(productSubitem.getUsefulLife());
        detailOrderDto.setDetailOrderProductDto(detailOrderProductDto);
        UserAddress userAddress = (UserAddress)this.userAddressMapper.selectById((Serializable)order.getUserAddressId());
        DetailOrderAddressDto detailOrderAddressDto = new DetailOrderAddressDto();
        detailOrderAddressDto.setAddress(userAddress.getAddress());
        detailOrderAddressDto.setCustomAddress(userAddress.getCustomAddress());
        detailOrderDto.setDetailOrderAddressDto(detailOrderAddressDto);
        QueryWrapper appointmentQueryWrapper = (QueryWrapper)new QueryWrapper().eq((Object)"service_order_id", (Object)order.getId());
        List appointmentS = this.appointmentMapper.selectList((Wrapper)appointmentQueryWrapper);
        ArrayList<DetailOrderUseRecordDto> list = new ArrayList<DetailOrderUseRecordDto>();
        for (Appointment appointment : appointmentS) {
            DetailOrderUseRecordDto detailOrderUseRecordDto = new DetailOrderUseRecordDto();
            detailOrderUseRecordDto.setUseRecordViewId(appointment.getViewId());
            detailOrderUseRecordDto.setUseRecordStatus(appointment.getStatus());
            detailOrderUseRecordDto.setUseRecordAppointmentTime(appointment.getAppointmentTime());
            detailOrderUseRecordDto.setUseRecordDoctorId(appointment.getDoctorId());
            detailOrderUseRecordDto.setUseRecordDoctorName(appointment.getDoctorName());
            list.add(detailOrderUseRecordDto);
        }
        detailOrderDto.setDetailOrderUseRecordDto(list);
        return detailOrderDto;
    }
}

