/*
 * Decompiled with CFR 0.152.
 */
package com.byh.server.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.byh.server.config.RemoteCallAddressConfig;
import com.byh.server.mapper.OrderMapper;
import com.byh.server.mapper.ServiceMerchantConfigMapper;
import com.byh.server.mapper.ServicePayBillMapper;
import com.byh.server.pojo.entity.Order;
import com.byh.server.pojo.entity.ServiceMerchantConfig;
import com.byh.server.pojo.entity.ServicePayBill;
import com.byh.server.pojo.enums.OrderStatusEnum;
import com.byh.server.pojo.enums.PayStatusEnum;
import com.byh.server.pojo.enums.ReturnCodeEnum;
import com.byh.server.pojo.vo.AggregationPayWxVo;
import com.byh.server.pojo.vo.DiscountVo;
import com.byh.server.pojo.vo.PayCallbackVo;
import com.byh.server.pojo.vo.PayNotifyAggregationVo;
import com.byh.server.pojo.vo.PayParamVo;
import com.byh.server.pojo.vo.RefundCallbackVo;
import com.byh.server.pojo.vo.RefundHttpVo;
import com.byh.server.pojo.vo.RefundVo;
import com.byh.server.service.PayService;
import com.byh.server.utils.HttpUtils;
import com.byh.server.utils.SignUtil;
import com.byh.server.utils.pinyinUtil;
import java.io.IOException;
import java.util.Map;
import org.apache.http.Consts;
import org.apache.http.entity.ContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PayServiceImpl
implements PayService {
    private static final Logger log = LoggerFactory.getLogger(PayServiceImpl.class);
    @Autowired
    private ServiceMerchantConfigMapper serviceMerchantConfigMapper;
    @Autowired
    private ServicePayBillMapper servicePayBillMapper;
    @Autowired
    private RemoteCallAddressConfig remoteCallAddressConfig;
    @Autowired
    private OrderMapper orderMapper;

    public JSONObject pricePay(PayParamVo payParamVo) {
        QueryWrapper queryWrapper = (QueryWrapper)new QueryWrapper().eq((Object)"app_code", (Object)payParamVo.getAppCode());
        ServiceMerchantConfig serviceMerchantConfig = (ServiceMerchantConfig)this.serviceMerchantConfigMapper.selectOne((Wrapper)queryWrapper);
        log.info("serviceMerchantConfig:{}", (Object)serviceMerchantConfig);
        StringBuffer serviceCode = new StringBuffer();
        String organName = "";
        serviceCode.append(payParamVo.getAppCode()).append("_").append(organName).append("_").append("HLZH");
        AggregationPayWxVo aggregationPayWxVo = new AggregationPayWxVo();
        aggregationPayWxVo.setPayChannel(payParamVo.getPayChannel());
        aggregationPayWxVo.setPayType("JSAPI");
        aggregationPayWxVo.setMchCode(serviceMerchantConfig.getMerchantSeq());
        aggregationPayWxVo.setServiceCode(serviceCode.toString());
        aggregationPayWxVo.setUserSign(payParamVo.getOpenId());
        aggregationPayWxVo.setOutTradeNo(payParamVo.getOrderViewId());
        aggregationPayWxVo.setTotalAmount(payParamVo.getPrice());
        aggregationPayWxVo.setActuallyAmount(payParamVo.getPrice());
        aggregationPayWxVo.setProductInfo("");
        aggregationPayWxVo.setDiscountVo(new DiscountVo());
        aggregationPayWxVo.setAuthCode("");
        aggregationPayWxVo.setNonceStr(pinyinUtil.getRandomString((int)32));
        aggregationPayWxVo.setPayNotifyUrl(this.remoteCallAddressConfig.getPayCallbackAddress() + "/HYT/nursing-care/api/v1/pay/pricePay");
        aggregationPayWxVo.setApplyCode(payParamVo.getAppCode());
        String[] str = new String[]{};
        Map map = SignUtil.getKeyAndValue((Object)aggregationPayWxVo);
        String sign = SignUtil.createSign((Map)map, (String)serviceMerchantConfig.getApplyKey(), (String[])str);
        aggregationPayWxVo.setSign(sign);
        log.info("\u805a\u5408\u652f\u4ed8\u521b\u5efaaggregationPayWxVo\uff1a{}", (Object)aggregationPayWxVo);
        String url = new StringBuffer(this.remoteCallAddressConfig.getPayHttpAddress() + "/trade/create-order").toString();
        log.info("\u805a\u5408\u652f\u4ed8\u521b\u5efa\u8bf7\u6c42\u8def\u5f84url\uff1a{}", (Object)url);
        String respStr = "";
        log.info("\u9884\u805a\u5408\u652f\u4ed8\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u7684\u8bf7\u6c42url\u662f:{}=========\u8bf7\u6c42\u53c2\u6570\u662f:{}", (Object)url, (Object)JSON.toJSONString((Object)aggregationPayWxVo));
        try {
            respStr = HttpUtils.doPost((String)url, (String)JSON.toJSONString((Object)aggregationPayWxVo), (String)Consts.UTF_8.name(), (String)ContentType.APPLICATION_JSON.getMimeType());
            log.info("\u8bf7\u6c42\u9884\u652f\u4ed8\u7684\u54cd\u5e94\u7ed3\u679c\u662f:{}", (Object)respStr);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String code = JSON.parseObject((String)respStr).getString("code");
        if (ReturnCodeEnum.SUCCEED.getValue().equals(code) && JSON.parseObject((String)respStr).getJSONObject("data") != null) {
            return JSON.parseObject((String)respStr).getJSONObject("data");
        }
        return JSON.parseObject((String)respStr).getJSONObject("msg");
    }

    public Boolean payCallback(PayCallbackVo payCallbackVo) {
        log.info("\u652f\u4ed8\u8d26\u5355\u2014\u2014\u805a\u5408\u652f\u4ed8\u56de\u8c03\u53c2\u6570payNotifyReqVO\uff1a{}\uff1b", (Object)payCallbackVo);
        String appCode = "HYT";
        log.info("\u652f\u4ed8\u8d26\u5355\u2014\u2014appCode\uff1a{}\uff1b", (Object)appCode);
        QueryWrapper queryWrapper = (QueryWrapper)new QueryWrapper().eq((Object)"apply_id", (Object)payCallbackVo.getApplyId());
        ServiceMerchantConfig serviceMerchantConfig = (ServiceMerchantConfig)this.serviceMerchantConfigMapper.selectOne((Wrapper)queryWrapper);
        log.info("\u652f\u4ed8\u8d26\u5355\u2014\u2014serviceMerchantConfig\uff1a{}\uff1b", (Object)serviceMerchantConfig);
        String organName = "";
        String serviceCode = appCode + "_" + organName + "_HLZH";
        PayNotifyAggregationVo payNotifyAggregationVo = new PayNotifyAggregationVo();
        payNotifyAggregationVo.setReturnCode(payCallbackVo.getReturnCode());
        payNotifyAggregationVo.setReturnMsg(payCallbackVo.getReturnMsg());
        payNotifyAggregationVo.setResultCode(payCallbackVo.getResultCode());
        payNotifyAggregationVo.setErrCode(payCallbackVo.getErrCode());
        payNotifyAggregationVo.setErrCodeDes(payCallbackVo.getErrCodeDes());
        payNotifyAggregationVo.setPayChannel(payCallbackVo.getPayChannel());
        payNotifyAggregationVo.setServiceCode(payCallbackVo.getServiceCode());
        payNotifyAggregationVo.setDealTradeNo(payCallbackVo.getDealTradeNo());
        payNotifyAggregationVo.setOutTradeNo(payCallbackVo.getOutTradeNo());
        payNotifyAggregationVo.setTotalAmount(payCallbackVo.getTotalAmount());
        payNotifyAggregationVo.setPayTime(payCallbackVo.getPayTime());
        payNotifyAggregationVo.setTradeNo(payCallbackVo.getTradeNo());
        payNotifyAggregationVo.setMchCode(payCallbackVo.getMchCode());
        payNotifyAggregationVo.setMchId(payCallbackVo.getMchId());
        payNotifyAggregationVo.setMchName(payCallbackVo.getMchName());
        payNotifyAggregationVo.setNotifyResultStr(payCallbackVo.getNotifyResultStr());
        payNotifyAggregationVo.setAttach(payCallbackVo.getAttach());
        payNotifyAggregationVo.setRemake(payCallbackVo.getRemake());
        payNotifyAggregationVo.setSign(payCallbackVo.getSign());
        payNotifyAggregationVo.setApplyId(payCallbackVo.getApplyId());
        log.info("\u652f\u4ed8\u8d26\u5355\u2014\u2014payNotifyAggregationVo\uff1a{}\uff1b", (Object)payNotifyAggregationVo);
        Map map = SignUtil.getKeyAndValue((Object)payNotifyAggregationVo);
        Boolean bool = SignUtil.checkSign((Map)map, (String)serviceMerchantConfig.getApplyKey());
        log.info("\u652f\u4ed8\u8d26\u5355\u2014\u2014\u9a8c\u7b7e\u7ed3\u679cbool\uff1a{}\uff1b", (Object)bool);
        if (bool.booleanValue()) {
            ServicePayBill servicePayBillEntity = new ServicePayBill();
            servicePayBillEntity.setStatus(Integer.valueOf(3));
            servicePayBillEntity.setAppCode(appCode);
            servicePayBillEntity.setOrganName(organName);
            servicePayBillEntity.setWorkServiceCode("HLZH");
            servicePayBillEntity.setApplyCode(serviceMerchantConfig.getAppCode());
            servicePayBillEntity.setPayChannel(payNotifyAggregationVo.getPayChannel());
            servicePayBillEntity.setTradeTime(payNotifyAggregationVo.getPayTime());
            servicePayBillEntity.setTradeNo(payNotifyAggregationVo.getTradeNo());
            servicePayBillEntity.setOutTradeNo(payNotifyAggregationVo.getOutTradeNo());
            servicePayBillEntity.setTradeStatus("SUCCESS");
            servicePayBillEntity.setOrderAmount(payNotifyAggregationVo.getTotalAmount());
            servicePayBillEntity.setDealAmount(payNotifyAggregationVo.getTotalAmount());
            servicePayBillEntity.setServiceCode(serviceCode);
            servicePayBillEntity.setDealTradeNo(payNotifyAggregationVo.getDealTradeNo());
            log.info("\u652f\u4ed8\u8d26\u5355\u2014\u2014\u805a\u5408\u652f\u4ed8\u56de\u8c03\u6570\u636e\u4fdd\u5b58servicePayBillEntity\uff1a{}\uff1b", (Object)servicePayBillEntity);
            int insert = this.servicePayBillMapper.insert((Object)servicePayBillEntity);
            if (insert != 1) {
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    public Boolean refund(RefundVo refundVo) {
        QueryWrapper queryWrapper = (QueryWrapper)new QueryWrapper().eq((Object)"out_trade_no", (Object)refundVo.getOrderViewId());
        ServicePayBill servicePayBill = (ServicePayBill)this.servicePayBillMapper.selectOne((Wrapper)queryWrapper);
        QueryWrapper configQueryWrapper = (QueryWrapper)new QueryWrapper().eq((Object)"app_code", (Object)refundVo.getAppCode());
        ServiceMerchantConfig serviceMerchantConfig = (ServiceMerchantConfig)this.serviceMerchantConfigMapper.selectOne((Wrapper)configQueryWrapper);
        RefundHttpVo refundHttpVo = new RefundHttpVo();
        refundHttpVo.setPayChannel(servicePayBill.getPayChannel());
        refundHttpVo.setMchCode(servicePayBill.getApplyCode());
        refundHttpVo.setOutTradeNo(servicePayBill.getOutTradeNo());
        refundHttpVo.setDealTradeNo(servicePayBill.getDealTradeNo());
        refundHttpVo.setTotalAmount(refundVo.getPrice());
        refundHttpVo.setRefundAmount(refundVo.getPrice());
        refundHttpVo.setNonceStr(pinyinUtil.getRandomString((int)32));
        refundHttpVo.setRefundNotifyUrl(this.remoteCallAddressConfig.getPayCallbackAddress() + "/HYT/nursing-care/api/v1/pay/refundCallback");
        refundHttpVo.setApplyCode(servicePayBill.getApplyCode());
        String[] str = new String[]{};
        Map map = SignUtil.getKeyAndValue((Object)refundHttpVo);
        String sign = SignUtil.createSign((Map)map, (String)serviceMerchantConfig.getApplyKey(), (String[])str);
        refundHttpVo.setSign(sign);
        String url = this.remoteCallAddressConfig.getPayHttpAddress() + "/trade/refund";
        String respStr = "";
        log.info("\u9000\u6b3e\u8bf7\u6c42url\u662f:{} http\u8bf7\u6c42\u53c2\u6570\u662f:{}", (Object)url, (Object)JSON.toJSONString((Object)refundHttpVo));
        try {
            respStr = HttpUtils.doPost((String)url, (String)JSON.toJSONString((Object)refundHttpVo), (String)Consts.UTF_8.name(), (String)ContentType.APPLICATION_JSON.getMimeType());
            log.info("\u9000\u6b3e\u8bf7\u6c42http\u8bf7\u6c42\u8fd4\u56de:{}", (Object)respStr);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String code = JSON.parseObject((String)respStr).getString("code");
        if (ReturnCodeEnum.SUCCEED.getValue().equals(code)) {
            return true;
        }
        return false;
    }

    @Transactional
    public Boolean refundCallback(RefundCallbackVo refundCallbackVo) {
        log.info("\u652f\u4ed8\u8d26\u5355\u2014\u2014\u9000\u6b3e\u652f\u4ed8\u56de\u8c03\u53c2\u6570refundCallbackVo\uff1a{}\uff1b", (Object)refundCallbackVo);
        if (!PayStatusEnum.SUCCESS.getValue().equals(refundCallbackVo.getReturnCode())) {
            log.error("\u8ba2\u5355\u9000\u6b3e\u5931\u8d25\uff1a{}", (Object)refundCallbackVo.getOutTradeNo());
            return false;
        }
        QueryWrapper orderQueryWrapper = (QueryWrapper)new QueryWrapper().eq((Object)"view_id", (Object)refundCallbackVo.getOutTradeNo());
        Order order = (Order)this.orderMapper.selectOne((Wrapper)orderQueryWrapper);
        UpdateWrapper orderUpdateWrapper = (UpdateWrapper)new UpdateWrapper().eq((Object)"view_id", (Object)refundCallbackVo.getOutTradeNo());
        order.setStatus(OrderStatusEnum.ORDER_STATUS_YTK.getValue());
        int update = this.orderMapper.update((Object)order, (Wrapper)orderUpdateWrapper);
        if (update != 1) {
            return false;
        }
        QueryWrapper queryWrapper = (QueryWrapper)new QueryWrapper().eq((Object)"apply_id", (Object)refundCallbackVo.getApplyId());
        ServiceMerchantConfig serviceMerchantConfig = (ServiceMerchantConfig)this.serviceMerchantConfigMapper.selectOne((Wrapper)queryWrapper);
        log.info("\u652f\u4ed8\u8d26\u5355\u2014\u2014\u9000\u6b3e\u652f\u4ed8\u56de\u8c03serviceMerchantConfig\uff1a{}\uff1b", (Object)serviceMerchantConfig);
        QueryWrapper billQueryWrapper = (QueryWrapper)new QueryWrapper().eq((Object)"out_trade_no", (Object)refundCallbackVo.getOutTradeNo());
        ServicePayBill servicePayBill = (ServicePayBill)this.servicePayBillMapper.selectOne((Wrapper)billQueryWrapper);
        String organName = "";
        String serviceCode = serviceMerchantConfig.getAppCode() + "_" + organName + "_HLZH";
        Map map = SignUtil.getKeyAndValue((Object)refundCallbackVo);
        Boolean bool = SignUtil.checkSign((Map)map, (String)serviceMerchantConfig.getApplyKey());
        if (bool.booleanValue()) {
            ServicePayBill refundPayBillEntity = new ServicePayBill();
            refundPayBillEntity.setStatus(Integer.valueOf(6));
            refundPayBillEntity.setRemark("");
            refundPayBillEntity.setAppCode(serviceMerchantConfig.getAppCode());
            refundPayBillEntity.setOrganName(organName);
            refundPayBillEntity.setWorkServiceCode("HLZH");
            refundPayBillEntity.setApplyCode(serviceMerchantConfig.getAppCode());
            refundPayBillEntity.setPayChannel(refundCallbackVo.getPayChannel());
            refundPayBillEntity.setTradeTime(servicePayBill.getTradeTime());
            refundPayBillEntity.setTradeNo(servicePayBill.getTradeNo());
            refundPayBillEntity.setOutTradeNo(refundCallbackVo.getOutTradeNo());
            refundPayBillEntity.setTradeStatus("SUCCESS");
            refundPayBillEntity.setOrderAmount(refundCallbackVo.getTotalAmount());
            refundPayBillEntity.setDealAmount(refundCallbackVo.getTotalAmount());
            refundPayBillEntity.setRefundNo(refundCallbackVo.getRefundNo());
            refundPayBillEntity.setOutRefundNo(refundCallbackVo.getRefundNo());
            refundPayBillEntity.setRefundTime(refundCallbackVo.getRefundTime());
            refundPayBillEntity.setRefundAmount(refundCallbackVo.getRefundMoney());
            refundPayBillEntity.setServiceCode(serviceCode);
            refundPayBillEntity.setDealTradeNo(refundCallbackVo.getDealTradeNo());
            log.info("\u652f\u4ed8\u8d26\u5355\u2014\u2014\u9000\u6b3e\u652f\u4ed8\u56de\u8c03\u6570\u636e\u4fdd\u5b58refundPayBillEntity\uff1a{}\uff1b", (Object)refundPayBillEntity);
            int insert = this.servicePayBillMapper.insert((Object)refundPayBillEntity);
            if (insert != 1) {
                return false;
            }
        } else {
            return false;
        }
        return true;
    }
}

