/*
 * Decompiled with CFR 0.152.
 */
package com.byh.server.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.byh.server.mapper.ProductCategoryMapper;
import com.byh.server.mapper.ProductMapper;
import com.byh.server.pojo.entity.ProductCategory;
import com.byh.server.pojo.vo.DeleteVo;
import com.byh.server.pojo.vo.SequenceProductCategoryVo;
import com.byh.server.pojo.vo.UpdateProductCategoryVo;
import com.byh.server.service.ProductCategoryService;
import com.ebaiyihui.framework.response.BaseResponse;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ProductCategoryServiceImpl
extends ServiceImpl<ProductCategoryMapper, ProductCategory>
implements ProductCategoryService {
    @Autowired
    private ProductCategoryMapper productCategoryMapper;
    @Autowired
    private ProductMapper productMapper;

    public BaseResponse<String> updateProductCategory(UpdateProductCategoryVo updateProductCategoryVo) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"view_id", (Object)updateProductCategoryVo.getViewId());
        ProductCategory productCategory = (ProductCategory)this.productCategoryMapper.selectOne((Wrapper)queryWrapper);
        Integer updateBoolean = 0;
        if (productCategory != null) {
            productCategory.setIcon(updateProductCategoryVo.getUrl());
            productCategory.setName(updateProductCategoryVo.getName());
            productCategory.setIsDisplayedHome(updateProductCategoryVo.getIsDisplayedHome());
            UpdateWrapper updateWrapper = new UpdateWrapper();
            updateWrapper.eq((Object)"view_id", (Object)updateProductCategoryVo.getViewId());
            updateBoolean = this.productCategoryMapper.update((Object)productCategory, (Wrapper)updateWrapper);
        }
        if (updateBoolean != 0) {
            return BaseResponse.success();
        }
        return BaseResponse.error((String)"\u5931\u8d25");
    }

    public BaseResponse<String> deleteProductCategory(DeleteVo deleteVo) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"view_id", (Object)deleteVo.getViewId());
        ProductCategory productCategory = (ProductCategory)this.productCategoryMapper.selectOne((Wrapper)queryWrapper);
        QueryWrapper queryProductWrapper = new QueryWrapper();
        queryProductWrapper.eq((Object)"product_category_id", (Object)productCategory.getId());
        List products = this.productMapper.selectList((Wrapper)queryProductWrapper);
        if (CollectionUtils.isEmpty((Collection)products)) {
            int delete = this.productCategoryMapper.delete((Wrapper)queryWrapper);
            if (delete != 1) {
                return BaseResponse.error((String)"\u5931\u8d25");
            }
        } else {
            return BaseResponse.error((String)"\u8bf7\u5148\u79fb\u9664\u5206\u7c7b\u4e2d\u7684\u5957\u9910\u518d\u5220\u9664\u5206\u7c7b");
        }
        return BaseResponse.success();
    }

    public ProductCategory selectMaxSequence() {
        ProductCategory productCategory = this.productCategoryMapper.selectMaxSequence();
        return productCategory;
    }

    @Transactional
    public Boolean sequenceProductCategory(SequenceProductCategoryVo sequenceProductCategoryVo) {
        List productCategoryIds = sequenceProductCategoryVo.getProductCategoryIds();
        for (Long productCategoryId : productCategoryIds) {
            int index = Arrays.binarySearch(productCategoryIds.toArray(), productCategoryId);
            ProductCategory productCategory = (ProductCategory)this.productCategoryMapper.selectById((Serializable)productCategoryId);
            productCategory.setSequence(Integer.valueOf(index));
            UpdateWrapper updateWrapper = new UpdateWrapper();
            updateWrapper.eq((Object)"id", (Object)productCategoryId);
            int update = this.productCategoryMapper.update((Object)productCategory, (Wrapper)updateWrapper);
            if (update == 1) continue;
            return false;
        }
        return true;
    }

    public List<ProductCategory> getListProductCategoryManagement() {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.orderByAsc((Object)"sequence");
        List productCategories = this.productCategoryMapper.selectList((Wrapper)queryWrapper);
        return productCategories;
    }

    public List<ProductCategory> getListProductCategoryPatient() {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.orderByAsc((Object)"sequence");
        queryWrapper.eq((Object)"is_displayed_home", (Object)1);
        List productCategories = this.productCategoryMapper.selectList((Wrapper)queryWrapper);
        return productCategories;
    }
}

