/*
 * Decompiled with CFR 0.152.
 */
package com.byh.server.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.byh.server.mapper.OrderMapper;
import com.byh.server.mapper.ProductCategoryMapper;
import com.byh.server.mapper.ProductMapper;
import com.byh.server.mapper.ProductSubitemMapper;
import com.byh.server.pojo.dto.DetailProductDataDto;
import com.byh.server.pojo.dto.DetailProductDto;
import com.byh.server.pojo.dto.DetailProductMaterialPackageDto;
import com.byh.server.pojo.dto.DetailProductSpecificationDto;
import com.byh.server.pojo.dto.DetailProductSpecificationValueDto;
import com.byh.server.pojo.dto.DetailProductSubitemDto;
import com.byh.server.pojo.dto.SelectListProductDto;
import com.byh.server.pojo.entity.Product;
import com.byh.server.pojo.entity.ProductCategory;
import com.byh.server.pojo.entity.ProductSubitem;
import com.byh.server.pojo.vo.DeleteVo;
import com.byh.server.pojo.vo.MarketableProductVo;
import com.byh.server.pojo.vo.SaveProductDataVo;
import com.byh.server.pojo.vo.SaveProductSubitemVo;
import com.byh.server.pojo.vo.SaveProductVo;
import com.byh.server.pojo.vo.SelectListProductVo;
import com.byh.server.pojo.vo.TopProductVo;
import com.byh.server.pojo.vo.UpdateProductDataVo;
import com.byh.server.pojo.vo.UpdateProductSubitemVo;
import com.byh.server.pojo.vo.UpdateProductVo;
import com.byh.server.service.ProductService;
import com.byh.server.utils.UniqueKeyGenerator;
import com.ebaiyihui.framework.page.PageResult;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ProductServiceImpl
extends ServiceImpl<ProductMapper, Product>
implements ProductService {
    @Autowired
    private ProductMapper productMapper;
    @Autowired
    private ProductSubitemMapper productSubitemMapper;
    @Autowired
    private ProductCategoryMapper productCategoryMapper;
    @Autowired
    private OrderMapper orderMapper;

    @Transactional
    public Boolean saveProduct(SaveProductVo saveProductVo) {
        SaveProductDataVo saveProductDataVo = saveProductVo.getSaveProductDataVo();
        Product product = new Product();
        product.setProductCategoryId(saveProductDataVo.getProductCategoryId());
        product.setViewId(UniqueKeyGenerator.generateUUID());
        product.setName(saveProductDataVo.getProductName());
        product.setImage(saveProductDataVo.getProductImage());
        product.setProductCategoryId(saveProductDataVo.getProductCategoryId());
        int insert = this.productMapper.insert((Object)product);
        if (insert != 1) {
            return false;
        }
        QueryWrapper productQueryWrapper = new QueryWrapper();
        productQueryWrapper.eq((Object)"view_id", (Object)product.getViewId());
        Product productEntity = (Product)this.productMapper.selectOne((Wrapper)productQueryWrapper);
        List saveProductSubitemVoList = saveProductVo.getSaveProductSubitemVoList();
        BigDecimal decimal = new BigDecimal(0.0);
        for (SaveProductSubitemVo saveProductSubitemVo : saveProductSubitemVoList) {
            ProductSubitem productSubitem = new ProductSubitem();
            productSubitem.setViewId(UniqueKeyGenerator.generateUUID());
            productSubitem.setProductId(productEntity.getId());
            productSubitem.setMaterialId(saveProductSubitemVo.getMaterialId());
            productSubitem.setMaterialName(saveProductSubitemVo.getMaterialName());
            productSubitem.setSpecificationId(saveProductSubitemVo.getSpecificationId());
            productSubitem.setSpecificationName(saveProductSubitemVo.getSpecificationName());
            productSubitem.setSpecificationValueId(saveProductSubitemVo.getSpecificationValueId());
            productSubitem.setSpecificationValueName(saveProductSubitemVo.getSpecificationValueName());
            productSubitem.setUsefulLife(saveProductSubitemVo.getUsefulLife());
            productSubitem.setServiceTimes(saveProductSubitemVo.getServiceTimes());
            productSubitem.setPrice(saveProductSubitemVo.getPrice());
            productSubitem.setIntroduce(saveProductSubitemVo.getIntroduce());
            decimal = decimal.multiply(saveProductSubitemVo.getPrice());
            int save = this.productSubitemMapper.insert((Object)productSubitem);
            if (save == 1) continue;
            return false;
        }
        UpdateWrapper productUpdateWrapper = new UpdateWrapper();
        productUpdateWrapper.eq((Object)"view_id", (Object)product.getViewId());
        productEntity.setPrice(decimal);
        int update = this.productMapper.update((Object)productEntity, (Wrapper)productUpdateWrapper);
        if (update != 1) {
            return false;
        }
        return true;
    }

    public Boolean topProduct(TopProductVo topProductVo) {
        QueryWrapper productQueryWrapper = new QueryWrapper();
        productQueryWrapper.eq((Object)"view_id", (Object)topProductVo.getProductViewId());
        Product product = (Product)this.productMapper.selectOne((Wrapper)productQueryWrapper);
        UpdateWrapper productUpdateWrapper = new UpdateWrapper();
        productUpdateWrapper.eq((Object)"view_id", (Object)topProductVo.getProductViewId());
        product.setIsTop(topProductVo.getTop());
        int update = this.productMapper.update((Object)product, (Wrapper)productUpdateWrapper);
        if (update != 1) {
            return false;
        }
        return true;
    }

    public Boolean marketableProduct(MarketableProductVo marketableProductVo) {
        QueryWrapper productQueryWrapper = new QueryWrapper();
        productQueryWrapper.eq((Object)"view_id", (Object)marketableProductVo.getProductViewId());
        Product product = (Product)this.productMapper.selectOne((Wrapper)productQueryWrapper);
        UpdateWrapper productUpdateWrapper = new UpdateWrapper();
        productUpdateWrapper.eq((Object)"view_id", (Object)marketableProductVo.getProductViewId());
        product.setIsMarketable(marketableProductVo.getMarketable());
        int update = this.productMapper.update((Object)product, (Wrapper)productUpdateWrapper);
        if (update != 1) {
            return false;
        }
        return true;
    }

    public PageResult<SelectListProductDto> selectListProduct(SelectListProductVo selectListProductVo) {
        PageResult pageResult = new PageResult();
        Page productPage = new Page();
        productPage.setCurrent((long)selectListProductVo.getPageIndex().intValue());
        productPage.setSize((long)selectListProductVo.getPageSize().intValue());
        QueryWrapper productQueryWrapper = new QueryWrapper();
        if (StringUtils.isNotEmpty((CharSequence)selectListProductVo.getSearch())) {
            productQueryWrapper.like((Object)"name", (Object)selectListProductVo.getSearch());
        }
        productQueryWrapper.orderByDesc((Object[])new String[]{"is_top", "create_time"});
        Page page = (Page)this.productMapper.selectPage((IPage)productPage, (Wrapper)productQueryWrapper);
        List productList = page.getRecords();
        ArrayList<SelectListProductDto> list = new ArrayList<SelectListProductDto>();
        for (Product product : productList) {
            SelectListProductDto selectListProductDto = new SelectListProductDto();
            selectListProductDto.setProductId(product.getId());
            selectListProductDto.setProductViewId(product.getViewId());
            selectListProductDto.setProductName(product.getName());
            selectListProductDto.setProductImage(product.getImage());
            selectListProductDto.setMarketable(product.getIsMarketable());
            selectListProductDto.setTop(product.getIsTop());
            selectListProductDto.setProductCategoryId(product.getProductCategoryId());
            selectListProductDto.setPrice(product.getPrice());
            QueryWrapper orderQueryWrapper = new QueryWrapper();
            orderQueryWrapper.eq((Object)"product_id", (Object)product.getId());
            Integer salesVolume = this.orderMapper.selectCount((Wrapper)orderQueryWrapper);
            selectListProductDto.setSalesVolume(salesVolume);
            BigDecimal sales = new BigDecimal(salesVolume);
            BigDecimal proceeds = sales.multiply(product.getPrice());
            selectListProductDto.setProceeds(proceeds);
            list.add(selectListProductDto);
        }
        pageResult.setContent(list);
        pageResult.setTotal(Integer.parseInt(Long.toString(page.getTotal())));
        pageResult.setTotalPages(Integer.parseInt(Long.toString(page.getPages())));
        pageResult.setPageNum(selectListProductVo.getPageIndex().intValue());
        pageResult.setPageSize(selectListProductVo.getPageSize().intValue());
        return pageResult;
    }

    @Transactional
    public Boolean deleteProduct(DeleteVo deleteVo) {
        QueryWrapper productQueryWrapper = new QueryWrapper();
        productQueryWrapper.eq((Object)"view_id", (Object)deleteVo.getViewId());
        int delete = this.productMapper.delete((Wrapper)productQueryWrapper);
        if (delete != 1) {
            return false;
        }
        Product product = (Product)this.productMapper.selectOne((Wrapper)productQueryWrapper);
        QueryWrapper subitemQueryWrapper = new QueryWrapper();
        subitemQueryWrapper.eq((Object)"product_id", (Object)product.getId());
        int subitemDelete = this.productSubitemMapper.delete((Wrapper)subitemQueryWrapper);
        if (subitemDelete == 0) {
            return false;
        }
        return true;
    }

    public DetailProductDto detailProduct(String viewId) {
        DetailProductDto detailProductDto = new DetailProductDto();
        QueryWrapper productQueryWrapper = (QueryWrapper)new QueryWrapper().eq((Object)"view_id", (Object)viewId);
        Product product = (Product)this.productMapper.selectOne((Wrapper)productQueryWrapper);
        ProductCategory productCategory = (ProductCategory)this.productCategoryMapper.selectById((Serializable)product.getProductCategoryId());
        DetailProductDataDto detailProductDataDto = new DetailProductDataDto();
        detailProductDataDto.setProductId(product.getId());
        detailProductDataDto.setProductName(product.getName());
        detailProductDataDto.setProductImage(product.getImage());
        detailProductDataDto.setProductCategoryId(productCategory.getId());
        detailProductDataDto.setProductCategoryName(productCategory.getName());
        detailProductDto.setDetailProductDataDto(detailProductDataDto);
        QueryWrapper subitemQueryWrapper = (QueryWrapper)new QueryWrapper().eq((Object)"product_id", (Object)product.getId());
        List productSubitems = this.productSubitemMapper.selectList((Wrapper)subitemQueryWrapper);
        ArrayList<DetailProductMaterialPackageDto> materialList = new ArrayList<DetailProductMaterialPackageDto>();
        ArrayList<DetailProductSubitemDto> subitemList = new ArrayList<DetailProductSubitemDto>();
        ArrayList<DetailProductSpecificationValueDto> specificationValueList = new ArrayList<DetailProductSpecificationValueDto>();
        DetailProductSpecificationDto detailProductSpecificationDto = new DetailProductSpecificationDto();
        for (ProductSubitem productSubitem : productSubitems) {
            DetailProductMaterialPackageDto detailProductMaterialPackageDto = new DetailProductMaterialPackageDto();
            detailProductMaterialPackageDto.setMaterialPackageId(productSubitem.getMaterialId());
            detailProductMaterialPackageDto.setMaterialPackageName(productSubitem.getMaterialName());
            materialList.add(detailProductMaterialPackageDto);
            detailProductSpecificationDto.setSpecificationId(productSubitem.getSpecificationId());
            detailProductSpecificationDto.setSpecificationName(productSubitem.getSpecificationName());
            DetailProductSpecificationValueDto detailProductSpecificationValueDto = new DetailProductSpecificationValueDto();
            detailProductSpecificationValueDto.setSpecificationValueId(productSubitem.getSpecificationValueId());
            detailProductSpecificationValueDto.setSpecificationValueName(productSubitem.getSpecificationValueName());
            specificationValueList.add(detailProductSpecificationValueDto);
            DetailProductSubitemDto detailProductSubitemDto = new DetailProductSubitemDto();
            detailProductSubitemDto.setProductId(productSubitem.getProductId());
            detailProductSubitemDto.setMaterialId(productSubitem.getMaterialId());
            detailProductSubitemDto.setMaterialName(productSubitem.getMaterialName());
            detailProductSubitemDto.setSpecificationId(productSubitem.getSpecificationId());
            detailProductSubitemDto.setSpecificationName(productSubitem.getSpecificationName());
            detailProductSubitemDto.setSpecificationValueId(productSubitem.getSpecificationValueId());
            detailProductSubitemDto.setSpecificationValueName(productSubitem.getSpecificationValueName());
            detailProductSubitemDto.setUsefulLife(productSubitem.getUsefulLife());
            detailProductSubitemDto.setServiceTimes(productSubitem.getServiceTimes());
            detailProductSubitemDto.setPrice(productSubitem.getPrice());
            detailProductSubitemDto.setIntroduce(productSubitem.getIntroduce());
            subitemList.add(detailProductSubitemDto);
        }
        detailProductDto.setDetailProductMaterialPackageDtoList(materialList.stream().distinct().collect(Collectors.toList()));
        detailProductSpecificationDto.setDetailProductSpecificationValueDtoList(specificationValueList.stream().distinct().collect(Collectors.toList()));
        detailProductDto.setDetailProductSpecificationDto(detailProductSpecificationDto);
        detailProductDto.setDetailProductSubitemDtoList(subitemList.stream().distinct().collect(Collectors.toList()));
        return detailProductDto;
    }

    @Transactional
    public Boolean updateProduct(UpdateProductVo updateProductVo) {
        UpdateProductDataVo updateProductDataVo = updateProductVo.getUpdateProductDataVo();
        QueryWrapper productQueryWrapper = (QueryWrapper)new QueryWrapper().eq((Object)"view_id", (Object)updateProductDataVo.getProductViewId());
        Product product = (Product)this.productMapper.selectOne((Wrapper)productQueryWrapper);
        if (StringUtils.isNotEmpty((CharSequence)updateProductDataVo.getProductName())) {
            product.setName(updateProductDataVo.getProductName());
        }
        if (StringUtils.isNotEmpty((CharSequence)updateProductDataVo.getProductImage())) {
            product.setImage(updateProductDataVo.getProductImage());
        }
        if (updateProductDataVo.getProductCategoryId() != null && updateProductDataVo.getProductCategoryId().intValue() != 0) {
            product.setProductCategoryId(updateProductDataVo.getProductCategoryId());
        }
        QueryWrapper subitemQueryWrapper = (QueryWrapper)new QueryWrapper().eq((Object)"product_id", (Object)product.getId());
        int delete = this.productSubitemMapper.delete((Wrapper)subitemQueryWrapper);
        List updateProductSubitemVoList = updateProductVo.getUpdateProductSubitemVoList();
        BigDecimal decimal = new BigDecimal(0.0);
        for (UpdateProductSubitemVo updateProductSubitemVo : updateProductSubitemVoList) {
            ProductSubitem productSubitem = new ProductSubitem();
            productSubitem.setViewId(UniqueKeyGenerator.generateUUID());
            productSubitem.setProductId(product.getId());
            productSubitem.setMaterialId(updateProductSubitemVo.getMaterialId());
            productSubitem.setMaterialName(updateProductSubitemVo.getMaterialName());
            productSubitem.setSpecificationId(updateProductSubitemVo.getSpecificationId());
            productSubitem.setSpecificationName(updateProductSubitemVo.getSpecificationName());
            productSubitem.setSpecificationValueId(updateProductSubitemVo.getSpecificationValueId());
            productSubitem.setSpecificationValueName(updateProductSubitemVo.getSpecificationValueName());
            productSubitem.setUsefulLife(updateProductSubitemVo.getUsefulLife());
            productSubitem.setServiceTimes(updateProductSubitemVo.getServiceTimes());
            productSubitem.setPrice(updateProductSubitemVo.getPrice());
            productSubitem.setIntroduce(updateProductSubitemVo.getIntroduce());
            decimal = decimal.multiply(updateProductSubitemVo.getPrice());
            int save = this.productSubitemMapper.insert((Object)productSubitem);
            if (save == 1) continue;
            return false;
        }
        product.setPrice(decimal);
        int update = this.productMapper.updateById((Object)product);
        if (update != 1) {
            return false;
        }
        return null;
    }
}

