/*
 * Decompiled with CFR 0.152.
 */
package com.byh.server.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.byh.server.config.HospitalConfig;
import com.byh.server.mapper.UserAddressMapper;
import com.byh.server.pojo.dto.QueryUserAddressDto;
import com.byh.server.pojo.entity.UserAddress;
import com.byh.server.pojo.vo.SaveUserAddressVo;
import com.byh.server.pojo.vo.UpdateUserAddressVo;
import com.byh.server.service.UserAddressService;
import com.byh.server.utils.DistanceUtil;
import com.byh.server.utils.UniqueKeyGenerator;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class UserAddressServiceImpl
extends ServiceImpl<UserAddressMapper, UserAddress>
implements UserAddressService {
    @Autowired
    private UserAddressMapper userAddressMapper;

    @Transactional(rollbackFor={Exception.class})
    public String saveUserAddress(SaveUserAddressVo saveUserAddressVo) {
        UserAddress userAddress;
        Integer noDefault = 0;
        UserAddress isDefault = (UserAddress)this.userAddressMapper.selectOne((Wrapper)new QueryWrapper().eq((Object)"is_default", (Object)1));
        if (Objects.nonNull(isDefault) && Integer.valueOf(1).equals(saveUserAddressVo.getIsDefault())) {
            userAddress = new UserAddress();
            userAddress.setId(isDefault.getId());
            userAddress.setIsDefault(noDefault);
            this.userAddressMapper.updateById((Object)userAddress);
        }
        userAddress = new UserAddress();
        BeanUtils.copyProperties((Object)saveUserAddressVo, (Object)userAddress);
        userAddress.setViewId(UniqueKeyGenerator.generateViewId().toString());
        this.userAddressMapper.insert((Object)userAddress);
        return "\u5730\u5740\u6dfb\u52a0\u6210\u529f";
    }

    public List<QueryUserAddressDto> selectUserAddressByUserId(Long userId) {
        ArrayList<QueryUserAddressDto> queryUserAddressDtoList = new ArrayList<QueryUserAddressDto>();
        List userAddressList = this.userAddressMapper.selectList((Wrapper)new QueryWrapper().eq((Object)"user_id", (Object)userId));
        for (UserAddress userAddress : userAddressList) {
            QueryUserAddressDto queryUserAddressDto = new QueryUserAddressDto();
            BeanUtils.copyProperties((Object)userAddress, (Object)queryUserAddressDto);
            double distance = DistanceUtil.distance((double)userAddress.getLatitude(), (double)userAddress.getLongitude(), (double)HospitalConfig.HOS_LAT, (double)HospitalConfig.HOS_LNG);
            this.getIsDistributionAndAddrPrice(distance, queryUserAddressDto);
            queryUserAddressDtoList.add(queryUserAddressDto);
        }
        return queryUserAddressDtoList;
    }

    public QueryUserAddressDto selectUserAddressByAddrId(Long addrId) {
        UserAddress userAddress = (UserAddress)this.userAddressMapper.selectById((Serializable)addrId);
        if (Objects.isNull(userAddress)) {
            return null;
        }
        QueryUserAddressDto queryUserAddressDto = new QueryUserAddressDto();
        BeanUtils.copyProperties((Object)userAddress, (Object)queryUserAddressDto);
        double distance = DistanceUtil.distance((double)userAddress.getLatitude(), (double)userAddress.getLongitude(), (double)HospitalConfig.HOS_LAT, (double)HospitalConfig.HOS_LNG);
        this.getIsDistributionAndAddrPrice(distance, queryUserAddressDto);
        return queryUserAddressDto;
    }

    public String deleteUserAddress(Long addrId) {
        this.userAddressMapper.delete((Wrapper)new QueryWrapper().eq((Object)"id", (Object)addrId));
        return "\u5730\u5740\u5220\u9664\u6210\u529f";
    }

    @Transactional(rollbackFor={Exception.class})
    public String updateUserAddressIsDefault(Long addrId, Integer isDefault) {
        UserAddress address;
        int noDefault = 0;
        if (Integer.valueOf(1).equals(isDefault) && Objects.nonNull(address = (UserAddress)this.userAddressMapper.selectOne((Wrapper)new QueryWrapper().eq((Object)"is_default", (Object)1)))) {
            UserAddress userAddress = new UserAddress();
            userAddress.setId(address.getId());
            userAddress.setIsDefault(Integer.valueOf(noDefault));
            this.userAddressMapper.updateById((Object)userAddress);
        }
        UserAddress userAddress = new UserAddress();
        userAddress.setId(Integer.valueOf(addrId.intValue()));
        userAddress.setIsDefault(isDefault);
        this.userAddressMapper.updateById((Object)userAddress);
        return "\u5730\u5740\u4fee\u6539\u6210\u529f";
    }

    public String updateUserAddress(UpdateUserAddressVo updateUserAddressVo) {
        UserAddress address;
        int noDefault = 0;
        if (Integer.valueOf(1).equals(updateUserAddressVo.getIsDefault()) && Objects.nonNull(address = (UserAddress)this.userAddressMapper.selectOne((Wrapper)new QueryWrapper().eq((Object)"is_default", (Object)1)))) {
            UserAddress userAddress = new UserAddress();
            userAddress.setId(address.getId());
            userAddress.setIsDefault(Integer.valueOf(noDefault));
            this.userAddressMapper.updateById((Object)userAddress);
        }
        UserAddress userAddress = new UserAddress();
        BeanUtils.copyProperties((Object)updateUserAddressVo, (Object)userAddress);
        userAddress.setId(Integer.valueOf(updateUserAddressVo.getAddressId().intValue()));
        this.userAddressMapper.updateById((Object)userAddress);
        return "\u5730\u5740\u4fee\u6539\u6210\u529f";
    }

    private void getIsDistributionAndAddrPrice(double distance, QueryUserAddressDto queryUserAddressDto) {
        BigDecimal addrPrice = new BigDecimal("0");
        if (distance != 0.0) {
            if (distance > 10000.0) {
                queryUserAddressDto.setIsDistribution(Integer.valueOf(3));
            } else if (distance < 5000.0) {
                queryUserAddressDto.setIsDistribution(Integer.valueOf(1));
            } else {
                queryUserAddressDto.setIsDistribution(Integer.valueOf(2));
                BigDecimal subtract = BigDecimal.valueOf(distance).subtract(new BigDecimal(5000.0)).divide(new BigDecimal("1000"), 0, RoundingMode.HALF_UP);
                addrPrice = addrPrice.add(subtract.multiply(new BigDecimal(12)));
            }
        }
        queryUserAddressDto.setAddrPrice(addrPrice);
    }
}

