/*
 * Decompiled with CFR 0.152.
 */
package com.byh.bill.controller;

import com.byh.bill.BillApi;
import com.byh.bill.pojo.dto.AddBillDetailDTO;
import com.byh.bill.pojo.vo.BillDetailObjectResVO;
import com.byh.bill.pojo.vo.BillMonthCountVO;
import com.byh.bill.pojo.vo.BillMonthInfoListVO;
import com.byh.bill.pojo.vo.BillMonthListReqVO;
import com.byh.bill.pojo.vo.BillObjectListReqVO;
import com.byh.bill.pojo.vo.BillObjectReqVO;
import com.byh.bill.pojo.vo.BillObjectResVO;
import com.byh.bill.pojo.vo.BillSettlementResVO;
import com.byh.bill.pojo.vo.SettleMentReqVO;
import com.byh.bill.service.IBillDetailService;
import com.byh.bill.service.IBillObjectService;
import com.byh.bill.service.IBillSettlementService;
import com.byh.bill.utils.ExcelExportUtil;
import com.ebaiyihui.framework.page.PageRequest;
import com.ebaiyihui.framework.page.PageResult;
import com.ebaiyihui.framework.response.BaseResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u8d26\u5355\u76f8\u5173"})
@Validated
public class BillController
implements BillApi {
    @Resource
    private IBillDetailService billDetailService;
    @Resource
    private IBillObjectService billObjectService;
    @Resource
    private IBillSettlementService billSettlementService;

    @ApiOperation(value="\u65b0\u589e\u8d26\u5355", httpMethod="POST", notes="\u65b0\u589e\u8d26\u5355")
    public BaseResponse<String> addBillDetail(@RequestBody AddBillDetailDTO vo) {
        return this.billDetailService.addBillDetail(vo);
    }

    @ApiOperation(value="\u8d26\u5355\u5bf9\u8c61ID\uff08\u533b\u751f/\u56e2\u961f/\u7b49\uff09\u3001\u6267\u4e1a\u673a\u6784ID\u3001\u670d\u52a1\u7f16\u7801\u7ec4\u5408\u67e5\u8be2\u8d26\u5355", httpMethod="POST", notes="\u8d26\u5355\u5bf9\u8c61ID\uff08\u533b\u751f/\u56e2\u961f/\u7b49\uff09\u3001\u6267\u4e1a\u673a\u6784ID\u3001\u670d\u52a1\u7f16\u7801\u7ec4\u5408\u67e5\u8be2\u8d26\u5355")
    public BaseResponse<List<BillObjectResVO>> queryBillObjectList(@RequestBody BillObjectReqVO reqVO) {
        if (StringUtils.isEmpty((String)reqVO.getObjectId())) {
            return BaseResponse.error((String)"\u53c2\u6570\u9519\u8bef:\u8d26\u5355\u5bf9\u8c61ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.billObjectService.queryBillObjectList(reqVO);
    }

    @ApiOperation(value="\u8d26\u5355\u5217\u8868", httpMethod="POST", notes="\u8d26\u5355\u660e\u7ec6\u5217\u8868")
    public BaseResponse<PageResult<BillDetailObjectResVO>> queryBillDetailList(@RequestBody PageRequest<BillObjectListReqVO> vo) {
        return this.billDetailService.queryBillDetailList(vo);
    }

    public void excelExport(@RequestParam(value="appCode") String appCode, @RequestParam(value="organCode") String organCode, @RequestParam(value="billDetailIds") List<String> billDetailIds, HttpServletResponse response) {
        ExcelExportUtil excelExport = this.billDetailService.doExportDetail(appCode, organCode, billDetailIds);
        try {
            response.setHeader("Content-disposition", "attachment; filename=" + new String(excelExport.getTitle().getBytes("iso8859-1"), "UTF-8"));
            response.setContentType("application/vnd.ms-excel;charset=utf-8");
            response.setCharacterEncoding("UTF-8");
            excelExport.export((OutputStream)response.getOutputStream());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public BaseResponse<PageResult<BillDetailObjectResVO>> queryBillDetailListServicePage(@RequestBody BillMonthInfoListVO vo) {
        return this.billDetailService.queryBillDetailListServicePag(vo);
    }

    public BaseResponse<List<BillMonthCountVO>> findBillDetailMonthAndTotal(@RequestBody BillMonthListReqVO vo) {
        return this.billObjectService.findBillDetailMonthAndTotal(vo);
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/findBillSettleMentList"})
    @ApiOperation(value="\u7ed3\u7b97\u660e\u7ec6\u5217\u8868", httpMethod="POST", notes="\u7ed3\u7b97\u660e\u7ec6\u5217\u8868")
    public BaseResponse<List<BillSettlementResVO>> findBillSettleMentList(@RequestBody SettleMentReqVO vo) {
        return this.billSettlementService.findBillSettlementList(vo);
    }
}

