/*
 * Decompiled with CFR 0.152.
 */
package com.byh.bill.utils;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelExportUtil {
    private String title;
    private String[] titleRow;
    private Boolean showOrder = true;
    private Boolean needTitle = true;
    private List<Object[]> dataList = new ArrayList();
    private static final Logger logger = LoggerFactory.getLogger(ExcelExportUtil.class);

    public ExcelExportUtil(String title, String[] titleRow, List<Object[]> dataList) {
        this.dataList = dataList;
        this.titleRow = titleRow;
        this.title = title;
    }

    public ExcelExportUtil(String title, String[] titleRow, List<Object[]> dataList, Boolean showOrder) {
        this.dataList = dataList;
        this.titleRow = titleRow;
        this.showOrder = showOrder;
        this.setTitle(title);
    }

    public void export(OutputStream out, Boolean needTitle) {
        this.needTitle = needTitle;
        this.export(out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void export(OutputStream out) {
        try {
            HSSFWorkbook workbook = new HSSFWorkbook();
            HSSFSheet sheet = workbook.createSheet(this.getTitle());
            HSSFCellStyle columnTopStyle = this.getColumnTopStyle(workbook);
            HSSFCellStyle style = this.getStyle(workbook);
            int columnNum = this.titleRow.length;
            HSSFRow row = sheet.createRow(0);
            for (int n = 0; n < columnNum; ++n) {
                HSSFCell cell = row.createCell(n);
                cell.setCellType(CellType.STRING);
                HSSFRichTextString text = new HSSFRichTextString(this.titleRow[n]);
                cell.setCellValue((RichTextString)text);
                cell.setCellStyle(columnTopStyle);
            }
            for (int i = 0; i < this.dataList.size(); ++i) {
                Object[] obj = (Object[])this.dataList.get(i);
                HSSFRow dataRow = sheet.createRow(i + 1);
                for (int j = 0; j < obj.length; ++j) {
                    HSSFCell cell = null;
                    if (j == 0 && this.showOrder.booleanValue()) {
                        cell = dataRow.createCell(j, CellType.NUMERIC);
                        cell.setCellValue((double)i + 1.0);
                    } else {
                        cell = dataRow.createCell(j, CellType.STRING);
                        if (obj[j] != null) {
                            cell.setCellValue(obj[j].toString());
                        } else {
                            cell.setCellValue(" ");
                        }
                    }
                    cell.setCellStyle(style);
                }
            }
            for (int colNum = 0; colNum < columnNum; ++colNum) {
                int columnWidth = sheet.getColumnWidth(colNum) / 256;
                for (int rowNum = 0; rowNum < sheet.getLastRowNum(); ++rowNum) {
                    HSSFCell currentCell;
                    HSSFRow currentRow = sheet.getRow(rowNum) == null ? sheet.createRow(rowNum) : sheet.getRow(rowNum);
                    if (currentRow.getCell(colNum) == null || (currentCell = currentRow.getCell(colNum)).getCellTypeEnum() != CellType.STRING) continue;
                    int length = 0;
                    try {
                        if (null != currentCell && null != currentCell.getStringCellValue()) {
                            length = currentCell.getStringCellValue().getBytes().length;
                        }
                    }
                    catch (Exception e) {
                        logger.error("\u8bbe\u7f6e\u6837\u5f0f\u5931\u8d25:" + e.getMessage(), (Throwable)e);
                    }
                    if (columnWidth >= length) continue;
                    columnWidth = length;
                }
                if (colNum == 0) {
                    sheet.setColumnWidth(colNum, (columnWidth - 2) * 256);
                    continue;
                }
                if (columnWidth > 150) {
                    columnWidth = 150;
                }
                sheet.setColumnWidth(colNum, (columnWidth + 4) * 256);
            }
            if (workbook != null) {
                try {
                    workbook.write(out);
                }
                catch (IOException e) {
                    logger.error("\u8bbe\u7f6e\u6837\u5f0f\u5931\u8d25:" + e.getMessage(), (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            logger.error("\u8bbe\u7f6e\u6837\u5f0f\u5931\u8d25:" + e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                out.close();
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public HSSFCellStyle getColumnTopStyle(HSSFWorkbook workbook) {
        HSSFFont font = workbook.createFont();
        font.setFontHeightInPoints((short)11);
        font.setBold(true);
        font.setFontName("Courier New");
        HSSFCellStyle style = workbook.createCellStyle();
        style.setBorderBottom(BorderStyle.THIN);
        style.setBottomBorderColor(IndexedColors.BLACK.getIndex());
        style.setBorderLeft(BorderStyle.THIN);
        style.setLeftBorderColor(IndexedColors.BLACK.getIndex());
        style.setBorderRight(BorderStyle.THIN);
        style.setRightBorderColor(IndexedColors.BLACK.getIndex());
        style.setBorderTop(BorderStyle.THIN);
        style.setTopBorderColor(IndexedColors.BLACK.getIndex());
        style.setFont(font);
        style.setWrapText(false);
        style.setAlignment(HorizontalAlignment.CENTER);
        style.setVerticalAlignment(VerticalAlignment.CENTER);
        return style;
    }

    public HSSFCellStyle getStyle(HSSFWorkbook workbook) {
        HSSFFont font = workbook.createFont();
        font.setFontName("Courier New");
        HSSFCellStyle style = workbook.createCellStyle();
        style.setBorderBottom(BorderStyle.THIN);
        style.setBottomBorderColor(IndexedColors.BLACK.getIndex());
        style.setBorderLeft(BorderStyle.THIN);
        style.setLeftBorderColor(IndexedColors.BLACK.getIndex());
        style.setBorderRight(BorderStyle.THIN);
        style.setRightBorderColor(IndexedColors.BLACK.getIndex());
        style.setBorderTop(BorderStyle.THIN);
        style.setTopBorderColor(IndexedColors.BLACK.getIndex());
        style.setFont(font);
        style.setWrapText(false);
        style.setAlignment(HorizontalAlignment.CENTER);
        style.setVerticalAlignment(VerticalAlignment.CENTER);
        return style;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String[] getTitleRow() {
        return this.titleRow;
    }

    public void setTitleRow(String[] titleRow) {
        this.titleRow = titleRow;
    }

    public Boolean getShowOrder() {
        return this.showOrder;
    }

    public void setShowOrder(Boolean showOrder) {
        this.showOrder = showOrder;
    }

    public Boolean getNeedTitle() {
        return this.needTitle;
    }

    public void setNeedTitle(Boolean needTitle) {
        this.needTitle = needTitle;
    }

    public List<Object[]> getDataList() {
        return this.dataList;
    }

    public void setDataList(List<Object[]> dataList) {
        this.dataList = dataList;
    }
}

