/*
 * Decompiled with CFR 0.152.
 */
package com.byh.bill.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.byh.bill.common.ServCodeEnum;
import com.byh.bill.mapper.BillDetailMapper;
import com.byh.bill.mapper.BillObjectMapper;
import com.byh.bill.pojo.dto.AddBillDetailDTO;
import com.byh.bill.pojo.dto.QueryOrganNameDTO;
import com.byh.bill.pojo.entity.BaseEntity;
import com.byh.bill.pojo.entity.BillDetailEntity;
import com.byh.bill.pojo.entity.BillObjectEntity;
import com.byh.bill.pojo.vo.BillDetailObjectResVO;
import com.byh.bill.pojo.vo.BillMonthInfoListVO;
import com.byh.bill.pojo.vo.BillObjectListReqVO;
import com.byh.bill.pojo.vo.BillObjectReqVO;
import com.byh.bill.pojo.vo.QueryOrganNameVO;
import com.byh.bill.service.IBillDetailService;
import com.byh.bill.service.feign.OrganizationFeignClient;
import com.byh.bill.utils.DateUtils;
import com.byh.bill.utils.ExcelExportUtil;
import com.ebaiyihui.framework.page.PageRequest;
import com.ebaiyihui.framework.page.PageResult;
import com.ebaiyihui.framework.response.BaseResponse;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class BillDetailServiceImpl
extends ServiceImpl<BillDetailMapper, BillDetailEntity>
implements IBillDetailService {
    private static final Logger log = LoggerFactory.getLogger(BillDetailServiceImpl.class);
    @Resource
    private BillDetailMapper billDetailMapper;
    @Resource
    private BillObjectMapper billObjectMapper;
    @Resource
    private OrganizationFeignClient organizationFeignClient;

    public BaseResponse<String> addBillDetail(AddBillDetailDTO vo) {
        BillDetailEntity bill = (BillDetailEntity)this.billDetailMapper.selectOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(BillDetailEntity::getAppCode, (Object)vo.getAppCode())).eq(BillDetailEntity::getTransactionId, (Object)vo.getTransactionId()));
        if (bill != null) {
            return BaseResponse.error((String)"\u5f53\u524d\u4ea4\u6613\u6570\u636e\u5df2\u7ecf\u5b58\u5728");
        }
        BillDetailEntity billDetailEntity = new BillDetailEntity();
        BeanUtils.copyProperties((Object)vo, (Object)billDetailEntity);
        this.billDetailMapper.insert((Object)billDetailEntity);
        BillObjectEntity billObject = (BillObjectEntity)this.billObjectMapper.selectOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(BillObjectEntity::getAppCode, (Object)vo.getAppCode())).eq(BillObjectEntity::getObjectId, (Object)vo.getObjectId())).eq(BillObjectEntity::getOrganCode, (Object)vo.getOrganCode())).eq(BillObjectEntity::getServCode, (Object)vo.getServCode()));
        if (billObject == null) {
            billObject = new BillObjectEntity();
            billObject.setObjectId(vo.getObjectId());
            billObject.setOrganCode(vo.getOrganCode());
            billObject.setServCode(vo.getServCode());
            billObject.setBalanceMoney(vo.getBillMoney());
            billObject.setTotalMoney(vo.getBillMoney());
            billObject.setSysBalanceMoney(vo.getOrderMoney());
            billObject.setSysTotalMoney(vo.getOrderMoney());
            billObject.setAppCode(vo.getAppCode());
            this.billObjectMapper.insert((Object)billObject);
        } else {
            if (1 == vo.getBillType()) {
                billObject.setBalanceMoney(billObject.getBalanceMoney().add(vo.getBillMoney()));
                billObject.setTotalMoney(billObject.getTotalMoney().add(vo.getBillMoney()));
                billObject.setSysBalanceMoney(billObject.getBalanceMoney().add(vo.getOrderMoney()));
                billObject.setSysTotalMoney(billObject.getTotalMoney().add(vo.getOrderMoney()));
            }
            if (2 == vo.getBillType()) {
                billObject.setBalanceMoney(billObject.getBalanceMoney().subtract(vo.getBillMoney()));
                billObject.setTotalMoney(billObject.getTotalMoney().subtract(vo.getBillMoney()));
                billObject.setSysBalanceMoney(billObject.getBalanceMoney().subtract(vo.getOrderMoney()));
                billObject.setSysTotalMoney(billObject.getTotalMoney().subtract(vo.getOrderMoney()));
            }
            if (3 == vo.getBillType()) {
                billObject.setBalanceMoney(billObject.getBalanceMoney().subtract(vo.getBillMoney()));
                billObject.setSysBalanceMoney(billObject.getBalanceMoney().subtract(vo.getOrderMoney()));
            }
            this.billObjectMapper.updateById((Object)billObject);
        }
        return BaseResponse.success((Object)"\u65b0\u589e\u6210\u529f");
    }

    public BaseResponse<PageResult<BillDetailObjectResVO>> queryBillDetailList(PageRequest<BillObjectListReqVO> vo) {
        LambdaQueryWrapper wapp = Wrappers.lambdaQuery();
        if (vo.getQuery() != null) {
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{((BillObjectListReqVO)vo.getQuery()).getObjectId()})) {
                ((BillObjectListReqVO)vo.getQuery()).setObjectIds(new ArrayList(1));
                ((BillObjectListReqVO)vo.getQuery()).getObjectIds().add(((BillObjectListReqVO)vo.getQuery()).getObjectId());
            }
            if (((BillObjectListReqVO)vo.getQuery()).getObjectIds() != null && ((BillObjectListReqVO)vo.getQuery()).getObjectIds().size() > 0) {
                wapp.in(BillDetailEntity::getObjectId, ((BillObjectListReqVO)vo.getQuery()).getObjectIds().toArray());
            }
            if (StringUtils.isNotEmpty((CharSequence)((BillObjectListReqVO)vo.getQuery()).getAppCode())) {
                wapp.eq(BillDetailEntity::getAppCode, (Object)((BillObjectListReqVO)vo.getQuery()).getAppCode());
            }
            if (StringUtils.isNotEmpty((CharSequence)((BillObjectListReqVO)vo.getQuery()).getOrganCode())) {
                wapp.eq(BillDetailEntity::getOrganCode, (Object)((BillObjectListReqVO)vo.getQuery()).getOrganCode());
            }
            if (StringUtils.isNotEmpty((CharSequence)((BillObjectListReqVO)vo.getQuery()).getServCode())) {
                wapp.eq(BillDetailEntity::getServCode, (Object)((BillObjectListReqVO)vo.getQuery()).getServCode());
            }
            if (StringUtils.isNotEmpty((CharSequence)((BillObjectListReqVO)vo.getQuery()).getName())) {
                wapp.and(wrappers -> (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrappers.like(BillDetailEntity::getDeptName, (Object)((BillObjectListReqVO)vo.getQuery()).getName())).or()).like(BillDetailEntity::getDoctorName, (Object)((BillObjectListReqVO)vo.getQuery()).getName())).or()).like(BillDetailEntity::getHospitalName, (Object)((BillObjectListReqVO)vo.getQuery()).getName()));
            }
            try {
                int length = 7;
                if (StringUtils.isNotEmpty((CharSequence)((BillObjectListReqVO)vo.getQuery()).getStartDate())) {
                    if (((BillObjectListReqVO)vo.getQuery()).getStartDate().length() == length) {
                        String[] start = ((BillObjectListReqVO)vo.getQuery()).getStartDate().split("-");
                        String startDate = DateUtils.getFirstDayOfMonth((int)Integer.valueOf(start[0]), (int)Integer.valueOf(start[1]));
                        wapp.gt(BaseEntity::getxCreateTime, (Object)DateUtils.stringToFullDate((String)(startDate + " 00:00:00")));
                    } else {
                        wapp.gt(BaseEntity::getxCreateTime, (Object)(((BillObjectListReqVO)vo.getQuery()).getStartDate() + " 00:00:00"));
                    }
                }
                if (StringUtils.isNotEmpty((CharSequence)((BillObjectListReqVO)vo.getQuery()).getEndDate())) {
                    if (((BillObjectListReqVO)vo.getQuery()).getEndDate().length() == length) {
                        String[] end = ((BillObjectListReqVO)vo.getQuery()).getEndDate().split("-");
                        String endDate = DateUtils.getLastDayOfMonth((int)Integer.valueOf(end[0]), (int)Integer.valueOf(end[1]));
                        wapp.lt(BaseEntity::getxCreateTime, (Object)DateUtils.stringToFullDate((String)(endDate + " 23:59:59")));
                    } else {
                        wapp.lt(BaseEntity::getxCreateTime, (Object)(((BillObjectListReqVO)vo.getQuery()).getEndDate() + " 23:59:59"));
                    }
                }
            }
            catch (Exception e) {
                return BaseResponse.error((String)"\u65f6\u95f4\u683c\u5f0f\u9519\u8bef");
            }
        }
        wapp.orderByDesc((Object[])new SFunction[]{BaseEntity::getxCreateTime});
        Page page = new Page((long)vo.getPageNum(), (long)vo.getPageSize());
        IPage list = this.billDetailMapper.selectPage((IPage)page, (Wrapper)wapp);
        Integer count = (int)list.getTotal();
        PageResult res = new PageResult();
        ArrayList<BillDetailObjectResVO> listRes = new ArrayList<BillDetailObjectResVO>();
        List listEntity = list.getRecords();
        if (listEntity.isEmpty()) {
            BaseResponse.success((Object)res);
        }
        for (BillDetailEntity entity : listEntity) {
            BillDetailObjectResVO resVO = new BillDetailObjectResVO();
            BeanUtils.copyProperties((Object)entity, (Object)resVO);
            resVO.setBillDetailId(entity.getxId());
            resVO.setServName(ServCodeEnum.getServName((String)resVO.getServCode()));
            BillObjectEntity billObject = (BillObjectEntity)this.billObjectMapper.selectOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(BillObjectEntity::getAppCode, (Object)entity.getAppCode())).eq(BillObjectEntity::getObjectId, (Object)entity.getObjectId())).eq(BillObjectEntity::getOrganCode, (Object)entity.getOrganCode())).eq(BillObjectEntity::getServCode, (Object)entity.getServCode()));
            if (billObject != null) {
                resVO.setBalanceMoney(billObject.getBalanceMoney());
                resVO.setBillObjectId(billObject.getxId());
                resVO.setTotalMoney(billObject.getTotalMoney());
                resVO.setSysBalanceMoney(billObject.getSysBalanceMoney());
                resVO.setSysTotalMoney(billObject.getSysTotalMoney());
            }
            listRes.add(resVO);
        }
        res.setContent(listRes);
        int num = count / vo.getPageSize();
        int numLes = count % vo.getPageSize();
        if (numLes > 0) {
            ++num;
        }
        res.setTotalPages(num);
        res.setPageSize(vo.getPageSize());
        res.setPageNum(vo.getPageNum());
        res.setTotal(count.intValue());
        return BaseResponse.success((Object)res);
    }

    public ExcelExportUtil doExportDetail(String appCode, String organCode, List<String> billDetailIds) {
        List list = new ArrayList();
        BillObjectReqVO VO = new BillObjectReqVO();
        VO.setAppCode(appCode);
        VO.setOrganCode(organCode);
        VO.setBillDetailIds(billDetailIds);
        BaseResponse data = this.excelExportDetail(VO);
        if (data == null) {
            return null;
        }
        list = (List)data.getData();
        String[] rowname = new String[]{"", "\u7f16\u53f7", "\u59d3\u540d", "\u533b\u9662", "\u79d1\u5ba4", "\u9879\u76ee", "\u91d1\u989d(\u5143)", "\u8d26\u5355\u65f6\u95f4"};
        Date nowTime = new Date();
        ArrayList<Object[]> dataList = new ArrayList<Object[]>();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM\u6708dd\u65e5HH\u65f6mm\u5206");
        for (BillDetailObjectResVO entity : list) {
            Object[] objArray = new Object[8];
            objArray[0] = "";
            objArray[1] = entity.getBillDetailId();
            objArray[2] = entity.getDoctorName();
            objArray[3] = entity.getHospitalName();
            objArray[4] = entity.getDeptName();
            objArray[5] = entity.getServName();
            objArray[6] = "\u4f59\u989d\u4f53\u73b0".equals(entity.getServName()) ? new BigDecimal("-" + entity.getBillMoney()) : entity.getBillMoney();
            if (entity.getxCreateTime() != null) {
                objArray[7] = DateUtils.dateToFullString((Date)entity.getxCreateTime());
            }
            dataList.add(objArray);
        }
        String dateString = sdf.format(nowTime);
        ExcelExportUtil detailExcel = new ExcelExportUtil("\u8d26\u5355\u5217\u8868" + dateString + ".xls", rowname, dataList);
        return detailExcel;
    }

    public BaseResponse<List<BillDetailObjectResVO>> excelExportDetail(BillObjectReqVO vo) {
        log.info("\u5165\u53c2:" + vo.toString());
        List<BillDetailEntity> listRes = new ArrayList();
        if (vo.getBillDetailIds() != null && !vo.getBillDetailIds().isEmpty()) {
            log.info(vo.getBillDetailIds() + "");
            for (String id : vo.getBillDetailIds()) {
                BillDetailEntity entity = (BillDetailEntity)this.billDetailMapper.selectOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(BillDetailEntity::getAppCode, (Object)vo.getAppCode())).eq(BaseEntity::getxId, (Object)id));
                listRes.add(entity);
            }
        } else {
            LambdaQueryWrapper wapp = Wrappers.lambdaQuery();
            if (vo != null) {
                if (StringUtils.isNotEmpty((CharSequence)vo.getAppCode())) {
                    wapp.eq(BillDetailEntity::getAppCode, (Object)vo.getAppCode());
                }
                if (StringUtils.isNotEmpty((CharSequence)vo.getObjectId())) {
                    wapp.eq(BillDetailEntity::getObjectId, (Object)vo.getObjectId());
                }
                if (StringUtils.isNotEmpty((CharSequence)vo.getOrganCode())) {
                    wapp.eq(BillDetailEntity::getOrganCode, (Object)vo.getOrganCode());
                }
                if (StringUtils.isNotEmpty((CharSequence)vo.getServCode())) {
                    wapp.eq(BillDetailEntity::getServCode, (Object)vo.getServCode());
                }
                if (StringUtils.isNotEmpty((CharSequence)vo.getName())) {
                    wapp.and(wrappers -> (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrappers.like(BillDetailEntity::getDeptName, (Object)vo.getName())).or()).like(BillDetailEntity::getDoctorName, (Object)vo.getName())).or()).like(BillDetailEntity::getHospitalName, (Object)vo.getName()));
                }
                try {
                    int length = 7;
                    if (StringUtils.isNotEmpty((CharSequence)vo.getStartDate())) {
                        if (vo.getStartDate().length() == length) {
                            String[] start = vo.getStartDate().split("-");
                            String startDate = DateUtils.getFirstDayOfMonth((int)Integer.valueOf(start[0]), (int)Integer.valueOf(start[1]));
                            wapp.gt(BaseEntity::getxCreateTime, (Object)DateUtils.stringToFullDate((String)(startDate + " 00:00:00")));
                        } else {
                            wapp.gt(BaseEntity::getxCreateTime, (Object)(vo.getStartDate() + " 00:00:00"));
                        }
                    }
                    if (StringUtils.isNotEmpty((CharSequence)vo.getEndDate())) {
                        if (vo.getEndDate().length() == length) {
                            String[] end = vo.getEndDate().split("-");
                            String endDate = DateUtils.getLastDayOfMonth((int)Integer.valueOf(end[0]), (int)Integer.valueOf(end[1]));
                            wapp.lt(BaseEntity::getxCreateTime, (Object)DateUtils.stringToFullDate((String)(endDate + " 23:59:59")));
                        } else {
                            wapp.lt(BaseEntity::getxCreateTime, (Object)(vo.getEndDate() + " 23:59:59"));
                        }
                    }
                }
                catch (Exception length) {
                    // empty catch block
                }
            }
            wapp.orderByDesc((Object[])new SFunction[]{BaseEntity::getxCreateTime});
            listRes = this.billDetailMapper.selectList((Wrapper)wapp);
        }
        ArrayList<BillDetailObjectResVO> list = new ArrayList<BillDetailObjectResVO>();
        List entityList = listRes.stream().filter(s -> s != null).collect(Collectors.toList());
        if (entityList.size() == 0) {
            log.info("\u67e5\u8be2\u6570\u636e\u4e3a\u7a7a");
            return BaseResponse.success(list);
        }
        log.info("====================" + listRes.toString());
        for (BillDetailEntity entity : entityList) {
            BillDetailObjectResVO resVO = new BillDetailObjectResVO();
            log.info("\u5faa\u73af\u67e5\u8be2\u6570\u636e" + entity);
            BeanUtils.copyProperties((Object)entity, (Object)resVO);
            resVO.setBillDetailId(entity.getxId());
            resVO.setServName(ServCodeEnum.getServName((String)resVO.getServCode()));
            BillObjectEntity billObject = (BillObjectEntity)this.billObjectMapper.selectOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(BillObjectEntity::getAppCode, (Object)entity.getAppCode())).eq(BillObjectEntity::getObjectId, (Object)entity.getObjectId())).eq(BillObjectEntity::getOrganCode, (Object)entity.getOrganCode())).eq(BillObjectEntity::getServCode, (Object)entity.getServCode()));
            if (billObject != null) {
                resVO.setTotalMoney(billObject.getTotalMoney());
                resVO.setBalanceMoney(billObject.getBalanceMoney());
                resVO.setBillObjectId(billObject.getxId());
                resVO.setSysBalanceMoney(billObject.getSysBalanceMoney());
                resVO.setSysTotalMoney(billObject.getSysTotalMoney());
            }
            list.add(resVO);
        }
        return BaseResponse.success(list);
    }

    public BaseResponse<PageResult<BillDetailObjectResVO>> queryBillDetailListServicePag(BillMonthInfoListVO bill) {
        List list;
        PageRequest vo = new PageRequest();
        vo.setPageSize(bill.getPageSize().intValue());
        vo.setPageNum(bill.getPageNum().intValue());
        BillObjectListReqVO billObjectReqVO = new BillObjectListReqVO();
        billObjectReqVO.setOrganCode(bill.getOrganCode());
        ArrayList<String> objectIds = new ArrayList<String>(1);
        objectIds.add(bill.getObjectId());
        billObjectReqVO.setObjectIds(objectIds);
        billObjectReqVO.setServCode(bill.getServCode());
        billObjectReqVO.setStartDate(bill.getMonthTime());
        billObjectReqVO.setEndDate(bill.getMonthTime());
        billObjectReqVO.setAppCode(bill.getAppCode());
        vo.setQuery((Object)billObjectReqVO);
        BaseResponse resVOHxPage = this.queryBillDetailList(vo);
        if (resVOHxPage != null && resVOHxPage.getData() != null && (list = ((PageResult)resVOHxPage.getData()).getContent()) != null && !list.isEmpty()) {
            for (BillDetailObjectResVO resVO : list) {
                QueryOrganNameDTO dto = new QueryOrganNameDTO();
                dto.setOrganCode(resVO.getOrganCode());
                BaseResponse baseResponse = this.organizationFeignClient.queryOrganName(dto);
                if (baseResponse == null || baseResponse.getData() == null) continue;
                QueryOrganNameVO organNameVO = (QueryOrganNameVO)baseResponse.getData();
                resVO.setHospitalName(organNameVO.getOrganName());
            }
        }
        return resVOHxPage;
    }
}

