/*
 * Decompiled with CFR 0.152.
 */
package com.byh.bill.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.byh.bill.common.ServCodeEnum;
import com.byh.bill.mapper.BillDetailMapper;
import com.byh.bill.mapper.BillObjectMapper;
import com.byh.bill.pojo.dto.QueryOrganNameDTO;
import com.byh.bill.pojo.entity.BaseEntity;
import com.byh.bill.pojo.entity.BillDetailEntity;
import com.byh.bill.pojo.entity.BillObjectEntity;
import com.byh.bill.pojo.vo.BillDetaiResVO;
import com.byh.bill.pojo.vo.BillMonthCountVO;
import com.byh.bill.pojo.vo.BillMonthListReqVO;
import com.byh.bill.pojo.vo.BillObjectReqVO;
import com.byh.bill.pojo.vo.BillObjectResVO;
import com.byh.bill.pojo.vo.QueryOrganNameVO;
import com.byh.bill.pojo.vo.QueryTeamByDocterIdDTO;
import com.byh.bill.pojo.vo.QueryTeamByDocterIdRes;
import com.byh.bill.pojo.vo.ResultData;
import com.byh.bill.service.IBillObjectService;
import com.byh.bill.service.feign.OrganizationFeignClient;
import com.byh.bill.service.feign.TeamFeignClient;
import com.byh.bill.utils.DateUtils;
import com.ebaiyihui.framework.response.BaseResponse;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class BillObjectServiceImpl
extends ServiceImpl<BillObjectMapper, BillObjectEntity>
implements IBillObjectService {
    @Resource
    private BillDetailMapper billDetailMapper;
    @Resource
    private BillObjectMapper billObjectMapper;
    @Resource
    private OrganizationFeignClient organizationFeignClient;
    @Resource
    private TeamFeignClient teamFeignClient;
    private static Logger logger = LoggerFactory.getLogger(BillObjectServiceImpl.class);

    public BaseResponse<List<BillObjectResVO>> queryBillObjectList(BillObjectReqVO reqVO) {
        LambdaQueryWrapper wapp = Wrappers.lambdaQuery();
        if (StringUtils.isNotEmpty((CharSequence)reqVO.getAppCode())) {
            wapp.eq(BillObjectEntity::getAppCode, (Object)reqVO.getAppCode());
        }
        if (StringUtils.isNotEmpty((CharSequence)reqVO.getObjectId())) {
            wapp.eq(BillObjectEntity::getObjectId, (Object)reqVO.getObjectId());
        }
        if (StringUtils.isNotEmpty((CharSequence)reqVO.getOrganCode())) {
            wapp.eq(BillObjectEntity::getOrganCode, (Object)reqVO.getOrganCode());
        }
        if (StringUtils.isNotEmpty((CharSequence)reqVO.getServCode())) {
            wapp.eq(BillObjectEntity::getServCode, (Object)reqVO.getServCode());
        }
        List list = this.billObjectMapper.selectList((Wrapper)wapp);
        ArrayList<BillObjectResVO> listRes = new ArrayList<BillObjectResVO>();
        if (list.isEmpty()) {
            return BaseResponse.success(listRes);
        }
        for (BillObjectEntity entity : list) {
            BillObjectResVO resVO = new BillObjectResVO();
            BeanUtils.copyProperties((Object)entity, (Object)resVO);
            resVO.setServName(ServCodeEnum.getServName((String)resVO.getServCode()));
            LambdaQueryWrapper wappDetail = Wrappers.lambdaQuery();
            wappDetail.eq(BillDetailEntity::getAppCode, (Object)entity.getAppCode());
            wappDetail.eq(BillDetailEntity::getObjectId, (Object)entity.getObjectId());
            wappDetail.eq(BillDetailEntity::getOrganCode, (Object)entity.getOrganCode());
            wappDetail.eq(BillDetailEntity::getServCode, (Object)entity.getServCode());
            try {
                if (StringUtils.isNotEmpty((CharSequence)reqVO.getStartDate())) {
                    String[] start = reqVO.getStartDate().split("-");
                    String startDate = DateUtils.getFirstDayOfMonth((int)Integer.valueOf(start[0]), (int)Integer.valueOf(start[1]));
                    wappDetail.gt(BaseEntity::getxCreateTime, (Object)DateUtils.stringToFullDate((String)(startDate + " 00:00:00")));
                }
                if (StringUtils.isNotEmpty((CharSequence)reqVO.getEndDate())) {
                    String[] end = reqVO.getEndDate().split("-");
                    String endDate = DateUtils.getLastDayOfMonth((int)Integer.valueOf(end[0]), (int)Integer.valueOf(end[1]));
                    wappDetail.lt(BaseEntity::getxCreateTime, (Object)DateUtils.stringToFullDate((String)(endDate + " 23:59:59")));
                }
            }
            catch (Exception e) {
                return BaseResponse.error((String)"\u65f6\u95f4\u683c\u5f0f\u9519\u8bef");
            }
            List listDetail = this.billDetailMapper.selectList((Wrapper)wappDetail);
            ArrayList<BillDetaiResVO> billDetailRes = new ArrayList<BillDetaiResVO>();
            for (BillDetailEntity billDetailEntity : listDetail) {
                BillDetaiResVO detailResVO = new BillDetaiResVO();
                BeanUtils.copyProperties((Object)billDetailEntity, (Object)detailResVO);
                detailResVO.setServName(ServCodeEnum.getServName((String)billDetailEntity.getServCode()));
                detailResVO.setBillDetailId(billDetailEntity.getxId());
                billDetailRes.add(detailResVO);
            }
            resVO.setBillList(billDetailRes);
            listRes.add(resVO);
        }
        return BaseResponse.success(listRes);
    }

    public BaseResponse<List<BillMonthCountVO>> findBillDetailMonthAndTotal(BillMonthListReqVO vo) {
        ArrayList listRes = new ArrayList();
        List listDoc = this.getBillMonthInfo(vo);
        if (listDoc != null && !listDoc.isEmpty()) {
            for (BillMonthCountVO vo1 : listDoc) {
                vo1.setType((short)1);
            }
            listRes.addAll(listDoc);
        }
        QueryTeamByDocterIdDTO reqDto = new QueryTeamByDocterIdDTO();
        reqDto.setDoctorId(vo.getObjectId());
        ResultData resultFeign = this.teamFeignClient.queryTeamInfoByDocterId(reqDto);
        if (!resultFeign.isSuccess()) {
            return BaseResponse.success(listRes);
        }
        List teamList = (List)resultFeign.getData();
        HashMap<String, String> iteam = new HashMap<String, String>();
        for (QueryTeamByDocterIdRes queryTeamByDocterIdRes : teamList) {
            iteam.put(queryTeamByDocterIdRes.getTeamId(), queryTeamByDocterIdRes.getTeamName());
        }
        for (Map.Entry entry : iteam.entrySet()) {
            BillMonthListReqVO reqVO = new BillMonthListReqVO();
            reqVO.setObjectId((String)entry.getKey());
            List list = this.getBillMonthInfo(reqVO);
            if (list != null && !list.isEmpty()) {
                for (BillMonthCountVO vo2 : list) {
                    vo2.setItemName((String)entry.getValue());
                    vo2.setType((short)2);
                }
            }
            listRes.addAll(list);
        }
        return BaseResponse.success(listRes);
    }

    List<BillMonthCountVO> getBillMonthInfo(BillMonthListReqVO vo) {
        LambdaQueryWrapper wapp = Wrappers.lambdaQuery();
        if (StringUtils.isNotEmpty((CharSequence)vo.getAppCode())) {
            wapp.eq(BillObjectEntity::getAppCode, (Object)vo.getAppCode());
        }
        if (StringUtils.isNotEmpty((CharSequence)vo.getObjectId())) {
            wapp.eq(BillObjectEntity::getObjectId, (Object)vo.getObjectId());
        }
        wapp.orderByDesc((Object[])new SFunction[]{BaseEntity::getxCreateTime});
        List list = this.billObjectMapper.selectList((Wrapper)wapp);
        ArrayList<BillMonthCountVO> listRes = new ArrayList<BillMonthCountVO>();
        for (BillObjectEntity entity : list) {
            BillMonthCountVO resVO = new BillMonthCountVO();
            BeanUtils.copyProperties((Object)entity, (Object)resVO);
            QueryOrganNameDTO dto = new QueryOrganNameDTO();
            dto.setOrganCode(entity.getOrganCode());
            BaseResponse baseResponse = this.organizationFeignClient.queryOrganName(dto);
            if (baseResponse != null && baseResponse.getData() != null) {
                QueryOrganNameVO organNameVO = (QueryOrganNameVO)baseResponse.getData();
                resVO.setOrganName(organNameVO.getOrganName());
            }
            BigDecimal month = new BigDecimal(0);
            String nowMonth = DateUtils.getCurrentYear() + "-" + DateUtils.getCurrentMonth();
            month = month.add(this.sumMoneyByTypeAndDate(entity.getObjectId(), entity.getOrganCode(), entity.getServCode(), nowMonth, Integer.valueOf(1)));
            month = month.subtract(this.sumMoneyByTypeAndDate(entity.getObjectId(), entity.getOrganCode(), entity.getServCode(), nowMonth, Integer.valueOf(2)));
            month = month.subtract(this.sumMoneyByTypeAndDate(entity.getObjectId(), entity.getOrganCode(), entity.getServCode(), nowMonth, Integer.valueOf(3)));
            resVO.setMonthMoney(month);
            listRes.add(resVO);
        }
        return listRes;
    }

    private BigDecimal sumMoneyByTypeAndDate(String objectId, String organCode, String servCode, String yearMonth, Integer type) {
        LambdaQueryWrapper wappDetail = Wrappers.lambdaQuery();
        wappDetail.eq(BillDetailEntity::getObjectId, (Object)objectId);
        wappDetail.eq(BillDetailEntity::getOrganCode, (Object)organCode);
        wappDetail.eq(BillDetailEntity::getServCode, (Object)servCode);
        wappDetail.eq(BillDetailEntity::getBillType, (Object)type);
        if (StringUtils.isNotEmpty((CharSequence)yearMonth)) {
            String[] start = yearMonth.split("-");
            String startDate = DateUtils.getFirstDayOfMonth((int)Integer.valueOf(start[0]), (int)Integer.valueOf(start[1]));
            wappDetail.gt(BaseEntity::getxCreateTime, (Object)DateUtils.stringToFullDate((String)(startDate + " 00:00:00")));
        }
        if (StringUtils.isNotEmpty((CharSequence)yearMonth)) {
            String[] end = yearMonth.split("-");
            String endDate = DateUtils.getLastDayOfMonth((int)Integer.valueOf(end[0]), (int)Integer.valueOf(end[1]));
            wappDetail.lt(BaseEntity::getxCreateTime, (Object)DateUtils.stringToFullDate((String)(endDate + " 23:59:59")));
        }
        List listDetail = this.billDetailMapper.selectList((Wrapper)wappDetail);
        BigDecimal moneyCount = new BigDecimal("0");
        if (listDetail == null || listDetail.isEmpty()) {
            return moneyCount;
        }
        for (BillDetailEntity entity : listDetail) {
            moneyCount = moneyCount.add(entity.getBillMoney());
        }
        return moneyCount;
    }
}

