/*
 * Decompiled with CFR 0.152.
 */
package com.byh.imforward.interceptor;

import com.byh.imforward.config.PropertiesConfig;
import com.byh.imforward.utils.HxHttpClient;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

@Component
public class AllInterceptor
extends HandlerInterceptorAdapter {
    private static Logger log = LoggerFactory.getLogger(AllInterceptor.class);
    @Autowired
    private PropertiesConfig config;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        String url = request.getServletPath();
        log.info("request.getServletPath = {} ", (Object)url);
        String pushUrl = this.config.getForwardPath().concat(url);
        log.info("\u8bf7\u6c42\u63a8\u9001\u670d\u52a1\u5730\u5740 = {}", (Object)pushUrl);
        String body = this.obtainPostParameter(request, response);
        log.info("post\u8bf7\u6c42\u53c2\u6570={}", (Object)body);
        String msg = HxHttpClient.post(pushUrl, body);
        log.info(" \u4e91\u7aef\u8fd4\u56de={} ", (Object)msg);
        response.setContentType("application/json;charset=UTF-8");
        response.getWriter().write(msg);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String obtainPostParameter(HttpServletRequest request, HttpServletResponse response) {
        StringBuilder stringBuilder = new StringBuilder();
        BufferedReader bufferedReader = null;
        ServletInputStream inputStream = null;
        try {
            inputStream = request.getInputStream();
            if (inputStream != null) {
                bufferedReader = new BufferedReader(new InputStreamReader((InputStream)inputStream));
                char[] charBuffer = new char[128];
                int bytesRead = -1;
                while ((bytesRead = bufferedReader.read(charBuffer)) > 0) {
                    stringBuilder.append(charBuffer, 0, bytesRead);
                }
            } else {
                stringBuilder.append("");
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return stringBuilder.toString();
    }
}

