/*
 * Decompiled with CFR 0.152.
 */
package com.byh.gateway.exception;

import com.byh.gateway.entity.ResponseData;
import com.byh.gateway.exception.BusinessException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.web.reactive.error.ErrorWebExceptionHandler;
import org.springframework.core.annotation.Order;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.stereotype.Component;
import org.springframework.web.server.ResponseStatusException;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

@Component
@Order(value=-1)
public class GlobalExceptionHandler
implements ErrorWebExceptionHandler {
    private Logger log = LoggerFactory.getLogger(GlobalExceptionHandler.class);

    public Mono<Void> handle(ServerWebExchange exchange, Throwable ex) {
        ServerHttpResponse response = exchange.getResponse();
        ServerHttpRequest request = exchange.getRequest();
        this.log.info("\u3010\u6355\u6349\u5230\u5f02\u5e38\u8bf7\u6c42\uff1a\u3011{}", (Object)request.getURI());
        if (response.isCommitted()) {
            return Mono.error((Throwable)ex);
        }
        response.getHeaders().setContentType(MediaType.APPLICATION_JSON);
        if (ex instanceof BusinessException) {
            response.setStatusCode(HttpStatus.FORBIDDEN);
        } else {
            response.setStatusCode(HttpStatus.INTERNAL_SERVER_ERROR);
        }
        Mono mono = response.writeWith((Publisher)Mono.fromSupplier(() -> {
            DataBufferFactory bufferFactory = response.bufferFactory();
            ObjectMapper objectMapper = new ObjectMapper();
            try {
                ex.printStackTrace();
                ResponseStatusException ex1 = (ResponseStatusException)ex;
                String errorCode = ex1.getStatus().toString();
                byte[] bytes = objectMapper.writeValueAsBytes((Object)ResponseData.error((String)errorCode, (String)ex.getMessage()));
                return bufferFactory.wrap(bytes);
            }
            catch (JsonProcessingException e) {
                e.printStackTrace();
                return null;
            }
        }));
        return mono;
    }
}

