/*
 * Decompiled with CFR 0.152.
 */
package com.byh.gateway.config;

import com.byh.gateway.constant.GatewayCodeEnum;
import com.byh.gateway.constant.PatternConstant;
import com.byh.gateway.exception.BusinessException;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.cloud.gateway.filter.GlobalFilter;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.Ordered;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.util.CollectionUtils;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

@Configuration
public class AuthCheckFilter
implements Ordered,
GlobalFilter {
    private Logger log = LoggerFactory.getLogger(AuthCheckFilter.class);
    private final String HEAD_TOKEN_KEY = "detailToken";

    public Mono<Void> filter(ServerWebExchange exchange, GatewayFilterChain chain) {
        ServerHttpRequest serverHttpRequest = exchange.getRequest();
        ServerHttpResponse serverHttpResponse = exchange.getResponse();
        ServerHttpRequest.Builder mutate = serverHttpRequest.mutate();
        String requestUrl = serverHttpRequest.getURI().getPath();
        this.log.info("=====================================================================================================================");
        this.log.info("\u5f53\u524d\u5b8c\u6574\u8bf7\u6c42\u3010{}\u3011\uff1a{}", (Object)serverHttpRequest.getMethodValue(), (Object)serverHttpRequest.getURI());
        this.log.info("\u5f53\u524d\u6a21\u5757\u8bf7\u6c42\uff1a{}", (Object)requestUrl);
        if (this.judgeUrl(requestUrl)) {
            return chain.filter(exchange);
        }
        List tokenList = serverHttpRequest.getHeaders().get((Object)"detailToken");
        if (CollectionUtils.isEmpty((Collection)tokenList)) {
            this.log.warn("[code:{}, msg:{}]", (Object)GatewayCodeEnum.REQUEST_HAVE_NOT_TOKEN.getCode(), (Object)GatewayCodeEnum.REQUEST_HAVE_NOT_TOKEN.getName());
            throw new BusinessException(GatewayCodeEnum.REQUEST_HAVE_NOT_TOKEN.getCode(), GatewayCodeEnum.REQUEST_HAVE_NOT_TOKEN.getName());
        }
        return chain.filter(exchange.mutate().request(mutate.build()).build());
    }

    public int getOrder() {
        return 0;
    }

    private boolean judgeUrl(String url) {
        for (String s : PatternConstant.GATEWAY_EXCLUDE_URL) {
            if (!url.equals(s)) continue;
            return true;
        }
        return false;
    }
}

