/*
 * Decompiled with CFR 0.152.
 */
package com.byh.hs.api.util;

import cn.hutool.http.HttpRequest;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.byh.hs.api.model.entity.HsConfigEntity;
import com.byh.hs.api.model.request.BaseRequest;
import com.byh.hs.api.model.respones.HsBaseResponse;
import com.byh.hs.api.util.DateUtils;
import com.byh.hs.api.util.SigNayureUtil;
import java.lang.reflect.Type;
import java.util.Base64;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class HsCommitUtil<T> {
    public static final Logger logger = LoggerFactory.getLogger(HsCommitUtil.class);

    public HsBaseResponse<T> commitHsInfo(HsConfigEntity hsConfigEntity, BaseRequest baseRequest, String infno, Map<String, Object> params, Class<T> clazz) {
        baseRequest.setInfno(infno);
        baseRequest.setMsgid(SigNayureUtil.getMsgId());
        baseRequest.setDev_safe_info("");
        baseRequest.setRecer_sys_code(hsConfigEntity.getHsCzyh());
        baseRequest.setDev_no(hsConfigEntity.getHsCzyh());
        baseRequest.setDev_safe_info("");
        baseRequest.setCainfo("");
        baseRequest.setSigntype(hsConfigEntity.getSignType());
        baseRequest.setInfver(hsConfigEntity.getInfver());
        if (Objects.isNull(baseRequest.getOpter_name())) {
            baseRequest.setOpter_type(hsConfigEntity.getOpterType());
            baseRequest.setOpter(hsConfigEntity.getHsCzyh());
            baseRequest.setOpter_name(hsConfigEntity.getOrganName() + hsConfigEntity.getHsCzyh());
        }
        baseRequest.setInf_time(DateUtils.getTime());
        baseRequest.setFixmedins_code(hsConfigEntity.getInsuranceCode());
        baseRequest.setFixmedins_name(hsConfigEntity.getOrganName());
        baseRequest.setInput(params);
        String requestJson = JSONObject.toJSONString((Object)baseRequest);
        logger.info("\u521b\u667a\u3010" + baseRequest.getMsgid() + "\u3011\u89e3\u6790\u5b8c\u6210\u540e\u5165\u53c2\uff1ainfno\u3010" + infno + "\u3011\u64cd\u4f5c\u5458\u3010" + "NCZK_HIS" + "\u3011\uff1a" + requestJson);
        String _api_timestamp = String.valueOf(System.currentTimeMillis() / 1000L);
        String _api_name = "hsa-fsi-" + infno;
        String param = "_api_access_key=" + hsConfigEntity.getAccessKey() + "&_api_name=" + _api_name + "&_api_timestamp=" + _api_timestamp + "&_api_version=" + hsConfigEntity.getApiVersion();
        String signature = Base64.getEncoder().encodeToString(SigNayureUtil.getHmacSHA1(param, hsConfigEntity.getSecretKey()));
        logger.info("signature:" + signature);
        String result = "";
        switch (hsConfigEntity.getInsuranceCode()) {
            case "H36070200017": {
                result = ((HttpRequest)((HttpRequest)((HttpRequest)((HttpRequest)((HttpRequest)((HttpRequest)((HttpRequest)HttpRequest.post((String)(hsConfigEntity.getInsuranceUrl() + infno)).body(requestJson).header("Content-Type", "application/json;charset=utf-8")).header("Accept-Language", "zh-CN,zh;q=0.9,en;q=0.8,und;q=0.7")).header("apiTimestamp", _api_timestamp)).header("apiName", _api_name)).header("apiVersion", hsConfigEntity.getApiVersion())).header("apiAccessKey", hsConfigEntity.getAccessKey())).header("apiSignature", signature)).execute().body();
                break;
            }
            default: {
                result = ((HttpRequest)((HttpRequest)((HttpRequest)((HttpRequest)((HttpRequest)((HttpRequest)((HttpRequest)HttpRequest.post((String)(hsConfigEntity.getInsuranceUrl() + infno)).body(requestJson).header("Content-Type", "application/json;charset=utf-8")).header("_api_timestamp", _api_timestamp)).header("Accept-Language", "zh-CN,zh;q=0.9,en;q=0.8,und;q=0.7")).header("_api_name", _api_name)).header("_api_version", hsConfigEntity.getApiVersion())).header("_api_access_key", hsConfigEntity.getAccessKey())).header("_api_signature", signature)).execute().body();
            }
        }
        logger.info("result->{}", (Object)result);
        TypeReference typeReference = new TypeReference<HsBaseResponse<T>>(new Type[]{clazz}){};
        HsBaseResponse hsBaseResponse = (HsBaseResponse)JSON.parseObject((String)result, (Type)typeReference.getType(), (Feature[])new Feature[0]);
        logger.info("\u521b\u667a\u3010" + baseRequest.getMsgid() + "\u3011\u89e3\u6790\u5b8c\u6210\u540e\u51fa\u53c2\uff1ainfno\u3010" + infno + "\u3011\u64cd\u4f5c\u5458\u3010" + "NCZK_HIS" + "\u3011\uff1a" + result);
        return hsBaseResponse;
    }
}

