/*
 * Decompiled with CFR 0.152.
 */
package com.byh.hs.api.util;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;

public class IpUtils {
    private static final String LOCAL_IP = "127.0.0.1";
    private static final String LOCAL_IP2 = "0:0:0:0:0:0:0:1";
    private static final String UN = "unknown";
    private static final String SEPARATE = ",";
    private static final int IP_LENGTH = 15;

    public static String getIpAddr(HttpServletRequest request) {
        String ipAddress = request.getHeader("x-forwarded-for");
        if (StringUtils.isEmpty((CharSequence)ipAddress) || UN.equalsIgnoreCase(ipAddress)) {
            ipAddress = request.getHeader("Proxy-Client-IP");
        }
        if (StringUtils.isEmpty((CharSequence)ipAddress) || UN.equalsIgnoreCase(ipAddress)) {
            ipAddress = request.getHeader("WL-Proxy-Client-IP");
        }
        if ((StringUtils.isEmpty((CharSequence)ipAddress) || UN.equalsIgnoreCase(ipAddress)) && (LOCAL_IP.equals(ipAddress = request.getRemoteAddr()) || LOCAL_IP2.equals(ipAddress))) {
            InetAddress inet = null;
            try {
                inet = InetAddress.getLocalHost();
            }
            catch (UnknownHostException e) {
                e.printStackTrace();
            }
            ipAddress = inet.getHostAddress();
        }
        if (ipAddress != null && ipAddress.length() > 15 && ipAddress.indexOf(SEPARATE) > 0) {
            ipAddress = ipAddress.substring(0, ipAddress.indexOf(SEPARATE));
        }
        return ipAddress;
    }

    public static String getLocalMac() {
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            byte[] mac = NetworkInterface.getByInetAddress(inetAddress).getHardwareAddress();
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < mac.length; ++i) {
                int temp;
                String str;
                if (i != 0) {
                    sb.append("-");
                }
                if ((str = Integer.toHexString(temp = mac[i] & 0xFF)).length() == 1) {
                    sb.append("0").append(str);
                    continue;
                }
                sb.append(str);
            }
            return sb.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

