/*
 * Decompiled with CFR 0.152.
 */
package com.byh.hs.api.util;

import cn.hutool.http.HttpRequest;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.byh.hs.api.model.entity.HsConfigEntity;
import com.byh.hs.api.util.DataHandler;
import com.byh.hs.api.util.SigNayureUtil;
import java.util.Base64;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class MoveHsCommitUtil<T> {
    public static final Logger logger = LoggerFactory.getLogger(MoveHsCommitUtil.class);

    public JSONObject commitHsInfo(HsConfigEntity hsConfigEntity, String infno, String params, Class<T> clazz) {
        TreeMap map = (TreeMap)JSONObject.parseObject((String)params, TreeMap.class);
        DataHandler dataHandler = null;
        String reqData = "";
        logger.info("hsConfigEntity={}", (Object)JSON.toJSONString((Object)hsConfigEntity));
        String _api_timestamp = String.valueOf(System.currentTimeMillis());
        logger.info("_api_timestamp={}", (Object)_api_timestamp);
        String _api_name = "hsa-fsi-" + infno;
        String param = "_api_access_key=" + hsConfigEntity.getXsAccessKey() + "&_api_name=" + _api_name + "&_api_timestamp=" + _api_timestamp + "&_api_version=" + hsConfigEntity.getApiVersion();
        String signature = Base64.getEncoder().encodeToString(SigNayureUtil.getHmacSHA1(param, hsConfigEntity.getXsSecretKey()));
        logger.info("signature={}", (Object)signature);
        try {
            logger.info("appId=====:{}", (Object)hsConfigEntity.getOrgAppId());
            logger.info("DigitalKey=====:{}", (Object)hsConfigEntity.getDigitalKey());
            logger.info("PublicKey=====:{}", (Object)hsConfigEntity.getPublicKey());
            logger.info("PrivateKey=====:{}", (Object)hsConfigEntity.getPrivateKey());
            logger.info("version=====:{}", (Object)hsConfigEntity.getApiVersion());
            dataHandler = DataHandler.newInstance(hsConfigEntity.getOrgAppId(), hsConfigEntity.getDigitalKey(), hsConfigEntity.getPublicKey(), hsConfigEntity.getPrivateKey());
            dataHandler.setVersion("2.0.1");
            reqData = dataHandler.buildReqData(map);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        logger.info("{}", (Object)reqData);
        String result = ((HttpRequest)((HttpRequest)((HttpRequest)((HttpRequest)((HttpRequest)((HttpRequest)((HttpRequest)HttpRequest.post((String)(hsConfigEntity.getInsuranceUrl() + _api_name)).body(reqData).header("Content-Type", "application/json;charset=utf-8")).header("_api_timestamp", _api_timestamp)).header("_api_name", _api_name)).header("Accept-Language", "zh-CN,zh;q=0.9,en;q=0.8,und;q=0.7")).header("_api_version", hsConfigEntity.getApiVersion())).header("_api_access_key", hsConfigEntity.getXsAccessKey())).header("_api_signature", signature)).execute().body();
        String res = "";
        try {
            res = dataHandler.processRspData(result);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        JSONObject jsonObject = JSON.parseObject((String)res);
        logger.info("jsonObject=========:{}", (Object)jsonObject);
        return jsonObject;
    }
}

