/*
 * Decompiled with CFR 0.152.
 */
package com.byh.inpatient.web.mvc.config;

import org.redisson.Redisson;
import org.redisson.api.RedissonClient;
import org.redisson.config.Config;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration
public class RedissonConfig {
    @Value(value="${spring.redis.host:localhost}")
    private String host;
    @Value(value="${spring.redis.port:6379}")
    private int port;
    @Value(value="${spring.redis.password:}")
    private String password;
    @Value(value="${spring.redis.cluster.nodes:}")
    private String clusterNodes;
    private final Environment environment;

    public RedissonConfig(Environment environment) {
        this.environment = environment;
    }

    @Bean
    public RedissonClient redissonSingleClient() {
        String activeProfile = this.environment.getProperty("spring.profiles.active");
        Config config = new Config();
        if ("pro".equals(activeProfile)) {
            String[] nodes;
            System.out.println("Redisson: \u751f\u4ea7\u73af\u5883\u542f\u7528\u96c6\u7fa4\u914d\u7f6e");
            for (String node : nodes = this.clusterNodes.split(",")) {
                String formattedNode = node.trim();
                if (!formattedNode.startsWith("redis://")) {
                    formattedNode = "redis://" + formattedNode;
                }
                config.useClusterServers().addNodeAddress(new String[]{formattedNode});
            }
        } else {
            System.out.println("Redisson: \u975e\u751f\u4ea7\u73af\u5883\u542f\u7528\u5355\u8282\u70b9\u914d\u7f6e");
            config.useSingleServer().setAddress("redis://" + this.host + ":" + this.port).setPassword(this.password);
        }
        return Redisson.create((Config)config);
    }
}

