/*
 * Decompiled with CFR 0.152.
 */
package com.byh.inpatient.web.mvc.controller;

import com.byh.inpatient.api.dto.prescription.SaveEntrustItemsDto;
import com.byh.inpatient.api.model.Entrustment;
import com.byh.inpatient.api.util.ResponseData;
import com.byh.inpatient.web.mvc.utils.CommonRequest;
import com.byh.inpatient.web.service.EntrustmentService;
import io.swagger.annotations.ApiOperation;
import io.swagger.v3.oas.annotations.Operation;
import java.util.List;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/Entrustment"})
public class EntrustmentController {
    @Autowired
    private EntrustmentService entrustmentService;
    @Autowired
    private CommonRequest commonRequest;

    @PostMapping(value={"/v1/saveEntrustItems"})
    @Operation(description="\u4fdd\u5b58\u5631\u6258")
    @ApiOperation(value="\u4fdd\u5b58\u5631\u6258", httpMethod="POST", notes="\u4fdd\u5b58\u5631\u6258")
    public ResponseData<String> saveEntrustItems(@RequestBody @Valid SaveEntrustItemsDto parameter) {
        parameter.setTenantId(this.commonRequest.getTenant());
        parameter.setOperatorId(this.commonRequest.getUserId());
        parameter.setOperatorName(this.commonRequest.getUserName());
        return this.entrustmentService.saveEntrustItems(parameter);
    }

    @GetMapping(value={"/v1/selectEntrustItems"})
    @Operation(description="\u67e5\u8be2\u5386\u53f2\u5631\u6258")
    @ApiOperation(value="\u67e5\u8be2\u5386\u53f2\u5631\u6258", httpMethod="GET", notes="\u67e5\u8be2\u5386\u53f2\u5631\u6258")
    public ResponseData<List<Entrustment>> selectEntrustItems(@RequestParam String inpatNo) {
        return this.entrustmentService.selectEntrustItems(inpatNo);
    }

    @GetMapping(value={"/v1/selectEntrustItemsDetail"})
    @Operation(description="\u67e5\u8be2\u5386\u53f2\u5631\u6258\u8be6\u60c5")
    @ApiOperation(value="\u67e5\u8be2\u5386\u53f2\u5631\u6258\u8be6\u60c5", httpMethod="GET", notes="\u67e5\u8be2\u5386\u53f2\u5631\u6258\u8be6\u60c5")
    public ResponseData<Entrustment> selectEntrustItemsDetail(@RequestParam String id) {
        return this.entrustmentService.selectEntrustItemsDetail(id);
    }

    @GetMapping(value={"/v1/delEntrustItems"})
    @Operation(description="\u5220\u9664\u5631\u6258")
    @ApiOperation(value="\u67e5\u8be2\u5386\u53f2\u5631\u6258\u8be6\u60c5", httpMethod="GET", notes="\u67e5\u8be2\u5386\u53f2\u5631\u6258\u8be6\u60c5")
    public ResponseData<String> delEntrustItems(@RequestParam String id) {
        return this.entrustmentService.delEntrustItems(id);
    }
}

