/*
 * Decompiled with CFR 0.152.
 */
package com.byh.inpatient.web.mvc.utils;

import com.byh.inpatient.api.util.DateUtils;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;

/*
 * Exception performing whole class analysis ignored.
 */
public class UUIDUtils {
    private static final AtomicInteger order_sequence = new AtomicInteger(0);
    private static LocalDateTime order_lastDateTime = LocalDateTime.now();
    private static final AtomicInteger prescriptionNo_sequence = new AtomicInteger(0);
    private static LocalDateTime prescriptionNo_lastDateTime = LocalDateTime.now();
    private static final AtomicInteger pay_sequence = new AtomicInteger(0);
    private static LocalDateTime pay_lastDateTime = LocalDateTime.now();
    private static final AtomicInteger transaction_sequence = new AtomicInteger(0);
    private static LocalDateTime transaction_lastDateTime = LocalDateTime.now();
    private static final AtomicInteger checkout_sequence = new AtomicInteger(0);
    private static LocalDateTime checkout_lastDateTime = LocalDateTime.now();
    private static String[] allLetter = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "l", "s", "t", "u", "v", "w", "x", "y", "z", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "L", "S", "T", "U", "V", "W", "X", "Y", "Z"};
    private static String[] number = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9"};
    private static String[] letter = new String[]{"a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "l", "s", "t", "u", "v", "w", "x", "y", "z", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "L", "S", "T", "U", "V", "W", "X", "Y", "Z"};
    private static String[] symbol = new String[]{"!", "~", "@", "#", "$", "%", "^", "&", "*", "-", "_", "=", "+", "/", "<", ">"};

    public static String getAllLetterRandom(int digit) {
        String str = "";
        for (int i = 0; i < digit; ++i) {
            int index = UUIDUtils.getRangeRandom((int)61, (int)0);
            str = str + allLetter[index];
        }
        return str;
    }

    public static String getLetterRandom(int digit) {
        String str = "";
        for (int i = 0; i < digit; ++i) {
            int index = UUIDUtils.getRangeRandom((int)letter.length, (int)0);
            str = str + letter[index];
        }
        return str;
    }

    public static String getNumberRandom(int digit) {
        String str = "";
        for (int i = 0; i < digit; ++i) {
            int index = UUIDUtils.getRangeRandom((int)number.length, (int)0);
            str = str + number[index];
        }
        return str;
    }

    public static String getSymbolRandom(int digit) {
        String str = "";
        for (int i = 0; i < digit; ++i) {
            int index = UUIDUtils.getRangeRandom((int)symbol.length, (int)0);
            str = str + symbol[index];
        }
        return str;
    }

    public static String getRandom(int digit, boolean bool) {
        String id = "";
        if (digit == 0) {
            digit = 10;
        }
        if (bool) {
            id = id + DateUtils.dateFormat((Date)new Date(), (String)"YYYYMMddHHmmss");
        }
        Random random = new Random();
        for (int i = 0; i < digit; ++i) {
            int a = random.nextInt(10);
            id = id + a;
        }
        return id;
    }

    public static String getUuidString(int digit, boolean bool) {
        String uuid = UUID.randomUUID().toString();
        if (digit > 0 && digit <= uuid.length()) {
            uuid.substring(0, digit);
        }
        if (!bool) {
            uuid.replaceAll("-", "");
        }
        return uuid;
    }

    public static int getRangeRandom(int max, int min) {
        Random random = new Random();
        int i = random.nextInt(max - min) + min;
        return i;
    }

    public static Long getLongRangeRandom(int max, int min) {
        Random random = new Random();
        int i = random.nextInt(max - min) + min;
        return Long.parseLong(i + "");
    }

    public static synchronized String getPrescriptionNo() {
        LocalDateTime currentDateTime = LocalDateTime.now();
        if (!currentDateTime.isEqual(prescriptionNo_lastDateTime)) {
            prescriptionNo_sequence.set(1);
            prescriptionNo_lastDateTime = currentDateTime;
        }
        DateTimeFormatter ofPattern = DateTimeFormatter.ofPattern("yyyyMMddHHmmssSSS");
        String localDate = LocalDateTime.now().format(ofPattern);
        String randomNumeric = UUIDUtils.getNumberRandom((int)3);
        int currentSequence = prescriptionNo_sequence.getAndIncrement();
        String sequenceNum = String.format("%04d", currentSequence);
        String orderNum = localDate + sequenceNum + randomNumeric;
        return orderNum;
    }

    public static synchronized String getOrderNo() {
        LocalDateTime currentDateTime = LocalDateTime.now();
        if (!currentDateTime.isEqual(order_lastDateTime)) {
            order_sequence.set(1);
            order_lastDateTime = currentDateTime;
        }
        DateTimeFormatter ofPattern = DateTimeFormatter.ofPattern("yyyyMMddHHmmssSSS");
        String localDate = LocalDateTime.now().format(ofPattern);
        String randomNumeric = UUIDUtils.getNumberRandom((int)3);
        int currentSequence = order_sequence.getAndIncrement();
        String sequenceNum = String.format("%04d", currentSequence);
        String orderNum = localDate + sequenceNum + randomNumeric;
        return orderNum;
    }

    public static synchronized String getPayOrderNo() {
        LocalDateTime currentDateTime = LocalDateTime.now();
        if (!currentDateTime.isEqual(pay_lastDateTime)) {
            pay_sequence.set(1);
            pay_lastDateTime = currentDateTime;
        }
        long epochMilli = currentDateTime.toInstant(ZoneOffset.of("+8")).toEpochMilli();
        String randomNumeric = UUIDUtils.getNumberRandom((int)3);
        int currentSequence = pay_sequence.getAndIncrement();
        String sequenceNum = String.format("%04d", currentSequence);
        String orderNum = "PAY" + epochMilli + sequenceNum + randomNumeric;
        return orderNum;
    }

    public static synchronized String getTransactionNo() {
        LocalDateTime currentDateTime = LocalDateTime.now();
        if (!currentDateTime.isEqual(transaction_lastDateTime)) {
            transaction_sequence.set(1);
            transaction_lastDateTime = currentDateTime;
        }
        long epochMilli = currentDateTime.toInstant(ZoneOffset.of("+8")).toEpochMilli();
        String randomNumeric = UUIDUtils.getNumberRandom((int)3);
        int currentSequence = transaction_sequence.getAndIncrement();
        String sequenceNum = String.format("%04d", currentSequence);
        String orderNum = epochMilli + sequenceNum + randomNumeric;
        return orderNum;
    }

    public static synchronized String getCheckoutNo() {
        LocalDateTime currentDateTime = LocalDateTime.now();
        if (!currentDateTime.isEqual(checkout_lastDateTime)) {
            checkout_sequence.set(1);
            checkout_lastDateTime = currentDateTime;
        }
        long epochMilli = currentDateTime.toInstant(ZoneOffset.of("+8")).toEpochMilli();
        String randomNumeric = UUIDUtils.getNumberRandom((int)1);
        int currentSequence = checkout_sequence.getAndIncrement();
        String sequenceNum = String.format("%01d", currentSequence);
        return epochMilli + sequenceNum + randomNumeric;
    }

    public static synchronized String getTreatmentNo() {
        LocalDateTime currentDateTime = LocalDateTime.now();
        if (!currentDateTime.isEqual(checkout_lastDateTime)) {
            checkout_sequence.set(1);
            checkout_lastDateTime = currentDateTime;
        }
        long epochMilli = currentDateTime.toInstant(ZoneOffset.of("+8")).toEpochMilli();
        String randomNumeric = UUIDUtils.getNumberRandom((int)1);
        int currentSequence = checkout_sequence.getAndIncrement();
        String sequenceNum = String.format("%07d", currentSequence);
        return epochMilli + sequenceNum + randomNumeric;
    }
}

