/*
 * Decompiled with CFR 0.152.
 */
package com.byh.inpatient.web.service.impl;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.byh.inpatient.api.enums.InpatWardBedUseStatus;
import com.byh.inpatient.api.exception.BusinessException;
import com.byh.inpatient.api.hsModel.BaseRequest;
import com.byh.inpatient.api.hsModel.InpatFeeDetailUploadRequest;
import com.byh.inpatient.api.hsModel.InpatFeeDetailUploadResponse;
import com.byh.inpatient.api.hsModel.InpatFeeUploadRequest;
import com.byh.inpatient.api.hsModel.InpatLeaveRegistDiseinfoRequest;
import com.byh.inpatient.api.hsModel.InpatLeaveRegistDscginfoRequest;
import com.byh.inpatient.api.hsModel.InpatLeaveRegistRequest;
import com.byh.inpatient.api.hsModel.InsurInpatFeeUploadCancel;
import com.byh.inpatient.api.hsModel.RegistrationEntity;
import com.byh.inpatient.api.model.InpatDeptTransfer;
import com.byh.inpatient.api.model.InpatFee;
import com.byh.inpatient.api.model.InpatMedicalRecordDiag;
import com.byh.inpatient.api.model.InpatRegist;
import com.byh.inpatient.api.model.InpatWardBed;
import com.byh.inpatient.api.model.dto.TransferDeptDTO;
import com.byh.inpatient.api.model.vo.QueryInsurInpatFeeUploadVO;
import com.byh.inpatient.api.outpatientModel.OutIcdItem;
import com.byh.inpatient.api.sysModel.request.SysDoctorDto;
import com.byh.inpatient.api.sysModel.request.SysDrugEntity;
import com.byh.inpatient.api.sysModel.respones.SysDoctorIdVo;
import com.byh.inpatient.api.util.ResponseData;
import com.byh.inpatient.data.repository.InpatDeptTransferMapper;
import com.byh.inpatient.data.repository.InpatMedicalRecordDiagMapper;
import com.byh.inpatient.web.feign.HsServiceFeign;
import com.byh.inpatient.web.feign.OutPatientServiceFeign;
import com.byh.inpatient.web.feign.SysServiceFeign;
import com.byh.inpatient.web.mvc.enums.InDeptStatus;
import com.byh.inpatient.web.mvc.enums.InHospEnum;
import com.byh.inpatient.web.mvc.enums.InpatDeptTransferStatus;
import com.byh.inpatient.web.mvc.enums.TransferIsValidStatus;
import com.byh.inpatient.web.mvc.utils.CommonRequest;
import com.byh.inpatient.web.service.IInpatDeptTransferService;
import com.byh.inpatient.web.service.IInpatFeeService;
import com.byh.inpatient.web.service.IInpatRegistService;
import com.byh.inpatient.web.service.IInpatWardBedService;
import com.byh.inpatient.web.service.InpatPrescriptionService;
import com.byh.inpatient.web.service.TreatmentItemsService;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class InpatDeptTransferServiceImpl
extends ServiceImpl<InpatDeptTransferMapper, InpatDeptTransfer>
implements IInpatDeptTransferService {
    private static final Logger log = LoggerFactory.getLogger(InpatDeptTransferServiceImpl.class);
    private final IInpatWardBedService inpatWardBedService;
    private final IInpatRegistService inpatRegistService;
    private final InpatDeptTransferMapper inpatDeptTransferMapper;
    private final InpatPrescriptionService inpatPrescriptionService;
    private final TreatmentItemsService treatmentItemsService;
    private final IInpatFeeService inpatFeeService;
    private final HsServiceFeign hsServiceFeign;
    private final CommonRequest commonRequest;
    private final InpatMedicalRecordDiagMapper inpatMedicalRecordDiagMapper;
    private final SysServiceFeign sysServiceFeign;
    private final OutPatientServiceFeign outPatientServiceFeign;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Transactional(rollbackFor={Exception.class})
    public boolean doInDept(InpatDeptTransfer inpatDeptTransfer) {
        Assert.notNull((Object)inpatDeptTransfer, (String)"\u4f4f\u9662\u8f6c\u79d1\u4fe1\u606f\u4e0d\u53ef\u4e3a\u7a7a!");
        Assert.notNull((Object)inpatDeptTransfer.getInpatNo(), (String)"\u5165\u9662\u8f6c\u79d1\u4fe1\u606f\u4e2d\u7684\u4f4f\u9662\u767b\u8bb0\u53f7\u4e0d\u53ef\u4e3a\u7a7a!");
        Assert.notNull((Object)inpatDeptTransfer.getToDeptId(), (String)"\u5165\u79d1\u79d1\u5ba4\u7f16\u7801\u4e0d\u53ef\u4e3a\u7a7a");
        Assert.hasText((String)inpatDeptTransfer.getToDeptName(), (String)"\u5165\u79d1\u79d1\u5ba4\u540d\u79f0\u4e0d\u53ef\u4e3a\u7a7a");
        Assert.notNull((Object)inpatDeptTransfer.getToWardId(), (String)"\u5165\u79d1\u75c5\u533a\u7f16\u7801\u4e0d\u53ef\u4e3a\u7a7a");
        Assert.hasText((String)inpatDeptTransfer.getToWardName(), (String)"\u5165\u79d1\u75c5\u533a\u540d\u79f0\u4e0d\u53ef\u4e3a\u7a7a");
        Assert.notNull((Object)inpatDeptTransfer.getDoctorId(), (String)"\u7ba1\u5e8a\u533b\u751f\u4e0d\u53ef\u4e3a\u7a7a!");
        Assert.hasText((String)inpatDeptTransfer.getDoctorName(), (String)"\u7ba1\u5e8a\u533b\u751f\u4e0d\u53ef\u4e3a\u7a7a");
        Assert.notNull((Object)inpatDeptTransfer.getNurseId(), (String)"\u7ba1\u5e8a\u62a4\u58eb\u7f16\u53f7\u4e0d\u53ef\u4e3a\u7a7a");
        Assert.hasText((String)inpatDeptTransfer.getNurseName(), (String)"\u7ba1\u5e8a\u62a4\u58eb\u540d\u79f0\u4e0d\u53ef\u4e3a\u7a7a");
        inpatDeptTransfer.setFromBedNo("");
        InpatWardBed inpatWardBed = this.inpatWardBedService.doModifyingBedUseStatus(inpatDeptTransfer.getToWardId(), inpatDeptTransfer.getToBedNo(), InpatWardBedUseStatus.USED);
        InpatRegist inpatRegist = this.inpatRegistService.selectByInpatNo(inpatDeptTransfer.getInpatNo());
        Assert.notNull((Object)inpatRegist, (String)("\u672a\u6839\u636e\u4f4f\u9662\u53f7[" + inpatDeptTransfer.getInpatNo() + "],\u67e5\u8be2\u5230\u60a3\u8005\u4fe1\u606f!"));
        Assert.isTrue((!InDeptStatus.IN_DEPT.inDeptStatusCode.equals(inpatRegist.getInDeptStatusCode()) ? 1 : 0) != 0, (String)"\u4f4f\u9662\u60a3\u8005\u5df2\u5165\u79d1,\u8bf7\u6838\u5bf9\u540e\u64cd\u4f5c!");
        Assert.isTrue((boolean)InHospEnum.IN_HOSPITAL.iohospCode.equals(inpatRegist.getInHospCode()), (String)"\u60a3\u8005\u672a\u5165\u9662,\u8bf7\u6838\u5bf9\u540e\u64cd\u4f5c!");
        boolean isFirstDept = false;
        if (inpatRegist.getTransferId() != null) {
            InpatDeptTransfer lastTransfer = (InpatDeptTransfer)this.inpatDeptTransferMapper.selectOne((Wrapper)Wrappers.lambdaQuery(InpatDeptTransfer.class).eq(InpatDeptTransfer::getId, (Object)inpatRegist.getTransferId()));
            if (InpatDeptTransferStatus.ROLL_OUT_DEPT.getStatusCode().equals(lastTransfer.getStatusCode())) {
                inpatDeptTransfer.setStatusCode(InpatDeptTransferStatus.INTO_DEPT.getStatusCode());
                inpatDeptTransfer.setStatusName(InpatDeptTransferStatus.INTO_DEPT.getStatusName());
                inpatDeptTransfer.setFromWardId(lastTransfer.getFromWardId());
                inpatDeptTransfer.setFromWardName(lastTransfer.getFromWardName());
                inpatDeptTransfer.setFromDeptName(lastTransfer.getFromDeptName());
                inpatDeptTransfer.setFromDeptId(lastTransfer.getFromDeptId());
                inpatDeptTransfer.setFromBedNo(lastTransfer.getFromBedNo());
            } else {
                if (!InpatDeptTransferStatus.CANCEL_ENTER_DEPT.getStatusCode().equals(lastTransfer.getStatusCode())) throw new BusinessException("\u60a3\u8005\u5f53\u524d\u72b6\u6001\u4e0d\u662f\u8f6c\u79d1,\u53d6\u6d88\u5165\u79d1\u72b6\u6001\u8bf7\u6838\u5bf9\u540e\u64cd\u4f5c!");
                inpatDeptTransfer.setStatusCode(InpatDeptTransferStatus.ENTER_DEPT.getStatusCode());
                inpatDeptTransfer.setStatusName(InpatDeptTransferStatus.ENTER_DEPT.getStatusName());
                inpatDeptTransfer.setFromWardId(lastTransfer.getFromWardId());
                inpatDeptTransfer.setFromWardName(lastTransfer.getFromWardName());
                inpatDeptTransfer.setFromDeptName(lastTransfer.getFromDeptName());
                inpatDeptTransfer.setFromDeptId(lastTransfer.getFromDeptId());
            }
        } else {
            isFirstDept = true;
            inpatDeptTransfer.setStatusCode(InpatDeptTransferStatus.ENTER_DEPT.getStatusCode());
            inpatDeptTransfer.setStatusName(InpatDeptTransferStatus.ENTER_DEPT.getStatusName());
        }
        inpatDeptTransfer.setUpstreamTransferId(inpatRegist.getTransferId());
        inpatDeptTransfer.setIsValid(TransferIsValidStatus.VALID.getStatusCode());
        this.inpatDeptTransferMapper.insert((Object)inpatDeptTransfer);
        InpatRegist newInpatRegist = new InpatRegist();
        if (isFirstDept) {
            newInpatRegist.setInHospDeptId(inpatDeptTransfer.getToDeptId());
            newInpatRegist.setInHospDeptName(inpatDeptTransfer.getToDeptName());
            newInpatRegist.setInHospDeptTime(inpatDeptTransfer.getCreateTime());
            newInpatRegist.setInHospWardId(inpatDeptTransfer.getToWardId());
            newInpatRegist.setInHospWardName(inpatDeptTransfer.getToWardName());
            newInpatRegist.setInHospBedNo(inpatDeptTransfer.getToBedNo());
        } else {
            newInpatRegist.setDeptId(inpatDeptTransfer.getToDeptId());
            newInpatRegist.setDeptName(inpatDeptTransfer.getToDeptName());
            newInpatRegist.setInDeptTime(inpatDeptTransfer.getCreateTime());
            newInpatRegist.setWardId(inpatDeptTransfer.getToWardId());
            newInpatRegist.setWardName(inpatDeptTransfer.getToWardName());
        }
        newInpatRegist.setInpatDoctorId(inpatDeptTransfer.getDoctorId());
        newInpatRegist.setInpatDoctorName(inpatDeptTransfer.getDoctorName());
        newInpatRegist.setNurseId(inpatDeptTransfer.getNurseId());
        newInpatRegist.setNurseName(inpatDeptTransfer.getNurseName());
        newInpatRegist.setBedNo(inpatDeptTransfer.getToBedNo());
        newInpatRegist.setTransferId(inpatDeptTransfer.getId());
        if (inpatWardBed != null) {
            inpatRegist.setRoomNo(inpatWardBed.getRoomNo());
        }
        newInpatRegist.setId(inpatRegist.getId());
        newInpatRegist.setInDeptStatusCode(InDeptStatus.IN_DEPT.inDeptStatusCode);
        newInpatRegist.setInDeptStatusName(InDeptStatus.IN_DEPT.inDeptStatusName);
        boolean upInpatRegist = this.inpatRegistService.updateById((Object)newInpatRegist);
        Assert.isTrue((boolean)upInpatRegist, (String)"\u66f4\u65b0\u4f4f\u9662\u767b\u8bb0\u4fe1\u606f\u5931\u8d25");
        return true;
    }

    @Transactional(rollbackFor={Exception.class})
    public Integer doTransferDept(TransferDeptDTO transferDeptDTO) {
        InpatDeptTransfer transfer = this.inpatDeptTransferMapper.selectValidTransfer(transferDeptDTO.getInpatNo());
        Assert.isTrue((transfer != null ? 1 : 0) != 0, (String)"\u6570\u636e\u5f02\u5e38,\u672a\u83b7\u53d6\u5230\u6709\u6548\u7684\u5f02\u52a8\u4fe1\u606f,,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458!");
        Assert.notNull((Object)transfer.getToWardId(), (String)"\u6570\u636e\u5f02\u5e38,\u5f02\u52a8\u4fe1\u606f\u4e2d,\u60a3\u8005\u6240\u5728\u75c5\u533a\u540d\u79f0\u4e3a\u7a7a,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458!");
        Assert.hasText((String)transfer.getToBedNo(), (String)"\u6570\u636e\u5f02\u5e38,\u5f02\u52a8\u4fe1\u606f\u4e2d,\u60a3\u8005\u6240\u5728\u5e8a\u4f4d\u4e3a\u7a7a,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458!");
        Assert.notNull((Object)transfer.getToDeptId(), (String)"\u6570\u636e\u5f02\u5e38,\u5f02\u52a8\u4fe1\u606f\u4e2d,\u60a3\u8005\u6240\u5728\u79d1\u5ba4\u4e3a\u7a7a,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458!");
        this.inpatWardBedService.doModifyingBedUseStatus(transfer.getToWardId(), transfer.getToBedNo(), InpatWardBedUseStatus.NOT_USED);
        InpatRegist inpatRegist = this.inpatRegistService.selectByInpatNo(transferDeptDTO.getInpatNo());
        if (!InHospEnum.IN_HOSPITAL.iohospCode.equals(inpatRegist.getInHospCode())) {
            throw new BusinessException("\u60a3\u8005\u4e0d\u662f\u5165\u9662\u72b6\u6001,\u8bf7\u6838\u5bf9\u540e\u64cd\u4f5c!");
        }
        if (!InDeptStatus.IN_DEPT.inDeptStatusCode.equals(inpatRegist.getInDeptStatusCode())) {
            throw new BusinessException("\u60a3\u8005\u4e0d\u662f\u5165\u79d1\u72b6\u6001,\u8bf7\u6838\u5bf9\u540e\u64cd\u4f5c!");
        }
        InpatDeptTransfer inpatDeptTransfer = new InpatDeptTransfer();
        inpatDeptTransfer.setStatusCode(InpatDeptTransferStatus.ROLL_OUT_DEPT.getStatusCode());
        inpatDeptTransfer.setStatusName(InpatDeptTransferStatus.ROLL_OUT_DEPT.getStatusName());
        inpatDeptTransfer.setFromDeptId(transfer.getToDeptId());
        inpatDeptTransfer.setFromDeptName(transfer.getToDeptName());
        inpatDeptTransfer.setFromWardName(transfer.getToWardName());
        inpatDeptTransfer.setFromWardId(transfer.getToWardId());
        inpatDeptTransfer.setFromBedNo(transfer.getToBedNo());
        inpatDeptTransfer.setToDeptId(transferDeptDTO.getNewDeptId());
        inpatDeptTransfer.setToDeptName(transferDeptDTO.getNewDeptName());
        inpatDeptTransfer.setToWardName(transferDeptDTO.getNewWardName());
        inpatDeptTransfer.setToWardId(transferDeptDTO.getNewWardId());
        inpatDeptTransfer.setInpatNo(transferDeptDTO.getInpatNo());
        inpatDeptTransfer.setUpstreamTransferId(transfer.getId());
        inpatDeptTransfer.setIsValid(TransferIsValidStatus.VALID.getStatusCode());
        inpatDeptTransfer.setDoctorId(inpatRegist.getInpatDoctorId());
        inpatDeptTransfer.setDoctorName(inpatRegist.getInpatDoctorName());
        this.inpatDeptTransferMapper.insert((Object)inpatDeptTransfer);
        InpatRegist newInpatRegist = new InpatRegist();
        newInpatRegist.setId(inpatRegist.getId());
        newInpatRegist.setInDeptStatusCode(InDeptStatus.NOT_IN_DEPT.inDeptStatusCode);
        newInpatRegist.setInDeptStatusName(InDeptStatus.NOT_IN_DEPT.inDeptStatusName);
        newInpatRegist.setDeptId(inpatDeptTransfer.getToDeptId());
        newInpatRegist.setDeptName(inpatDeptTransfer.getToDeptName());
        newInpatRegist.setInDeptTime(inpatDeptTransfer.getCreateTime());
        newInpatRegist.setWardId(inpatDeptTransfer.getToWardId());
        newInpatRegist.setWardName(inpatDeptTransfer.getToWardName());
        newInpatRegist.setTransferId(inpatDeptTransfer.getId());
        boolean upInpatRegist = this.inpatRegistService.updateById((Object)newInpatRegist);
        Assert.isTrue((boolean)upInpatRegist, (String)"\u66f4\u65b0\u4f4f\u9662\u767b\u8bb0\u4fe1\u606f\u5931\u8d25");
        return 1;
    }

    @Transactional(rollbackFor={Exception.class})
    public InpatDeptTransfer doBedTransfer(InpatDeptTransfer inpatDeptTransfer) {
        Assert.notNull((Object)inpatDeptTransfer, (String)"\u4f4f\u9662\u5e8a\u4f4d\u4fe1\u606f\u4e0d\u53ef\u4e3a\u7a7a!");
        Assert.hasText((String)inpatDeptTransfer.getInpatNo(), (String)"\u4f4f\u9662\u767b\u8bb0\u53f7\u4e0d\u53ef\u4e3a\u7a7a!");
        Assert.hasText((String)inpatDeptTransfer.getFromBedNo(), (String)"\u5c06\u8981\u8f6c\u51fa\u7684\u5e8a\u4f4d\u53f7\u4e0d\u53ef\u4e3a\u7a7a!");
        Assert.hasText((String)inpatDeptTransfer.getToBedNo(), (String)"\u5c06\u8981\u8f6c\u5165\u7684\u5e8a\u4f4d\u53f7\u4e0d\u53ef\u4e3a\u7a7a!");
        Assert.notNull((Object)inpatDeptTransfer.getToWardId(), (String)"\u8f6c\u5165\u75c5\u533aid\u4e0d\u53ef\u4e3a\u7a7a!");
        ArrayList<String> bedNoList = new ArrayList<String>();
        bedNoList.add(inpatDeptTransfer.getToBedNo());
        bedNoList.add(inpatDeptTransfer.getFromBedNo());
        InpatWardBed toInpatWardBed = null;
        InpatWardBed formInpatWardBed = null;
        List wardBedList = this.inpatWardBedService.lockByWardIdAndBedNoList(inpatDeptTransfer.getToWardId(), bedNoList);
        for (InpatWardBed wardBed : wardBedList) {
            if (wardBed.getBedNo().equals(inpatDeptTransfer.getToBedNo())) {
                toInpatWardBed = wardBed;
                continue;
            }
            formInpatWardBed = wardBed;
        }
        Assert.notNull(toInpatWardBed, (String)"\u5c06\u8981\u8f6c\u5165\u5e8a\u4f4d\u4fe1\u606f\u4e3a\u7a7a!");
        Assert.notNull(formInpatWardBed, (String)"\u5c06\u8981\u8f6c\u51fa\u5e8a\u4f4d\u4fe1\u606f\u4e3a\u7a7a!");
        Assert.isTrue((formInpatWardBed.getUseStatusCode() != null && formInpatWardBed.getUseStatusCode().equals("1") ? 1 : 0) != 0, (String)(inpatDeptTransfer.getFromBedNo() + "\u53f7\u5e8a\u4f4d\u4e3a\u7a7a\u5e8a,\u8bf7\u5237\u65b0\u9875\u9762\u540e\u64cd\u4f5c!"));
        InpatRegist fromInpatRegist = this.inpatRegistService.selectByInpatNo(inpatDeptTransfer.getInpatNo());
        Assert.notNull((Object)fromInpatRegist, (String)"\u8f6c\u5e8a\u60a3\u8005\u4fe1\u606f\u4e3a\u7a7a!");
        inpatDeptTransfer.setFromWardId(formInpatWardBed.getWardId());
        inpatDeptTransfer.setFromWardName(formInpatWardBed.getWardName());
        inpatDeptTransfer.setFromDeptId(fromInpatRegist.getDeptId());
        inpatDeptTransfer.setFromDeptName(fromInpatRegist.getDeptName());
        inpatDeptTransfer.setToWardId(toInpatWardBed.getWardId());
        inpatDeptTransfer.setToWardName(toInpatWardBed.getWardName());
        inpatDeptTransfer.setToDeptId(fromInpatRegist.getDeptId());
        inpatDeptTransfer.setToDeptName(fromInpatRegist.getDeptName());
        inpatDeptTransfer.setInpatNo(fromInpatRegist.getInpatNo());
        inpatDeptTransfer.setStatusCode(InpatDeptTransferStatus.TURN_BED.getStatusCode());
        inpatDeptTransfer.setStatusName(InpatDeptTransferStatus.TURN_BED.getStatusName());
        inpatDeptTransfer.setUpstreamTransferId(fromInpatRegist.getTransferId());
        inpatDeptTransfer.setIsValid(TransferIsValidStatus.VALID.getStatusCode());
        inpatDeptTransfer.setDoctorId(fromInpatRegist.getInpatDoctorId());
        inpatDeptTransfer.setDoctorName(fromInpatRegist.getInpatDoctorName());
        this.inpatDeptTransferMapper.insert((Object)inpatDeptTransfer);
        InpatWardBed InpatWardBedTo = new InpatWardBed();
        InpatWardBedTo.setUseStatusCode(InpatWardBedUseStatus.USED.getUseStatusCode());
        InpatWardBedTo.setUseStatusName(InpatWardBedUseStatus.USED.getUseStatusName());
        InpatWardBedTo.setId(toInpatWardBed.getId());
        boolean upToInpatWardBed = this.inpatWardBedService.updateById((Object)InpatWardBedTo);
        Assert.isTrue((boolean)upToInpatWardBed, (String)("\u4f4f\u9662\u8f6c\u5e8a\u8f6c\u5165\u5e8a\u4f4d\u64cd\u4f5c\u65f6\uff0c\u6839\u636e\u4f4f\u9662\u5e8a\u4f4d\u7f16\u53f7[" + toInpatWardBed.getId() + "]\u66f4\u65b0\u5e8a\u4f4d\u4fe1\u606f\u5931\u8d25!"));
        InpatWardBed InpatWardBedFrom = new InpatWardBed();
        InpatWardBedFrom.setUseStatusCode(InpatWardBedUseStatus.NOT_USED.getUseStatusCode());
        InpatWardBedFrom.setUseStatusName(InpatWardBedUseStatus.NOT_USED.getUseStatusName());
        InpatWardBedFrom.setId(formInpatWardBed.getId());
        boolean upformInpatWardBed = this.inpatWardBedService.updateById((Object)InpatWardBedTo);
        Assert.isTrue((boolean)upformInpatWardBed, (String)("\u4f4f\u9662\u8f6c\u5e8a\u8f6c\u51fa\u5e8a\u4f4d\u64cd\u4f5c\u65f6\uff0c\u6839\u636e\u4f4f\u9662\u5e8a\u4f4d\u7f16\u53f7[" + formInpatWardBed.getId() + "]\u66f4\u65b0\u5e8a\u4f4d\u4fe1\u606f\u5931\u8d25!"));
        InpatRegist newFromInpatRegist = new InpatRegist();
        newFromInpatRegist.setId(fromInpatRegist.getId());
        newFromInpatRegist.setBedNo(inpatDeptTransfer.getToBedNo());
        newFromInpatRegist.setTransferId(inpatDeptTransfer.getId());
        boolean upInpatRegist = this.inpatRegistService.updateById((Object)newFromInpatRegist);
        Assert.isTrue((boolean)upInpatRegist, (String)"\u66f4\u65b0\u4f4f\u9662\u767b\u8bb0\u4fe1\u606f\u5931\u8d25");
        return inpatDeptTransfer;
    }

    public Integer cancelTransfer(TransferDeptDTO transferDeptDTO) {
        Assert.hasText((String)transferDeptDTO.getInpatNo(), (String)"\u4f4f\u9662\u7f16\u53f7\u4e0d\u53ef\u4e3a\u7a7a!");
        Assert.notNull((Object)transferDeptDTO.getNewWardId(), (String)"\u75c5\u533a\u7f16\u7801\u4e0d\u53ef\u4e3a\u7a7a!");
        Assert.hasText((String)transferDeptDTO.getBedNo(), (String)"\u5e8a\u4f4d\u53f7\u4e0d\u53ef\u4e3a\u7a7a!");
        InpatRegist inpatRegist = this.inpatRegistService.selectByInpatNo(transferDeptDTO.getInpatNo());
        if (!InHospEnum.IN_HOSPITAL.iohospCode.equals(inpatRegist.getInHospCode())) {
            throw new BusinessException("\u60a3\u8005\u4e0d\u662f\u5165\u9662\u72b6\u6001,\u8bf7\u6838\u5bf9\u540e\u64cd\u4f5c!");
        }
        if (!InDeptStatus.NOT_IN_DEPT.inDeptStatusCode.equals(inpatRegist.getInDeptStatusCode())) {
            throw new BusinessException("\u60a3\u8005\u4e0d\u662f\u672a\u5165\u79d1\u72b6\u6001,\u8bf7\u6838\u5bf9\u540e\u64cd\u4f5c!");
        }
        List inValidList = this.inpatDeptTransferMapper.selectInValidTransferDeptList(transferDeptDTO.getInpatNo());
        Optional<InpatDeptTransfer> deptTransferMax = inValidList.stream().max(Comparator.comparing(InpatDeptTransfer::getId));
        InpatDeptTransfer lastTransferDeptInfo = new InpatDeptTransfer();
        for (InpatDeptTransfer transfer : inValidList) {
            transfer.setIsValid(TransferIsValidStatus.IN_VALID.getStatusCode());
            if (!InpatDeptTransferStatus.ROLL_OUT_DEPT.getStatusCode().equals(transfer.getStatusCode())) continue;
            lastTransferDeptInfo = transfer;
        }
        this.inpatDeptTransferMapper.updateById((Collection)inValidList);
        this.inpatWardBedService.doModifyingBedUseStatus(lastTransferDeptInfo.getFromWardId(), transferDeptDTO.getBedNo(), InpatWardBedUseStatus.USED);
        InpatDeptTransfer inpatDeptTransfer = new InpatDeptTransfer();
        inpatDeptTransfer.setStatusCode(InpatDeptTransferStatus.CANCEL_IN_DEPT.getStatusCode());
        inpatDeptTransfer.setStatusName(InpatDeptTransferStatus.CANCEL_IN_DEPT.getStatusName());
        inpatDeptTransfer.setInpatNo(transferDeptDTO.getInpatNo());
        inpatDeptTransfer.setUpstreamTransferId(deptTransferMax.get().getId());
        inpatDeptTransfer.setIsValid(TransferIsValidStatus.IN_VALID.getStatusCode());
        inpatDeptTransfer.setToDeptName(lastTransferDeptInfo.getFromDeptName());
        inpatDeptTransfer.setToDeptId(lastTransferDeptInfo.getFromDeptId());
        inpatDeptTransfer.setToWardName(lastTransferDeptInfo.getFromWardName());
        inpatDeptTransfer.setToWardId(lastTransferDeptInfo.getFromWardId());
        inpatDeptTransfer.setToBedNo(transferDeptDTO.getBedNo());
        inpatDeptTransfer.setFromDeptName(lastTransferDeptInfo.getFromDeptName());
        inpatDeptTransfer.setFromDeptId(lastTransferDeptInfo.getFromDeptId());
        inpatDeptTransfer.setFromWardName(lastTransferDeptInfo.getFromWardName());
        inpatDeptTransfer.setFromWardId(lastTransferDeptInfo.getFromWardId());
        inpatDeptTransfer.setDoctorId(inpatRegist.getInpatDoctorId());
        inpatDeptTransfer.setDoctorName(inpatRegist.getInpatDoctorName());
        this.inpatDeptTransferMapper.insert((Object)inpatDeptTransfer);
        Integer transferId = this.inpatDeptTransferMapper.selectValidTransferId(inpatDeptTransfer.getInpatNo());
        if (!transferDeptDTO.getBedNo().equals(lastTransferDeptInfo.getFromBedNo())) {
            InpatDeptTransfer bedDeptTransfer = new InpatDeptTransfer();
            bedDeptTransfer.setStatusCode(InpatDeptTransferStatus.TURN_BED.getStatusCode());
            bedDeptTransfer.setStatusName(InpatDeptTransferStatus.TURN_BED.getStatusName());
            bedDeptTransfer.setInpatNo(transferDeptDTO.getInpatNo());
            bedDeptTransfer.setUpstreamTransferId(deptTransferMax.get().getId());
            bedDeptTransfer.setIsValid(TransferIsValidStatus.VALID.getStatusCode());
            bedDeptTransfer.setToDeptName(lastTransferDeptInfo.getFromDeptName());
            bedDeptTransfer.setFromDeptId(lastTransferDeptInfo.getFromDeptId());
            bedDeptTransfer.setToWardName(lastTransferDeptInfo.getFromWardName());
            bedDeptTransfer.setToWardId(lastTransferDeptInfo.getFromWardId());
            bedDeptTransfer.setToBedNo(transferDeptDTO.getBedNo());
            bedDeptTransfer.setFromDeptName(lastTransferDeptInfo.getFromDeptName());
            bedDeptTransfer.setFromDeptId(lastTransferDeptInfo.getFromDeptId());
            bedDeptTransfer.setFromWardName(lastTransferDeptInfo.getFromWardName());
            bedDeptTransfer.setFromWardId(lastTransferDeptInfo.getFromWardId());
            bedDeptTransfer.setFromBedNo(lastTransferDeptInfo.getFromBedNo());
            bedDeptTransfer.setDoctorId(inpatRegist.getInpatDoctorId());
            bedDeptTransfer.setDoctorName(inpatRegist.getInpatDoctorName());
            this.inpatDeptTransferMapper.insert((Object)bedDeptTransfer);
            transferId = bedDeptTransfer.getId();
        }
        InpatRegist newInpatRegist = new InpatRegist();
        newInpatRegist.setId(inpatRegist.getId());
        newInpatRegist.setTransferId(transferId);
        newInpatRegist.setBedNo(transferDeptDTO.getBedNo());
        newInpatRegist.setInDeptStatusName(InDeptStatus.IN_DEPT.inDeptStatusName);
        newInpatRegist.setInDeptStatusCode(InDeptStatus.IN_DEPT.inDeptStatusCode);
        newInpatRegist.setDeptId(lastTransferDeptInfo.getFromDeptId());
        newInpatRegist.setDeptName(lastTransferDeptInfo.getFromDeptName());
        newInpatRegist.setWardId(lastTransferDeptInfo.getFromWardId());
        newInpatRegist.setWardName(lastTransferDeptInfo.getFromWardName());
        boolean upInpatRegist = this.inpatRegistService.updateById((Object)newInpatRegist);
        Assert.isTrue((boolean)upInpatRegist, (String)"\u66f4\u65b0\u4f4f\u9662\u767b\u8bb0\u4fe1\u606f\u5931\u8d25!");
        return 1;
    }

    @Transactional(rollbackFor={Exception.class})
    public Integer doLeaveHospital(TransferDeptDTO transferDeptRequest) {
        String inpatNo = transferDeptRequest.getInpatNo();
        Assert.hasText((String)inpatNo, (String)"\u51fa\u9662\u65f6,\u60a3\u8005\u4f4f\u9662\u53f7\u4e0d\u53ef\u4e3a\u7a7a!");
        Date leaveHospitalTime = transferDeptRequest.getLeaveHospitalTime();
        Assert.notNull((Object)leaveHospitalTime, (String)"\u51fa\u9662\u65f6,\u51fa\u9662\u65f6\u95f4\u4e0d\u53ef\u4e3a\u7a7a!");
        InpatRegist inpatRegist = this.inpatRegistService.selectByInpatNo(inpatNo);
        Assert.notNull((Object)inpatRegist, (String)("\u672a\u6839\u636e\u4f4f\u9662\u53f7[" + inpatNo + "],\u67e5\u8be2\u5230\u60a3\u8005\u4fe1\u606f!"));
        List inpatBabyRegistList = this.inpatRegistService.selectBabyInfoList(inpatRegist.getId());
        List inpatMotherAndBabyIdList = inpatBabyRegistList.stream().map(InpatRegist::getInpatNo).collect(Collectors.toCollection(ArrayList::new));
        inpatMotherAndBabyIdList.add(inpatRegist.getInpatNo());
        List inpatPrescriptions = this.inpatPrescriptionService.selectPrescriptionList(inpatMotherAndBabyIdList);
        Assert.isTrue((inpatPrescriptions == null || inpatPrescriptions.isEmpty() ? 1 : 0) != 0, (String)"\u51fa\u9662\u9a8c\u8bc1\u5931\u8d25\uff0c\u836f\u54c1\u533b\u5631\u5b58\u5728\u672a\u6267\u884c\u5b8c\u6bd5\u7684\u9879\u76ee\uff0c\u8bf7\u91cd\u65b0\u51fa\u9662\u9a8c\u8bc1");
        List treatmentItems = this.treatmentItemsService.selectTreatmentItemsList(inpatMotherAndBabyIdList);
        Assert.isTrue((treatmentItems == null || treatmentItems.isEmpty() ? 1 : 0) != 0, (String)"\u51fa\u9662\u9a8c\u8bc1\u5931\u8d25\uff0c\u8bca\u7597\u9879\u76ee\u533b\u5631\u5b58\u5728\u672a\u6267\u884c\u5b8c\u6bd5\u7684\u9879\u76ee\uff0c\u8bf7\u91cd\u65b0\u51fa\u9662\u9a8c\u8bc1");
        InpatDeptTransfer transfer = ((InpatDeptTransferMapper)this.baseMapper).selectValidTransfer(inpatNo);
        Assert.isTrue((transfer != null ? 1 : 0) != 0, (String)"\u6570\u636e\u5f02\u5e38,\u672a\u83b7\u53d6\u5230\u6709\u6548\u7684\u5f02\u52a8\u4fe1\u606f,,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458!");
        Assert.notNull((Object)transfer.getToWardId(), (String)"\u6570\u636e\u5f02\u5e38,\u5f02\u52a8\u4fe1\u606f\u4e2d,\u60a3\u8005\u6240\u5728\u75c5\u533a\u540d\u79f0\u4e3a\u7a7a,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458!");
        Assert.hasText((String)transfer.getToBedNo(), (String)"\u6570\u636e\u5f02\u5e38,\u5f02\u52a8\u4fe1\u606f\u4e2d,\u60a3\u8005\u6240\u5728\u5e8a\u4f4d\u4e3a\u7a7a,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458!");
        Assert.notNull((Object)transfer.getToDeptId(), (String)"\u6570\u636e\u5f02\u5e38,\u5f02\u52a8\u4fe1\u606f\u4e2d,\u60a3\u8005\u6240\u5728\u79d1\u5ba4\u4e3a\u7a7a,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458!");
        this.inpatWardBedService.doModifyingBedUseStatus(transfer.getToWardId(), transfer.getToBedNo(), InpatWardBedUseStatus.NOT_USED);
        if (InHospEnum.DISCHARGED_HOSPITAL.iohospCode.equals(inpatRegist.getInHospCode())) {
            throw new BusinessException("\u60a3\u8005\u5df2\u7ecf\u51fa\u9662");
        }
        if (InDeptStatus.DISCHARGED_HOSPITAL.inDeptStatusCode.equals(inpatRegist.getInDeptStatusCode())) {
            throw new BusinessException("\u60a3\u8005\u5df2\u7ecf\u51fa\u9662");
        }
        long count = this.inpatFeeService.count((Wrapper)Wrappers.lambdaQuery().eq(InpatFee::getInpatRegId, (Object)inpatRegist.getId()));
        BigDecimal amount = this.inpatFeeService.selectAmount((Wrapper)Wrappers.lambdaQuery().eq(InpatFee::getInpatRegId, (Object)inpatRegist.getId()));
        if (count == 0L || amount.compareTo(BigDecimal.ZERO) == 0) {
            throw new BusinessException("\u5f53\u524d\u60a3\u8005\u672a\u4ea7\u751f\u8d39\u7528,\u53ea\u9700\u53d6\u6d88\u5165\u79d1!");
        }
        InpatDeptTransfer inpatDeptTransfer = new InpatDeptTransfer();
        inpatDeptTransfer.setStatusCode(InpatDeptTransferStatus.DISCHARGED.getStatusCode());
        inpatDeptTransfer.setStatusName(InpatDeptTransferStatus.DISCHARGED.getStatusName());
        inpatDeptTransfer.setFromDeptId(inpatRegist.getDeptId());
        inpatDeptTransfer.setFromDeptName(inpatRegist.getDeptName());
        inpatDeptTransfer.setFromWardName(inpatRegist.getWardName());
        inpatDeptTransfer.setFromWardId(inpatRegist.getWardId());
        inpatDeptTransfer.setFromBedNo(transfer.getToBedNo());
        inpatDeptTransfer.setInpatNo(inpatRegist.getInpatNo());
        inpatDeptTransfer.setUpstreamTransferId(inpatRegist.getTransferId());
        inpatDeptTransfer.setIsValid(TransferIsValidStatus.VALID.getStatusCode());
        inpatDeptTransfer.setDoctorId(inpatRegist.getInpatDoctorId());
        inpatDeptTransfer.setDoctorName(inpatRegist.getInpatDoctorName());
        inpatDeptTransfer.setAssistantDoctorId(transfer.getAssistantDoctorId());
        inpatDeptTransfer.setAssistantDoctorName(transfer.getAssistantDoctorName());
        boolean save = this.save((Object)inpatDeptTransfer);
        if (!save) {
            throw new BusinessException("\u65b0\u589e\u51fa\u9662\u5f02\u52a8\u65e5\u5fd7\u5931\u8d25");
        }
        ArrayList<InpatRegist> inpatRegistListAll = new ArrayList<InpatRegist>();
        inpatRegistListAll.add(inpatRegist);
        if (!inpatBabyRegistList.isEmpty()) {
            inpatRegistListAll.addAll(inpatBabyRegistList);
        }
        for (InpatRegist regist : inpatRegistListAll) {
            LocalDate dischargeLocalDate;
            LocalDate admissionLocalDate = regist.getInHospDeptTime().toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
            long diffBetween = ChronoUnit.DAYS.between(admissionLocalDate, dischargeLocalDate = transferDeptRequest.getLeaveHospitalTime().toInstant().atZone(ZoneId.systemDefault()).toLocalDate());
            Integer diffDays = Math.toIntExact(diffBetween);
            diffDays = diffDays == 0 ? 1 : diffDays;
            InpatRegist newInpatRegist = new InpatRegist();
            newInpatRegist.setId(regist.getId());
            newInpatRegist.setInDeptStatusCode(InDeptStatus.DISCHARGED_HOSPITAL.inDeptStatusCode);
            newInpatRegist.setInDeptStatusName(InDeptStatus.DISCHARGED_HOSPITAL.inDeptStatusName);
            newInpatRegist.setOutHospTime(leaveHospitalTime);
            newInpatRegist.setActualInhospDays(diffDays);
            newInpatRegist.setTransferId(inpatDeptTransfer.getId());
            boolean updateInpatRegist = this.inpatRegistService.updateById((Object)newInpatRegist);
            if (updateInpatRegist) continue;
            throw new BusinessException("\u66f4\u65b0\u4f4f\u9662\u767b\u8bb0\u4fe1\u606f\u5931\u8d25!");
        }
        BigDecimal feeUploadAmount = this.insurInpatFeeUpload(inpatRegist.getId());
        this.doInpatLeaveRegist(inpatRegist.getId());
        return 1;
    }

    public void doInpatLeaveRegist(Integer inpatRegistId) {
        log.info("******\u51fa\u9662\u529e\u7406*****");
        log.info("\u5165\u53c2{}", (Object)JSON.toJSONString((Object)inpatRegistId));
        String mdtrtId = "";
        String psnNo = "";
        String insuplcAdmdvs = "";
        Assert.notNull((Object)inpatRegistId, (String)"\u4f4f\u9662id \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        InpatRegist regist = (InpatRegist)this.inpatRegistService.getById((Serializable)inpatRegistId);
        Assert.notNull((Object)regist, (String)"\u672a\u627e\u5230\u4f4f\u9662\u767b\u8bb0\u4fe1\u606f");
        if ("1".equals(regist.getPatientType())) {
            return;
        }
        RegistrationEntity registrationEntity = new RegistrationEntity();
        registrationEntity.setIpt_otp_no(regist.getInpatNo());
        registrationEntity.setMethod_code("2401");
        ResponseData listResponseData = this.hsServiceFeign.selectLogByMethondCode(registrationEntity);
        if (listResponseData.getData() == null || ((List)listResponseData.getData()).isEmpty()) {
            log.info("\u672a\u67e5\u8be2\u5230\u60a3\u8005\u533b\u4fdd\u5165\u9662\u529e\u7406,\u8bf7\u786e\u8ba4");
            throw new BusinessException("\u672a\u67e5\u8be2\u5230\u60a3\u8005\u533b\u4fdd\u5165\u9662\u529e\u7406,\u8bf7\u786e\u8ba4");
        }
        RegistrationEntity insurRegist = (RegistrationEntity)((List)listResponseData.getData()).get(0);
        JSONObject param = JSON.parseObject((String)insurRegist.getParam());
        JSONObject mdtrtinfo = param.getJSONObject("mdtrtinfo");
        mdtrtId = insurRegist.getMdtrt_id();
        psnNo = insurRegist.getPsn_no();
        insuplcAdmdvs = mdtrtinfo.getString("insuplc_admdvs");
        String insutype = mdtrtinfo.getString("insutype");
        String medType = mdtrtinfo.getString("med_type");
        registrationEntity = new RegistrationEntity();
        registrationEntity.setMethod_code("2301");
        registrationEntity.setMdtrt_id(mdtrtId);
        listResponseData = this.hsServiceFeign.selectLogByMethondCode(registrationEntity);
        if (listResponseData.getData() == null || ((List)listResponseData.getData()).isEmpty()) {
            log.info("\u672a\u8fdb\u884c\u8d39\u7528\u4e0a\u4f20\uff0c\u65e0\u6cd5\u8fdb\u884c\u51fa\u9662\u529e\u7406");
            throw new BusinessException("\u672a\u8fdb\u884c\u8d39\u7528\u4e0a\u4f20\uff0c\u65e0\u6cd5\u8fdb\u884c\u51fa\u9662\u529e\u7406");
        }
        String dscgWayCode = "1";
        String dscgWayName = "\u533b\u5631\u79bb\u9662";
        InpatLeaveRegistDscginfoRequest dscginfo = new InpatLeaveRegistDscginfoRequest();
        dscginfo.setMdtrt_id(mdtrtId);
        dscginfo.setPsn_no(psnNo);
        dscginfo.setInsutype(insutype);
        dscginfo.setEndtime(DateUtil.format((Date)regist.getOutHospTime(), (String)"yyyy-MM-dd HH:mm:ss"));
        dscginfo.setDise_codg(mdtrtinfo.getString("dscg_maindiag_code"));
        dscginfo.setDise_name(mdtrtinfo.getString("dscg_maindiag_name"));
        dscginfo.setOprn_oprt_code("");
        dscginfo.setOprn_oprt_name("");
        dscginfo.setFpsc_no("");
        dscginfo.setMatn_type(medType);
        dscginfo.setBirctrl_type("");
        dscginfo.setLatechb_flag("");
        dscginfo.setGeso_val(null);
        dscginfo.setFetts(null);
        dscginfo.setFetus_cnt(null);
        dscginfo.setPret_flag("");
        dscginfo.setBirctrl_matn_date("");
        dscginfo.setCop_flag("");
        dscginfo.setDscg_dept_codg(String.valueOf(regist.getDeptId()));
        dscginfo.setDscg_dept_name(regist.getDeptName());
        dscginfo.setDscg_bed("");
        dscginfo.setDscg_way(dscgWayCode);
        dscginfo.setDie_date("");
        dscginfo.setExp_content("");
        ArrayList<InpatLeaveRegistDiseinfoRequest> diseinfoList = new ArrayList<InpatLeaveRegistDiseinfoRequest>();
        InpatLeaveRegistDiseinfoRequest diseinfo = new InpatLeaveRegistDiseinfoRequest();
        SysDoctorDto sysDoctorDto = new SysDoctorDto();
        sysDoctorDto.setId(regist.getInpatDoctorId());
        ResponseData newSysDoctorIdVoResponseData = this.sysServiceFeign.newDoctorById(sysDoctorDto);
        if (Objects.isNull(newSysDoctorIdVoResponseData) || !newSysDoctorIdVoResponseData.isSuccess()) {
            throw new BusinessException("\u67e5\u8be2\u533b\u751f\u4fe1\u606f\u5931\u8d25");
        }
        SysDoctorIdVo sysDoctorIdVo = (SysDoctorIdVo)JSON.parseObject((String)JSON.toJSONString((Object)newSysDoctorIdVoResponseData.getData()), SysDoctorIdVo.class);
        if (Objects.isNull(sysDoctorIdVo.getHsCode()) || sysDoctorIdVo.getHsCode().isEmpty()) {
            throw new BusinessException("\u67e5\u8be2\u533b\u751f\u8d2f\u6807\u7801\u5931\u8d25\uff0c\u8bf7\u5b8c\u5584\u533b\u751f\u4fe1\u606f\uff01");
        }
        List inpatMedicalRecordDiagList = this.inpatMedicalRecordDiagMapper.selectList((Wrapper)Wrappers.lambdaQuery().eq(InpatMedicalRecordDiag::getInpatNo, (Object)regist.getInpatNo()));
        if (inpatMedicalRecordDiagList == null || inpatMedicalRecordDiagList.isEmpty()) {
            throw new BusinessException("\u51fa\u9662\u8bca\u65ad\u4e3a\u7a7a\uff01");
        }
        List icdCodes = inpatMedicalRecordDiagList.stream().map(InpatMedicalRecordDiag::getDiagCode).collect(Collectors.toList());
        ResponseData queryIcdByCode = this.outPatientServiceFeign.queryIcdByCode(icdCodes, this.commonRequest.getTenant());
        if (queryIcdByCode.isError() || queryIcdByCode.getData() == null || ((List)queryIcdByCode.getData()).isEmpty()) {
            throw new BusinessException("\u672a\u80fd\u627e\u5230\u533b\u4fdd\u8bca\u65ad\u7f16\u7801\uff01");
        }
        List outIcdItemList = (List)queryIcdByCode.getData();
        diseinfo.setMdtrt_id(mdtrtId);
        diseinfo.setPsn_no(psnNo);
        String medicalCode = ((OutIcdItem)outIcdItemList.get(0)).getMedicalCode();
        String medicalName = ((OutIcdItem)outIcdItemList.get(0)).getMedicalName();
        String diagName = medicalName.substring(medicalName.length() - 1);
        if ("\u8bc1".equals(diagName)) {
            diseinfo.setDiag_type("3");
        } else {
            diseinfo.setDiag_type(((OutIcdItem)outIcdItemList.get(0)).getDiagnosticType() == 1 ? "2" : "1");
        }
        diseinfo.setMaindiag_flag("1");
        diseinfo.setDiag_srt_no(Integer.valueOf(1));
        diseinfo.setDiag_code(medicalCode);
        diseinfo.setDiag_name(medicalName);
        diseinfo.setDiag_dept(sysDoctorIdVo.getDepartmentId());
        diseinfo.setDise_dor_no(sysDoctorIdVo.getHsCode());
        diseinfo.setDise_dor_name(sysDoctorIdVo.getUserName());
        diseinfo.setDiag_time(DateUtil.format((Date)regist.getOutHospTime(), (String)"yyyy-MM-dd HH:mm:ss"));
        diseinfoList.add(diseinfo);
        InpatLeaveRegistRequest inpatLeaveRegistRequest = new InpatLeaveRegistRequest();
        inpatLeaveRegistRequest.setDiseinfos(diseinfoList);
        inpatLeaveRegistRequest.setDscginfo(dscginfo);
        inpatLeaveRegistRequest.setInsuplc_admdvs(insuplcAdmdvs);
        inpatLeaveRegistRequest.setTenantId(this.commonRequest.getTenant());
        inpatLeaveRegistRequest.setSign_no(this.commonRequest.getSignNo());
        ResponseData inpatLeaveRegistRes = this.hsServiceFeign.inpatLeaveRegist(inpatLeaveRegistRequest);
        if (inpatLeaveRegistRes.isError()) {
            throw new BusinessException(inpatLeaveRegistRes.getMsg());
        }
        log.info("\u533b\u4fdd\u51fa\u9662\u9662\u529e\u7406\u6210\u529f\uff01");
    }

    public BigDecimal insurInpatFeeUpload(Integer inpatRegId) {
        log.info("******\u4f4f\u9662\u8d39\u7528\u660e\u7ec6\u4e0a\u4f20*****");
        log.info("HIS\u5165\u53c2: {}", (Object)inpatRegId);
        BigDecimal fee_sumamt = BigDecimal.ZERO;
        String mdtrtId = "";
        String psnNo = "";
        String insuplcAdmdvs = "";
        int iGoto = 0;
        try {
            Assert.notNull((Object)inpatRegId, (String)"\u4f4f\u9662id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            InpatRegist regist = (InpatRegist)this.inpatRegistService.getById((Serializable)inpatRegId);
            Assert.notNull((Object)regist, (String)"\u672a\u67e5\u8be2\u5230\u60a3\u8005\u4f4f\u9662\u767b\u8bb0\u4fe1\u606f\uff01");
            if ("1".equals(regist.getPatientType())) {
                return BigDecimal.ZERO;
            }
            RegistrationEntity registrationEntity = new RegistrationEntity();
            registrationEntity.setIpt_otp_no(regist.getInpatNo());
            registrationEntity.setMethod_code("2401");
            ResponseData listResponseData = this.hsServiceFeign.selectLogByMethondCode(registrationEntity);
            if (listResponseData.getData() == null || ((List)listResponseData.getData()).isEmpty()) {
                log.info("\u672a\u67e5\u8be2\u5230\u60a3\u8005\u533b\u4fdd\u5165\u9662\u529e\u7406,\u8bf7\u786e\u8ba4");
                throw new BusinessException("\u672a\u67e5\u8be2\u5230\u60a3\u8005\u533b\u4fdd\u5165\u9662\u529e\u7406,\u8bf7\u786e\u8ba4");
            }
            RegistrationEntity insurRegist = (RegistrationEntity)((List)listResponseData.getData()).get(0);
            JSONObject param = JSON.parseObject((String)insurRegist.getParam());
            JSONObject mdtrtinfo = param.getJSONObject("mdtrtinfo");
            mdtrtId = insurRegist.getMdtrt_id();
            psnNo = insurRegist.getPsn_no();
            insuplcAdmdvs = mdtrtinfo.getString("insuplc_admdvs");
            String medType = mdtrtinfo.getString("med_type");
            registrationEntity = new RegistrationEntity();
            registrationEntity.setMethod_code("2301");
            registrationEntity.setMdtrt_id(mdtrtId);
            listResponseData = this.hsServiceFeign.selectLogByMethondCode(registrationEntity);
            if (listResponseData.getData() != null && !((List)listResponseData.getData()).isEmpty()) {
                return BigDecimal.ZERO;
            }
            List feeList = this.inpatFeeService.getInsuerInpatFeeUploadList(inpatRegId, "2099-01-01 23:59:59");
            if (feeList == null || feeList.isEmpty()) {
                log.info("\u672a\u67e5\u8be2\u5230\u60a3\u8005\u8d39\u7528\u4fe1\u606f\u6216\u60a3\u8005\u8d39\u7528\u4fe1\u606f\u5df2\u4e0a\u4f20");
                throw new BusinessException("\u672a\u67e5\u8be2\u5230\u60a3\u8005\u8d39\u7528\u4fe1\u606f\u6216\u60a3\u8005\u8d39\u7528\u4fe1\u606f\u5df2\u4e0a\u4f20");
            }
            ArrayList<InpatFeeDetailUploadRequest> feedetail = new ArrayList<InpatFeeDetailUploadRequest>();
            ArrayList<InpatFeeDetailUploadRequest> Unfeedetail = new ArrayList<InpatFeeDetailUploadRequest>();
            StringBuilder errMsg = new StringBuilder();
            for (QueryInsurInpatFeeUploadVO feeItem : feeList) {
                if (StrUtil.isBlank((CharSequence)feeItem.getMedicalInsuranceCode())) {
                    errMsg.append("\r\n").append(String.format("\u9879\u76ee:%s/%s \u672a\u5bf9\u7167", feeItem.getChargeItemCode(), feeItem.getChargeItemName()));
                }
                InpatFeeDetailUploadRequest fee = new InpatFeeDetailUploadRequest();
                fee.setFeedetl_sn("ZK" + mdtrtId + "-" + feeItem.getId());
                if (feeItem.getBackInpatFeeId() == null) {
                    fee.setInit_feedetl_sn("");
                } else {
                    fee.setInit_feedetl_sn("ZK" + mdtrtId + "-" + feeItem.getBackInpatFeeId());
                }
                fee.setMdtrt_id(mdtrtId);
                fee.setPsn_no(psnNo);
                fee.setDrord_no("");
                fee.setMed_type(medType);
                fee.setFee_ocur_time(DateUtil.format((Date)feeItem.getTallyTime(), (String)"yyyy-MM-dd HH:mm:ss"));
                fee.setMed_list_codg(feeItem.getMedicalInsuranceCode());
                fee.setMedins_list_codg(feeItem.getChargeItemCode());
                fee.setDet_item_fee_sumamt(feeItem.getChargeItemAmount());
                fee.setCnt(feeItem.getChargeItemNum());
                fee.setPric(feeItem.getChargeItemPrice());
                fee.setBilg_dept_codg(feeItem.getOrderDeptId());
                fee.setBilg_dept_name(feeItem.getOrderDeptName());
                fee.setBilg_dr_codg(feeItem.getOrderDoctorId());
                fee.setBilg_dr_name(feeItem.getOrderDoctorName());
                fee.setAcord_dept_codg(feeItem.getOrderDeptId());
                fee.setAcord_dept_name(feeItem.getOrderDeptName());
                fee.setOrders_dr_code(feeItem.getOrderDoctorId());
                fee.setOrders_dr_name(feeItem.getOrderDoctorName());
                fee.setHosp_appr_flag(feeItem.getHospApprFlag());
                fee.setTcmdrug_used_way("");
                fee.setEtip_flag("");
                fee.setEtip_hosp_code("");
                fee.setDscg_tkdrug_flag("");
                fee.setMatn_fee_flag("");
                fee.setMemo("");
                fee.setComb_no("");
                fee.setExp_content("");
                SysDrugEntity sysDrugEntity = new SysDrugEntity();
                sysDrugEntity.setId(feeItem.getOrderItemCode());
                ResponseData newSysDrugEntityResponseData = this.sysServiceFeign.newDrugIdDetails(sysDrugEntity, this.commonRequest.getTenant());
                if (Objects.isNull(newSysDrugEntityResponseData) || newSysDrugEntityResponseData.isError()) {
                    throw new BusinessException("\u5f53\u524d\uff1a" + feeItem.getOrderItemName() + " \u836f\u54c1\u672a\u542f\u7528");
                }
                ResponseData sysDrugEntityResponseData = this.sysServiceFeign.drugIdDetails(sysDrugEntity, this.commonRequest.getTenant());
                if (!Objects.isNull(sysDrugEntityResponseData) && sysDrugEntityResponseData.isSuccess()) {
                    SysDrugEntity result = (SysDrugEntity)sysDrugEntityResponseData.getData();
                    BigDecimal packSpecification = new BigDecimal(result.getPackSpecification());
                    fee.setCnt(packSpecification.multiply(feeItem.getChargeItemNum()));
                    fee.setMed_list_codg(result.getMedicalInsuranceCode());
                    fee.setPric(feeItem.getChargeItemPrice().divide(packSpecification, RoundingMode.HALF_EVEN));
                    fee.setMedins_list_codg(StrUtil.isBlank((CharSequence)result.getInternalCode()) ? result.getId() : result.getInternalCode());
                }
                if (feeItem.getChargeItemAmount().compareTo(BigDecimal.ZERO) > 0) {
                    feedetail.add(fee);
                    continue;
                }
                Unfeedetail.add(fee);
            }
            if (errMsg.length() > 0) {
                log.info(errMsg.toString());
                throw new BusinessException(errMsg.toString());
            }
            fee_sumamt = this.uploadFees(feedetail, insuplcAdmdvs, fee_sumamt);
            iGoto = 1;
            fee_sumamt = this.uploadFees(Unfeedetail, insuplcAdmdvs, fee_sumamt);
            log.info("\u8d39\u7528\u660e\u7ec6\u4e0a\u4f20\u6210\u529f\uff0c\u8d39\u7528\u603b\u989d\u4e3a\uff1a{}", (Object)fee_sumamt);
            return fee_sumamt;
        }
        catch (Exception ex) {
            String msg = "";
            switch (iGoto) {
                case 0: {
                    log.info("\u4f4f\u9662\u8d39\u7528\u660e\u7ec6\u4e0a\u4f20\u63a5\u53e3\u5f02\u5e38;{}", (Object)ex.getMessage());
                    msg = "\u4f4f\u9662\u8d39\u7528\u660e\u7ec6\u4e0a\u4f20\u63a5\u53e3\u5f02\u5e38;" + ex.getMessage();
                    break;
                }
                case 1: {
                    log.info("\u4f4f\u9662\u8d39\u7528\u660e\u7ec6\u4e0a\u4f20\u6570\u636e\u4fdd\u5b58\u5931\u8d25;{}", (Object)ex.getMessage());
                    msg = "\u4f4f\u9662\u8d39\u7528\u660e\u7ec6\u4e0a\u4f20\u6570\u636e\u4fdd\u5b58\u5931\u8d25;" + ex.getMessage();
                    InsurInpatFeeUploadCancel unilateral = new InsurInpatFeeUploadCancel();
                    unilateral.setMdtrt_id(mdtrtId);
                    unilateral.setPsn_no(psnNo);
                    unilateral.setInsuplc_admdvs(insuplcAdmdvs);
                    unilateral.setTenantId(this.commonRequest.getTenant());
                    this.doCancelByInPatFeeDetail(unilateral);
                }
            }
            throw new BusinessException(msg);
        }
    }

    private BigDecimal uploadFees(List<InpatFeeDetailUploadRequest> feeList, String insuplcAdmdvs, BigDecimal fee_sumamt) {
        int batchCount = 1;
        int rowCount = 0;
        ArrayList<InpatFeeDetailUploadRequest> feeUpList = new ArrayList<InpatFeeDetailUploadRequest>();
        for (InpatFeeDetailUploadRequest fee : feeList) {
            if (rowCount < 100) {
                feeUpList.add(fee);
                ++rowCount;
                continue;
            }
            fee_sumamt = this.executeUpload(feeUpList, insuplcAdmdvs, fee_sumamt, batchCount);
            feeUpList.clear();
            feeUpList.add(fee);
            rowCount = 1;
            ++batchCount;
        }
        if (rowCount > 0) {
            fee_sumamt = this.executeUpload(feeUpList, insuplcAdmdvs, fee_sumamt, batchCount);
        }
        return fee_sumamt;
    }

    private BigDecimal executeUpload(List<InpatFeeDetailUploadRequest> feeUpList, String insuplcAdmdvs, BigDecimal fee_sumamt, int batchCount) {
        log.info("\u5f00\u59cb\u7b2c" + batchCount + "\u6b21\u5206\u6279\u4e0a\u4f20");
        BaseRequest baseRequest = new BaseRequest();
        baseRequest.setInsuplc_admdvs(insuplcAdmdvs);
        baseRequest.setTenantId(this.commonRequest.getTenant());
        baseRequest.setSign_no(this.commonRequest.getSignNo());
        InpatFeeUploadRequest inpatFeeUploadRequest = new InpatFeeUploadRequest();
        inpatFeeUploadRequest.setInpatFeeDetailUploadRequest(feeUpList);
        inpatFeeUploadRequest.setBaseRequest(baseRequest);
        ResponseData response = this.hsServiceFeign.inpatFeeDetailUpload(inpatFeeUploadRequest);
        if (response.isError()) {
            log.info("\u4f4f\u9662\u8d39\u7528\u660e\u7ec6\u4e0a\u4f20\u5931\u8d25\uff1a" + response.getMsg());
            throw new BusinessException("\u4f4f\u9662\u8d39\u7528\u660e\u7ec6\u4e0a\u4f20\u5931\u8d25\uff1a" + response.getMsg());
        }
        ArrayList<InpatFee> inpatFeeList = new ArrayList<InpatFee>();
        List insurFeeList = (List)response.getData();
        for (InpatFeeDetailUploadResponse insurFee : insurFeeList) {
            fee_sumamt = fee_sumamt.add(insurFee.getDet_item_fee_sumamt());
            InpatFee inpatFee = new InpatFee();
            String[] strings = insurFee.getFeedetl_sn().split("-");
            inpatFee.setId(Integer.valueOf(strings[1]));
            inpatFee.setInsuranceUpNo(insurFee.getFeedetl_sn());
            inpatFeeList.add(inpatFee);
            this.inpatFeeService.updateById((Object)inpatFee);
        }
        return fee_sumamt;
    }

    public void doCancelByInPatFeeDetail(InsurInpatFeeUploadCancel inParam) {
        log.info("******\u4f4f\u9662\u8d39\u7528\u660e\u7ec6\u4e0a\u4f20\u64a4\u9500_\u5355\u8fb9*****");
        log.info("HIS\u5165\u53c2" + JSON.toJSONString((Object)inParam));
        inParam.setFeedetl_sn("0000");
        inParam.setSign_no(this.commonRequest.getSignNo());
        ResponseData response = this.hsServiceFeign.inpatFeeDetailCancel(inParam);
        if (response.isError()) {
            log.info("\u4f4f\u9662\u8d39\u7528\u660e\u7ec6\u4e0a\u4f20\u64a4\u9500_\u5355\u8fb9\u5931\u8d25\uff1a{}", (Object)response.getMsg());
        }
    }

    public InpatDeptTransferServiceImpl(IInpatWardBedService inpatWardBedService, IInpatRegistService inpatRegistService, InpatDeptTransferMapper inpatDeptTransferMapper, InpatPrescriptionService inpatPrescriptionService, TreatmentItemsService treatmentItemsService, IInpatFeeService inpatFeeService, HsServiceFeign hsServiceFeign, CommonRequest commonRequest, InpatMedicalRecordDiagMapper inpatMedicalRecordDiagMapper, SysServiceFeign sysServiceFeign, OutPatientServiceFeign outPatientServiceFeign) {
        this.inpatWardBedService = inpatWardBedService;
        this.inpatRegistService = inpatRegistService;
        this.inpatDeptTransferMapper = inpatDeptTransferMapper;
        this.inpatPrescriptionService = inpatPrescriptionService;
        this.treatmentItemsService = treatmentItemsService;
        this.inpatFeeService = inpatFeeService;
        this.hsServiceFeign = hsServiceFeign;
        this.commonRequest = commonRequest;
        this.inpatMedicalRecordDiagMapper = inpatMedicalRecordDiagMapper;
        this.sysServiceFeign = sysServiceFeign;
        this.outPatientServiceFeign = outPatientServiceFeign;
    }
}

