/*
 * Decompiled with CFR 0.152.
 */
package com.byh.inpatient.web.service.impl;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.byh.inpatient.api.enums.InpatFeeNodeCodeEnum;
import com.byh.inpatient.api.enums.InpatSettleTypeEnum;
import com.byh.inpatient.api.enums.ItemTypeFlagEnum;
import com.byh.inpatient.api.exception.BusinessException;
import com.byh.inpatient.api.model.InpatFee;
import com.byh.inpatient.api.model.InpatRegist;
import com.byh.inpatient.api.model.InpatSettle;
import com.byh.inpatient.api.model.dto.InpatFeeBySettleDTO;
import com.byh.inpatient.api.model.dto.InpatOrderChargeFeeDTO;
import com.byh.inpatient.api.model.prescription.InpatPrescriptionDrug;
import com.byh.inpatient.api.model.treatment.InpatTreatmentItems;
import com.byh.inpatient.api.model.vo.InpatSettleFeeVO;
import com.byh.inpatient.api.model.vo.QueryInsurInpatFeeUploadVO;
import com.byh.inpatient.api.sysModel.request.SysDictValueDTO;
import com.byh.inpatient.api.sysModel.request.SysDrugEntity;
import com.byh.inpatient.api.sysModel.respones.BasePageEntity;
import com.byh.inpatient.api.sysModel.respones.SysDictValueVo;
import com.byh.inpatient.api.sysModel.respones.SysTreatmentChargeVo;
import com.byh.inpatient.api.sysModel.respones.SysTreatmentItemVo;
import com.byh.inpatient.api.util.ResponseData;
import com.byh.inpatient.data.repository.InpatFeeMapper;
import com.byh.inpatient.web.feign.SysServiceFeign;
import com.byh.inpatient.web.mvc.enums.InpatFeeStatusEnum;
import com.byh.inpatient.web.service.IInpatFeeService;
import com.byh.inpatient.web.service.IInpatRegistService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class InpatFeeServiceImpl
extends ServiceImpl<InpatFeeMapper, InpatFee>
implements IInpatFeeService {
    private static final Logger log = LoggerFactory.getLogger(InpatFeeServiceImpl.class);
    @Autowired
    private SysServiceFeign sysServiceFeign;
    @Autowired
    private IInpatRegistService iInpatRegistService;

    public BigDecimal selectAmount(Wrapper<InpatFee> wrapper) {
        return ((InpatFeeMapper)this.baseMapper).selectAmount(wrapper);
    }

    @Transactional(rollbackFor={Exception.class})
    public void chargeByPrescriptionDrug(InpatOrderChargeFeeDTO param) {
        Assert.isTrue((param != null ? 1 : 0) != 0, (String)"\u8ba1\u8d39\u64cd\u4f5c\u53c2\u6570\u4e0d\u53ef\u672a\u7a7a\uff01");
        List prescriptionDrugs = param.getPrescriptionDrug();
        Assert.isTrue((prescriptionDrugs != null && !prescriptionDrugs.isEmpty() ? 1 : 0) != 0, (String)"\u8ba1\u8d39\u64cd\u4f5c\u53c2\u6570\u4e2d\u5904\u65b9\u660e\u7ec6\u4e0d\u53ef\u4e3a\u7a7a\uff01");
        Assert.hasText((String)param.getInpatNo(), (String)"\u8ba1\u8d39\u64cd\u4f5c\u53c2\u6570\u4e2d\u4f4f\u9662\u53f7\u4e0d\u53ef\u4e3a\u7a7a!");
        InpatRegist inpatRegist = this.iInpatRegistService.selectByInpatNo(param.getInpatNo());
        Assert.notNull((Object)inpatRegist, (String)("\u4f4f\u9662\u53f7\uff1a" + param.getInpatNo() + " \u4e0d\u5b58\u5728\uff01"));
        log.info("\u533b\u5631\u6267\u884c\u8ba1\u8d39\u8282\u70b9\uff1a\u897f\u836f\u7684\u533b\u5631\u6536\u8d39\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)param));
        ArrayList<InpatFee> inpatFeeList = new ArrayList<InpatFee>();
        SysDictValueDTO sysDictValueDTO = new SysDictValueDTO();
        sysDictValueDTO.setSize(-1);
        sysDictValueDTO.setType("drug_type");
        ResponseData drugDictRes = this.sysServiceFeign.sysDictValueById(sysDictValueDTO, inpatRegist.getTenantId() + "");
        Map<String, String> drugDictMap = ((Page)drugDictRes.getData()).getRecords().stream().collect(Collectors.toMap(SysDictValueVo::getValue, SysDictValueVo::getLabel));
        sysDictValueDTO.setType("fee_category");
        ResponseData feeDictRes = this.sysServiceFeign.sysDictValueById(sysDictValueDTO, inpatRegist.getTenantId() + "");
        Map<String, String> feeDictMap = ((Page)feeDictRes.getData()).getRecords().stream().collect(Collectors.toMap(SysDictValueVo::getValue, SysDictValueVo::getLabel));
        BigDecimal totalAmount = BigDecimal.ONE;
        for (InpatPrescriptionDrug prescriptionDrug : prescriptionDrugs) {
            SysDrugEntity sysDrugEntity = new SysDrugEntity();
            sysDrugEntity.setId(prescriptionDrug.getDrugNo());
            ResponseData newSysDrugEntityResponseData = this.sysServiceFeign.newDrugIdDetails(sysDrugEntity, inpatRegist.getTenantId());
            Assert.isTrue((newSysDrugEntityResponseData != null && newSysDrugEntityResponseData.isSuccess() ? 1 : 0) != 0, (String)("\u5f53\u524d\uff1a" + prescriptionDrug.getDrugName() + " \u836f\u54c1\u672a\u542f\u7528"));
            SysDrugEntity sysDrug = (SysDrugEntity)JSONObject.parseObject((String)JSONObject.toJSONString((Object)newSysDrugEntityResponseData.getData()), SysDrugEntity.class);
            InpatFee inpatFee = new InpatFee();
            inpatFee.setOperatorName(param.getOperationName());
            inpatFee.setOperatorId(param.getOperationId());
            inpatFee.setOrderDoctorName(param.getBusineDoctorName());
            inpatFee.setOrderDoctorId(param.getBusineDoctorId());
            inpatFee.setOrderDeptId(param.getBusineDeptId());
            inpatFee.setOrderDeptName(param.getBusineDeptName());
            inpatFee.setOrderWardId(param.getBusineWardId());
            inpatFee.setOrderWardName(param.getBusineWardName());
            inpatFee.setOrderDoctorDeptId(param.getBusineDeptId());
            inpatFee.setOrderDoctorDeptName(param.getBusineDeptName());
            inpatFee.setOrderTypeCode(sysDrug.getDrugsType());
            inpatFee.setOrderTypeName(drugDictMap.get(sysDrug.getDrugsType()));
            inpatFee.setChargeTypeCode(sysDrug.getFeeCategory());
            inpatFee.setChargeTypeName(feeDictMap.get(sysDrug.getFeeCategory()));
            inpatFee.setChargeItemCode(prescriptionDrug.getDrugNo());
            inpatFee.setChargeItemName(prescriptionDrug.getDrugName());
            inpatFee.setOrderItemName(prescriptionDrug.getDrugName());
            inpatFee.setOrderItemCode(prescriptionDrug.getDrugNo());
            inpatFee.setChargeItemNum(prescriptionDrug.getQuantity());
            inpatFee.setOrderItemNum(prescriptionDrug.getQuantity());
            inpatFee.setChargeItemUnit(prescriptionDrug.getQuantityUnit());
            inpatFee.setOrderItemSpec(prescriptionDrug.getQuantityUnit());
            inpatFee.setChargeItemAmount(prescriptionDrug.getTotalDrugAmount());
            inpatFee.setChargeItemPrice(prescriptionDrug.getDrugPriceAmount());
            inpatFee.setOrderItemPrice(prescriptionDrug.getTotalDrugAmount());
            inpatFee.setInpatRegId(inpatRegist.getId());
            inpatFee.setInpatDeptId(inpatRegist.getDeptId());
            inpatFee.setInpatDeptName(inpatRegist.getDeptName());
            inpatFee.setResidentDoctorName(inpatRegist.getInpatDoctorName());
            inpatFee.setResidentDoctorId(inpatRegist.getInpatDoctorId());
            inpatFee.setStatusName(InpatFeeStatusEnum.CHARGED.getStatusName());
            inpatFee.setStatusCode(InpatFeeStatusEnum.CHARGED.getStatusCode());
            inpatFee.setFeeNodeCode(InpatFeeNodeCodeEnum.NURSER_EXEC.getCode());
            inpatFee.setFeeNodeName(InpatFeeNodeCodeEnum.NURSER_EXEC.getName());
            inpatFee.setItemTypeFlag(ItemTypeFlagEnum.drug.getCode());
            inpatFee.setTallyTime(new Date());
            inpatFee.setOrderBackNum(new BigDecimal(0));
            inpatFee.setPrescriptionNo(prescriptionDrug.getPrescriptionNo());
            inpatFee.setHospApprFlag(Integer.valueOf(Integer.parseInt(prescriptionDrug.getMedicalInsuranceAuditFlag())));
            inpatFeeList.add(inpatFee);
            totalAmount = totalAmount.add(inpatFee.getChargeItemAmount());
        }
        log.info("\u533b\u5631\u6267\u884c\u8ba1\u8d39\u8282\u70b9\uff1a\u897f\u836f\u7684\u533b\u5631\u8d39\u7528\u660e\u7ec6\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString(inpatFeeList));
        this.saveBatch(inpatFeeList);
        this.iInpatRegistService.doDeduction(inpatRegist.getId(), totalAmount);
    }

    @Transactional(rollbackFor={Exception.class})
    public void chargeByTreatmentItems(InpatOrderChargeFeeDTO param) {
        Assert.isTrue((param != null ? 1 : 0) != 0, (String)"\u8ba1\u8d39\u64cd\u4f5c\u53c2\u6570\u4e0d\u53ef\u672a\u7a7a\uff01");
        List treatmentItems = param.getTreatmentItems();
        Assert.isTrue((treatmentItems != null && !treatmentItems.isEmpty() ? 1 : 0) != 0, (String)"\u8ba1\u8d39\u64cd\u4f5c\u53c2\u6570\u4e2d\u8bca\u7597\u9879\u76ee\u4e0d\u53ef\u4e3a\u7a7a\uff01");
        Assert.hasText((String)param.getInpatNo(), (String)"\u8ba1\u8d39\u64cd\u4f5c\u53c2\u6570\u4e2d\u4f4f\u9662\u53f7\u4e0d\u53ef\u4e3a\u7a7a!");
        InpatRegist inpatRegist = this.iInpatRegistService.selectByInpatNo(param.getInpatNo());
        Assert.notNull((Object)inpatRegist, (String)("\u4f4f\u9662\u53f7\uff1a" + param.getInpatNo() + " \u4e0d\u5b58\u5728\uff01"));
        ArrayList<InpatFee> inpatFeeList = new ArrayList<InpatFee>();
        BigDecimal totalAmount = BigDecimal.ONE;
        log.info("\u533b\u5631\u6267\u884c\u8ba1\u8d39\u8282\u70b9\uff1a\u8bca\u7597\u9879\u76ee\u7684\u533b\u5631\u6536\u8d39\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)param));
        SysDictValueDTO sysDictValueDTO = new SysDictValueDTO();
        sysDictValueDTO.setSize(-1);
        sysDictValueDTO.setType("charge_unit");
        ResponseData chargeUnitDictRes = this.sysServiceFeign.sysDictValueById(sysDictValueDTO, inpatRegist.getTenantId() + "");
        Map<String, String> chargeUnitDictMap = ((Page)chargeUnitDictRes.getData()).getRecords().stream().collect(Collectors.toMap(SysDictValueVo::getValue, SysDictValueVo::getLabel));
        sysDictValueDTO.setType("fee_category");
        ResponseData feeDictRes = this.sysServiceFeign.sysDictValueById(sysDictValueDTO, inpatRegist.getTenantId() + "");
        Map<String, String> feeDictMap = ((Page)feeDictRes.getData()).getRecords().stream().collect(Collectors.toMap(SysDictValueVo::getValue, SysDictValueVo::getLabel));
        Integer[] itemIdArray = (Integer[])treatmentItems.stream().map(InpatTreatmentItems::getItemsNo).map(Integer::parseInt).toArray(Integer[]::new);
        ResponseData listResponseData = this.sysServiceFeign.selectListWithChargeItems(itemIdArray);
        if (!listResponseData.isSuccess() || listResponseData.getData() == null) {
            throw new BusinessException("\u9879\u76ee\u8be6\u60c5\u67e5\u8be2\u5931\u8d25");
        }
        for (InpatTreatmentItems treatmentItem : treatmentItems) {
            Map<Integer, List> inpatTreatmentDetailMap = ((List)listResponseData.getData()).stream().collect(Collectors.toMap(BasePageEntity::getId, SysTreatmentItemVo::getSysTreatmentChargeVoList));
            List inpatTreatmentDetails = inpatTreatmentDetailMap.get(Integer.valueOf(treatmentItem.getItemsNo()));
            Assert.isTrue((inpatTreatmentDetails != null && !inpatTreatmentDetails.isEmpty() ? 1 : 0) != 0, (String)"\u8bca\u7597\u9879\u76ee\u660e\u7ec6\u4e0d\u53ef\u4e3a\u7a7a");
            for (SysTreatmentChargeVo treatmentDetail : inpatTreatmentDetails) {
                InpatFee inpatFee = new InpatFee();
                inpatFee.setOperatorName(param.getOperationName());
                inpatFee.setOperatorId(param.getOperationId());
                inpatFee.setOrderDoctorName(param.getBusineDoctorName());
                inpatFee.setOrderDoctorId(param.getBusineDoctorId());
                inpatFee.setOrderDeptId(param.getBusineDeptId());
                inpatFee.setOrderDeptName(param.getBusineDeptName());
                inpatFee.setOrderWardId(param.getBusineWardId());
                inpatFee.setOrderWardName(param.getBusineWardName());
                inpatFee.setOrderDoctorDeptId(param.getBusineDeptId());
                inpatFee.setOrderDoctorDeptName(param.getBusineDeptName());
                inpatFee.setOrderTypeCode(treatmentDetail.getTreatmentTypeCode());
                inpatFee.setOrderTypeName(treatmentDetail.getTreatmentTypeName());
                inpatFee.setChargeTypeCode(treatmentDetail.getChargeItemId());
                inpatFee.setChargeTypeName(feeDictMap.get(treatmentDetail.getChargeItemId()));
                inpatFee.setChargeItemCode(treatmentDetail.getChargeItemCode());
                inpatFee.setChargeItemName(treatmentDetail.getChargeItemName());
                inpatFee.setOrderItemName(treatmentItem.getName());
                inpatFee.setOrderItemCode(treatmentItem.getItemsCode());
                inpatFee.setChargeItemNum(BigDecimal.valueOf(treatmentDetail.getQuantity().intValue()));
                inpatFee.setOrderItemNum(BigDecimal.valueOf(treatmentItem.getQuantity().intValue()));
                if (StrUtil.isNotBlank((CharSequence)treatmentDetail.getUnit())) {
                    inpatFee.setChargeItemUnit(chargeUnitDictMap.get(treatmentDetail.getUnit()));
                }
                if (StrUtil.isNotBlank((CharSequence)treatmentItem.getUnit())) {
                    inpatFee.setOrderItemSpec(chargeUnitDictMap.get(treatmentItem.getUnit()));
                }
                inpatFee.setChargeItemAmount(treatmentDetail.getItemPrice().multiply(BigDecimal.valueOf(treatmentDetail.getQuantity().intValue())));
                inpatFee.setChargeItemPrice(treatmentDetail.getItemPrice());
                inpatFee.setOrderItemPrice(treatmentItem.getTotalAmount());
                inpatFee.setInpatRegId(inpatRegist.getId());
                inpatFee.setInpatDeptId(inpatRegist.getDeptId());
                inpatFee.setInpatDeptName(inpatRegist.getDeptName());
                inpatFee.setResidentDoctorName(inpatRegist.getInpatDoctorName());
                inpatFee.setResidentDoctorId(inpatRegist.getInpatDoctorId());
                inpatFee.setStatusName(InpatFeeStatusEnum.CHARGED.getStatusName());
                inpatFee.setStatusCode(InpatFeeStatusEnum.CHARGED.getStatusCode());
                inpatFee.setFeeNodeCode(InpatFeeNodeCodeEnum.NURSER_EXEC.getCode());
                inpatFee.setFeeNodeName(InpatFeeNodeCodeEnum.NURSER_EXEC.getName());
                inpatFee.setItemTypeFlag(ItemTypeFlagEnum.Treatment.getCode());
                inpatFee.setTallyTime(new Date());
                inpatFee.setOrderBackNum(new BigDecimal(0));
                inpatFee.setPrescriptionNo(String.valueOf(treatmentItem.getId()));
                inpatFee.setHospApprFlag(Integer.valueOf(1));
                inpatFeeList.add(inpatFee);
                totalAmount = totalAmount.add(inpatFee.getChargeItemAmount());
            }
        }
        log.info("\u533b\u5631\u6267\u884c\u8ba1\u8d39\u8282\u70b9\uff1a\u8bca\u7597\u9879\u76ee\u7684\u533b\u5631\u8d39\u7528\u660e\u7ec6\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString(inpatFeeList));
        this.saveBatch(inpatFeeList);
        this.iInpatRegistService.doDeduction(inpatRegist.getId(), totalAmount);
    }

    public List<InpatSettleFeeVO> selectFeeListAtInpatSettle(InpatFeeBySettleDTO request) {
        BigDecimal totTallyAmount;
        List babyIdList;
        Assert.isTrue((request.getInpatRegId() != null ? 1 : 0) != 0, (String)"\u60a3\u8005\u4f4f\u9662\u7f16\u53f7\u4e0d\u53ef\u4e3a\u7a7a");
        Assert.hasText((String)request.getSettleTypeCode(), (String)"\u7ed3\u7b97\u7c7b\u578b\u4e0d\u53ef\u4e3a\u7a7a");
        String tallyStartTime = "";
        String tallyEndTime = "";
        if (!InpatSettleTypeEnum.OUT_HOSP_SETTLE.getCode().equals(request.getSettleTypeCode())) {
            tallyStartTime = request.getTallyStartTime();
            tallyEndTime = request.getTallyEndTime();
            Assert.hasText((String)tallyStartTime, (String)"\u8bb0\u8d26\u5f00\u59cb\u65f6\u95f4\u4e0d\u53ef\u4e3a\u7a7a");
            Assert.hasText((String)tallyEndTime, (String)"\u8bb0\u8d26\u7ed3\u675f\u65f6\u95f4\u4e0d\u53ef\u4e3a\u7a7a");
        }
        ArrayList<Integer> inpatIdList = new ArrayList<Integer>();
        inpatIdList.add(request.getInpatRegId());
        if ("1".equals(request.getIsWithBaby()) && (babyIdList = this.iInpatRegistService.selectBabyRegIdList(request.getInpatRegId())) != null && !babyIdList.isEmpty()) {
            inpatIdList.addAll(babyIdList);
        }
        List inpatFeeInfoList = ((InpatFeeMapper)this.baseMapper).selectFeeListAtInpatSettle(inpatIdList, tallyStartTime, tallyEndTime);
        List codeNullList = inpatFeeInfoList.stream().filter(e -> StrUtil.isBlank((CharSequence)e.getChargeTypeCode())).collect(Collectors.toList());
        Assert.isTrue((boolean)codeNullList.isEmpty(), (String)"\u60a3\u8005\u8d39\u7528\u6536\u8d39\u7c7b\u522b\u7c7b\u578b\u4e3a\u7a7a,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458!");
        BigDecimal totalMoney = inpatFeeInfoList.stream().map(InpatSettleFeeVO::getMoney).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().in(InpatFee::getInpatRegId, inpatIdList)).isNull(InpatFee::getPayOrderNo);
        if (StrUtil.isNotBlank((CharSequence)tallyStartTime)) {
            wrapper.between(InpatFee::getTallyTime, (Object)tallyStartTime, (Object)tallyEndTime);
        }
        totTallyAmount = (totTallyAmount = ((InpatFeeMapper)this.baseMapper).selectAmount((Wrapper)wrapper)) == null ? BigDecimal.ZERO : totTallyAmount;
        Assert.isTrue((totalMoney.compareTo(totTallyAmount) == 0 ? 1 : 0) != 0, (String)"\u8d39\u7528\u7c7b\u522b\u603b\u91d1\u989d\u4e0e\u8d39\u7528\u8868\u603b\u91d1\u989d\u65e0\u6cd5\u5339\u914d,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458!");
        for (InpatSettleFeeVO inpatSettleFee : inpatFeeInfoList) {
            inpatSettleFee.setTotalMoney(totalMoney);
        }
        return inpatFeeInfoList;
    }

    public Boolean updateSettleInfoByInpatRegId(List<Integer> inpatRegIdList, List<InpatFee> inpatFeeList, InpatSettle inpatSettle) {
        Assert.notEmpty(inpatFeeList, (String)"\u8d39\u7528\u96c6\u5408\u4e3a\u7a7a");
        Assert.notNull((Object)inpatSettle, (String)"\u4f4f\u9662\u7ed3\u7b97\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        String payOrderNo = inpatSettle.getPayOrderNo();
        int rowsUpdated = 0;
        if (InpatSettleTypeEnum.OUT_HOSP_SETTLE.getCode().equals(inpatSettle.getSettleTypeCode())) {
            rowsUpdated = ((InpatFeeMapper)this.baseMapper).updateSettleInfoByInpatRegId(inpatRegIdList, payOrderNo);
        }
        if (rowsUpdated != inpatFeeList.size()) {
            throw new BusinessException(String.format("\u8d39\u7528\u5217\u8868\u66f4\u65b0\u5931\u8d25\uff0c\u9700\u8981\u8bbe\u7f6e\u66f4\u65b0\u8d39\u7528\u5217\u8868\u7684\u603b\u6761\u6570\u4e3a %d\uff0c\u5b9e\u9645\u66f4\u65b0 %d \u6761\u6570\u636e", inpatFeeList.size(), rowsUpdated));
        }
        return true;
    }

    public List<QueryInsurInpatFeeUploadVO> getInsuerInpatFeeUploadList(Integer inpatRegId, String tallyTime) {
        return ((InpatFeeMapper)this.baseMapper).getInsurInpatFeeUploadList(inpatRegId, tallyTime);
    }
}

