/*
 * Decompiled with CFR 0.152.
 */
package com.byh.inpatient.web.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.byh.inpatient.api.model.InpatMedicalRecord;
import com.byh.inpatient.api.model.InpatMedicalRecordDiag;
import com.byh.inpatient.api.model.InpatRegist;
import com.byh.inpatient.api.model.dto.HistoricalDiagDTO;
import com.byh.inpatient.api.model.dto.InpatMedicalRecordDTO;
import com.byh.inpatient.api.model.vo.AdmissionDiagListVO;
import com.byh.inpatient.api.model.vo.AdmissionDiagVO;
import com.byh.inpatient.api.model.vo.HistoryDiagVO;
import com.byh.inpatient.api.util.BeanUtil;
import com.byh.inpatient.data.repository.InpatMedicalRecordDiagMapper;
import com.byh.inpatient.data.repository.InpatMedicalRecordMapper;
import com.byh.inpatient.web.service.IInpatMedicalRecordService;
import com.byh.inpatient.web.service.IInpatRegistService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class InpatMedicalRecordServiceImpl
extends ServiceImpl<InpatMedicalRecordMapper, InpatMedicalRecord>
implements IInpatMedicalRecordService {
    @Autowired
    InpatMedicalRecordMapper inpatMedicalRecordMapper;
    @Autowired
    InpatMedicalRecordDiagMapper inpatMedicalRecordDiagMapper;
    @Autowired
    IInpatRegistService iInpatRegistService;

    public List<AdmissionDiagListVO> getAdmissionDiagList(Integer doctorId, String search, String inHospFlag) {
        Assert.notNull((Object)doctorId, (String)"\u5f53\u524d\u533b\u751f\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a!");
        return this.inpatMedicalRecordMapper.queryAdmissionDiagList(doctorId, search, inHospFlag);
    }

    public void saveOrUpdateAdmissionDiag(InpatMedicalRecordDTO inpatMedicalRecordDTO) {
        Assert.notNull((Object)inpatMedicalRecordDTO, (String)"\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a!");
        Assert.hasText((String)inpatMedicalRecordDTO.getInpatNo(), (String)"\u4f4f\u9662\u53f7\u4e0d\u80fd\u4e3a\u7a7a!");
        Assert.isTrue((inpatMedicalRecordDTO.getDiagnosis() != null && !inpatMedicalRecordDTO.getDiagnosis().isEmpty() ? 1 : 0) != 0, (String)"\u8bca\u65ad\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        InpatRegist inpatRegist = this.iInpatRegistService.selectByInpatNo(inpatMedicalRecordDTO.getInpatNo());
        Assert.notNull((Object)inpatRegist, (String)"\u672a\u627e\u5230\u4f4f\u9662\u767b\u8bb0\u4fe1\u606f!");
        InpatMedicalRecord inpatMedicalRecord = new InpatMedicalRecord();
        BeanUtil.copy((Object)inpatMedicalRecordDTO, (Object)inpatMedicalRecord);
        inpatMedicalRecord.setMedicalRecordNo(inpatRegist.getMedicalRecordNo());
        inpatMedicalRecord.setStatus("1");
        inpatMedicalRecord.setDoctorId(inpatRegist.getInpatDoctorId());
        inpatMedicalRecord.setDoctorName(inpatRegist.getInpatDoctorName());
        if (inpatMedicalRecordDTO.getId() == null) {
            this.inpatMedicalRecordMapper.insert((Object)inpatMedicalRecord);
            inpatMedicalRecordDTO.getDiagnosis().forEach(item -> {
                InpatMedicalRecordDiag inpatMedicalRecordDiag = new InpatMedicalRecordDiag();
                BeanUtil.copy((Object)item, (Object)inpatMedicalRecordDiag);
                inpatMedicalRecordDiag.setInpatNo(inpatRegist.getInpatNo());
                inpatMedicalRecordDiag.setInpatMedicalRecordId(inpatMedicalRecord.getId());
                this.inpatMedicalRecordDiagMapper.insert((Object)inpatMedicalRecordDiag);
            });
        } else {
            this.inpatMedicalRecordMapper.updateById((Object)inpatMedicalRecord);
            inpatMedicalRecordDTO.getDiagnosis().forEach(item -> {
                InpatMedicalRecordDiag inpatMedicalRecordDiag = new InpatMedicalRecordDiag();
                BeanUtil.copy((Object)item, (Object)inpatMedicalRecordDiag);
                inpatMedicalRecordDiag.setInpatNo(inpatRegist.getInpatNo());
                inpatMedicalRecordDiag.setInpatMedicalRecordId(inpatMedicalRecord.getId());
                this.inpatMedicalRecordDiagMapper.update((Object)inpatMedicalRecordDiag, (Wrapper)Wrappers.lambdaQuery(InpatMedicalRecordDiag.class).eq(InpatMedicalRecordDiag::getInpatMedicalRecordId, (Object)inpatMedicalRecord.getId()));
            });
        }
    }

    public AdmissionDiagVO getAdmissionDiagByInpatNo(String inpatNo) {
        Assert.hasText((String)inpatNo, (String)"\u4f4f\u9662\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        AdmissionDiagVO admissionDiagVO = new AdmissionDiagVO();
        try {
            InpatMedicalRecord inpatMedicalRecord = (InpatMedicalRecord)this.inpatMedicalRecordMapper.selectOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(InpatMedicalRecord::getInpatNo, (Object)inpatNo)).eq(InpatMedicalRecord::getStatus, (Object)"1"));
            BeanUtil.copy((Object)inpatMedicalRecord, (Object)admissionDiagVO);
            List inpatMedicalRecordDiag = this.inpatMedicalRecordDiagMapper.selectList((Wrapper)Wrappers.lambdaQuery().eq(InpatMedicalRecordDiag::getInpatNo, (Object)inpatNo));
            admissionDiagVO.setDiagnosis(inpatMedicalRecordDiag);
        }
        catch (Exception e) {
            return null;
        }
        return admissionDiagVO;
    }

    public Page<HistoryDiagVO> getHistoryDiagList(HistoricalDiagDTO param) {
        Assert.hasText((String)param.getPatientName(), (String)"\u60a3\u8005\u59d3\u540d\u4e0d\u80fd\u4e3a\u7a7a!");
        Assert.hasText((String)param.getCardNo(), (String)"\u8eab\u4efd\u8bc1\u53f7\u4e0d\u80fd\u4e3a\u7a7a!");
        Page page = new Page((long)param.getCurrent().intValue(), (long)param.getSize().intValue());
        return this.inpatMedicalRecordMapper.getHIsDiagList(page, param);
    }
}

