/*
 * Decompiled with CFR 0.152.
 */
package com.byh.inpatient.web.service.impl;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.byh.inpatient.api.dto.inpatOrderDrug.ApplyReturnDto;
import com.byh.inpatient.api.dto.inpatOrderDrug.CancelApplyDispenseDto;
import com.byh.inpatient.api.dto.inpatOrderDrug.CancelReturnDto;
import com.byh.inpatient.api.dto.inpatOrderDrug.DispensedDto;
import com.byh.inpatient.api.dto.inpatOrderDrug.GetApplyPageDto;
import com.byh.inpatient.api.dto.inpatOrderDrug.GetApplyReturnListDto;
import com.byh.inpatient.api.dto.inpatOrderDrug.GetDetailListDto;
import com.byh.inpatient.api.dto.inpatOrderDrug.GetDispensePageDto;
import com.byh.inpatient.api.enums.ApplyStatusEnum;
import com.byh.inpatient.api.enums.ApplyTypeEnum;
import com.byh.inpatient.api.enums.DrugPharmacyOutStatusEnum;
import com.byh.inpatient.api.enums.ProjectDetailsStatusEnum;
import com.byh.inpatient.api.enums.VisitTypeEnum;
import com.byh.inpatient.api.exception.BusinessException;
import com.byh.inpatient.api.model.InpatOrderDrugEntity;
import com.byh.inpatient.api.util.BeanUtil;
import com.byh.inpatient.api.util.ExceptionUtils;
import com.byh.inpatient.api.util.UUIDUtils;
import com.byh.inpatient.api.vo.inpatOrderDrug.DoctorDeptVo;
import com.byh.inpatient.api.vo.inpatOrderDrug.GetApplyPageVo;
import com.byh.inpatient.api.vo.inpatOrderDrug.GetApplyReturnDetailVo;
import com.byh.inpatient.api.vo.inpatOrderDrug.GetApplyReturnListVo;
import com.byh.inpatient.api.vo.inpatOrderDrug.GetDetailListVo;
import com.byh.inpatient.api.vo.inpatOrderDrug.GetDispensePageVo;
import com.byh.inpatient.api.vo.inpatOrderDrug.GetOrderDrugVo;
import com.byh.inpatient.api.vo.inpatOrderDrug.SysDrugPharmacyOutVo;
import com.byh.inpatient.api.vo.inpatOrderDrug.SysDrugPharmacySimpleVo;
import com.byh.inpatient.api.vo.inpatOrderDrug.SysDrugPharmacyVo;
import com.byh.inpatient.data.repository.InpatOrderDrugMapper;
import com.byh.inpatient.web.service.InpatOrderDrugService;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class InpatOrderDrugServiceImpl
extends ServiceImpl<InpatOrderDrugMapper, InpatOrderDrugEntity>
implements InpatOrderDrugService {
    private Logger logger = LoggerFactory.getLogger(InpatOrderDrugServiceImpl.class);
    @Resource
    private InpatOrderDrugMapper inpatOrderDrugMapper;

    @Transactional(rollbackFor={BusinessException.class})
    public void dispensedOrReturned(DispensedDto dto) {
        List orderDrugIds = dto.getOrderDrugIds().stream().distinct().collect(Collectors.toList());
        if (orderDrugIds.isEmpty()) {
            ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"500", (String)"\u4f4f\u9662\u53d1\u836f\u65f6\uff0c\u836f\u7269\u7533\u9886\u4e3b\u952eID\u4e0d\u53ef\u4e3a\u7a7a\uff01");
        }
        dto.setOrderDrugIds(orderDrugIds);
        String operateType = dto.getOperateType();
        if ("1".equals(operateType)) {
            this.dispensed(dto);
        } else if (!"2".equals(operateType)) {
            ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"500", (String)("\u64cd\u4f5c\u836f\u7269\u7533\u9886\u65f6\uff0c\u64cd\u4f5c\u7f16\u7801\u9519\u8bef\uff01\u5e94\u4e3a\uff081\u3001\u53d1\u836f\uff0c2\u3001\u9000\u836f\uff09\uff01\u5b9e\u9645\u4e3a\uff1a" + operateType));
        }
    }

    public void returned(DispensedDto dto) {
        Integer tenantId = dto.getTenantId();
        Integer operatorId = dto.getOperatorId();
        String operatorName = dto.getOperatorName();
        ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"500", (String)"\u6d4b\u8bd5\u884c\u9519\u8bef\uff01");
    }

    private void dispensed(DispensedDto dto) {
        Object errorInfo;
        List missPriceInvertoryNos;
        List nullPriceInvertoryNos;
        List errorInvertoryNos;
        List nullPriceOrderDrugIds;
        List errorOrderDrugIds;
        Integer tenantId = dto.getTenantId();
        Integer operatorId = dto.getOperatorId();
        String operatorName = dto.getOperatorName();
        List orderDrugIds = dto.getOrderDrugIds();
        LambdaQueryWrapper orderDrugQueryWrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)orderDrugQueryWrapper.eq(tenantId != null, InpatOrderDrugEntity::getTenantId, (Object)tenantId)).eq(InpatOrderDrugEntity::getStatusCode, (Object)ApplyStatusEnum.PRIMED_MEDICINE.getValue())).in(InpatOrderDrugEntity::getId, (Collection)orderDrugIds);
        List dispenseVos = this.inpatOrderDrugMapper.selectList((Wrapper)orderDrugQueryWrapper);
        if (dispenseVos.isEmpty()) {
            ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"500", (String)"\u4f4f\u9662\u53d1\u836f\u65f6\uff0c\u6839\u636e\u836f\u7269\u7533\u9886\u4e3b\u952eID\u96c6\u5408\u6ca1\u6709\u67e5\u8be2\u5230\u7b26\u5408\u6761\u4ef6\u7684\u836f\u7269\u7533\u9886\u5217\u8868\u4fe1\u606f\uff01");
        }
        if (orderDrugIds.size() != dispenseVos.size()) {
            LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
            ((LambdaQueryWrapper)queryWrapper.eq(tenantId != null, InpatOrderDrugEntity::getTenantId, (Object)tenantId)).in(InpatOrderDrugEntity::getId, (Collection)orderDrugIds);
            List orderDrugList = this.inpatOrderDrugMapper.selectList((Wrapper)queryWrapper);
            List dispenseOrderDrugId = dispenseVos.stream().map(InpatOrderDrugEntity::getId).collect(Collectors.toList());
            List missOrderDrugIds = orderDrugList.stream().map(InpatOrderDrugEntity::getId).filter(orderDrugId -> !dispenseOrderDrugId.contains(orderDrugId)).collect(Collectors.toList());
            if (!missOrderDrugIds.isEmpty()) {
                String errorInfo3 = "\u4ee5\u4e0b\u836f\u7269\u7533\u9886\u4e3b\u952eID\uff0c\u6ca1\u6709\u67e5\u8be2\u5230\u5bf9\u5e94\u7684\u7b26\u5408\u6761\u4ef6\u7684\u836f\u7269\u7533\u9886\u4fe1\u606f\uff1a";
                String idsSrt = this.getMissIdIntegerFoString(missOrderDrugIds);
                ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"500", (String)(errorInfo3 + idsSrt));
            }
        }
        if (!(errorOrderDrugIds = dispenseVos.stream().filter(vo -> StrUtil.isEmpty((CharSequence)vo.getPrescriptionNo())).map(InpatOrderDrugEntity::getId).collect(Collectors.toList())).isEmpty()) {
            String errorInfo4 = "\u4f4f\u9662\u53d1\u836f\u65f6\uff0c\u4ee5\u4e0b\u836f\u7269\u7533\u9886\u5185\u7684\u5904\u65b9\u7f16\u53f7\u4e3a\u7a7a\uff01\u836f\u7269\u7533\u9886\u7f16\u53f7\uff1a";
            String idsStr = this.getMissIdIntegerFoString(errorOrderDrugIds);
            ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"500", (String)(errorInfo4 + idsStr));
        }
        if (!(nullPriceOrderDrugIds = dispenseVos.stream().filter(vo -> vo.getDrugAmount() == null || vo.getDrugAmount().compareTo(BigDecimal.ZERO) <= 0).map(InpatOrderDrugEntity::getId).collect(Collectors.toList())).isEmpty()) {
            String errorInfo5 = "\u4f4f\u9662\u53d1\u836f\u65f6\uff0c\u4ee5\u4e0b\u836f\u7269\u7533\u9886\u5185\u7684\u836f\u54c1\u91d1\u989d\u4e3a\u7a7a\uff01\u836f\u7269\u7533\u9886\u7f16\u53f7\uff1a";
            String idsStr = this.getMissIdIntegerFoString(nullPriceOrderDrugIds);
            ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"500", (String)(errorInfo5 + idsStr));
        }
        Map<String, List<InpatOrderDrugEntity>> orderDrugMap = dispenseVos.stream().collect(Collectors.groupingBy(InpatOrderDrugEntity::getPrescriptionNo));
        List prescNos = dispenseVos.stream().map(InpatOrderDrugEntity::getPrescriptionNo).distinct().collect(Collectors.toList());
        List drugPharmacyOutVos = this.inpatOrderDrugMapper.selectDrugPharmacyOutList(tenantId, prescNos);
        Map<String, String> drugPharmacyOutMap = drugPharmacyOutVos.stream().collect(Collectors.toMap(SysDrugPharmacyOutVo::getPrescriptionId, SysDrugPharmacyOutVo::getInventoryNumber));
        if (drugPharmacyOutVos.isEmpty()) {
            String errorInfo6 = "\u4f4f\u9662\u53d1\u836f\u65f6\uff0c\u6839\u636e\u5904\u65b9\u53f7\u6ca1\u6709\u67e5\u8be2\u5230\u5bf9\u5e94\u7684\u51fa\u5e93\u5355\u5217\u8868\u4fe1\u606f\uff01\u836f\u7269\u7533\u9886\u7f16\u53f7\uff1a";
            String idsStr = this.getMissIdIntegerFoString(orderDrugIds);
            ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"500", (String)(errorInfo6 + idsStr));
        }
        if (drugPharmacyOutVos.size() != prescNos.size()) {
            List outPrescNos = drugPharmacyOutVos.stream().map(SysDrugPharmacyOutVo::getPrescriptionId).distinct().collect(Collectors.toList());
            List missPrescNos = prescNos.stream().map(String::valueOf).filter(prescNo -> !outPrescNos.contains(prescNo)).collect(Collectors.toList());
            if (!missPrescNos.isEmpty()) {
                String errorInfo2 = "\u4f4f\u9662\u53d1\u836f\u65f6\uff0c\u6839\u636e\u5904\u65b9\u53f7\u6ca1\u6709\u67e5\u8be2\u5230\u5bf9\u5e94\u7684\u51fa\u5e93\u5217\u8868\u4fe1\u606f\uff0c\u5904\u65b9\u53f7\uff1a";
                String prescNosStr = missPrescNos.stream().map(String::valueOf).collect(Collectors.joining("\uff0c"));
                ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"500", (String)(errorInfo2 + prescNosStr));
            }
        }
        if (!(errorInvertoryNos = drugPharmacyOutVos.stream().filter(vo -> !DrugPharmacyOutStatusEnum.WAIT_TO_OUT.getValue().equals(vo.getAuditStatus())).map(SysDrugPharmacyOutVo::getInventoryNumber).collect(Collectors.toList())).isEmpty()) {
            String errorInfo7 = "\u4f4f\u9662\u53d1\u836f\u65f6\uff0c\u5904\u65b9\u5bf9\u5e94\u7684\u51fa\u5e93\u5355\u72b6\u6001\u5f02\u5e38\uff01\u51fa\u5e93\u5355\u53f7\uff1a";
            String idsStr = this.getMissIdStrForString(errorInvertoryNos);
            ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"500", (String)(errorInfo7 + idsStr));
        }
        if (!(nullPriceInvertoryNos = drugPharmacyOutVos.stream().filter(vo -> vo.getOutboundRetailAmount() == null || vo.getOutboundRetailAmount().compareTo(BigDecimal.ZERO) <= 0).map(SysDrugPharmacyOutVo::getInventoryNumber).collect(Collectors.toList())).isEmpty()) {
            String errorInfo2 = "\u4f4f\u9662\u53d1\u836f\u65f6\uff0c\u51fa\u5e93\u5355\u7684\u91d1\u989d\u4e0d\u53ef\u4e3a\u7a7a\uff01\u51fa\u5e93\u5355\u53f7\uff1a";
            String idsStr = this.getMissIdStrForString(nullPriceInvertoryNos);
            ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"500", (String)(errorInfo2 + idsStr));
        }
        if (!(missPriceInvertoryNos = drugPharmacyOutVos.stream().filter(vo -> {
            List list = orderDrugMap.getOrDefault(vo.getPrescriptionId(), new ArrayList());
            BigDecimal drugAmount = list.stream().map(InpatOrderDrugEntity::getDrugAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            return vo.getOutboundRetailAmount().compareTo(drugAmount) != 0;
        }).map(SysDrugPharmacyOutVo::getInventoryNumber).collect(Collectors.toList())).isEmpty()) {
            String errorInfo8 = "\u4f4f\u9662\u53d1\u836f\u65f6\uff0c\u91d1\u989d\u4e0d\u5339\u914d\uff01\u51fa\u5e93\u5355\u53f7\uff1a";
            String idsStr = this.getMissIdStrForString(missPriceInvertoryNos);
            ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"500", (String)(errorInfo8 + idsStr));
        }
        List invertoryNos = drugPharmacyOutVos.stream().map(SysDrugPharmacyOutVo::getInventoryNumber).collect(Collectors.toList());
        this.inpatOrderDrugMapper.updateSysDrugPharmacyOutList(tenantId, DrugPharmacyOutStatusEnum.CONFIRMED.getValue(), operatorName, VisitTypeEnum.INPATIENT.getValue(), invertoryNos);
        List drugIds = dispenseVos.stream().map(InpatOrderDrugEntity::getDrugNo).distinct().collect(Collectors.toList());
        String warehouse = dto.getWarehouse();
        List drugPharmacySimpleList = this.inpatOrderDrugMapper.selectDrugPharmacySimpleListByDrugIds(drugIds, warehouse);
        Map simpleMap = drugPharmacySimpleList.stream().collect(Collectors.toMap(SysDrugPharmacySimpleVo::getDrugId, Function.identity()));
        Map<String, Integer> applyNumMap = dispenseVos.stream().collect(Collectors.groupingBy(InpatOrderDrugEntity::getDrugNo, Collectors.mapping(entity -> entity.getApplyBackNum().intValue(), Collectors.reducing(0, Integer::sum))));
        ArrayList<SysDrugPharmacySimpleVo> successSimpletList = new ArrayList<SysDrugPharmacySimpleVo>();
        ArrayList<SysDrugPharmacySimpleVo> errorSimpleList = new ArrayList<SysDrugPharmacySimpleVo>();
        LinkedHashMap<String, Integer> errorSimpleMap = new LinkedHashMap<String, Integer>();
        for (Map.Entry<String, Integer> entry2 : applyNumMap.entrySet()) {
            String drugId = entry2.getKey();
            Integer applyNum = entry2.getValue();
            SysDrugPharmacySimpleVo simpleVo = (SysDrugPharmacySimpleVo)simpleMap.get(drugId);
            if (simpleVo == null) {
                errorSimpleMap.put(drugId, applyNum);
                continue;
            }
            Integer realStockNum = simpleVo.getActualInventory() - applyNum;
            Integer realMarkStockNum = simpleVo.getOccupyInventory() - applyNum;
            if (realStockNum < 0) {
                simpleVo.setApplyBackNum(applyNum);
                errorSimpleList.add(simpleVo);
                continue;
            }
            simpleVo.setActualInventory(realStockNum);
            simpleVo.setOccupyInventory(realMarkStockNum);
            simpleVo.setWarehouse(warehouse);
            successSimpletList.add(simpleVo);
        }
        Map<String, String> drugInfoMap = dispenseVos.stream().collect(Collectors.toMap(InpatOrderDrugEntity::getDrugNo, InpatOrderDrugEntity::getDrugName, (existing, replacement) -> existing));
        if (!errorSimpleMap.isEmpty()) {
            errorInfo = errorSimpleMap.entrySet().stream().map(entry -> String.format("\uff08%s\u3001%s\uff0c\u7533\u8bf7\u53d1\u836f\u6570\u91cf\uff1a%s\uff09\u3002", entry.getKey(), drugInfoMap.get(entry.getKey()), entry.getValue())).collect(Collectors.joining("", "\u4f4f\u9662\u53d1\u836f\u65f6\uff0c\u4ee5\u4e0b\u836f\u54c1\u672a\u627e\u5230\u5bf9\u5e94\u7684\u5e93\u5b58\u4fe1\u606f\uff1a", ""));
            ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"500", (String)errorInfo);
        }
        if (!errorSimpleList.isEmpty()) {
            errorInfo = errorSimpleList.stream().map(error -> String.format("\uff08%s\u3001%s\uff1a\u7533\u8bf7\u6570\u91cf\uff1a%s\uff0c\u5b9e\u9645\u5e93\u5b58\u6570\u91cf\uff1a%s\uff09\u3002", error.getDrugId(), error.getDrugName(), error.getApplyBackNum(), error.getActualInventory())).collect(Collectors.joining("", "\u4f4f\u9662\u53d1\u836f\u65f6\uff0c\u4ee5\u4e0b\u836f\u54c1\u5e93\u5b58\u4e0d\u8db3\uff1a", ""));
            ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"500", (String)errorInfo);
        }
        for (SysDrugPharmacySimpleVo simpleVo : successSimpletList) {
            this.inpatOrderDrugMapper.updateStockNum(simpleVo.getActualInventory(), simpleVo.getOccupyInventory(), warehouse, simpleVo.getDrugId());
        }
        List drugPharmacyVos = this.inpatOrderDrugMapper.selectDrugPharmacyList(warehouse, drugIds);
        Map<String, List<SysDrugPharmacyVo>> drugPharmacyMap = drugPharmacyVos.stream().collect(Collectors.groupingBy(SysDrugPharmacyVo::getDrugsId));
        Map<String, Map<String, Integer>> dispenseMap = dispenseVos.stream().collect(Collectors.groupingBy(InpatOrderDrugEntity::getPrescriptionNo, Collectors.groupingBy(InpatOrderDrugEntity::getDrugNo, Collectors.summingInt(entity -> entity.getApplyBackNum().intValue()))));
        ArrayList<SysDrugPharmacyVo> applyDrugPharmacyList = new ArrayList<SysDrugPharmacyVo>();
        LinkedHashMap<String, Integer> errorDrugPharmacyMap = new LinkedHashMap<String, Integer>();
        for (Map.Entry entry2 : dispenseMap.entrySet()) {
            String prescNo2 = (String)entry2.getKey();
            Map applyInfoMap = (Map)entry2.getValue();
            for (Map.Entry applyInfoEntry : applyInfoMap.entrySet()) {
                String drugId = (String)applyInfoEntry.getKey();
                Integer applyNum = (Integer)applyInfoEntry.getValue();
                List pharmacyVos = drugPharmacyMap.getOrDefault(drugId, new ArrayList());
                if (pharmacyVos.isEmpty()) {
                    errorDrugPharmacyMap.merge(drugId, applyNum, Integer::sum);
                    continue;
                }
                Iterator iterator = pharmacyVos.iterator();
                while (iterator.hasNext() && applyNum > 0) {
                    SysDrugPharmacyVo drugPharmacyVo = (SysDrugPharmacyVo)iterator.next();
                    Integer stockNum = drugPharmacyVo.getActualInventory();
                    if (stockNum <= 0) continue;
                    SysDrugPharmacyVo newDrugPharmacy = new SysDrugPharmacyVo();
                    BeanUtil.copy((Object)drugPharmacyVo, (Object)newDrugPharmacy);
                    int deductedStockNum = Math.min(stockNum, applyNum);
                    drugPharmacyVo.setActualInventory(Integer.valueOf(stockNum - deductedStockNum));
                    applyNum = applyNum - deductedStockNum;
                    newDrugPharmacy.setActualInventory(Integer.valueOf(-deductedStockNum));
                    BigDecimal purchasePrice = drugPharmacyVo.getPurchasePrice();
                    BigDecimal retailPrice = drugPharmacyVo.getRetailPrice();
                    BigDecimal applyQty = BigDecimal.valueOf(deductedStockNum);
                    BigDecimal purchaseAmount = purchasePrice.multiply(applyQty);
                    BigDecimal retailAmount = retailPrice.multiply(applyQty);
                    newDrugPharmacy.setPurchaseAmount(purchaseAmount);
                    newDrugPharmacy.setRetailAmount(retailAmount);
                    newDrugPharmacy.setId(UUIDUtils.getRandom((int)6, (boolean)true));
                    newDrugPharmacy.setCreateId(operatorId);
                    newDrugPharmacy.setInOutType("2");
                    newDrugPharmacy.setInOutMethod("11");
                    newDrugPharmacy.setDelFlag("0");
                    newDrugPharmacy.setInOutTime(new Date());
                    newDrugPharmacy.setPrescriptionId(prescNo2);
                    newDrugPharmacy.setVisitType("2");
                    newDrugPharmacy.setValidityPeriod(this.getValidityPeriod(drugPharmacyVo.getEffectiveTime()));
                    String inventoryId = drugPharmacyOutMap.get(prescNo2);
                    newDrugPharmacy.setInventoryId(inventoryId);
                    applyDrugPharmacyList.add(newDrugPharmacy);
                }
            }
        }
        if (!errorDrugPharmacyMap.isEmpty()) {
            String errorInfo9 = errorDrugPharmacyMap.entrySet().stream().map(entry -> String.format("\uff08%s\u3001%s\uff0c\u7533\u8bf7\u53d1\u836f\u6570\u91cf\uff1a%s\uff09\u3002", entry.getKey(), drugInfoMap.get(entry.getKey()), entry.getValue())).collect(Collectors.joining("", "\u4f4f\u9662\u53d1\u836f\u65f6\uff0c\u4ee5\u4e0b\u836f\u54c1\u6ca1\u6709\u67e5\u8be2\u5230\u5bf9\u5e94\u7684\u6279\u6b21\u4fe1\u606f\uff1a", ""));
            ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"500", (String)errorInfo9);
        }
        this.inpatOrderDrugMapper.insertDrugPharmacyList(applyDrugPharmacyList);
        this.inpatOrderDrugMapper.update(null, (Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().eq(InpatOrderDrugEntity::getTenantId, (Object)tenantId)).in(InpatOrderDrugEntity::getId, (Collection)orderDrugIds)).set(InpatOrderDrugEntity::getStatusCode, (Object)ApplyStatusEnum.DISPENSED_MEDICINE.getValue())).set(InpatOrderDrugEntity::getStatusName, (Object)ApplyStatusEnum.DISPENSED_MEDICINE.getLabel())).set(InpatOrderDrugEntity::getUpdateId, (Object)operatorId)).set(InpatOrderDrugEntity::getUpdateName, (Object)operatorName)).set(InpatOrderDrugEntity::getApplyBackEmpId, (Object)operatorId)).set(InpatOrderDrugEntity::getApplyBackEmpName, (Object)operatorName)).set(InpatOrderDrugEntity::getDispenseBackTime, (Object)new Date()));
    }

    private String getValidityPeriod(Date effectiveTime) {
        String validityPeriod = "";
        if (effectiveTime == null) {
            return "";
        }
        LocalDate effectiveDate = effectiveTime.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        LocalDate currentDate = LocalDate.now();
        long daysLeft = ChronoUnit.DAYS.between(currentDate, effectiveDate);
        if (daysLeft < 0L) {
            validityPeriod = "1";
        } else if (daysLeft <= 30L) {
            validityPeriod = "2";
        } else if (daysLeft <= 60L) {
            validityPeriod = "3";
        } else if (daysLeft <= 180L) {
            validityPeriod = "4";
        }
        return validityPeriod;
    }

    private String getMissIdStrForString(List<String> ids) {
        return ids.stream().map(String::valueOf).collect(Collectors.joining("\uff0c"));
    }

    private String getMissIdIntegerFoString(List<Integer> ids) {
        return ids.stream().map(String::valueOf).collect(Collectors.joining("\uff0c"));
    }

    public GetDetailListVo selectDetailList(GetDetailListDto dto) {
        List orderDrugList = this.inpatOrderDrugMapper.selectOrderDrugList(dto);
        Map<String, List<GetOrderDrugVo>> detailMap = orderDrugList.stream().collect(Collectors.groupingBy(GetOrderDrugVo::getPrescNo));
        GetDetailListVo vo = this.inpatOrderDrugMapper.selectInpatRegistInfo(dto.getTenantId(), dto.getInpatNo());
        ArrayList<List<GetOrderDrugVo>> orderDrugs = new ArrayList<List<GetOrderDrugVo>>();
        for (Map.Entry<String, List<GetOrderDrugVo>> entry : detailMap.entrySet()) {
            List<GetOrderDrugVo> voList = entry.getValue();
            orderDrugs.add(voList);
        }
        vo.setOrderDrugList(orderDrugs);
        return vo;
    }

    public Page<GetDispensePageVo> selectPageList(GetDispensePageDto dto) {
        Page page = new Page((long)dto.getCurrent().intValue(), (long)dto.getSize().intValue());
        List list = this.inpatOrderDrugMapper.selectPageList(page, dto);
        page.setRecords(list);
        return page;
    }

    @Transactional(rollbackFor={BusinessException.class})
    public void cancelReturn(CancelReturnDto dto) {
        Integer tenantId = dto.getTenantId();
        Integer backOrderDrugId = dto.getBackOrderDrugId();
        if (backOrderDrugId == null) {
            ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"500", (String)"\u53d6\u6d88\u7533\u8bf7\u9000\u836f\u65f6\uff0c\u836f\u7269\u7533\u9886\u4e3b\u952eID \u4e0d\u53ef\u4e3a\u7a7a\uff01");
        }
        LambdaQueryWrapper backOrderDrugQuerWrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)backOrderDrugQuerWrapper.eq(tenantId != null, InpatOrderDrugEntity::getTenantId, (Object)tenantId)).eq(InpatOrderDrugEntity::getId, (Object)backOrderDrugId);
        InpatOrderDrugEntity backOrderDrug = (InpatOrderDrugEntity)this.inpatOrderDrugMapper.selectOne((Wrapper)backOrderDrugQuerWrapper);
        if (backOrderDrug == null) {
            ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"500", (String)"\u53d6\u6d88\u7533\u8bf7\u9000\u836f\u65f6\uff0c\u6839\u636e\u836f\u7269\u7533\u9886\u4e3b\u952eID\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u5f85\u9000\u836f\u4fe1\u606f\uff01");
        }
        if (!ApplyStatusEnum.PENDING_RETURN_MEDICATION.getValue().equals(backOrderDrug.getStatusCode())) {
            String errorInfo = String.format("\u53d6\u6d88\u7533\u8bf7\u9000\u836f\u65f6\uff0c\u72b6\u6001\u5f02\u5e38\uff01\u5e94\u4e3a\uff1a%s\uff0c\u5b9e\u9645\u4e3a\uff1a%s\uff0c\u836f\u7269\u7533\u9886\u4e3b\u952eID\uff1a%s\u3002", ApplyStatusEnum.PENDING_RETURN_MEDICATION.getLabel(), backOrderDrug.getStatusName(), backOrderDrugId);
            ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"500", (String)errorInfo);
        }
        this.inpatOrderDrugMapper.deleteById((Serializable)backOrderDrugId);
    }

    public GetApplyReturnListVo selectApplyReturnWithAllowBackNum(GetApplyReturnListDto dto) {
        GetApplyReturnListVo vo = new GetApplyReturnListVo();
        Integer tenantId = dto.getTenantId();
        Integer inpatOrderDrugId = dto.getInpatOrderDrugId();
        LambdaQueryWrapper orderDrugQueryWrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)orderDrugQueryWrapper.eq(tenantId != null, InpatOrderDrugEntity::getTenantId, (Object)tenantId)).eq(InpatOrderDrugEntity::getId, (Object)inpatOrderDrugId);
        InpatOrderDrugEntity inpatOrderDrug = (InpatOrderDrugEntity)this.inpatOrderDrugMapper.selectOne((Wrapper)orderDrugQueryWrapper);
        if (inpatOrderDrug == null) {
            ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"500", (String)"\u6839\u636e\u4f4f\u9662\u836f\u7269\u7533\u9886\u7f16\u53f7\uff0c\u6ca1\u6709\u67e5\u8be2\u5230\u5bf9\u5e94\u7684\u836f\u7269\u7533\u9886\u8bb0\u5f55\uff01");
        }
        LambdaQueryWrapper orderDrugBackQueryWrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)orderDrugBackQueryWrapper.eq(tenantId != null, InpatOrderDrugEntity::getTenantId, (Object)tenantId)).eq(InpatOrderDrugEntity::getBackOrderDrugId, (Object)inpatOrderDrugId);
        List backList = this.inpatOrderDrugMapper.selectList((Wrapper)orderDrugBackQueryWrapper);
        List detailList = backList.stream().map(entity -> {
            GetApplyReturnDetailVo detailVo = new GetApplyReturnDetailVo();
            detailVo.setBackOrderDrugId(entity.getId());
            detailVo.setBackNum(entity.getApplyBackNum());
            detailVo.setBackUnit(entity.getApplyBackUnit());
            detailVo.setApplyStatusCode(entity.getStatusCode());
            detailVo.setApplyStatusName(entity.getStatusName());
            return detailVo;
        }).collect(Collectors.toList());
        vo.setDetailList(detailList);
        BigDecimal backNum = backList.stream().filter(entity -> entity.getApplyBackNum() != null).map(InpatOrderDrugEntity::getApplyBackNum).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal allowBackNum = inpatOrderDrug.getApplyBackNum().subtract(backNum);
        vo.setAllowBackNum(allowBackNum);
        vo.setAllowBackUnit(inpatOrderDrug.getApplyBackUnit());
        return vo;
    }

    @Transactional(rollbackFor={BusinessException.class})
    public void applyReturn(ApplyReturnDto dto) {
        BigDecimal backTotalNum;
        BigDecimal allowBackNum;
        Integer tenantId = dto.getTenantId();
        Integer inpatOrderDrugId = dto.getInpatOrderDrugId();
        BigDecimal backNum = dto.getBackNum();
        LambdaQueryWrapper inpatOrderDrugWrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)inpatOrderDrugWrapper.eq(tenantId != null, InpatOrderDrugEntity::getTenantId, (Object)tenantId)).eq(InpatOrderDrugEntity::getId, (Object)inpatOrderDrugId);
        InpatOrderDrugEntity inpatOrderDrug = (InpatOrderDrugEntity)this.inpatOrderDrugMapper.selectOne((Wrapper)inpatOrderDrugWrapper);
        if (inpatOrderDrug == null) {
            ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"500", (String)"\u7533\u8bf7\u9000\u836f\u65f6\uff0c\u6839\u636e\u4f4f\u9662\u836f\u7269\u7533\u9886\u4e3b\u952eID\uff0c\u6ca1\u6709\u67e5\u8be2\u5230\u5bf9\u5e94\u7684\u836f\u7269\u7533\u9886\u8bb0\u5f55\uff01");
        }
        String statusCode = inpatOrderDrug.getStatusCode();
        String applyTypeCode = inpatOrderDrug.getApplyTypeCode();
        if (!ApplyTypeEnum.DISPENSE_MEDICINE.getValue().equals(applyTypeCode)) {
            String errorInfo = String.format("\u7533\u8bf7\u9000\u836f\u65f6\uff0c\u7533\u9886\u72b6\u6001\u7f16\u7801\u5f02\u5e38\uff01\u5e94\u4e3a\uff1a%s\uff0c\u5b9e\u9645\u4e3a\uff1a%s\uff0c\u4f4f\u9662\u836f\u7269\u7533\u9886\u4e3b\u952eID\uff1a%s\u3002", ApplyTypeEnum.DISPENSE_MEDICINE.getLabel(), inpatOrderDrug.getApplyTypeName(), inpatOrderDrug.getId());
            ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"500", (String)errorInfo);
        }
        BigDecimal applyNum = inpatOrderDrug.getApplyBackNum();
        LambdaQueryWrapper backInpatOrderDrugWrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)backInpatOrderDrugWrapper.eq(tenantId != null, InpatOrderDrugEntity::getTenantId, (Object)tenantId)).eq(InpatOrderDrugEntity::getBackOrderDrugId, (Object)inpatOrderDrugId);
        List backInpatOrderDrugList = this.inpatOrderDrugMapper.selectList((Wrapper)backInpatOrderDrugWrapper);
        if (!backInpatOrderDrugList.isEmpty() && backNum.compareTo(allowBackNum = applyNum.subtract(backTotalNum = backInpatOrderDrugList.stream().filter(entity -> entity.getApplyBackNum() != null).map(InpatOrderDrugEntity::getApplyBackNum).reduce(BigDecimal.ZERO, BigDecimal::add))) > 0) {
            String errorInfo = String.format("\u7533\u8bf7\u9000\u836f\u65f6\uff0c\u9000\u836f\u6570\u91cf\u8d85\u51fa\u9650\u5236\uff01\u7533\u8bf7\u9000\u836f\u6570\u91cf\uff1a%s\uff0c\u5141\u8bb8\u9000\u836f\u6570\u91cf\uff1a%s\uff0c\u4f4f\u9662\u836f\u7269\u7533\u9886\u4e3b\u952eID\uff1a%s\u3002", backNum, allowBackNum.stripTrailingZeros().toPlainString(), inpatOrderDrugId);
            ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"500", (String)errorInfo);
        }
        if (backNum.compareTo(applyNum) > 0) {
            String errorInfo = String.format("\u7533\u8bf7\u9000\u836f\u65f6\uff0c\u9000\u836f\u6570\u91cf\u8d85\u51fa\u9650\u5236\uff01\u7533\u8bf7\u9000\u836f\u6570\u91cf\uff1a%s\uff0c\u5141\u8bb8\u9000\u836f\u6570\u91cf\uff1a%s\uff0c\u4f4f\u9662\u836f\u7269\u7533\u9886\u4e3b\u952eID\uff1a%s\u3002", backNum, applyNum.stripTrailingZeros().stripTrailingZeros(), inpatOrderDrugId);
            ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"500", (String)errorInfo);
        }
        InpatOrderDrugEntity backOrderDrug = new InpatOrderDrugEntity();
        BeanUtil.copy((Object)inpatOrderDrug, (Object)backOrderDrug);
        Integer operatorId = dto.getOperatorId();
        String operatorName = dto.getOperatorName();
        backOrderDrug.setCreateId(operatorId);
        backOrderDrug.setCreateName(operatorName);
        backOrderDrug.setCreateTime(new Date());
        backOrderDrug.setApplyBackNum(backNum);
        BigDecimal drugPrice = backOrderDrug.getDrugPrice();
        BigDecimal backAmount = drugPrice != null ? backNum.multiply(drugPrice) : BigDecimal.ZERO;
        backOrderDrug.setDrugAmount(backAmount);
        backOrderDrug.setBackReason(dto.getBackReason());
        backOrderDrug.setStatusCode(ApplyStatusEnum.PENDING_RETURN_MEDICATION.getValue());
        backOrderDrug.setStatusName(ApplyStatusEnum.PENDING_RETURN_MEDICATION.getLabel());
        backOrderDrug.setApplyTypeCode(ApplyTypeEnum.RETURN_MEDICINE.getValue());
        backOrderDrug.setApplyTypeName(ApplyTypeEnum.RETURN_MEDICINE.getLabel());
        backOrderDrug.setBackOrderDrugId(inpatOrderDrugId);
        backOrderDrug.setId(null);
        backOrderDrug.setApplyDispenseBackTime(new Date());
        this.inpatOrderDrugMapper.insert((Object)backOrderDrug);
    }

    @Transactional(rollbackFor={BusinessException.class})
    public void cancelApplyDispense(CancelApplyDispenseDto dto) {
        Integer inpatOrderDrugId = dto.getInpatOrderDrug();
        Integer tenantId = dto.getTenantId();
        LambdaQueryWrapper inpatOrderDrugWrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)inpatOrderDrugWrapper.eq(tenantId != null, InpatOrderDrugEntity::getTenantId, (Object)tenantId)).eq(InpatOrderDrugEntity::getId, (Object)inpatOrderDrugId);
        InpatOrderDrugEntity inpatOrderDrug = (InpatOrderDrugEntity)this.inpatOrderDrugMapper.selectOne((Wrapper)inpatOrderDrugWrapper);
        if (inpatOrderDrug == null) {
            ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"500", (String)"\u53d6\u6d88\u4f4f\u9662\u6446\u836f\u65f6\uff0c\u6839\u636e\u4f4f\u9662\u836f\u7269\u7533\u9886\u4e3b\u952eID\uff0c\u6ca1\u6709\u67e5\u8be2\u5230\u5bf9\u5e94\u7684\u836f\u7269\u7533\u9886\u8bb0\u5f55\uff01");
        }
        if (!ApplyStatusEnum.PRIMED_MEDICINE.getValue().equals(inpatOrderDrug.getStatusCode())) {
            String errorInfo = String.format("\u53d6\u6d88\u4f4f\u9662\u6446\u836f\u65f6\uff0c\u72b6\u6001\u7f16\u7801\u9519\u8bef\uff01\u5e94\u4e3a\uff1a%s\uff0c\u5b9e\u9645\u4e3a\uff1a%s\uff0c\u836f\u7269\u7533\u9886\u4e3b\u952eID\uff1a%s\u3002", ApplyStatusEnum.PRIMED_MEDICINE.getLabel(), inpatOrderDrug.getStatusName(), inpatOrderDrugId);
            ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"500", (String)errorInfo);
        }
        this.inpatOrderDrugMapper.deleteById((Serializable)inpatOrderDrug.getId());
    }

    @Transactional(rollbackFor={BusinessException.class})
    public void applyDispense(List<InpatOrderDrugEntity> list, Integer tenantId, Integer userId, String userName) {
        if (list.isEmpty()) {
            ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"500", (String)"\u7533\u8bf7\u6446\u836f\u65f6\uff0c\u4f20\u9012\u7684\u96c6\u5408\u4e0d\u53ef\u4e3a\u7a7a\uff01");
        }
        StringBuilder execErrorInfoBuilder = new StringBuilder();
        list.stream().filter(entity -> !ProjectDetailsStatusEnum.PENDING_EXECUTION.getValue().equals(entity.getExecStatusValue())).forEach(entity -> execErrorInfoBuilder.append(String.format("\uff08%s\uff09%s\uff0c\u72b6\u6001\u5f02\u5e38\uff0c\u5e94\u4e3a\uff1a%s\uff0c\u5b9e\u9645\u4e3a\uff1a%s\u3002", entity.getPatientName(), entity.getDrugName(), ProjectDetailsStatusEnum.PENDING_EXECUTION.getDesc(), entity.getExecStatusLabel())));
        String execErrorInfo = execErrorInfoBuilder.toString();
        if (StrUtil.isNotEmpty((CharSequence)execErrorInfo)) {
            execErrorInfo = "\u4ee5\u4e0b\u60a3\u8005\u72b6\u6001\u5f02\u5e38\uff1a" + execErrorInfo;
            ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"500", (String)execErrorInfo);
        }
        StringBuilder applyErrorInfoBuilder = new StringBuilder();
        list.stream().filter(entity -> StrUtil.isNotEmpty((CharSequence)entity.getDispenseStatusValue())).forEach(entity -> applyErrorInfoBuilder.append(String.format("\uff08%s\uff09%s\uff0c\u72b6\u6001\u5f02\u5e38\uff0c\u5e94\u4e3a\uff1a%s\uff0c\u5b9e\u9645\u4e3a\uff1a%s\u3002", entity.getPatientName(), entity.getDrugName(), "\u5f85\u7533\u9886", entity.getDispenseStatusLabel())));
        String applyErrorInfo = applyErrorInfoBuilder.toString();
        if (StrUtil.isNotEmpty((CharSequence)applyErrorInfo)) {
            applyErrorInfo = "\u4ee5\u4e0b\u60a3\u8005\u72b6\u6001\u5f02\u5e38\uff1a" + applyErrorInfo;
            ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"500", (String)applyErrorInfo);
        }
        for (InpatOrderDrugEntity entity2 : list) {
            this.checkRequiredField(entity2, Integer.valueOf(1));
        }
        List prescNos = list.stream().map(InpatOrderDrugEntity::getPrescriptionNo).collect(Collectors.toList());
        LambdaQueryWrapper orderDrugQueryWrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)orderDrugQueryWrapper.eq(tenantId != null, InpatOrderDrugEntity::getTenantId, (Object)tenantId)).in(InpatOrderDrugEntity::getPrescriptionNo, prescNos);
        List orderDrugList = this.inpatOrderDrugMapper.selectList((Wrapper)orderDrugQueryWrapper);
        Map<String, List<InpatOrderDrugEntity>> orderDrugMap = orderDrugList.stream().collect(Collectors.groupingBy(entity -> entity.getPrescriptionNo() + entity.getDrugNo() + entity.getDrugSpec() + entity.getApplyBackNum() + entity.getApplyBackUnit()));
        Map errorMap = list.stream().filter(entity -> {
            String key = entity.getPrescriptionNo() + entity.getDrugNo() + entity.getDrugSpec() + entity.getApplyBackNum() + entity.getApplyBackUnit();
            return orderDrugMap.containsKey(key);
        }).collect(Collectors.toMap(entity -> entity.getPrescriptionNo() + "\uff1a" + entity.getDrugName(), InpatOrderDrugEntity::getPatientName, (existing, replacement) -> existing, LinkedHashMap::new));
        if (!errorMap.isEmpty()) {
            String errorInfo = errorMap.entrySet().stream().map(entry -> "\uff08" + (String)entry.getValue() + "\uff09" + (String)entry.getKey()).collect(Collectors.joining("\uff0c", "\u4ee5\u4e0b\u60a3\u8005\u5df2\u63d0\u4ea4\u8fc7\u6446\u836f\u7533\u8bf7\uff0c\u5904\u65b9\u53f7\uff1a", ""));
            ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"500", (String)errorInfo);
        }
        for (InpatOrderDrugEntity entity3 : list) {
            entity3.setTenantId(tenantId);
            entity3.setCreateId(userId);
            entity3.setCreateName(userName);
            entity3.setApplyTypeCode(ApplyTypeEnum.DISPENSE_MEDICINE.getValue());
            entity3.setApplyTypeName(ApplyTypeEnum.DISPENSE_MEDICINE.getLabel());
            entity3.setStatusCode(ApplyStatusEnum.PRIMED_MEDICINE.getValue());
            entity3.setStatusName(ApplyStatusEnum.PRIMED_MEDICINE.getLabel());
            entity3.setApplyDispenseBackTime(new Date());
        }
        this.inpatOrderDrugMapper.insertList(list);
    }

    private void checkRequiredField(InpatOrderDrugEntity entity, Integer operaFlag) {
        BigDecimal drugAmount;
        BigDecimal applyBackNum;
        BigDecimal drugPrice;
        String prescNo = entity.getPrescriptionNo();
        if (StrUtil.isEmpty((CharSequence)prescNo)) {
            ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"500", (String)"\u7533\u8bf7\u6446\u836f\u65f6\uff0c\u5904\u65b9\u53f7\u4e0d\u53ef\u4e3a\u7a7a\uff01");
        }
        if (StrUtil.isEmpty((CharSequence)entity.getInpatNo()) && operaFlag == 1) {
            ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"500", (String)("\u7533\u8bf7\u6446\u836f\u65f6\uff0c\u4f4f\u9662\u53f7\u4e0d\u53ef\u4e3a\u7a7a\uff0c\u5904\u65b9\u53f7\uff1a" + prescNo));
        }
        if (entity.getDeptId() == null && operaFlag == 1) {
            ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"500", (String)("\u7533\u8bf7\u6446\u836f\u65f6\uff0c\uff08\u5f00\u7acb\uff09\u79d1\u5ba4\u7f16\u53f7\u4e0d\u53ef\u4e3a\u7a7a\uff0c\u5904\u65b9\u53f7\uff1a" + prescNo));
        }
        if (entity.getWardId() == null && operaFlag == 1) {
            ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"500", (String)("\u7533\u8bf7\u6446\u836f\u65f6\uff0c\uff08\u5f00\u7acb\uff09\u75c5\u533a\u7f16\u53f7\u4e0d\u53ef\u4e3a\u7a7a\uff0c\u5904\u65b9\u53f7\uff1a" + prescNo));
        }
        if (StrUtil.isEmpty((CharSequence)entity.getDrugNo()) && operaFlag == 1) {
            ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"500", (String)("\u7533\u8bf7\u6446\u836f\u65f6\uff0c\u836f\u54c1\u7f16\u53f7\u4e0d\u53ef\u4e3a\u7a7a\uff0c\u5904\u65b9\u53f7\uff1a" + prescNo));
        }
        if (((drugPrice = entity.getDrugPrice()) == null || drugPrice.compareTo(BigDecimal.ZERO) == 0) && operaFlag == 1) {
            ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"500", (String)("\u7533\u8bf7\u6446\u836f\u65f6\uff0c\u836f\u54c1\u5355\u4ef7\u4e0d\u53ef\u4e3a\u7a7a\u6216\u4e3a0\uff0c\u5904\u65b9\u53f7\uff1a" + prescNo));
        }
        if (((applyBackNum = entity.getApplyBackNum()) == null || applyBackNum.compareTo(BigDecimal.ZERO) == 0) && operaFlag == 1) {
            ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"500", (String)("\u7533\u8bf7\u6446\u836f\u65f6\uff0c\u7533\u9886\u6570\u91cf\u4e0d\u53ef\u4e3a\u7a7a\u6216\u4e3a0\uff0c\u5904\u65b9\u53f7\uff1a" + prescNo));
        }
        if (((drugAmount = entity.getDrugAmount()) == null || drugAmount.compareTo(BigDecimal.ZERO) == 0) && operaFlag == 1) {
            ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"500", (String)("\u7533\u8bf7\u6446\u836f\u65f6\uff0c\u836f\u54c1\u91d1\u989d\u4e0d\u53ef\u4e3a\u7a7a\u6216\u4e3a0\uff0c\u5904\u65b9\u53f7\uff1a" + prescNo));
        }
        if (StrUtil.isEmpty((CharSequence)entity.getWarehouseId()) && operaFlag == 1) {
            ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"500", (String)("\u7533\u8bf7\u6446\u836f\u65f6\uff0c\u836f\u623f\u7f16\u53f7\u4e0d\u53ef\u4e3a\u7a7a\uff0c\u5904\u65b9\u53f7\uff1a" + prescNo));
        }
        if (StrUtil.isEmpty((CharSequence)entity.getLongTempFlag()) && operaFlag == 1) {
            ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"500", (String)("\u7533\u8bf7\u6446\u836f\u65f6\uff0c\u957f\u3001\u4e34\u671f\u6807\u5fd7\u4e0d\u53ef\u4e3a\u7a7a\uff0c\u5904\u65b9\u53f7\uff1a" + prescNo));
        }
    }

    public Page<GetApplyPageVo> selectApplyPageList(GetApplyPageDto dto) {
        String type = dto.getType();
        Page page = new Page((long)dto.getCurrent().intValue(), (long)dto.getSize().intValue());
        if ("1".equals(type)) {
            DoctorDeptVo doctorDeptVo = this.inpatOrderDrugMapper.selectDeptInfoByUserId(dto.getDoctorId());
            if (doctorDeptVo == null) {
                return page;
            }
            dto.setDeptId(doctorDeptVo.getDeptId());
        }
        List list = this.inpatOrderDrugMapper.selectApplyPageList(page, dto);
        page.setRecords(list);
        return page;
    }
}

