/*
 * Decompiled with CFR 0.152.
 */
package com.byh.inpatient.web.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.byh.inpatient.api.dto.order.SaveOrderDto;
import com.byh.inpatient.api.enums.InpatpatientDataStatusEnum;
import com.byh.inpatient.api.enums.OrderStatusEnum;
import com.byh.inpatient.api.enums.OrderTypeEnum;
import com.byh.inpatient.api.model.order.InpatOrder;
import com.byh.inpatient.data.repository.InpatOrderMapper;
import com.byh.inpatient.data.repository.InpatTreatmentDetailsMapper;
import com.byh.inpatient.data.repository.InpatTreatmentItemsMapper;
import com.byh.inpatient.web.mvc.exception.RunDisplayException;
import com.byh.inpatient.web.mvc.utils.UUIDUtils;
import com.byh.inpatient.web.service.InpatOrderService;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class InpatOrderServiceImpl
implements InpatOrderService {
    @Autowired
    private InpatOrderMapper inpatOrderMapper;
    @Autowired
    private InpatTreatmentDetailsMapper outTreatmentDetailsMapper;
    @Autowired
    private InpatTreatmentItemsMapper outTreatmentItemsMapper;
    private static Logger log = LoggerFactory.getLogger(InpatOrderServiceImpl.class);

    public void saveOrder(OrderTypeEnum orderTypeEnum, SaveOrderDto saveOrderDto) {
        log.debug("\u8ba2\u5355\u4fdd\u5b58 -->>\u7c7b\u578b:{}\u4f20\u53c2:{}", (Object)orderTypeEnum.getDesc(), (Object)JSON.toJSONString((Object)saveOrderDto));
        InpatOrder order = new InpatOrder();
        order.setOrderAmount(saveOrderDto.getOrderAmount());
        order.setActualOtherPayment(saveOrderDto.getActualOtherPayment());
        order.setAmount(order.getOrderAmount().add(order.getActualOtherPayment()));
        order.setTotalAmount(order.getAmount());
        order.setCreateId(saveOrderDto.getOperatorId());
        order.setTenantId(saveOrderDto.getTenantId());
        order.setInpatNo(saveOrderDto.getInpatNo());
        order.setOrderType(orderTypeEnum.getValue());
        order.setOrderEntryName(orderTypeEnum.getName());
        order.setPrescriptionNo(saveOrderDto.getPrescriptionNo());
        order.setStatus(InpatpatientDataStatusEnum.NORMAL.getValue());
        order.setPatientName(saveOrderDto.getPatientName());
        order.setMedicalRecordNo(saveOrderDto.getMedicalRecordNo());
        order.setOrderStatus(OrderStatusEnum.PAYMENT_PENDING.getValue());
        order.setRegTime(saveOrderDto.getRegTime());
        order.setPatientCardNo(saveOrderDto.getPatientCardNo());
        order.setCreateName(saveOrderDto.getCreateName());
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"status", (Object)InpatpatientDataStatusEnum.NORMAL.getValue());
        query.eq((Object)"prescription_no", (Object)saveOrderDto.getPrescriptionNo());
        InpatOrder outOrders = (InpatOrder)this.inpatOrderMapper.selectOne((Wrapper)query);
        if (outOrders == null) {
            log.debug("\u8ba2\u5355\u521b\u5efa-->\u65b0\u589e\u8ba2\u5355[\u5f00\u59cb]");
            String orderNo = UUIDUtils.getOrderNo();
            log.debug("\u8ba2\u5355\u521b\u5efa-->>\u751f\u6210\u7684\u8ba2\u5355\u7f16\u53f7:{}", (Object)orderNo);
            order.setOrderNo(orderNo);
            Integer size = this.inpatOrderMapper.insert((Object)order);
            if (size < 1) {
                throw new RunDisplayException("\u65b0\u589e\u8ba2\u5355\u5931\u8d25");
            }
        } else {
            log.debug("\u8ba2\u5355\u4fee\u6539-->>\u4fee\u6539\u7684\u7f16\u53f7:{}", (Object)outOrders.getId());
            order.setId(outOrders.getId());
            Integer size = this.inpatOrderMapper.updateById((Object)order);
            if (size < 1) {
                throw new RunDisplayException("\u4fee\u6539\u8ba2\u5355\u5931\u8d25");
            }
        }
    }

    public List<InpatOrder> getOrderListByPrescriptionNos(List<String> orderType, List<String> prescriptionNos) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.in((Object)"order_type", orderType);
        queryWrapper.in((Object)"prescription_no", prescriptionNos);
        queryWrapper.eq((Object)"status", (Object)InpatpatientDataStatusEnum.NORMAL.getValue());
        List outOrders = this.inpatOrderMapper.selectList((Wrapper)queryWrapper);
        return outOrders;
    }
}

