/*
 * Decompiled with CFR 0.152.
 */
package com.byh.inpatient.web.service.impl;

import cn.hutool.core.util.IdcardUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.byh.inpatient.api.exception.BusinessException;
import com.byh.inpatient.api.hsModel.InpatDiseinfoRequest;
import com.byh.inpatient.api.hsModel.InpatMdtrtinfoRequest;
import com.byh.inpatient.api.hsModel.InpatRegistRequest;
import com.byh.inpatient.api.hsModel.RegistrationEntity;
import com.byh.inpatient.api.model.InpatFee;
import com.byh.inpatient.api.model.InpatMedicalRecordDiag;
import com.byh.inpatient.api.model.InpatRegist;
import com.byh.inpatient.api.model.PatientEntity;
import com.byh.inpatient.api.model.dto.ApplyForInpatDTO;
import com.byh.inpatient.api.model.dto.ApplyForInpatListDTO;
import com.byh.inpatient.api.model.dto.InpatRegistDTO;
import com.byh.inpatient.api.model.dto.InpatRegistListDTO;
import com.byh.inpatient.api.model.dto.QueryInpatPageListDTO;
import com.byh.inpatient.api.model.vo.RegInfoByTranferVO;
import com.byh.inpatient.api.model.vo.WardBedAndDiagAndCardVO;
import com.byh.inpatient.api.outpatientModel.OutIcdItem;
import com.byh.inpatient.api.sysModel.request.SysDoctorDto;
import com.byh.inpatient.api.sysModel.respones.SysDoctorIdVo;
import com.byh.inpatient.api.util.BeanUtil;
import com.byh.inpatient.api.util.ResponseData;
import com.byh.inpatient.api.util.StringPinYinUtil;
import com.byh.inpatient.data.repository.InpatMedicalRecordDiagMapper;
import com.byh.inpatient.data.repository.InpatRegistMapper;
import com.byh.inpatient.web.feign.HsServiceFeign;
import com.byh.inpatient.web.feign.OutPatientServiceFeign;
import com.byh.inpatient.web.feign.SysServiceFeign;
import com.byh.inpatient.web.mvc.enums.InDeptStatus;
import com.byh.inpatient.web.mvc.enums.InHospEnum;
import com.byh.inpatient.web.mvc.enums.SignStatusEnum;
import com.byh.inpatient.web.mvc.redis.RedisInpatNoGenerator;
import com.byh.inpatient.web.mvc.utils.CommonRequest;
import com.byh.inpatient.web.service.IInpatFeeService;
import com.byh.inpatient.web.service.IInpatRegistService;
import com.byh.inpatient.web.service.impl.PatientServiceImpl;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class InpatRegistServiceImpl
extends ServiceImpl<InpatRegistMapper, InpatRegist>
implements IInpatRegistService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    RedisInpatNoGenerator redisInpatNoGenerator;
    @Autowired
    InpatRegistMapper inpatRegistMapper;
    @Autowired
    PatientServiceImpl patientService;
    @Autowired
    InpatMedicalRecordDiagMapper inpatMedicalRecordDiagMapper;
    @Autowired
    SysServiceFeign sysServiceFeign;
    @Autowired
    HsServiceFeign hsServiceFeign;
    @Autowired
    private IInpatFeeService inpatFeeService;
    @Autowired
    private OutPatientServiceFeign outPatientServiceFeign;
    @Autowired
    private CommonRequest commonRequest;

    public static String generateInpatNo() {
        AtomicLong counter = new AtomicLong(System.currentTimeMillis());
        long timestamp = System.currentTimeMillis();
        long uniqueId = counter.incrementAndGet();
        return String.format("%d%05d", timestamp, uniqueId % 100000L);
    }

    public InpatRegist doApplyForInpat(ApplyForInpatDTO param) {
        InpatRegist inpatRegist = this.inpatRegistMapper.selectByOutpatienId(param.getOutpatientNo());
        Assert.isNull((Object)inpatRegist, (String)"\u5df2\u7ecf\u6210\u529f\u529e\u7406\u4e86\u5165\u9662\u8bc1!");
        inpatRegist = new InpatRegist();
        BeanUtil.copy((Object)param, (Object)inpatRegist);
        inpatRegist.setSignStatus(SignStatusEnum.NOT_REGIST.signStatusCode);
        int insert = this.inpatRegistMapper.insert((Object)inpatRegist);
        Assert.isTrue((insert == 1 ? 1 : 0) != 0, (String)"\u529e\u7406\u5165\u9662\u8bc1\u5931\u8d25");
        return inpatRegist;
    }

    public Page<InpatRegist> selectApplyForInpatList(ApplyForInpatListDTO param) {
        Page page = new Page((long)param.getCurrent().intValue(), (long)param.getSize().intValue());
        this.inpatRegistMapper.selectApplyForInpatList(page, param.getSearchValue());
        return page;
    }

    @Transactional(rollbackFor={Exception.class})
    public InpatRegist doRegist(InpatRegistDTO param) {
        if ("01".equals(param.getCardTypeCode())) {
            Assert.isTrue((boolean)IdcardUtil.isValidCard((String)param.getCardNo()), (String)"\u8eab\u4efd\u8bc1\u53f7\u975e\u6cd5!");
        }
        String idCard = param.getCardNo().toUpperCase();
        Long count = this.inpatRegistMapper.selectCount((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(InpatRegist.class).eq(InpatRegist::getSignStatus, (Object)SignStatusEnum.HAVE_REGIST.signStatusCode)).eq(InpatRegist::getInHospCode, (Object)InHospEnum.IN_HOSPITAL.iohospCode)).eq(InpatRegist::getCardNo, (Object)idCard));
        Assert.isTrue((count == 0L ? 1 : 0) != 0, (String)"\u6b64\u60a3\u8005\u5c1a\u6709\u672a\u51fa\u9662\u8bb0\u5f55\uff0c\u65e0\u6cd5\u529e\u7406\u5165\u9662!");
        InpatRegist regist = (InpatRegist)this.inpatRegistMapper.selectOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(InpatRegist.class).eq(InpatRegist::getSignStatus, (Object)SignStatusEnum.NOT_REGIST.signStatusCode)).eq(InpatRegist::getCardNo, (Object)idCard)).eq(InpatRegist::getPatientName, (Object)param.getPatientName()));
        param.setCardNo(idCard);
        InpatRegist inpatRegist = new InpatRegist();
        BeanUtil.copy((Object)param, (Object)inpatRegist);
        inpatRegist.setSignStatus(SignStatusEnum.HAVE_REGIST.signStatusCode);
        inpatRegist.setInHospCode(InHospEnum.IN_HOSPITAL.iohospCode);
        inpatRegist.setInHospName(InHospEnum.IN_HOSPITAL.iohospName);
        inpatRegist.setInDeptStatusCode(InDeptStatus.NOT_IN_DEPT.inDeptStatusCode);
        inpatRegist.setInDeptStatusName(InDeptStatus.NOT_IN_DEPT.inDeptStatusName);
        Timestamp now = new Timestamp(System.currentTimeMillis());
        inpatRegist.setInHospTime((Date)now);
        inpatRegist.setInpatNo(this.redisInpatNoGenerator.generateInpatNo());
        inpatRegist.setPyCode(StringPinYinUtil.toFirstChar((String)inpatRegist.getPatientName()));
        if (ObjectUtil.isNotNull((Object)regist)) {
            inpatRegist.setId(regist.getId());
            this.inpatRegistMapper.updateById((Object)inpatRegist);
            return inpatRegist;
        }
        PatientEntity patientEntity = this.patientService.checkPatient(param);
        Assert.notNull((Object)patientEntity, (String)"\u60a3\u8005\u5efa\u6863\u5931\u8d25\uff01");
        inpatRegist.setMedicalRecordNo(patientEntity.getMedicalRecordNo());
        this.inpatRegistMapper.insert((Object)inpatRegist);
        if (param.getDiagnose() != null) {
            InpatMedicalRecordDiag diagnose = param.getDiagnose();
            diagnose.setInpatNo(inpatRegist.getInpatNo());
            diagnose.setIsMainDiag(Integer.valueOf(1));
            this.inpatMedicalRecordDiagMapper.insert((Object)diagnose);
        }
        if (!"1".equals(inpatRegist.getPatientType())) {
            InpatMdtrtinfoRequest inpatMdtrtinfoRequest = new InpatMdtrtinfoRequest();
            inpatMdtrtinfoRequest.setIpt_no(inpatRegist.getInpatNo());
            inpatMdtrtinfoRequest.setInsutype(param.getInsurTypeCode());
            inpatMdtrtinfoRequest.setPsn_no(param.getPsnNo());
            inpatMdtrtinfoRequest.setInsuplc_admdvs(param.getInsuplcAdmdvs());
            inpatMdtrtinfoRequest.setMdtrt_cert_no(param.getMdtrtCertNo());
            inpatMdtrtinfoRequest.setMdtrt_cert_type(param.getMdtrtCertType());
            inpatMdtrtinfoRequest.setMed_type("21");
            this.inusrInpatRegister(inpatMdtrtinfoRequest);
        }
        return inpatRegist;
    }

    public Page<InpatRegist> selectInpatRegistList(InpatRegistListDTO param) {
        Page page = new Page((long)param.getCurrent().intValue(), (long)param.getSize().intValue());
        this.inpatRegistMapper.selectInpatList(page, param);
        return page;
    }

    public InpatRegist selectByInpatNo(String inpatNo) {
        Assert.hasText((String)inpatNo, (String)"\u4f4f\u9662\u53f7\u4e0d\u80fd\u4e3a\u7a7a!");
        return this.inpatRegistMapper.selectByInpatNo(inpatNo);
    }

    public List<RegInfoByTranferVO> selectWaitIntoDept(Integer wardId) {
        Assert.notNull((Object)wardId, (String)"\u75c5\u533a\u7f16\u53f7\u4e0d\u53ef\u4e3a\u7a7a");
        return this.inpatRegistMapper.selectWaitIntoDept(wardId);
    }

    public List<WardBedAndDiagAndCardVO> selectListWithWardBedAndDiagAndCardStatus(Integer wardId, Integer deptId, String search) {
        return this.inpatRegistMapper.selectListWithWardBedAndDiagAndCardStatus(wardId, deptId, search);
    }

    public Integer toAnotherDepartment(InpatRegist inpatRegist) {
        Assert.notNull((Object)inpatRegist, (String)"\u767b\u8bb0\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)inpatRegist.getId(), (String)"\u4f4f\u9662\u767b\u8bb0\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)inpatRegist.getDeptId(), (String)"\u79d1\u5ba4\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)inpatRegist.getDeptName(), (String)"\u79d1\u5ba4\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)inpatRegist.getWardId(), (String)"\u75c5\u533a\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)inpatRegist.getWardName(), (String)"\u75c5\u533a\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        InpatRegist newInpatRegist = new InpatRegist();
        newInpatRegist.setId(inpatRegist.getId());
        newInpatRegist.setWardId(inpatRegist.getWardId());
        newInpatRegist.setWardName(inpatRegist.getWardName());
        newInpatRegist.setDeptId(inpatRegist.getDeptId());
        newInpatRegist.setDeptName(inpatRegist.getDeptName());
        int count = this.inpatRegistMapper.updateById((Object)newInpatRegist);
        Assert.isTrue((count == 1 ? 1 : 0) != 0, (String)"\u8f6c\u79d1\u5931\u8d25!");
        return 1;
    }

    public int doDeduction(Integer inpatRegId, BigDecimal totalAmount) {
        return this.doRefundOrDeductionRegistAmount(inpatRegId);
    }

    public ResponseData<String> updateAssessmentForm(InpatRegist param) {
        InpatRegist inpatRegist = this.inpatRegistMapper.selectByInpatNo(param.getInpatNo());
        if (null == inpatRegist) {
            return ResponseData.error((String)"\u8be5\u60a3\u8005\u672a\u5728\u9662");
        }
        inpatRegist.setInpatienNursingAssessmentForm(param.getInpatienNursingAssessmentForm());
        this.inpatRegistMapper.updateById((Object)inpatRegist);
        return ResponseData.success((String)"\u64cd\u4f5c\u6210\u529f", (Object)"\u64cd\u4f5c\u6210\u529f");
    }

    public int doRefundOrDeductionRegistAmount(Integer inpatRegId) {
        Assert.notNull((Object)inpatRegId, (String)"\u4f4f\u9662\u767b\u8bb0\u7f16\u53f7\u4e0d\u53ef\u4e3a\u7a7a!");
        ArrayList<Integer> registIdList = new ArrayList<Integer>();
        registIdList.add(inpatRegId);
        InpatRegist optionInpatRegist = (InpatRegist)this.inpatRegistMapper.selectOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().in(InpatRegist::getId, registIdList)).in(InpatRegist::getInDeptStatusCode, Arrays.asList(Integer.parseInt(InDeptStatus.NOT_IN_DEPT.inDeptStatusCode), Integer.parseInt(InDeptStatus.IN_DEPT.inDeptStatusCode))));
        BigDecimal totTallyAmount = this.inpatFeeService.selectAmount((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().in(InpatFee::getInpatRegId, registIdList)).isNull(InpatFee::getPayOrderNo));
        BigDecimal totBalanceAmount = optionInpatRegist.getTotPrepaymentAmount().add(optionInpatRegist.getTotGuarantyAmount()).subtract(totTallyAmount);
        int updateCount = ((InpatRegistMapper)this.baseMapper).update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().set(InpatRegist::getTotTallyAmount, (Object)totTallyAmount)).set(InpatRegist::getTotBalanceAmount, (Object)totBalanceAmount)).set(InpatRegist::getUpdateTime, (Object)new Date())).eq(InpatRegist::getId, (Object)inpatRegId));
        Assert.isTrue((updateCount > 0 ? 1 : 0) != 0, (String)"\u589e\u52a0\u4f4f\u9662\u767b\u8bb0\u603b\u8d39\u7528\u4f59\u989d\u5931\u8d25!");
        return updateCount;
    }

    public Page<InpatRegist> queryInpatPageList(QueryInpatPageListDTO param) {
        Page pageParam = new Page();
        pageParam.setCurrent((long)param.getCurrent().intValue());
        pageParam.setSize((long)param.getSize().intValue());
        Assert.hasText((String)param.getInHospCode(), (String)"InHospCode \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        if ("3".equals(param.getInHospCode())) {
            return this.inpatRegistMapper.queryOutHospList(pageParam, param);
        }
        return this.inpatRegistMapper.queryInHospList(pageParam, param);
    }

    public List<Integer> selectBabyRegIdList(Integer motherRegId) {
        return ((InpatRegistMapper)this.baseMapper).selectBabyRegIdList(motherRegId);
    }

    public List<InpatRegist> selectBabyInfoList(Integer motherId) {
        return ((InpatRegistMapper)this.baseMapper).selectBabyInfoList(motherId);
    }

    public void inusrInpatRegister(InpatMdtrtinfoRequest inParam) {
        this.logger.info("******\u5165\u9662\u529e\u7406*****");
        this.logger.info("\u5165\u53c2{}", (Object)JSON.toJSONString((Object)inParam));
        StringBuilder strbMsg = new StringBuilder();
        if (StrUtil.isBlank((CharSequence)inParam.getIpt_no())) {
            strbMsg.append("\u4f4f\u9662ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StrUtil.isBlank((CharSequence)inParam.getPsn_no())) {
            strbMsg.append("\u4e2a\u4eba\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a;");
        }
        if (StrUtil.isBlank((CharSequence)inParam.getInsutype())) {
            strbMsg.append("\u9669\u79cd\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a;");
        }
        if (StrUtil.isBlank((CharSequence)inParam.getMed_type())) {
            strbMsg.append("\u533b\u7597\u7c7b\u522b\u4e0d\u80fd\u4e3a\u7a7a;");
        }
        if (strbMsg.length() > 1) {
            this.logger.info(String.valueOf(strbMsg));
            throw new BusinessException(String.valueOf(strbMsg));
        }
        RegistrationEntity registrationEntity = new RegistrationEntity();
        registrationEntity.setIpt_otp_no(inParam.getIpt_no());
        registrationEntity.setPsn_no(inParam.getPsn_no());
        registrationEntity.setMethod_code("2401");
        ResponseData listResponseData = this.hsServiceFeign.selectLogByMethondCode(registrationEntity);
        if (listResponseData.getData() != null && !((List)listResponseData.getData()).isEmpty()) {
            this.logger.info("\u8be5\u60a3\u8005\u5df2\u8fdb\u884c\u533b\u4fdd\u5165\u9662\u529e\u7406,\u8bf7\u786e\u8ba4");
            throw new BusinessException("\u8be5\u60a3\u8005\u5df2\u8fdb\u884c\u533b\u4fdd\u5165\u9662\u529e\u7406,\u8bf7\u786e\u8ba4");
        }
        InpatRegist inpatRegist = this.inpatRegistMapper.selectByInpatNo(inParam.getIpt_no());
        if (inpatRegist == null) {
            this.logger.info("\u672a\u83b7\u53d6\u8be5\u60a3\u8005\u5165\u9662\u767b\u8bb0\u4fe1\u606f,\u8bf7\u786e\u8ba4");
            throw new BusinessException("\u672a\u83b7\u53d6\u8be5\u60a3\u8005\u5165\u9662\u767b\u8bb0\u4fe1\u606f,\u8bf7\u786e\u8ba4");
        }
        SysDoctorDto sysDoctorDto = new SysDoctorDto();
        sysDoctorDto.setId(inpatRegist.getAdmitDoctorId() == null ? inpatRegist.getInpatDoctorId() : inpatRegist.getAdmitDoctorId());
        ResponseData newSysDoctorIdVoResponseData = this.sysServiceFeign.newDoctorById(sysDoctorDto);
        if (Objects.isNull(newSysDoctorIdVoResponseData) || !newSysDoctorIdVoResponseData.isSuccess()) {
            throw new BusinessException("\u67e5\u8be2\u533b\u751f\u4fe1\u606f\u5931\u8d25");
        }
        SysDoctorIdVo sysDoctorIdVo = (SysDoctorIdVo)JSON.parseObject((String)JSON.toJSONString((Object)newSysDoctorIdVoResponseData.getData()), SysDoctorIdVo.class);
        if (Objects.isNull(sysDoctorIdVo.getHsCode()) || sysDoctorIdVo.getHsCode().isEmpty()) {
            throw new BusinessException("\u67e5\u8be2\u533b\u751f\u8d2f\u6807\u7801\u5931\u8d25\uff0c\u8bf7\u5b8c\u5584\u533b\u751f\u4fe1\u606f\uff01");
        }
        inParam.setConer_name(inpatRegist.getContactName());
        inParam.setTel(inpatRegist.getContactTelNo());
        inParam.setBegntime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(inpatRegist.getInHospTime()));
        inParam.setAtddr_no(sysDoctorIdVo.getHsCode());
        inParam.setChfpdr_name(sysDoctorIdVo.getUserName());
        inParam.setMedrcdno(inpatRegist.getMedicalRecordNo());
        inParam.setAdm_diag_dscr("");
        inParam.setAdm_dept_codg(sysDoctorIdVo.getDepartmentId());
        inParam.setAdm_dept_name(sysDoctorIdVo.getDepartmentName());
        InpatMedicalRecordDiag inpatMedicalRecordDiag = (InpatMedicalRecordDiag)this.inpatMedicalRecordDiagMapper.selectOne((Wrapper)Wrappers.lambdaQuery().eq(InpatMedicalRecordDiag::getInpatNo, (Object)inpatRegist.getInpatNo()));
        if (inpatMedicalRecordDiag == null || inpatMedicalRecordDiag.getDiagCode().isEmpty()) {
            throw new BusinessException("\u5165\u9662\u8bca\u65ad\u4e3a\u7a7a\uff01");
        }
        ArrayList<String> icdCodes = new ArrayList<String>();
        icdCodes.add(inpatMedicalRecordDiag.getDiagCode());
        ResponseData queryIcdByCode = this.outPatientServiceFeign.queryIcdByCode(icdCodes, this.commonRequest.getTenant());
        if (queryIcdByCode.isError() || queryIcdByCode.getData() == null || ((List)queryIcdByCode.getData()).isEmpty()) {
            throw new BusinessException("\u672a\u80fd\u627e\u5230\u533b\u4fdd\u8bca\u65ad\u7f16\u7801\uff01");
        }
        inParam.setDscg_maindiag_code(((OutIcdItem)((List)queryIcdByCode.getData()).get(0)).getMedicalCode());
        inParam.setDscg_maindiag_name(((OutIcdItem)((List)queryIcdByCode.getData()).get(0)).getMedicalName());
        inParam.setMain_cond_dscr("");
        ArrayList<InpatDiseinfoRequest> diseInfoList = new ArrayList<InpatDiseinfoRequest>();
        InpatDiseinfoRequest diseInfo = new InpatDiseinfoRequest();
        diseInfo.setPsn_no(inParam.getPsn_no());
        String diagName = inpatMedicalRecordDiag.getDiagName().substring(inpatMedicalRecordDiag.getDiagName().length() - 1);
        if ("\u8bc1".equals(diagName)) {
            diseInfo.setDiag_type("3");
        } else {
            diseInfo.setDiag_type(inpatMedicalRecordDiag.getDiagnosticType() == 1 ? "2" : "1");
        }
        diseInfo.setMaindiag_flag("1");
        diseInfo.setDiag_srt_no(Integer.valueOf(1));
        diseInfo.setDiag_code(inParam.getDscg_maindiag_code());
        diseInfo.setDiag_name(inParam.getDscg_maindiag_name());
        diseInfo.setAdm_cond("");
        diseInfo.setDiag_dept(sysDoctorIdVo.getDepartmentId());
        diseInfo.setDise_dor_no(sysDoctorIdVo.getHsCode());
        diseInfo.setDise_dor_name(sysDoctorIdVo.getUserName());
        diseInfo.setDiag_time(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(inpatRegist.getInHospTime()));
        diseInfoList.add(diseInfo);
        InpatRegistRequest inpatRegistRequest = new InpatRegistRequest();
        inpatRegistRequest.setMdtrtinfo(inParam);
        inpatRegistRequest.setDiseinfo(diseInfoList);
        inpatRegistRequest.setInsuplc_admdvs(inParam.getInsuplc_admdvs());
        inpatRegistRequest.setTenantId(this.commonRequest.getTenant());
        ResponseData insurRegistRes = this.hsServiceFeign.inpatRegist(inpatRegistRequest);
        if (insurRegistRes.isError()) {
            throw new BusinessException(insurRegistRes.getMsg());
        }
        String mdtrtId = (String)insurRegistRes.getData();
        this.logger.info("\u5165\u9662\u529e\u7406\u6210\u529f\uff01 mdtrtId\u4e3a\uff1a{}", (Object)mdtrtId);
    }
}

