/*
 * Decompiled with CFR 0.152.
 */
package com.byh.inpatient.web.service.impl;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.byh.inpatient.api.enums.InpatSettleTypeEnum;
import com.byh.inpatient.api.enums.SettleFeeStatus;
import com.byh.inpatient.api.exception.BusinessException;
import com.byh.inpatient.api.hsModel.InpatFeeDetailUploadRequest;
import com.byh.inpatient.api.hsModel.InpatPreSettleRequest;
import com.byh.inpatient.api.hsModel.PaymentResponse;
import com.byh.inpatient.api.hsModel.RegistrationEntity;
import com.byh.inpatient.api.model.InpatFee;
import com.byh.inpatient.api.model.InpatPrepay;
import com.byh.inpatient.api.model.InpatRegist;
import com.byh.inpatient.api.model.InpatSettle;
import com.byh.inpatient.api.model.InpatSettleFee;
import com.byh.inpatient.api.model.dto.InpatSettleDTO;
import com.byh.inpatient.api.model.dto.InsurPreSettleDTO;
import com.byh.inpatient.api.util.ResponseData;
import com.byh.inpatient.api.util.UUIDUtils;
import com.byh.inpatient.data.repository.InpatSettleMapper;
import com.byh.inpatient.web.feign.HsServiceFeign;
import com.byh.inpatient.web.mvc.enums.InHospEnum;
import com.byh.inpatient.web.mvc.enums.InpatDeptTransferStatus;
import com.byh.inpatient.web.mvc.utils.CommonRequest;
import com.byh.inpatient.web.service.IInpatFeeService;
import com.byh.inpatient.web.service.IInpatPrepayService;
import com.byh.inpatient.web.service.IInpatRegistService;
import com.byh.inpatient.web.service.IInpatSettleFeeService;
import com.byh.inpatient.web.service.IInpatSettleService;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class InpatSettleServiceImpl
extends ServiceImpl<InpatSettleMapper, InpatSettle>
implements IInpatSettleService {
    private static final Logger log = LoggerFactory.getLogger(InpatSettleServiceImpl.class);
    @Autowired
    IInpatRegistService iInpatRegistService;
    @Autowired
    IInpatPrepayService iInpatPrepayService;
    @Autowired
    IInpatFeeService inpatFeeService;
    @Autowired
    IInpatSettleFeeService iInpatSettleFeeService;
    @Autowired
    HsServiceFeign hsServiceFeign;
    @Autowired
    CommonRequest commonRequest;

    @Transactional(rollbackFor={Exception.class})
    public InpatSettle doSettle(InpatSettleDTO param) {
        List babyInpatRegistList;
        Assert.notNull((Object)param.getInpatRegId(), (String)"\u60a3\u8005\u4f4f\u9662\u767b\u8bb0\u53f7\u4e0d\u53ef\u4e3a\u7a7a");
        Assert.notNull((Object)param.getSettleTypeCode(), (String)"\u7ed3\u7b97\u7c7b\u578b\u7f16\u7801\u4e0d\u53ef\u4e3a\u7a7a");
        Assert.isTrue((param.getTotalAmount() != null && param.getTotalAmount().compareTo(new BigDecimal(0)) >= 0 ? 1 : 0) != 0, (String)"\u60a3\u8005\u4f4f\u9662\u8d39\u7528\u4e0d\u53ef\u4e3a\u7a7a");
        InpatRegist inpatRegist = (InpatRegist)this.iInpatRegistService.getById((Serializable)param.getInpatRegId());
        Assert.notNull((Object)inpatRegist, (String)"\u672a\u627e\u5230\u60a3\u8005\u4f4f\u9662\u767b\u8bb0\u4fe1\u606f");
        Assert.isTrue((boolean)InHospEnum.IN_HOSPITAL.iohospCode.equals(inpatRegist.getInHospCode()), (String)"\u60a3\u8005\u51fa\u5165\u9662\u72b6\u6001\u4e0d\u662f\u5165\u9662");
        Assert.isTrue((boolean)inpatRegist.getPatientName().equals(param.getPatientName()), (String)"\u4f4f\u9662\u767b\u8bb0\u4eba\u5458\u59d3\u540d\u4e0e\u51fa\u9662\u7ed3\u7b97\u4eba\u5458\u59d3\u540d\u4e0d\u540c\uff01\uff01\uff01");
        if (this.checkInpatSettle(SettleFeeStatus.SETTLE.statusCode, param.getInpatRegId()) > 0) {
            throw new BusinessException("\u5df2\u5b58\u5728\u7ed3\u7b97\u4fe1\u606f");
        }
        ArrayList<InpatRegist> inpatRegistList = new ArrayList<InpatRegist>();
        inpatRegistList.add(inpatRegist);
        if (param.getBabyTogetherSettle() != null && 1 == param.getBabyTogetherSettle() && (babyInpatRegistList = this.iInpatRegistService.list((Wrapper)Wrappers.lambdaQuery().eq(InpatRegist::getMotherRegId, (Object)inpatRegist.getId()))) != null && !babyInpatRegistList.isEmpty()) {
            inpatRegistList.addAll(babyInpatRegistList);
        }
        List inpatRegistIdList = inpatRegistList.stream().map(InpatRegist::getId).collect(Collectors.toList());
        String payOrderNo = UUIDUtils.getOutHospPayOrderNo();
        List inpatPrepayList = this.iInpatPrepayService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().in(InpatPrepay::getInpatRegId, inpatRegistIdList)).isNull(InpatPrepay::getSettleNo));
        for (InpatPrepay prepay : inpatPrepayList) {
            prepay.setSettleNo(payOrderNo);
            if (!this.iInpatPrepayService.updateById((Object)prepay)) continue;
            throw new BusinessException("\u66f4\u65b0\u4f4f\u9662\u60a3\u8005\u9884\u4ea4\u6b3e\u4fe1\u606f\u5931\u8d25");
        }
        if (InpatSettleTypeEnum.OUT_HOSP_SETTLE.getCode().equals(param.getSettleTypeCode())) {
            for (Integer registId : inpatRegistIdList) {
                InpatRegist regist = (InpatRegist)this.iInpatRegistService.getById((Serializable)registId);
                Assert.isTrue((boolean)InpatDeptTransferStatus.DISCHARGED.getStatusCode().equals(regist.getInDeptStatusCode()), (String)"\u60a3\u8005\u60a3\u8005\u79d1\u5ba4\u7684\u72b6\u6001\u72b6\u6001\u4e0d\u662f\u5df2\u51fa\u9662");
                InpatRegist itemInpatR = new InpatRegist();
                itemInpatR.setId(registId);
                itemInpatR.setInHospCode(InHospEnum.DISCHARGED_HOSPITAL.iohospCode);
                itemInpatR.setInHospName(InHospEnum.DISCHARGED_HOSPITAL.iohospName);
                this.iInpatRegistService.updateById((Object)itemInpatR);
            }
        }
        LambdaQueryWrapper inpatFeeWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().in(InpatFee::getInpatRegId, inpatRegistIdList)).isNull(InpatFee::getPayOrderNo);
        BigDecimal settleFee = this.inpatFeeService.selectAmount((Wrapper)inpatFeeWrapper);
        Assert.isTrue((param.getTotalAmount().compareTo(settleFee) == 0 ? 1 : 0) != 0, (String)"\u5b9e\u9645\u8d39\u7528\u91d1\u989d\u4e0e\u754c\u9762\u91d1\u989d\u4e0d\u7b26\u5408");
        if (param.getRecvBackCode() == 0) {
            Assert.isTrue((settleFee.subtract(inpatRegist.getTotPrepaymentAmount()).compareTo(param.getRecvBackAmount()) == 0 ? 1 : 0) != 0, (String)"\u5b9e\u9645\u6536\u6b3e\u91d1\u989d\u6709\u8bef\uff01");
        } else {
            Assert.isTrue((inpatRegist.getTotPrepaymentAmount().subtract(settleFee).compareTo(param.getRecvBackAmount()) == 0 ? 1 : 0) != 0, (String)"\u5b9e\u9645\u9000\u6b3e\u91d1\u989d\u6709\u8bef\uff01");
        }
        Date settleTime = new Date();
        InpatSettle inpatSettle = new InpatSettle();
        inpatSettle.setInpatRegId(param.getInpatRegId());
        inpatSettle.setInpatNo(inpatRegist.getInpatNo());
        inpatSettle.setPatientName(inpatRegist.getPatientName());
        inpatSettle.setPayOrderNo(payOrderNo);
        inpatSettle.setSettleTime(settleTime);
        inpatSettle.setTotalAmount(param.getTotalAmount());
        inpatSettle.setTotalInsurAmount(param.getTotalInsurAmount());
        inpatSettle.setTotalPrepayAmount(param.getTotalPrepayAmount());
        inpatSettle.setRecvBackAmount(param.getRecvBackAmount());
        inpatSettle.setBabyTogetherSettle(param.getBabyTogetherSettle());
        inpatSettle.setIsOwed(param.getIsOwed());
        inpatSettle.setRecvBackCode(param.getRecvBackCode());
        inpatSettle.setRecvBackName(param.getRecvBackName());
        inpatSettle.setPaymentTransactionNo(param.getPaymentTransactionNo());
        inpatSettle.setSettleTypeCode(param.getSettleTypeCode());
        inpatSettle.setSettleTypeName(param.getSettleTypeName());
        inpatSettle.setPaymentTypeCode(param.getPaymentTypeCode());
        inpatSettle.setPaymentTypeName(param.getPaymentTypeName());
        inpatSettle.setPaymentTypeFlag(param.getPaymentTypeFlag());
        inpatSettle.setStatusCode(SettleFeeStatus.SETTLE.statusCode);
        inpatSettle.setStatusName(SettleFeeStatus.SETTLE.statusName);
        inpatSettle.setSettlePersonId(this.commonRequest.getUserId());
        inpatSettle.setSettlePersonName(this.commonRequest.getUserName());
        ((InpatSettleMapper)this.baseMapper).insert((Object)inpatSettle);
        long count = this.inpatFeeService.count((Wrapper)inpatFeeWrapper);
        List inpatFeeList = new ArrayList();
        if (count > 30000L) {
            long l = count / 29999L + 1L;
            int i = 1;
            while ((long)i <= l) {
                Page page = new Page((long)i, 29999L);
                Page inpatFeePage = (Page)this.inpatFeeService.page((IPage)page, (Wrapper)inpatFeeWrapper);
                List rows = inpatFeePage.getRecords();
                inpatFeeList.addAll(rows);
                ++i;
            }
        } else {
            inpatFeeList = this.inpatFeeService.list((Wrapper)inpatFeeWrapper);
        }
        this.inpatFeeService.updateSettleInfoByInpatRegId(inpatRegistIdList, inpatFeeList, inpatSettle);
        for (InpatFee inpatFee : inpatFeeList) {
            InpatSettleFee inpatSettleFee = new InpatSettleFee();
            inpatSettleFee.setInpatSettleId(inpatSettle.getId());
            inpatSettleFee.setInpatFeeId(inpatFee.getId());
            inpatSettleFee.setStatusCode(SettleFeeStatus.SETTLE.statusCode);
            inpatSettleFee.setStatusName(SettleFeeStatus.SETTLE.statusName);
            inpatSettleFee.setSettleTime(settleTime);
            this.iInpatSettleFeeService.save((Object)inpatSettleFee);
        }
        return inpatSettle;
    }

    public PaymentResponse doInsurPreSettle(InsurPreSettleDTO inParam) {
        Assert.notNull((Object)inParam.getInpatRegId(), (String)"\u60a3\u8005\u4f4f\u9662\u767b\u8bb0\u53f7\u4e0d\u53ef\u4e3a\u7a7a");
        Assert.notNull((Object)inParam.getSettleTypeCode(), (String)"\u7ed3\u7b97\u7c7b\u578b\u7f16\u7801\u4e0d\u53ef\u4e3a\u7a7a");
        Assert.isTrue((inParam.getTotalAmount() != null && inParam.getTotalAmount().compareTo(new BigDecimal(0)) >= 0 ? 1 : 0) != 0, (String)"\u60a3\u8005\u4f4f\u9662\u8d39\u7528\u4e0d\u53ef\u4e3a\u7a7a");
        Assert.notNull((Object)inParam.getInsurTypeCode(), (String)"\u9669\u79cd\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)inParam.getAcctUsedFlag(), (String)"\u8d26\u6237\u4f7f\u7528\u6807\u5fd7\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)inParam.getPsnSetlway(), (String)"\u4e2a\u4eba\u7ed3\u7b97\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a");
        InpatRegist inpatRegist = (InpatRegist)this.iInpatRegistService.getById((Serializable)inParam.getInpatRegId());
        Assert.notNull((Object)inpatRegist, (String)"\u672a\u627e\u5230\u60a3\u8005\u4f4f\u9662\u767b\u8bb0\u4fe1\u606f");
        RegistrationEntity registrationEntity = new RegistrationEntity();
        registrationEntity.setIpt_otp_no(inpatRegist.getInpatNo());
        registrationEntity.setMethod_code("2401");
        ResponseData listResponseData = this.hsServiceFeign.selectLogByMethondCode(registrationEntity);
        if (listResponseData.getData() == null || ((List)listResponseData.getData()).isEmpty()) {
            log.info("\u672a\u67e5\u8be2\u5230\u60a3\u8005\u533b\u4fdd\u5165\u9662\u529e\u7406,\u8bf7\u786e\u8ba4");
            throw new BusinessException("\u672a\u67e5\u8be2\u5230\u60a3\u8005\u533b\u4fdd\u5165\u9662\u529e\u7406,\u8bf7\u786e\u8ba4");
        }
        RegistrationEntity insurRegist = (RegistrationEntity)((List)listResponseData.getData()).get(0);
        String mdtrtId = insurRegist.getMdtrt_id();
        String psnNo = insurRegist.getPsn_no();
        if (!psnNo.equals(inParam.getPsnNo())) {
            log.error("\u5f53\u524d\u5361\u4eba\u5458\u4fe1\u606f\u4e0e\u533b\u4fdd\u767b\u8bb0\u4fe1\u606f\u4e0d\u7b26\uff0c\u8bf7\u6838\u5bf9");
            throw new BusinessException("\u5f53\u524d\u5361\u4eba\u5458\u4fe1\u606f\u4e0e\u533b\u4fdd\u767b\u8bb0\u4fe1\u606f\u4e0d\u7b26\uff0c\u8bf7\u6838\u5bf9");
        }
        registrationEntity = new RegistrationEntity();
        registrationEntity.setMethod_code("2304");
        registrationEntity.setMdtrt_id(mdtrtId);
        listResponseData = this.hsServiceFeign.selectLogByMethondCode(registrationEntity);
        if (listResponseData.getData() != null && !((List)listResponseData.getData()).isEmpty()) {
            log.info("\u60a3\u8005\u5df2\u8fdb\u884c\u533b\u4fdd\u7ed3\u7b97,\u4e0d\u80fd\u91cd\u590d\u7ed3\u7b97");
            throw new BusinessException("\u60a3\u8005\u5df2\u8fdb\u884c\u533b\u4fdd\u7ed3\u7b97,\u4e0d\u80fd\u91cd\u590d\u7ed3\u7b97");
        }
        registrationEntity = new RegistrationEntity();
        registrationEntity.setMethod_code("2301");
        registrationEntity.setMdtrt_id(mdtrtId);
        listResponseData = this.hsServiceFeign.selectLogByMethondCode(registrationEntity);
        if (listResponseData.getData() == null || ((List)listResponseData.getData()).isEmpty()) {
            log.info("\u8d39\u7528\u660e\u7ec6\u672a\u4e0a\u4f20\u65e0\u6cd5\u9884\u7ed3\u7b97\uff01");
            throw new BusinessException("\u8d39\u7528\u660e\u7ec6\u672a\u4e0a\u4f20\u65e0\u6cd5\u9884\u7ed3\u7b97\uff01");
        }
        insurRegist = (RegistrationEntity)((List)listResponseData.getData()).get(0);
        List inpatFeeDetailUploadRequests = JSON.parseArray((String)insurRegist.getParam(), InpatFeeDetailUploadRequest.class);
        BigDecimal feeUploadAmt = inpatFeeDetailUploadRequests.stream().map(InpatFeeDetailUploadRequest::getDet_item_fee_sumamt).reduce(BigDecimal.ZERO, BigDecimal::add);
        if (inParam.getTotalAmount().subtract(feeUploadAmt).abs().compareTo(new BigDecimal("1.00")) > 0) {
            log.error("\u4f4f\u9662\u8d39\u7528\u4e0a\u4f20\u5931\u8d25;\u4e0a\u4f20\u8d39\u7528\u4e0e\u603b\u8d39\u7528\u76f8\u5dee:" + inParam.getTotalAmount().subtract(feeUploadAmt) + ",\u8bf7\u786e\u8ba4;");
            throw new BusinessException("\u4f4f\u9662\u8d39\u7528\u4e0a\u4f20\u5931\u8d25;\u4e0a\u4f20\u8d39\u7528\u4e0e\u603b\u8d39\u7528\u76f8\u5dee:" + inParam.getTotalAmount().subtract(feeUploadAmt) + ",\u8bf7\u786e\u8ba4;");
        }
        InpatPreSettleRequest inpatPreSettleRequest = new InpatPreSettleRequest();
        inpatPreSettleRequest.setPsn_no(inParam.getPsnNo());
        inpatPreSettleRequest.setMdtrt_cert_type(inParam.getMdtrtCertType());
        inpatPreSettleRequest.setMdtrt_cert_no(inParam.getMdtrtCertNo());
        inpatPreSettleRequest.setMedfee_sumamt(inParam.getTotalAmount());
        inpatPreSettleRequest.setPsn_setlway(inParam.getPsnSetlway());
        inpatPreSettleRequest.setMdtrt_id(mdtrtId);
        inpatPreSettleRequest.setAcct_used_flag(inParam.getAcctUsedFlag());
        inpatPreSettleRequest.setInsutype(inParam.getInsurTypeCode());
        inpatPreSettleRequest.setInsuplc_admdvs(inParam.getInsuplcAdmdvs());
        String midSetlFlag = InpatSettleTypeEnum.OUT_HOSP_SETTLE.getCode().equals(inParam.getSettleTypeCode()) ? "0" : "1";
        inpatPreSettleRequest.setMid_setl_flag(midSetlFlag);
        inpatPreSettleRequest.setDscgTime(DateUtil.now());
        inpatPreSettleRequest.setSign_no(this.commonRequest.getSignNo());
        inpatPreSettleRequest.setTenantId(this.commonRequest.getTenant());
        inpatPreSettleRequest.setOpter(String.valueOf(this.commonRequest.getUserId()));
        inpatPreSettleRequest.setOpter_name(this.commonRequest.getUserName());
        inpatPreSettleRequest.setOpter_type("1");
        ResponseData preSettleRes = this.hsServiceFeign.inpatPreSettle(inpatPreSettleRequest);
        Assert.isTrue((boolean)preSettleRes.isSuccess(), (String)preSettleRes.getMsg());
        return (PaymentResponse)preSettleRes.getData();
    }

    public int checkInpatSettle(Integer statusCode, Integer inpatRegId) {
        return ((InpatSettleMapper)this.baseMapper).checkInpatSettle(statusCode, inpatRegId);
    }
}

