/*
 * Decompiled with CFR 0.152.
 */
package com.byh.nursingcarenewserver.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.ObjectUtils;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.byh.nursingcarenewserver.common.execption.BusinessException;
import com.byh.nursingcarenewserver.mapper.UserAddressMapper;
import com.byh.nursingcarenewserver.pojo.dto.DistanceDto;
import com.byh.nursingcarenewserver.pojo.dto.QueryUserAddressDto;
import com.byh.nursingcarenewserver.pojo.entity.HospitalConfig;
import com.byh.nursingcarenewserver.pojo.entity.UserAddress;
import com.byh.nursingcarenewserver.pojo.vo.SaveUserAddressVo;
import com.byh.nursingcarenewserver.pojo.vo.UpdateUserAddressVo;
import com.byh.nursingcarenewserver.service.HospitalConfigService;
import com.byh.nursingcarenewserver.service.UserAddressService;
import com.byh.nursingcarenewserver.service.impl.CartItemServiceImpl;
import com.byh.nursingcarenewserver.utils.DistanceUtil;
import com.byh.nursingcarenewserver.utils.UniqueKeyGenerator;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class UserAddressServiceImpl
extends ServiceImpl<UserAddressMapper, UserAddress>
implements UserAddressService {
    @Autowired
    private UserAddressMapper userAddressMapper;
    @Resource
    private CartItemServiceImpl cartItemServiceImpl;
    @Resource
    private HospitalConfigService hospitalConfigService;
    private static final String USER_ID = "user_id";
    private static final String IS_DEFAULT = "is_default";

    @Transactional(rollbackFor={Exception.class})
    public String saveUserAddress(SaveUserAddressVo saveUserAddressVo) {
        UserAddress userAddress;
        Integer noDefault = 0;
        UserAddress isDefault = (UserAddress)this.userAddressMapper.selectOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)IS_DEFAULT, (Object)1)).eq((Object)USER_ID, (Object)saveUserAddressVo.getUserId()));
        if (Objects.nonNull(isDefault) && Integer.valueOf(1).equals(saveUserAddressVo.getIsDefault())) {
            userAddress = new UserAddress();
            userAddress.setId(isDefault.getId());
            userAddress.setIsDefault(noDefault);
            this.userAddressMapper.updateById((Object)userAddress);
        }
        userAddress = new UserAddress();
        BeanUtils.copyProperties((Object)saveUserAddressVo, (Object)userAddress);
        userAddress.setViewId(UniqueKeyGenerator.generateViewId().toString());
        this.userAddressMapper.insert((Object)userAddress);
        return "\u5730\u5740\u6dfb\u52a0\u6210\u529f";
    }

    public List<QueryUserAddressDto> selectUserAddressByUserId(Long userId, Integer organId) {
        HospitalConfig hospitalConfig = (HospitalConfig)this.hospitalConfigService.getOne((Wrapper)new LambdaQueryWrapper().eq(HospitalConfig::getOrganId, (Object)organId));
        if (ObjectUtils.isEmpty((Object)hospitalConfig)) {
            throw new BusinessException("\u533b\u9662\u914d\u7f6e\u4e0d\u5b58\u5728");
        }
        ArrayList<QueryUserAddressDto> queryUserAddressDtoList = new ArrayList<QueryUserAddressDto>();
        List userAddressList = this.userAddressMapper.selectList((Wrapper)new QueryWrapper().eq((Object)USER_ID, (Object)userId));
        for (UserAddress userAddress : userAddressList) {
            QueryUserAddressDto queryUserAddressDto = new QueryUserAddressDto();
            BeanUtils.copyProperties((Object)userAddress, (Object)queryUserAddressDto);
            double distance = DistanceUtil.distance((double)userAddress.getLatitude(), (double)userAddress.getLongitude(), (double)Double.parseDouble(hospitalConfig.getHosLat()), (double)Double.parseDouble(hospitalConfig.getHosLng()));
            this.getIsDistributionAndAddrPrice(distance, queryUserAddressDto, organId);
            queryUserAddressDtoList.add(queryUserAddressDto);
        }
        return queryUserAddressDtoList;
    }

    public QueryUserAddressDto selectUserAddressByAddrId(Long addrId, Integer organId) {
        HospitalConfig hospitalConfig = (HospitalConfig)this.hospitalConfigService.getOne((Wrapper)new LambdaQueryWrapper().eq(HospitalConfig::getOrganId, (Object)organId));
        if (ObjectUtils.isEmpty((Object)hospitalConfig)) {
            throw new BusinessException("\u533b\u9662\u914d\u7f6e\u4e0d\u5b58\u5728");
        }
        UserAddress userAddress = (UserAddress)this.userAddressMapper.selectById((Serializable)addrId);
        if (Objects.isNull(userAddress)) {
            return null;
        }
        QueryUserAddressDto queryUserAddressDto = new QueryUserAddressDto();
        BeanUtils.copyProperties((Object)userAddress, (Object)queryUserAddressDto);
        double distance = DistanceUtil.distance((double)userAddress.getLatitude(), (double)userAddress.getLongitude(), (double)Double.parseDouble(hospitalConfig.getHosLat()), (double)Double.parseDouble(hospitalConfig.getHosLng()));
        this.getIsDistributionAndAddrPrice(distance, queryUserAddressDto, organId);
        return queryUserAddressDto;
    }

    public String deleteUserAddress(Long addrId) {
        this.userAddressMapper.delete((Wrapper)new QueryWrapper().eq((Object)"id", (Object)addrId));
        return "\u5730\u5740\u5220\u9664\u6210\u529f";
    }

    @Transactional(rollbackFor={Exception.class})
    public String updateUserAddressIsDefault(Long addrId, Long userId, Integer isDefault) {
        UserAddress address;
        int noDefault = 0;
        if (Integer.valueOf(1).equals(isDefault) && Objects.nonNull(address = (UserAddress)this.userAddressMapper.selectOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)IS_DEFAULT, (Object)1)).eq((Object)USER_ID, (Object)userId)))) {
            UserAddress userAddress = new UserAddress();
            userAddress.setId(address.getId());
            userAddress.setIsDefault(Integer.valueOf(noDefault));
            this.userAddressMapper.updateById((Object)userAddress);
        }
        UserAddress userAddress = new UserAddress();
        userAddress.setId(Integer.valueOf(addrId.intValue()));
        userAddress.setIsDefault(isDefault);
        this.userAddressMapper.updateById((Object)userAddress);
        return "\u5730\u5740\u4fee\u6539\u6210\u529f";
    }

    public String updateUserAddress(UpdateUserAddressVo updateUserAddressVo) {
        UserAddress address;
        int noDefault = 0;
        if (Integer.valueOf(1).equals(updateUserAddressVo.getIsDefault()) && Objects.nonNull(address = (UserAddress)this.userAddressMapper.selectOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)IS_DEFAULT, (Object)1)).eq((Object)USER_ID, (Object)updateUserAddressVo.getUserId())))) {
            UserAddress userAddress = new UserAddress();
            userAddress.setId(address.getId());
            userAddress.setIsDefault(Integer.valueOf(noDefault));
            this.userAddressMapper.updateById((Object)userAddress);
        }
        UserAddress userAddress = new UserAddress();
        BeanUtils.copyProperties((Object)updateUserAddressVo, (Object)userAddress);
        userAddress.setId(Integer.valueOf(updateUserAddressVo.getAddressId().intValue()));
        this.userAddressMapper.updateById((Object)userAddress);
        return "\u5730\u5740\u4fee\u6539\u6210\u529f";
    }

    public DistanceDto getDistancePrice(double lat, double log, Integer organId) {
        HospitalConfig hospitalConfig = (HospitalConfig)this.hospitalConfigService.getOne((Wrapper)new LambdaQueryWrapper().eq(HospitalConfig::getOrganId, (Object)organId));
        if (ObjectUtils.isEmpty((Object)hospitalConfig)) {
            throw new BusinessException("\u533b\u9662\u914d\u7f6e\u4e0d\u5b58\u5728");
        }
        DistanceDto distanceDto = new DistanceDto();
        double distance = DistanceUtil.distance((double)lat, (double)log, (double)Double.parseDouble(hospitalConfig.getHosLat()), (double)Double.parseDouble(hospitalConfig.getHosLng()));
        BigDecimal addrPrice = new BigDecimal("0");
        if (distance != 0.0) {
            Object[] objects = this.cartItemServiceImpl.getDisTypeAndPrice(distance, organId);
            distanceDto.setStatus(Integer.valueOf(String.valueOf(objects[0])));
            distanceDto.setDistancePrice(new BigDecimal(String.valueOf(objects[1])));
        }
        return distanceDto;
    }

    private void getIsDistributionAndAddrPrice(double distance, QueryUserAddressDto queryUserAddressDto, Integer organId) {
        Object[] objects = this.cartItemServiceImpl.getDisTypeAndPrice(distance, organId);
        queryUserAddressDto.setIsDistribution(Integer.valueOf(String.valueOf(objects[0])));
        queryUserAddressDto.setAddrPrice(new BigDecimal(String.valueOf(objects[1])));
    }
}

