/*
 * Decompiled with CFR 0.152.
 */
package com.byh.nursingcarenewserver.config;

import com.byh.nursingcarenewserver.config.HospitalConfig;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class GlobalConfig {
    private static final Logger log = LoggerFactory.getLogger(GlobalConfig.class);
    public static String configAppCodeStatic;
    @Value(value="${configs.appCode}")
    public String configAppCode;
    @Value(value="${configs.hosLat}")
    public Double hosLat;
    @Value(value="${configs.hosLng}")
    public Double hosLng;
    @Value(value="${configs.basTrip}")
    public int basTrip;
    @Value(value="${configs.tenKm}")
    public double tenKm;
    @Value(value="${configs.fiveKm}")
    public double fiveKm;

    @Value(value="${configs.appCode}")
    public void setConfigAppCodeStatic(String configAppCodeStatic) {
        GlobalConfig.configAppCodeStatic = configAppCodeStatic;
    }

    @PostConstruct
    public void init() {
        HospitalConfig.HOS_LAT = this.hosLat;
        HospitalConfig.HOS_LNG = this.hosLng;
        HospitalConfig.BAS_TRIP = this.basTrip;
        HospitalConfig.TEN_KM = this.tenKm;
        HospitalConfig.FIVE_KM = this.fiveKm;
        log.info("\u5bb9\u5668\u6ce8\u5165\u4e86\u914d\u7f6e\u9879\uff0c\u5982\u4e0b\uff1aappCode = {},Hos_lat = {},hos_lng = {}", new Object[]{configAppCodeStatic, this.hosLat, this.hosLng});
    }

    public String getConfigAppCode() {
        return this.configAppCode;
    }

    public Double getHosLat() {
        return this.hosLat;
    }

    public Double getHosLng() {
        return this.hosLng;
    }

    public int getBasTrip() {
        return this.basTrip;
    }

    public double getTenKm() {
        return this.tenKm;
    }

    public double getFiveKm() {
        return this.fiveKm;
    }

    public void setConfigAppCode(String configAppCode) {
        this.configAppCode = configAppCode;
    }

    public void setHosLat(Double hosLat) {
        this.hosLat = hosLat;
    }

    public void setHosLng(Double hosLng) {
        this.hosLng = hosLng;
    }

    public void setBasTrip(int basTrip) {
        this.basTrip = basTrip;
    }

    public void setTenKm(double tenKm) {
        this.tenKm = tenKm;
    }

    public void setFiveKm(double fiveKm) {
        this.fiveKm = fiveKm;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GlobalConfig)) {
            return false;
        }
        GlobalConfig other = (GlobalConfig)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$configAppCode = this.getConfigAppCode();
        String other$configAppCode = other.getConfigAppCode();
        if (this$configAppCode == null ? other$configAppCode != null : !this$configAppCode.equals(other$configAppCode)) {
            return false;
        }
        Double this$hosLat = this.getHosLat();
        Double other$hosLat = other.getHosLat();
        if (this$hosLat == null ? other$hosLat != null : !((Object)this$hosLat).equals(other$hosLat)) {
            return false;
        }
        Double this$hosLng = this.getHosLng();
        Double other$hosLng = other.getHosLng();
        if (this$hosLng == null ? other$hosLng != null : !((Object)this$hosLng).equals(other$hosLng)) {
            return false;
        }
        if (this.getBasTrip() != other.getBasTrip()) {
            return false;
        }
        if (Double.compare(this.getTenKm(), other.getTenKm()) != 0) {
            return false;
        }
        return Double.compare(this.getFiveKm(), other.getFiveKm()) == 0;
    }

    protected boolean canEqual(Object other) {
        return other instanceof GlobalConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $configAppCode = this.getConfigAppCode();
        result = result * 59 + ($configAppCode == null ? 43 : $configAppCode.hashCode());
        Double $hosLat = this.getHosLat();
        result = result * 59 + ($hosLat == null ? 43 : ((Object)$hosLat).hashCode());
        Double $hosLng = this.getHosLng();
        result = result * 59 + ($hosLng == null ? 43 : ((Object)$hosLng).hashCode());
        result = result * 59 + this.getBasTrip();
        long $tenKm = Double.doubleToLongBits(this.getTenKm());
        result = result * 59 + (int)($tenKm >>> 32 ^ $tenKm);
        long $fiveKm = Double.doubleToLongBits(this.getFiveKm());
        result = result * 59 + (int)($fiveKm >>> 32 ^ $fiveKm);
        return result;
    }

    public String toString() {
        return "GlobalConfig(configAppCode=" + this.getConfigAppCode() + ", hosLat=" + this.getHosLat() + ", hosLng=" + this.getHosLng() + ", basTrip=" + this.getBasTrip() + ", tenKm=" + this.getTenKm() + ", fiveKm=" + this.getFiveKm() + ")";
    }
}

