/*
 * Decompiled with CFR 0.152.
 */
package com.byh.nursingcarenewserver.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.byh.nursingcarenewserver.constant.ComponentConstant;
import com.byh.nursingcarenewserver.mapper.DoctorPoolMapper;
import com.byh.nursingcarenewserver.mapper.OrderMapper;
import com.byh.nursingcarenewserver.pojo.entity.DoctorPool;
import com.byh.nursingcarenewserver.pojo.entity.Orders;
import com.byh.nursingcarenewserver.pojo.enums.PayStatusEnum;
import com.byh.nursingcarenewserver.pojo.vo.PayCallbackVo;
import com.byh.nursingcarenewserver.pojo.vo.PayParamVo;
import com.byh.nursingcarenewserver.pojo.vo.RefundCallbackVo;
import com.byh.nursingcarenewserver.pojo.vo.RefundVo;
import com.byh.nursingcarenewserver.service.AppWebPushService;
import com.byh.nursingcarenewserver.service.GoEasyPushService;
import com.byh.nursingcarenewserver.service.PayService;
import com.byh.nursingcarenewserver.service.ProgramPushService;
import com.byh.nursingcarenewserver.service.SmsPushService;
import com.byh.nursingcarenewserver.utils.DateUtils;
import com.byh.nursingcarenewserver.utils.PushParamUtil;
import com.ebaiyihui.framework.response.BaseResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
@RequestMapping(value={"/api/v1/pay"})
@Api(tags={"\u652f\u4ed8\u7ba1\u7406API"})
public class PayController
extends BaseResponse {
    private static final Logger log = LoggerFactory.getLogger(PayController.class);
    @Autowired
    private PayService payService;
    @Autowired
    private ProgramPushService programPushService;
    @Autowired
    private AppWebPushService appWebPushService;
    @Autowired
    private DoctorPoolMapper doctorPoolMapper;
    @Autowired
    private SmsPushService smsPushService;
    @Autowired
    private OrderMapper orderMapper;
    @Autowired
    private GoEasyPushService goEasyPushService;
    ExecutorService executorService = Executors.newCachedThreadPool();

    @ApiOperation(value="\u652f\u4ed8")
    @PostMapping(value={"/pricePay"})
    public BaseResponse<JSONObject> pricePay(@RequestBody @Validated PayParamVo payParamVo) {
        BaseResponse result = this.payService.pricePay(payParamVo);
        return result;
    }

    @ApiOperation(value="\u652f\u4ed8\u56de\u8c03")
    @PostMapping(value={"/callback/payNotify"})
    public BaseResponse<String> payCallback(@RequestBody @Validated PayCallbackVo payCallbackVo) {
        Boolean flag = this.payService.payCallback(payCallbackVo);
        if (!flag.booleanValue()) {
            return PayController.success((Object)PayStatusEnum.FAIL.getValue());
        }
        this.executorService.execute(() -> {
            try {
                String date = DateUtils.getDate((Date)new Date());
                List doctorPoolList = this.doctorPoolMapper.selectList((Wrapper)new QueryWrapper().like((Object)"date_time", (Object)date));
                if (CollectionUtils.isNotEmpty((Collection)doctorPoolList)) {
                    for (DoctorPool doctorPool : doctorPoolList) {
                        String userId = PushParamUtil.getUserIdByDoctorId((Long)doctorPool.getDoctorId(), (String)doctorPool.getDoctorOrganId().toString());
                        this.appWebPushService.addAppointmentPush(userId, ComponentConstant.APP_CODE);
                    }
                }
            }
            catch (Exception e) {
                log.info("app\u63a8\u9001\uff0c\u62a2\u5355\u533a\u65b0\u589e\u4e00\u7b14\u5f85\u62a2\u8ba2\u5355\u9519\u8bef");
            }
            try {
                this.goEasyPushService.manageNewAppointmentPush(ComponentConstant.APP_CODE);
            }
            catch (Exception e) {
                log.info("\u7ba1\u7406\u7aef\u63a8\u9001 \u62a4\u7406\u9884\u7ea6\u5f85\u5ba1\u6838\u63d0\u9192\u9519\u8bef");
            }
        });
        return PayController.success((Object)PayStatusEnum.SUCCESS.getValue());
    }

    @ApiOperation(value="\u9000\u6b3e")
    @PostMapping(value={"/refund"})
    public BaseResponse<Object> refund(@RequestBody @Validated RefundVo refundVo) {
        Boolean flag = this.payService.refund(refundVo);
        if (flag.booleanValue()) {
            return PayController.success((Object)PayStatusEnum.SUCCESS.getValue());
        }
        return PayController.error((String)PayStatusEnum.FAIL.getValue());
    }

    @ApiOperation(value="\u9000\u6b3e\u56de\u8c03")
    @PostMapping(value={"/refundCallback"})
    public BaseResponse<String> refundCallback(@RequestBody RefundCallbackVo refundCallbackVo) {
        Boolean flag = this.payService.refundCallback(refundCallbackVo);
        if (flag.booleanValue()) {
            try {
                this.programPushService.refundPush(ComponentConstant.APP_CODE, refundCallbackVo.getOutTradeNo(), refundCallbackVo.getRefundMoney());
            }
            catch (Exception e) {
                log.info("\u9000\u6b3e\u5c0f\u7a0b\u5e8f\u63a8\u9001\u9519\u8bef");
            }
            try {
                Orders orders = (Orders)this.orderMapper.selectOne((Wrapper)new QueryWrapper().eq((Object)"view_id", (Object)refundCallbackVo.getOutTradeNo()));
                this.smsPushService.refundSmsPush(orders.getPatientPhone(), ComponentConstant.APP_CODE);
            }
            catch (Exception e) {
                log.info("\u9000\u6b3e\u77ed\u4fe1\u63a8\u9001\u9519\u8bef");
            }
            return PayController.success((Object)PayStatusEnum.SUCCESS.getValue());
        }
        return PayController.error((String)PayStatusEnum.FAIL.getValue());
    }
}

