/*
 * Decompiled with CFR 0.152.
 */
package com.byh.nursingcarenewserver.service.impl;

import com.alibaba.fastjson.JSON;
import com.byh.nursingcarenewserver.pojo.enums.ChannelCodeEnum;
import com.byh.nursingcarenewserver.pojo.req.UmPushMsgAndroidReqVO;
import com.byh.nursingcarenewserver.pojo.req.UmPushMsgIOSReqVo;
import com.byh.nursingcarenewserver.pojo.res.PushConfigurationDetailVO;
import com.byh.nursingcarenewserver.pojo.res.UserLastLoginDeviceRespVo;
import com.byh.nursingcarenewserver.service.AppWebPushService;
import com.byh.nursingcarenewserver.utils.AppWebPushUtil;
import com.byh.nursingcarenewserver.utils.PushParamUtil;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class AppWebPushServiceImpl
implements AppWebPushService {
    private static final Logger log = LoggerFactory.getLogger(AppWebPushServiceImpl.class);

    public void addAppointmentPush(String userId, String appCode) {
        PushConfigurationDetailVO pushConfig;
        UserLastLoginDeviceRespVo userLastLoginDeviceRespVo = PushParamUtil.getDocUserDeviceToken((String)userId, (Short)new Short("1"));
        if (userLastLoginDeviceRespVo == null || StringUtils.isEmpty((CharSequence)userLastLoginDeviceRespVo.getDeviceType())) {
            log.info("\u6ca1\u6709\u627e\u5230\u8be5\u7528\u6237\u7684\u8bbe\u5907\u53f7\uff0c\u4e0d\u6267\u884c\u63a8\u9001\u903b\u8f91");
            return;
        }
        if (userLastLoginDeviceRespVo.getDeviceType().equals(ChannelCodeEnum.IOS.getValue())) {
            pushConfig = PushParamUtil.getPushConfig((String)appCode, (String)"youmengPush", (String)"doctor", (String)"IOS");
            String msg = "\u60a8\u6709\u4e00\u7b14\u65b0\u7684\u62a4\u7406\u9884\u7ea6\u5355\u53ef\u62a2\u5355\uff0c\u8bf7\u53ca\u65f6\u5904\u7406";
            UmPushMsgIOSReqVo iosPush = new UmPushMsgIOSReqVo();
            iosPush.setBusiCode("HLZH_502");
            iosPush.setTitle("\u62a4\u7406\u62a2\u5355\u63d0\u9192");
            iosPush.setSubTitle("\u62a4\u7406\u62a2\u5355\u63d0\u9192");
            iosPush.setUserId(userId);
            iosPush.setUserType(Integer.valueOf(1));
            iosPush.setClientCode(pushConfig.getClientCode());
            iosPush.setDeviceTokens(userLastLoginDeviceRespVo.getDeviceNumber());
            iosPush.setDescription(msg);
            iosPush.setBody(msg);
            iosPush.setBusiStyle(msg);
            iosPush.setText(msg);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("pushCode", "502");
            map.put("content", msg);
            HashMap<String, String> custom = new HashMap<String, String>();
            custom.putAll(map);
            String customJsonString = JSON.toJSONString(custom);
            iosPush.setCustom(customJsonString);
            iosPush.setExtra(map);
            AppWebPushUtil.pushIOSMessage((UmPushMsgIOSReqVo)iosPush);
        }
        if (userLastLoginDeviceRespVo.getDeviceType().equals(ChannelCodeEnum.ANDROID.getValue())) {
            pushConfig = PushParamUtil.getPushConfig((String)appCode, (String)"youmengPush", (String)"doctor", (String)"Android");
            UmPushMsgAndroidReqVO androidPush = new UmPushMsgAndroidReqVO();
            androidPush.setBusiCode("HLZH_502");
            androidPush.setTitle("\u62a4\u7406\u62a2\u5355\u63d0\u9192");
            androidPush.setUserId(userId);
            androidPush.setClientCode(pushConfig.getClientCode());
            androidPush.setDeviceTokens(userLastLoginDeviceRespVo.getDeviceNumber());
            androidPush.setText("\u60a8\u6709\u4e00\u7b14\u65b0\u7684\u62a4\u7406\u9884\u7ea6\u5355\u53ef\u62a2\u5355\uff0c\u8bf7\u53ca\u65f6\u5904\u7406");
            androidPush.setDescription("\u60a8\u6709\u4e00\u7b14\u65b0\u7684\u62a4\u7406\u9884\u7ea6\u5355\u53ef\u62a2\u5355\uff0c\u8bf7\u53ca\u65f6\u5904\u7406");
            androidPush.setTicker("\u62a4\u7406\u62a2\u5355\u63d0\u9192");
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("pushCode", "502");
            androidPush.setExtra(map);
            AppWebPushUtil.pushAndroidMessage((UmPushMsgAndroidReqVO)androidPush);
        }
    }

    public void todayBeforeTwoPush(String appCode, String userId, String time) {
        PushConfigurationDetailVO pushConfig;
        UserLastLoginDeviceRespVo userLastLoginDeviceRespVo = PushParamUtil.getDocUserDeviceToken((String)userId, (Short)new Short("1"));
        if (userLastLoginDeviceRespVo == null || StringUtils.isEmpty((CharSequence)userLastLoginDeviceRespVo.getDeviceType())) {
            log.info("\u6ca1\u6709\u627e\u5230\u8be5\u7528\u6237\u7684\u8bbe\u5907\u53f7\uff0c\u4e0d\u6267\u884c\u63a8\u9001\u903b\u8f91");
            return;
        }
        if (userLastLoginDeviceRespVo.getDeviceType().equals(ChannelCodeEnum.IOS.getValue())) {
            pushConfig = PushParamUtil.getPushConfig((String)appCode, (String)"youmengPush", (String)"doctor", (String)"IOS");
            String msg = "\u6709\u4e00\u7b14\u62a4\u7406\u9884\u7ea6\u5355\u5f85\u670d\u52a1\uff0c\u8bf7\u53ca\u65f6\u5904\u7406";
            UmPushMsgIOSReqVo iosPush = new UmPushMsgIOSReqVo();
            iosPush.setBusiCode("HLZH_504");
            iosPush.setTitle("\u62a4\u7406\u5373\u5c06\u5f00\u59cb\u63d0\u9192");
            iosPush.setUserId(userId);
            iosPush.setUserType(Integer.valueOf(1));
            iosPush.setClientCode(pushConfig.getClientCode());
            iosPush.setDeviceTokens(userLastLoginDeviceRespVo.getDeviceNumber());
            iosPush.setSubTitle("\u62a4\u7406\u5373\u5c06\u5f00\u59cb\u63d0\u9192");
            iosPush.setDescription("\u60a8\u4eca\u5929" + time + msg);
            iosPush.setBody("\u60a8\u4eca\u5929" + time + msg);
            iosPush.setText(msg);
            iosPush.setBusiStyle("\u60a8\u4eca\u5929" + time + msg);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("pushCode", "504");
            map.put("content", msg);
            iosPush.setExtra(map);
            HashMap<String, String> custom = new HashMap<String, String>();
            custom.putAll(map);
            String customJsonString = JSON.toJSONString(custom);
            iosPush.setCustom(customJsonString);
            AppWebPushUtil.pushIOSMessage((UmPushMsgIOSReqVo)iosPush);
        }
        if (userLastLoginDeviceRespVo.getDeviceType().equals(ChannelCodeEnum.ANDROID.getValue())) {
            pushConfig = PushParamUtil.getPushConfig((String)appCode, (String)"youmengPush", (String)"doctor", (String)"Android");
            UmPushMsgAndroidReqVO androidPush = new UmPushMsgAndroidReqVO();
            androidPush.setBusiCode("HLZH_504");
            androidPush.setBusiStyle("\u62a4\u7406\u5373\u5c06\u5f00\u59cb\u63d0\u9192");
            androidPush.setTitle("\u62a4\u7406\u5373\u5c06\u5f00\u59cb\u63d0\u9192");
            androidPush.setUserId(userId);
            androidPush.setClientCode(pushConfig.getClientCode());
            androidPush.setDeviceTokens(userLastLoginDeviceRespVo.getDeviceNumber());
            androidPush.setText("\u60a8\u4eca\u5929" + time + "\u6709\u4e00\u7b14\u62a4\u7406\u9884\u7ea6\u5355\u5f85\u670d\u52a1\uff0c\u8bf7\u53ca\u65f6\u5904\u7406");
            androidPush.setDescription("\u60a8\u4eca\u5929" + time + "\u6709\u4e00\u7b14\u62a4\u7406\u9884\u7ea6\u5355\u5f85\u670d\u52a1\uff0c\u8bf7\u53ca\u65f6\u5904\u7406");
            androidPush.setTicker("\u62a4\u7406\u5373\u5c06\u5f00\u59cb\u63d0\u9192");
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("pushCode", "504");
            androidPush.setExtra(map);
            AppWebPushUtil.pushAndroidMessage((UmPushMsgAndroidReqVO)androidPush);
        }
    }

    public void manageDistributionWalk(String userId, String appCode, String time, String doctorName) {
        PushConfigurationDetailVO pushConfig;
        UserLastLoginDeviceRespVo userLastLoginDeviceRespVo = PushParamUtil.getDocUserDeviceToken((String)userId, (Short)new Short("1"));
        if (userLastLoginDeviceRespVo == null || StringUtils.isEmpty((CharSequence)userLastLoginDeviceRespVo.getDeviceType())) {
            log.info("\u6ca1\u6709\u627e\u5230\u8be5\u7528\u6237\u7684\u8bbe\u5907\u53f7\uff0c\u4e0d\u6267\u884c\u63a8\u9001\u903b\u8f91");
            return;
        }
        if (userLastLoginDeviceRespVo.getDeviceType().equals(ChannelCodeEnum.IOS.getValue())) {
            pushConfig = PushParamUtil.getPushConfig((String)appCode, (String)"youmengPush", (String)"doctor", (String)"IOS");
            String msg = "\u60a8\u7684" + time + "\u7684\u62a4\u7406\u670d\u52a1\u5355\uff0c\u5df2\u88ab\u7ba1\u7406\u5458\u91cd\u65b0\u5206\u914d\u7ed9" + doctorName + "\u62a4\u58eb\uff0c\u539f\u670d\u52a1\u5355\u5df2\u5220\u9664";
            UmPushMsgIOSReqVo iosPush = new UmPushMsgIOSReqVo();
            iosPush.setBusiCode("HLZH_501");
            iosPush.setTitle("\u62a4\u7406\u670d\u52a1\u91cd\u65b0\u5206\u914d\u63d0\u9192");
            iosPush.setUserId(userId);
            iosPush.setClientCode(pushConfig.getClientCode());
            iosPush.setDeviceTokens(userLastLoginDeviceRespVo.getDeviceNumber());
            iosPush.setSubTitle("\u62a4\u7406\u670d\u52a1\u91cd\u65b0\u5206\u914d\u63d0\u9192");
            iosPush.setDescription(msg);
            iosPush.setBody(msg);
            iosPush.setBusiStyle(msg);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("pushCode", "501");
            map.put("content", msg);
            iosPush.setExtra(map);
            iosPush.setUserType(Integer.valueOf(1));
            iosPush.setText(msg);
            HashMap<String, String> custom = new HashMap<String, String>();
            custom.putAll(map);
            String customJsonString = JSON.toJSONString(custom);
            iosPush.setCustom(customJsonString);
            AppWebPushUtil.pushIOSMessage((UmPushMsgIOSReqVo)iosPush);
        }
        if (userLastLoginDeviceRespVo.getDeviceType().equals(ChannelCodeEnum.ANDROID.getValue())) {
            pushConfig = PushParamUtil.getPushConfig((String)appCode, (String)"youmengPush", (String)"doctor", (String)"Android");
            UmPushMsgAndroidReqVO androidPush = new UmPushMsgAndroidReqVO();
            androidPush.setBusiCode("HLZH_501");
            androidPush.setBusiStyle("\u62a4\u7406\u670d\u52a1\u91cd\u65b0\u5206\u914d\u63d0\u9192");
            androidPush.setTitle("\u62a4\u7406\u670d\u52a1\u91cd\u65b0\u5206\u914d\u63d0\u9192");
            androidPush.setUserId(userId);
            androidPush.setClientCode(pushConfig.getClientCode());
            androidPush.setDeviceTokens(userLastLoginDeviceRespVo.getDeviceNumber());
            androidPush.setText("\u60a8\u7684" + time + "\u7684\u62a4\u7406\u670d\u52a1\u5355\uff0c\u5df2\u88ab\u7ba1\u7406\u5458\u91cd\u65b0\u5206\u914d\u7ed9" + doctorName + "\u62a4\u58eb\uff0c\u539f\u670d\u52a1\u5355\u5df2\u5220\u9664");
            androidPush.setDescription("\u60a8\u7684" + time + "\u7684\u62a4\u7406\u670d\u52a1\u5355\uff0c\u5df2\u88ab\u7ba1\u7406\u5458\u91cd\u65b0\u5206\u914d\u7ed9" + doctorName + "\u62a4\u58eb\uff0c\u539f\u670d\u52a1\u5355\u5df2\u5220\u9664");
            androidPush.setTicker("\u62a4\u7406\u670d\u52a1\u91cd\u65b0\u5206\u914d\u63d0\u9192");
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("pushCode", "501");
            androidPush.setExtra(map);
            AppWebPushUtil.pushAndroidMessage((UmPushMsgAndroidReqVO)androidPush);
        }
    }

    public void manageDistribution(String userId, String appCode, String time) {
        PushConfigurationDetailVO pushConfig;
        UserLastLoginDeviceRespVo userLastLoginDeviceRespVo = PushParamUtil.getDocUserDeviceToken((String)userId, (Short)new Short("1"));
        if (userLastLoginDeviceRespVo == null || StringUtils.isEmpty((CharSequence)userLastLoginDeviceRespVo.getDeviceType())) {
            log.info("\u6ca1\u6709\u627e\u5230\u8be5\u7528\u6237\u7684\u8bbe\u5907\u53f7\uff0c\u4e0d\u6267\u884c\u63a8\u9001\u903b\u8f91");
            return;
        }
        if (userLastLoginDeviceRespVo.getDeviceType().equals(ChannelCodeEnum.IOS.getValue())) {
            pushConfig = PushParamUtil.getPushConfig((String)appCode, (String)"youmengPush", (String)"doctor", (String)"IOS");
            String msg = "\u60a8\u6536\u5230\u7ba1\u7406\u5458\u5206\u914d\u7684" + time + "\u7684\u62a4\u7406\u670d\u52a1\u5355\uff0c\u8bf7\u53ca\u65f6\u5904\u7406";
            UmPushMsgIOSReqVo iosPush = new UmPushMsgIOSReqVo();
            iosPush.setBusiCode("HLZH_503");
            iosPush.setTitle("\u62a4\u7406\u670d\u52a1\u5206\u914d\u63d0\u9192");
            iosPush.setUserId(userId);
            iosPush.setClientCode(pushConfig.getClientCode());
            iosPush.setDeviceTokens(userLastLoginDeviceRespVo.getDeviceNumber());
            iosPush.setSubTitle("\u62a4\u7406\u670d\u52a1\u5206\u914d\u63d0\u9192");
            iosPush.setDescription(msg);
            iosPush.setBody(msg);
            iosPush.setBusiStyle(msg);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("pushCode", "503");
            map.put("content", msg);
            iosPush.setExtra(map);
            iosPush.setUserType(Integer.valueOf(1));
            iosPush.setText(msg);
            HashMap<String, String> custom = new HashMap<String, String>();
            custom.putAll(map);
            String customJsonString = JSON.toJSONString(custom);
            iosPush.setCustom(customJsonString);
            AppWebPushUtil.pushIOSMessage((UmPushMsgIOSReqVo)iosPush);
        }
        if (userLastLoginDeviceRespVo.getDeviceType().equals(ChannelCodeEnum.ANDROID.getValue())) {
            pushConfig = PushParamUtil.getPushConfig((String)appCode, (String)"youmengPush", (String)"doctor", (String)"Android");
            UmPushMsgAndroidReqVO androidPush = new UmPushMsgAndroidReqVO();
            androidPush.setBusiCode("HLZH_503");
            androidPush.setTitle("\u62a4\u7406\u670d\u52a1\u5206\u914d\u63d0\u9192");
            androidPush.setUserId(userId);
            androidPush.setClientCode(pushConfig.getClientCode());
            androidPush.setDeviceTokens(userLastLoginDeviceRespVo.getDeviceNumber());
            androidPush.setText("\u60a8\u6536\u5230\u7ba1\u7406\u5458\u5206\u914d\u7684" + time + "\u7684\u62a4\u7406\u670d\u52a1\u5355\uff0c\u8bf7\u53ca\u65f6\u5904\u7406");
            androidPush.setDescription("\u60a8\u6536\u5230\u7ba1\u7406\u5458\u5206\u914d\u7684" + time + "\u7684\u62a4\u7406\u670d\u52a1\u5355\uff0c\u8bf7\u53ca\u65f6\u5904\u7406");
            androidPush.setTicker("\u62a4\u7406\u670d\u52a1\u5206\u914d\u63d0\u9192");
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("pushCode", "503");
            androidPush.setExtra(map);
            AppWebPushUtil.pushAndroidMessage((UmPushMsgAndroidReqVO)androidPush);
        }
    }
}

