/*
 * Decompiled with CFR 0.152.
 */
package com.byh.nursingcarenewserver.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.byh.nursingcarenewserver.common.execption.BusinessException;
import com.byh.nursingcarenewserver.constant.ComponentConstant;
import com.byh.nursingcarenewserver.manage.DoctorUserEvaluationFeignClient;
import com.byh.nursingcarenewserver.mapper.AppointmentJunkMapper;
import com.byh.nursingcarenewserver.mapper.AppointmentMapper;
import com.byh.nursingcarenewserver.mapper.DoctorPoolMapper;
import com.byh.nursingcarenewserver.mapper.MaterialItemMapper;
import com.byh.nursingcarenewserver.mapper.MaterialPackageMapper;
import com.byh.nursingcarenewserver.mapper.OrderMapper;
import com.byh.nursingcarenewserver.mapper.ProductMapper;
import com.byh.nursingcarenewserver.mapper.ProductSubitemMapper;
import com.byh.nursingcarenewserver.mapper.UserAddressMapper;
import com.byh.nursingcarenewserver.pojo.dto.AppointmentCompetitionListDto;
import com.byh.nursingcarenewserver.pojo.dto.AppointmentConditionDto;
import com.byh.nursingcarenewserver.pojo.dto.AppointmentDetailDto;
import com.byh.nursingcarenewserver.pojo.dto.AppointmentDetailMaterialDto;
import com.byh.nursingcarenewserver.pojo.dto.AppointmentListDto;
import com.byh.nursingcarenewserver.pojo.dto.AppointmentListPageDto;
import com.byh.nursingcarenewserver.pojo.dto.AppointmentServerDto;
import com.byh.nursingcarenewserver.pojo.dto.AppointmentServerListDto;
import com.byh.nursingcarenewserver.pojo.dto.DetailAppointmentAddressDto;
import com.byh.nursingcarenewserver.pojo.dto.DetailAppointmentDto;
import com.byh.nursingcarenewserver.pojo.dto.DetailAppointmentOrderDto;
import com.byh.nursingcarenewserver.pojo.dto.DetailAppointmentProductDto;
import com.byh.nursingcarenewserver.pojo.dto.DetailAppointmentProductMaterialDto;
import com.byh.nursingcarenewserver.pojo.dto.DetailAppointmentUseRecordDto;
import com.byh.nursingcarenewserver.pojo.dto.HistoryNursingDetailDto;
import com.byh.nursingcarenewserver.pojo.dto.PatientHistoryNursingDto;
import com.byh.nursingcarenewserver.pojo.dto.QueryAppointmentToUserDto;
import com.byh.nursingcarenewserver.pojo.dto.UserSaveAppointmentDto;
import com.byh.nursingcarenewserver.pojo.entity.Appointment;
import com.byh.nursingcarenewserver.pojo.entity.MaterialItem;
import com.byh.nursingcarenewserver.pojo.entity.MaterialPackage;
import com.byh.nursingcarenewserver.pojo.entity.Orders;
import com.byh.nursingcarenewserver.pojo.entity.Product;
import com.byh.nursingcarenewserver.pojo.entity.ProductSubitem;
import com.byh.nursingcarenewserver.pojo.entity.UserAddress;
import com.byh.nursingcarenewserver.pojo.enums.AppointmentStatusDescribeDoctorEnum;
import com.byh.nursingcarenewserver.pojo.enums.AppointmentStatusDescribeUserEnum;
import com.byh.nursingcarenewserver.pojo.enums.AppointmentStatusEnum;
import com.byh.nursingcarenewserver.pojo.enums.OrderStatusDescribeEnum;
import com.byh.nursingcarenewserver.pojo.enums.OrderStatusEnum;
import com.byh.nursingcarenewserver.pojo.enums.ServerCodeEnum;
import com.byh.nursingcarenewserver.pojo.res.AppointmentJunkListDto;
import com.byh.nursingcarenewserver.pojo.vo.AddCommentVO;
import com.byh.nursingcarenewserver.pojo.vo.AppointmentCompetitionListVo;
import com.byh.nursingcarenewserver.pojo.vo.AppointmentConditionVo;
import com.byh.nursingcarenewserver.pojo.vo.AppointmentDetailVo;
import com.byh.nursingcarenewserver.pojo.vo.AppointmentDoctorVo;
import com.byh.nursingcarenewserver.pojo.vo.AppointmentListVo;
import com.byh.nursingcarenewserver.pojo.vo.AppointmentServerDateVo;
import com.byh.nursingcarenewserver.pojo.vo.AppointmentServerListVo;
import com.byh.nursingcarenewserver.pojo.vo.HistoryNursingDetailVo;
import com.byh.nursingcarenewserver.pojo.vo.ManageDistributionNurseVo;
import com.byh.nursingcarenewserver.pojo.vo.ManageNotAuditAppointmentVo;
import com.byh.nursingcarenewserver.pojo.vo.QueryCommentVO;
import com.byh.nursingcarenewserver.pojo.vo.RefundVo;
import com.byh.nursingcarenewserver.pojo.vo.SaveAppointmentVo;
import com.byh.nursingcarenewserver.pojo.vo.UcUserEvaluationListVO;
import com.byh.nursingcarenewserver.pojo.vo.UpdateToDoctorEndAppointmentVo;
import com.byh.nursingcarenewserver.pojo.vo.UserEvaluationVO;
import com.byh.nursingcarenewserver.service.AppWebPushService;
import com.byh.nursingcarenewserver.service.AppointmentService;
import com.byh.nursingcarenewserver.service.PayService;
import com.byh.nursingcarenewserver.service.ProgramPushService;
import com.byh.nursingcarenewserver.utils.DateUtils;
import com.byh.nursingcarenewserver.utils.DesensitizationUtil;
import com.byh.nursingcarenewserver.utils.DistanceUtil;
import com.byh.nursingcarenewserver.utils.PushParamUtil;
import com.byh.nursingcarenewserver.utils.UniqueKeyGenerator;
import com.byh.nursingcarenewserver.utils.pinyinUtil;
import com.doctor.basedata.api.dto.UcUserEvaluationDTO;
import com.doctor.basedata.api.vo.UcUserEvaluationVO;
import com.ebaiyihui.framework.page.PageResult;
import com.ebaiyihui.framework.response.BaseResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AppointmentServiceImpl
extends ServiceImpl<AppointmentMapper, Appointment>
implements AppointmentService {
    private static final Logger log = LoggerFactory.getLogger(AppointmentServiceImpl.class);
    @Autowired
    private AppointmentMapper appointmentMapper;
    @Autowired
    private OrderMapper orderMapper;
    @Autowired
    private ProductSubitemMapper productSubitemMapper;
    @Autowired
    private ProductMapper productMapper;
    @Autowired
    private UserAddressMapper userAddressMapper;
    @Autowired
    private MaterialItemMapper materialItemMapper;
    @Autowired
    private MaterialPackageMapper materialPackageMapper;
    @Autowired
    private PayService payService;
    @Autowired
    private AppWebPushService appWebPushService;
    @Autowired
    private DoctorUserEvaluationFeignClient evaluationFeignClient;
    @Autowired
    private DoctorPoolMapper doctorPoolMapper;
    @Autowired
    private AppointmentJunkMapper appointmentJunkMapper;
    @Autowired
    private ProgramPushService programPushService;
    ExecutorService executorService = Executors.newCachedThreadPool();

    public BaseResponse<PageResult<UcUserEvaluationListVO>> getCommentList(QueryCommentVO queryCommentVO) {
        if (Objects.isNull(queryCommentVO)) {
            throw new BusinessException("\u8bf7\u8f93\u5165\u53c2\u6570");
        }
        log.info("\u5f00\u59cb\u8c03\u7528\u4e91\u7aef\u83b7\u53d6\u8bc4\u8bba\u5217\u8868\u63a5\u53e3,\u53c2\u6570\u4e3a:{}", (Object)JSON.toJSONString((Object)queryCommentVO));
        BaseResponse resultBaseResponse = this.evaluationFeignClient.getDoctorEvaluationMsgPage(queryCommentVO.getDoctorId(), ServerCodeEnum.hlzh.name(), queryCommentVO.getViewId(), queryCommentVO.getProductId(), queryCommentVO.getPageNum().intValue(), queryCommentVO.getPageSize().intValue());
        for (UcUserEvaluationVO ucUserEvaluationVO : ((PageResult)resultBaseResponse.getData()).getContent()) {
            ucUserEvaluationVO.setDoctorName(pinyinUtil.nameDesensitization((String)ucUserEvaluationVO.getDoctorName()));
            ucUserEvaluationVO.setPatientName(pinyinUtil.nameDesensitization((String)ucUserEvaluationVO.getPatientName()));
        }
        PageResult voPageResult = (PageResult)resultBaseResponse.getData();
        PageResult ucUserEvaluationListVOPageResult = new PageResult();
        ucUserEvaluationListVOPageResult.setPageNum(voPageResult.getPageNum());
        ucUserEvaluationListVOPageResult.setPageSize(voPageResult.getPageSize());
        ucUserEvaluationListVOPageResult.setTotal(voPageResult.getTotal());
        ucUserEvaluationListVOPageResult.setTotalPages(voPageResult.getTotalPages());
        ucUserEvaluationListVOPageResult.setContent(new ArrayList());
        for (UcUserEvaluationVO ucUserEvaluationVO : voPageResult.getContent()) {
            UcUserEvaluationListVO ucUserEvaluationListVO = new UcUserEvaluationListVO();
            BeanUtils.copyProperties((Object)ucUserEvaluationVO, (Object)ucUserEvaluationListVO);
            ucUserEvaluationListVO.setCreateTimeString(DateUtils.javaDateParseStringByPattern((Date)ucUserEvaluationVO.getCreateTime(), (String)"yyyy-MM-dd"));
            ucUserEvaluationListVOPageResult.getContent().add(ucUserEvaluationListVO);
        }
        return BaseResponse.success((Object)ucUserEvaluationListVOPageResult);
    }

    public Integer insertOrderComment(AddCommentVO addCommentVO) {
        log.info("\u8c03\u7528\u4e91\u7aef\u589e\u52a0\u8bc4\u8bba\u63a5\u53e3");
        Appointment appointment = (Appointment)this.appointmentMapper.selectOne((Wrapper)new QueryWrapper().eq((Object)"view_id", (Object)addCommentVO.getViewId()));
        if (Objects.isNull(appointment)) {
            throw new BusinessException("\u5f53\u524d\u9884\u7ea6\u5355\u627e\u4e0d\u5230\u4e86\uff0c\u8bc4\u8bba\u5931\u8d25");
        }
        if (!AppointmentStatusEnum.APPOINTMENT_STATUS_FWJS.getValue().equals(appointment.getStatus())) {
            throw new BusinessException("\u53ea\u6709\u670d\u52a1\u7ed3\u675f\u7684\u9884\u7ea6\u5355\u53ef\u4ee5\u8bc4\u4ef7");
        }
        BaseResponse baseResponse = this.evaluationFeignClient.getDoctorEvaluationMsg("", ServerCodeEnum.hlzh.name(), appointment.getViewId(), null);
        if (null != baseResponse && null != baseResponse.getData() && ((List)baseResponse.getData()).size() > 0) {
            throw new BusinessException("\u5f53\u524d\u9884\u7ea6\u5355\u5df2\u7ecf\u8bc4\u8bba\u8fc7\u4e86");
        }
        Orders orders = this.orderMapper.queryById(appointment.getServiceOrderId());
        if (Objects.isNull(orders)) {
            throw new BusinessException("\u5f53\u524d\u8ba2\u5355\u627e\u4e0d\u5230\u4e86\uff0c\u8bc4\u8bba\u5931\u8d25");
        }
        Product product = this.productMapper.queryById(orders.getProductId());
        if (Objects.isNull(product)) {
            throw new BusinessException("\u5f53\u524d\u5957\u9910\u627e\u4e0d\u5230\u4e86\uff0c\u8bc4\u8bba\u5931\u8d25");
        }
        UcUserEvaluationDTO evaluationDTO = new UcUserEvaluationDTO();
        evaluationDTO.setAdmId(addCommentVO.getViewId());
        evaluationDTO.setAppCode(addCommentVO.getAppCode());
        evaluationDTO.setOrganId(addCommentVO.getOrganId());
        evaluationDTO.setProductId(product.getViewId());
        evaluationDTO.setServCode(ServerCodeEnum.hlzh.name());
        evaluationDTO.setDoctorScore(addCommentVO.getDoctorScore());
        evaluationDTO.setRemark(addCommentVO.getRemark());
        evaluationDTO.setDoctorId(addCommentVO.getDoctorId());
        evaluationDTO.setDoctorName(addCommentVO.getDoctorName());
        evaluationDTO.setEvalType(Byte.valueOf("1"));
        evaluationDTO.setPatientName(addCommentVO.getPatientName());
        evaluationDTO.setPaitientId(addCommentVO.getPaitientId());
        evaluationDTO.setDoctorComment(addCommentVO.getDoctorComment());
        evaluationDTO.setTagsName(addCommentVO.getTagsName());
        ArrayList<UcUserEvaluationDTO> ucUserEvaluationDtoS = new ArrayList<UcUserEvaluationDTO>();
        ucUserEvaluationDtoS.add(evaluationDTO);
        log.info("\u8bc4\u4ef7\u540c\u6b65\u5165\u53c2:{}", (Object)JSON.toJSONString(ucUserEvaluationDtoS));
        BaseResponse result = this.evaluationFeignClient.saveEvaluationMsg(ucUserEvaluationDtoS);
        log.info("\u540c\u6b65\u8bc4\u4ef7\u5230\u4e91\u4e0a\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)result));
        if (!result.isSuccess()) {
            log.error("\u540c\u6b65\u8bc4\u4ef7\u5230\u4e91\u4e0a\u5931\u8d25");
            throw new BusinessException("\u8bc4\u4ef7\u5931\u8d25");
        }
        return 1;
    }

    @Transactional(rollbackFor={Exception.class})
    public String doctorNotAuditAppointment(String appointmentViewId, String appCode) {
        Appointment appointment = (Appointment)this.appointmentMapper.selectOne((Wrapper)new QueryWrapper().eq((Object)"view_id", (Object)appointmentViewId));
        if (Objects.isNull(appointment)) {
            return "\u8981\u9000\u6b3e\u7684\u8ba2\u5355\u4e0d\u5b58\u5728";
        }
        appointment.setStatus(AppointmentStatusEnum.APPOINTMENT_STATUS_YQX.getValue());
        appointment.setStatusDescribe("\u62a4\u58eb\u5df2\u4e3a\u60a8\u9000\u6b3e\uff0c\u672c\u6b21\u670d\u52a1\u5c06\u4e3a\u60a8\u5168\u989d\u9000\u6b3e");
        this.appointmentMapper.update((Object)appointment, (Wrapper)new QueryWrapper().eq((Object)"view_id", (Object)appointmentViewId));
        Orders order = (Orders)this.orderMapper.selectById((Serializable)appointment.getServiceOrderId());
        Orders orderDb = new Orders();
        orderDb.setId(order.getId());
        orderDb.setStatus(OrderStatusEnum.ORDER_STATUS_YTK.getValue());
        orderDb.setStatusDescribe(OrderStatusDescribeEnum.STATUS_DOCTOR_YTK.getDisplay());
        orderDb.setServerResidueNum(Integer.valueOf(0));
        orderDb.setRefundPrice(order.getPrice());
        this.orderMapper.updateById((Object)orderDb);
        RefundVo refundVo = new RefundVo();
        refundVo.setAppCode(appCode);
        refundVo.setPrice(order.getPrice());
        refundVo.setOrderViewId(order.getViewId());
        Boolean refund = this.payService.refund(refundVo);
        if (!refund.booleanValue()) {
            throw new RuntimeException("\u9000\u6b3e\u5931\u8d25");
        }
        return "\u8ba2\u5355\u5ba1\u6838\u4e0d\u901a\u8fc7";
    }

    public String doctorAuditAppointment(String appointmentViewId) {
        Appointment appointment = (Appointment)this.appointmentMapper.selectOne((Wrapper)new QueryWrapper().eq((Object)"view_id", (Object)appointmentViewId));
        if (Objects.isNull(appointment)) {
            return "\u8981\u5ba1\u6838\u7684\u8ba2\u5355\u4e0d\u5b58\u5728";
        }
        appointment.setStatus(AppointmentStatusEnum.APPOINTMENT_STATUS_DFW.getValue());
        appointment.setStatusDescribe(AppointmentStatusDescribeUserEnum.STATUS_USER_DFW.getDisplay());
        this.appointmentMapper.update((Object)appointment, (Wrapper)new QueryWrapper().eq((Object)"view_id", (Object)appointmentViewId));
        return "\u8ba2\u5355\u5ba1\u6838\u901a\u8fc7\u5b8c\u6210";
    }

    public String doctorRobAppointment(AppointmentDoctorVo appointmentDoctorVo) {
        Appointment appointment = (Appointment)this.appointmentMapper.selectOne((Wrapper)new QueryWrapper().eq((Object)"view_id", (Object)appointmentDoctorVo.getAppointmentViewId()));
        if (Objects.isNull(appointment)) {
            return "\u8981\u62a2\u5355\u7684\u8ba2\u5355\u4e0d\u5b58\u5728";
        }
        if (!Objects.isNull(appointment.getDoctorId())) {
            return "\u8ba2\u5355\u5df2\u88ab\u62a2,\u8bf7\u9009\u62e9\u5176\u4ed6\u8ba2\u5355\u62a2\u5355";
        }
        BeanUtils.copyProperties((Object)appointmentDoctorVo, (Object)appointment);
        int update = this.appointmentMapper.update((Object)appointment, (Wrapper)new QueryWrapper().eq((Object)"view_id", (Object)appointmentDoctorVo.getAppointmentViewId()));
        if (update == 1) {
            return "\u62a2\u5355\u6210\u529f";
        }
        log.info("\u8ba2\u5355\u5df2\u88ab\u62a2,\u8bf7\u9009\u62e9\u5176\u4ed6\u8ba2\u5355\u62a2\u5355");
        return "\u8ba2\u5355\u5df2\u88ab\u62a2,\u8bf7\u9009\u62e9\u5176\u4ed6\u8ba2\u5355\u62a2\u5355";
    }

    public String doctorStartAppointment(String appointmentViewId) {
        Appointment appointment = (Appointment)this.appointmentMapper.selectOne((Wrapper)new QueryWrapper().eq((Object)"view_id", (Object)appointmentViewId));
        if (Objects.isNull(appointment)) {
            return "\u8981\u5f00\u59cb\u7684\u8ba2\u5355\u4e0d\u5b58\u5728";
        }
        appointment.setServerBeginTime(this.getDate());
        appointment.setStatus(AppointmentStatusEnum.APPOINTMENT_STATUS_FWZ.getValue());
        appointment.setStatusDescribe(AppointmentStatusDescribeDoctorEnum.STATUS_USER_FWZ.getDisplay());
        this.appointmentMapper.update((Object)appointment, (Wrapper)new QueryWrapper().eq((Object)"view_id", (Object)appointmentViewId));
        return "\u5f00\u59cb\u670d\u52a1";
    }

    @Transactional(rollbackFor={Exception.class})
    public String doctorEndAppointment(UpdateToDoctorEndAppointmentVo updateToDoctorEndAppointmentVo) {
        int count = 0;
        Appointment appointment = (Appointment)this.appointmentMapper.selectOne((Wrapper)new QueryWrapper().eq((Object)"view_id", (Object)updateToDoctorEndAppointmentVo.getAppointmentViewId()));
        if (Objects.isNull(appointment)) {
            return "\u8981\u7ed3\u675f\u7684\u8ba2\u5355\u4e0d\u5b58\u5728";
        }
        appointment.setStatus(AppointmentStatusEnum.APPOINTMENT_STATUS_FWJS.getValue());
        appointment.setStatusDescribe(AppointmentStatusDescribeDoctorEnum.STATUS_USER_FWJS.getDisplay());
        appointment.setArchivesBefore(updateToDoctorEndAppointmentVo.getArchivesBefore());
        appointment.setArchivesAfter(updateToDoctorEndAppointmentVo.getArchivesAfter());
        appointment.setNursingSummary(updateToDoctorEndAppointmentVo.getNursingSummary());
        appointment.setServerEndTime(this.getDate());
        this.appointmentMapper.updateById((Object)appointment);
        Orders order = (Orders)this.orderMapper.selectById((Serializable)appointment.getServiceOrderId());
        List appointmentList = this.appointmentMapper.selectList((Wrapper)new QueryWrapper().eq((Object)"service_order_id", (Object)order.getId()));
        boolean isEnd = true;
        for (Appointment appoint : appointmentList) {
            if (!AppointmentStatusEnum.APPOINTMENT_STATUS_DFW.getValue().equals(appoint.getStatus()) && !AppointmentStatusEnum.APPOINTMENT_STATUS_FWZ.getValue().equals(appoint.getStatus())) continue;
            isEnd = false;
        }
        log.info("\u5269\u4f59\u6b21\u6570\u65f6\u5019\u7528\u5b8c:{}", (Object)isEnd);
        if (count >= order.getServerResidueNum() && isEnd && OrderStatusEnum.ORDER_STATUS_SYZ.getValue().equals(order.getStatus())) {
            log.info("======\u7ed3\u675f\u670d\u52a1\u8ba2\u5355\u5b8c\u6210======");
            Orders orderDb = new Orders();
            orderDb.setId(order.getId());
            orderDb.setStatus(OrderStatusEnum.ORDER_STATUS_YWC.getValue());
            orderDb.setStatusDescribe(OrderStatusDescribeEnum.STATUS_YWC.getDisplay());
            this.orderMapper.updateById((Object)orderDb);
        }
        return "\u8ba2\u5355\u7ed3\u675f";
    }

    public String saveAppointmentInfo(UpdateToDoctorEndAppointmentVo updateToDoctorEndAppointmentVo) {
        Appointment appointment = (Appointment)this.appointmentMapper.selectOne((Wrapper)new QueryWrapper().eq((Object)"view_id", (Object)updateToDoctorEndAppointmentVo.getAppointmentViewId()));
        if (Objects.isNull(appointment)) {
            return "\u8be5\u670d\u52a1\u4e2d\u7684\u8ba2\u5355\u4e0d\u5b58\u5728";
        }
        appointment.setArchivesBefore(updateToDoctorEndAppointmentVo.getArchivesBefore());
        appointment.setArchivesAfter(updateToDoctorEndAppointmentVo.getArchivesAfter());
        this.appointmentMapper.updateById((Object)appointment);
        return "\u8ba2\u5355\u4fe1\u606f\u4fdd\u5b58\u6210\u529f";
    }

    public String doctorIsCommunication(String appointmentViewId, int communicate) {
        Appointment appointment = (Appointment)this.appointmentMapper.selectOne((Wrapper)new QueryWrapper().eq((Object)"view_id", (Object)appointmentViewId));
        if (Objects.isNull(appointment)) {
            return "\u8981\u6c9f\u901a\u7684\u8ba2\u5355\u4e0d\u5b58\u5728";
        }
        appointment.setCommunicate(Integer.valueOf(communicate));
        this.appointmentMapper.update((Object)appointment, (Wrapper)new QueryWrapper().eq((Object)"view_id", (Object)appointmentViewId));
        return null;
    }

    @Transactional(rollbackFor={Exception.class})
    public UserSaveAppointmentDto userSaveAppointment(SaveAppointmentVo saveAppointmentVo) {
        int count = 0;
        UserSaveAppointmentDto userSaveAppointmentDto = new UserSaveAppointmentDto();
        List appointmentList = this.appointmentMapper.selectList((Wrapper)new QueryWrapper().eq((Object)"service_order_id", (Object)saveAppointmentVo.getServiceOrderId()));
        for (Appointment appoint : appointmentList) {
            if (!AppointmentStatusEnum.APPOINTMENT_STATUS_DSH.getValue().equals(appoint.getStatus())) continue;
            userSaveAppointmentDto.setMessage("\u8ba2\u5355\u5ba1\u6838\u901a\u8fc7\u540e\u53ef\u518d\u6b21\u9884\u7ea6");
            return userSaveAppointmentDto;
        }
        Orders order = (Orders)this.orderMapper.selectById((Serializable)saveAppointmentVo.getServiceOrderId());
        if (order.getServerResidueNum() <= 0 || count >= order.getQuantity()) {
            userSaveAppointmentDto.setMessage("\u8ba2\u5355\u53ef\u4f7f\u7528\u6b21\u6570\u5df2\u7528\u5b8c,\u8bf7\u91cd\u65b0\u8d2d\u4e70");
            return userSaveAppointmentDto;
        }
        Orders orderDb = new Orders();
        orderDb.setId(order.getId());
        Integer result = this.orderMapper.subTotalNum(orderDb);
        if (result < 1) {
            throw new BusinessException("\u64cd\u4f5c\u9891\u6b21\u8fc7\u9ad8\uff0c\u7a0d\u7b49\u4e00\u4e0b\u518d\u6765\u5c1d\u8bd5\u5427~");
        }
        Appointment appointment = new Appointment();
        BeanUtils.copyProperties((Object)saveAppointmentVo, (Object)appointment);
        appointment.setViewId(UniqueKeyGenerator.generateViewId().toString());
        appointment.setStatus(AppointmentStatusEnum.APPOINTMENT_STATUS_DFW.getValue());
        appointment.setStatusDescribe(AppointmentStatusDescribeUserEnum.STATUS_USER_DFW.getDisplay());
        this.appointmentMapper.insertAppointment(appointment);
        Appointment appointmentDb = (Appointment)this.appointmentMapper.selectById((Serializable)appointment.getId());
        userSaveAppointmentDto.setAppointmentId(appointmentDb.getId());
        userSaveAppointmentDto.setAppointmentViewId(appointmentDb.getViewId());
        userSaveAppointmentDto.setMessage("\u9884\u7ea6\u6210\u529f");
        this.executorService.execute((Runnable)new /* Unavailable Anonymous Inner Class!! */);
        return userSaveAppointmentDto;
    }

    @Transactional(rollbackFor={Exception.class})
    public String userCancelAppointment(String appointmentViewId, String appCode) {
        String ret = "\u8ba2\u5355\u53d6\u6d88\u6210\u529f";
        Appointment appointment = (Appointment)this.appointmentMapper.selectOne((Wrapper)new QueryWrapper().eq((Object)"view_id", (Object)appointmentViewId));
        Orders order = (Orders)this.orderMapper.selectById((Serializable)appointment.getServiceOrderId());
        ProductSubitem productSubitem = (ProductSubitem)this.productSubitemMapper.selectById((Serializable)order.getProductSubitemId());
        boolean equals = Integer.valueOf(1).equals(order.getServerTotalNum());
        boolean communicate = Integer.valueOf(1).equals((int)appointment.getCommunicate());
        if (Objects.isNull(appointment)) {
            return "\u8981\u53d6\u6d88\u7684\u9884\u7ea6\u4e0d\u5b58\u5728";
        }
        if (AppointmentStatusEnum.APPOINTMENT_STATUS_FWZ.getValue().equals(appointment.getStatus())) {
            return "\u672c\u6b21\u670d\u52a1\u5df2\u5f00\u59cb,\u65e0\u6cd5\u53d6\u6d88";
        }
        if (AppointmentStatusEnum.APPOINTMENT_STATUS_DSH.getValue().equals(appointment.getStatus())) {
            return "\u8ba2\u5355\u6b63\u5728\u5ba1\u6838\u4e2d,\u8bf7\u7b49\u5f85\u5ba1\u6838\u5b8c\u6210";
        }
        if (AppointmentStatusEnum.APPOINTMENT_STATUS_YQX.equals((Object)appointment.getStatus()) || AppointmentStatusEnum.APPOINTMENT_STATUS_YTK.equals((Object)appointment.getStatus()) || AppointmentStatusEnum.APPOINTMENT_STATUS_FWJS.equals((Object)appointment.getStatus())) {
            return "\u9884\u7ea6\u670d\u52a1\u5df2\u7ec8\u6b62,\u65e0\u6cd5\u53d6\u6d88";
        }
        RefundVo refundVo = new RefundVo();
        refundVo.setAppCode(appCode);
        refundVo.setOrderViewId(order.getViewId());
        if (AppointmentStatusEnum.APPOINTMENT_STATUS_DFW.getValue().equals(appointment.getStatus())) {
            if (equals) {
                ArrayList<Integer> arrayList = new ArrayList<Integer>();
                arrayList.add(AppointmentStatusEnum.APPOINTMENT_STATUS_DFW.getValue());
                arrayList.add(AppointmentStatusEnum.APPOINTMENT_STATUS_FWZ.getValue());
                List appointmentList = this.appointmentMapper.selectList((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"service_order_id", (Object)order.getId())).in((Object)"status", arrayList));
                if (1 > order.getServerResidueNum() && CollectionUtils.isEmpty((Collection)appointmentList)) {
                    Orders orderDb = new Orders();
                    orderDb.setStatus(OrderStatusEnum.ORDER_STATUS_YWC.getValue());
                    orderDb.setStatusDescribe(OrderStatusDescribeEnum.STATUS_YWC.getDisplay());
                    this.orderMapper.update((Object)orderDb, (Wrapper)new QueryWrapper().eq((Object)"view_id", (Object)order.getViewId()));
                    return ret;
                }
                if (Objects.isNull(appointment.getDoctorId())) {
                    BigDecimal price = order.getPrice().divide(new BigDecimal(order.getServerTotalNum().toString()));
                    String statusDisplay = "\u60a8\u5df2\u81ea\u884c\u9000\u6b3e\uff0c\u672c\u6b21\u670d\u52a1\u5c06\u4e3a\u60a8\u5168\u989d\u9000\u6b3e";
                    this.refundAppointment(appointmentViewId, statusDisplay, price, 0);
                    refundVo.setPrice(price);
                    Boolean refund = this.payService.refund(refundVo);
                    if (!refund.booleanValue()) {
                        throw new RuntimeException("\u9000\u6b3e\u5931\u8d25");
                    }
                    return ret;
                }
                if (communicate) {
                    String statusDisplay = "\u60a8\u5df2\u81ea\u884c\u9000\u6b3e\uff0c\u672c\u6b21\u670d\u52a1\u5c06\u6309\u6bd4\u4f8b\u4e3a\u60a8\u9000\u6b3e50%";
                    BigDecimal price = order.getPrice().divide(new BigDecimal(order.getServerTotalNum().toString())).multiply(new BigDecimal("0.5"));
                    this.refundAppointment(appointmentViewId, statusDisplay, price, 0);
                    refundVo.setPrice(price);
                    Boolean refund = this.payService.refund(refundVo);
                    if (!refund.booleanValue()) {
                        throw new RuntimeException("\u9000\u6b3e\u5931\u8d25");
                    }
                    return ret;
                }
                String statusDisplay = "\u60a8\u5df2\u81ea\u884c\u9000\u6b3e\uff0c\u672c\u6b21\u670d\u52a1\u5c06\u6309\u6bd4\u4f8b\u4e3a\u60a8\u9000\u6b3e80%";
                BigDecimal price = order.getPrice().divide(new BigDecimal(order.getServerTotalNum().toString())).multiply(new BigDecimal("0.8"));
                this.refundAppointment(appointmentViewId, statusDisplay, price, 0);
                refundVo.setPrice(price);
                Boolean refund = this.payService.refund(refundVo);
                if (!refund.booleanValue()) {
                    throw new RuntimeException("\u9000\u6b3e\u5931\u8d25");
                }
                return ret;
            }
            String statusDisplay = "\u60a8\u5df2\u81ea\u884c\u53d6\u6d88\uff0c\u672c\u6b21\u670d\u52a1\u5c06\u4e3a\u60a8\u8fd4\u8fd8\u6b21\u6570";
            this.refundAppointment(appointmentViewId, statusDisplay, new BigDecimal("0"), 1);
            return ret;
        }
        return ret;
    }

    @Transactional(rollbackFor={Exception.class})
    public String doctorCancelAppointment(String appointmentViewId) {
        Appointment appointment = (Appointment)this.appointmentMapper.selectOne((Wrapper)new QueryWrapper().eq((Object)"view_id", (Object)appointmentViewId));
        appointment.setStatus(AppointmentStatusEnum.APPOINTMENT_STATUS_YQX.getValue());
        appointment.setStatusDescribe("\u62a4\u58eb\u5df2\u4e3a\u60a8\u53d6\u6d88\uff0c\u672c\u6b21\u670d\u52a1\u5c06\u4e3a\u60a8\u8fd4\u8fd8\u6b21\u6570");
        this.appointmentMapper.update((Object)appointment, (Wrapper)new QueryWrapper().eq((Object)"view_id", (Object)appointmentViewId));
        Orders order = (Orders)this.orderMapper.selectById((Serializable)appointment.getServiceOrderId());
        order.setServerResidueNum(Integer.valueOf(order.getServerResidueNum() + 1));
        this.orderMapper.update((Object)order, (Wrapper)new QueryWrapper().eq((Object)"view_id", (Object)order.getViewId()));
        return "\u53d6\u6d88\u9884\u7ea6\u6210\u529f";
    }

    public AppointmentListPageDto getListAppointment(AppointmentListVo appointmentListVo) {
        AppointmentListPageDto appointmentListPageDto = new AppointmentListPageDto();
        QueryWrapper appointmentQueryWrapper = new QueryWrapper();
        if (StringUtils.isNotEmpty((CharSequence)appointmentListVo.getAppointmentTimeBegin()) && StringUtils.isNotEmpty((CharSequence)appointmentListVo.getAppointmentTimeEnd())) {
            appointmentQueryWrapper.between((Object)"appointment_time", (Object)appointmentListVo.getAppointmentTimeBegin(), (Object)appointmentListVo.getAppointmentTimeEnd());
        }
        if (appointmentListVo.getAppointmentStatus() != null && appointmentListVo.getAppointmentStatus() != 0) {
            appointmentQueryWrapper.eq((Object)"status", (Object)appointmentListVo.getAppointmentStatus());
        }
        appointmentQueryWrapper.orderByDesc((Object)"create_time");
        List appointments = this.appointmentMapper.selectList((Wrapper)appointmentQueryWrapper);
        ArrayList<AppointmentListDto> appointmentListDtos = new ArrayList<AppointmentListDto>();
        for (Appointment appointment : appointments) {
            Orders order = this.orderMapper.queryById(appointment.getServiceOrderId());
            ProductSubitem productSubitem = this.productSubitemMapper.queryById(order.getProductSubitemId());
            Product product = this.productMapper.queryById(order.getProductId());
            AppointmentListDto appointmentListDto2 = new AppointmentListDto();
            appointmentListDto2.setAppointmentTime(appointment.getAppointmentTime());
            appointmentListDto2.setAppointmentStatus(appointment.getStatus());
            appointmentListDto2.setAppointmentViewId(appointment.getViewId());
            appointmentListDto2.setAppointmentDoctorName(appointment.getDoctorName());
            appointmentListDto2.setPatientName(order.getPatientName());
            appointmentListDto2.setPatientPhone(order.getPatientPhone());
            appointmentListDto2.setProductName(product.getName());
            appointmentListDto2.setMaterialName(productSubitem.getMaterialName());
            appointmentListDto2.setSpecificationValueName(productSubitem.getSpecificationValueName());
            appointmentListDtos.add(appointmentListDto2);
        }
        List appointmentListDtoList = appointmentListDtos.stream().filter(appointmentListDto -> appointmentListDto.getAppointmentViewId().contains(appointmentListVo.getSearch()) || appointmentListDto.getAppointmentDoctorName().contains(appointmentListVo.getSearch()) || appointmentListDto.getPatientName().contains(appointmentListVo.getSearch()) || appointmentListDto.getPatientPhone().contains(appointmentListVo.getSearch()) || appointmentListDto.getProductName().contains(appointmentListVo.getSearch())).collect(Collectors.toList());
        List appointmentListDtoLists = appointmentListDtoList.stream().skip(appointmentListVo.getPageIndex() * appointmentListVo.getPageSize()).limit(appointmentListVo.getPageSize()).collect(Collectors.toList());
        Integer fForServiceNum = appointmentListDtoList.stream().filter(appointmentListDto -> appointmentListDto.getAppointmentStatus().intValue() == AppointmentStatusEnum.APPOINTMENT_STATUS_DFW.getValue().intValue()).collect(Collectors.toList()).size();
        appointmentListPageDto.setAppointmentListDtoList(appointmentListDtoLists);
        appointmentListPageDto.setPageIndex(appointmentListVo.getPageIndex());
        appointmentListPageDto.setPageSize(appointmentListVo.getPageSize());
        appointmentListPageDto.setTotal(Integer.valueOf(appointmentListDtoList.size()));
        BigDecimal bigDecimal = new BigDecimal(appointmentListDtoList.size());
        BigDecimal bigDecimal1 = new BigDecimal(appointmentListVo.getPageSize());
        BigDecimal divide = BigDecimal.ZERO;
        divide = 0 == bigDecimal1.compareTo(BigDecimal.ZERO) ? BigDecimal.ZERO : bigDecimal.divide(bigDecimal1, 0);
        double ceil = Math.ceil(Double.valueOf(divide.toString()));
        appointmentListPageDto.setPageNum(Integer.valueOf(new Double(ceil).intValue()));
        appointmentListPageDto.setForServiceNum(fForServiceNum);
        return appointmentListPageDto;
    }

    public DetailAppointmentDto detailAppointment(String appointmentViewId) {
        DetailAppointmentDto detailAppointmentDto = new DetailAppointmentDto();
        QueryWrapper appointmentQueryWrapper = (QueryWrapper)new QueryWrapper().eq((Object)"view_id", (Object)appointmentViewId);
        Appointment appointment = (Appointment)this.appointmentMapper.selectOne((Wrapper)appointmentQueryWrapper);
        Orders order = (Orders)this.orderMapper.selectById((Serializable)appointment.getServiceOrderId());
        DetailAppointmentOrderDto detailAppointmentOrderDto = new DetailAppointmentOrderDto();
        detailAppointmentOrderDto.setCreateTime(order.getCreateTime());
        detailAppointmentOrderDto.setOrderViewId(order.getViewId());
        detailAppointmentOrderDto.setOrderStatus(order.getStatus());
        detailAppointmentOrderDto.setMedicalCertificate(order.getMedicalCertificate());
        detailAppointmentOrderDto.setServerResidueNum(order.getServerResidueNum());
        detailAppointmentOrderDto.setServerTotalNum(order.getServerTotalNum());
        detailAppointmentOrderDto.setPatientId(order.getPatientId());
        detailAppointmentOrderDto.setPatientName(order.getPatientName());
        detailAppointmentOrderDto.setPatientAge(order.getPatientAge());
        detailAppointmentOrderDto.setPatientSex(order.getPatientSex());
        detailAppointmentOrderDto.setPatientPhone(order.getPatientPhone());
        detailAppointmentOrderDto.setAppointmentRemark(appointment.getRemark());
        detailAppointmentDto.setDetailAppointmentOrderDto(detailAppointmentOrderDto);
        BaseResponse baseResponse = this.evaluationFeignClient.getDoctorEvaluationMsg("", ServerCodeEnum.hlzh.name(), appointment.getViewId(), null);
        if (null != baseResponse && null != baseResponse.getData() && ((List)baseResponse.getData()).size() > 0) {
            UcUserEvaluationVO ucUserEvaluationVO = (UcUserEvaluationVO)((List)baseResponse.getData()).get(0);
            UserEvaluationVO userEvaluationVO = new UserEvaluationVO();
            BeanUtils.copyProperties((Object)ucUserEvaluationVO, (Object)userEvaluationVO);
            detailAppointmentDto.setUserEvaluationVO(userEvaluationVO);
        }
        Product product = this.productMapper.queryById(order.getProductId());
        ProductSubitem productSubitem = this.productSubitemMapper.queryById(order.getProductSubitemId());
        DetailAppointmentProductDto detailAppointmentProductDto = new DetailAppointmentProductDto();
        detailAppointmentProductDto.setProductId(product.getId());
        detailAppointmentProductDto.setProductName(product.getName());
        detailAppointmentProductDto.setProductImage(product.getImage());
        detailAppointmentProductDto.setMaterialName(productSubitem.getMaterialName());
        detailAppointmentProductDto.setSpecificationValueName(productSubitem.getSpecificationValueName());
        detailAppointmentProductDto.setUsefulLife(productSubitem.getUsefulLife());
        MaterialItem param = new MaterialItem();
        param.setMaterialPackageId(productSubitem.getMaterialId());
        List materialItems = this.materialItemMapper.queryList(param);
        ArrayList<DetailAppointmentProductMaterialDto> materialDtos = new ArrayList<DetailAppointmentProductMaterialDto>();
        if (CollectionUtils.isNotEmpty((Collection)materialItems)) {
            for (MaterialItem materialItem : materialItems) {
                DetailAppointmentProductMaterialDto detailAppointmentProductMaterialDto = new DetailAppointmentProductMaterialDto();
                detailAppointmentProductMaterialDto.setMaterialName(materialItem.getName());
                detailAppointmentProductMaterialDto.setMaterialQuantity(materialItem.getQuantity());
                materialDtos.add(detailAppointmentProductMaterialDto);
            }
        }
        detailAppointmentProductDto.setDetailAppointmentProductMaterialDtoList(materialDtos);
        detailAppointmentDto.setDetailAppointmentProductDto(detailAppointmentProductDto);
        UserAddress userAddress = (UserAddress)this.userAddressMapper.selectById((Serializable)order.getUserAddressId());
        DetailAppointmentAddressDto detailAppointmentAddressDto = new DetailAppointmentAddressDto();
        detailAppointmentAddressDto.setAddress(userAddress.getAddress());
        detailAppointmentAddressDto.setCustomAddress(userAddress.getCustomAddress());
        detailAppointmentDto.setDetailAppointmentAddressDto(detailAppointmentAddressDto);
        DetailAppointmentUseRecordDto detailAppointmentUseRecordDto = new DetailAppointmentUseRecordDto();
        detailAppointmentUseRecordDto.setUseRecordViewId(appointment.getViewId());
        detailAppointmentUseRecordDto.setUseRecordStatus(appointment.getStatus());
        detailAppointmentUseRecordDto.setUseRecordAppointmentTime(appointment.getAppointmentTime());
        detailAppointmentUseRecordDto.setUseRecordDoctorId(appointment.getDoctorId());
        detailAppointmentUseRecordDto.setUseRecordDoctorName(appointment.getDoctorName());
        detailAppointmentUseRecordDto.setUseRecordDoctorHeadPortrait(appointment.getDoctorHeadPortrait());
        detailAppointmentUseRecordDto.setUseRecordDoctorDeptId(appointment.getDoctorDeptId());
        detailAppointmentUseRecordDto.setUseRecordDoctorDeptName(appointment.getDoctorDeptName());
        detailAppointmentUseRecordDto.setUseRecordDoctorOrganId(appointment.getDoctorOrganId());
        detailAppointmentUseRecordDto.setUseRecordDoctorOrganName(appointment.getDoctorOrganName());
        detailAppointmentUseRecordDto.setUseRecordDoctorProfession(appointment.getProfession());
        detailAppointmentUseRecordDto.setNursingSummary(appointment.getNursingSummary());
        detailAppointmentUseRecordDto.setServerBeginTime(appointment.getServerBeginTime());
        detailAppointmentUseRecordDto.setServerEndTime(appointment.getServerEndTime());
        detailAppointmentUseRecordDto.setArchivesBefore(appointment.getArchivesBefore());
        detailAppointmentUseRecordDto.setArchivesAfter(appointment.getArchivesAfter());
        detailAppointmentDto.setDetailAppointmentUseRecordDto(detailAppointmentUseRecordDto);
        List appointmentJunkList = this.appointmentJunkMapper.selectList((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"appointment_id", (Object)appointment.getViewId())).orderByDesc((Object)"handle_time"));
        detailAppointmentDto.setAppointmentJunkListDtos(AppointmentJunkListDto.setAppointment((List)appointmentJunkList));
        return detailAppointmentDto;
    }

    public List<AppointmentCompetitionListDto> appointmentCompetitionList(AppointmentCompetitionListVo appointmentCompetitionListVo) {
        ArrayList<AppointmentCompetitionListDto> list = new ArrayList<AppointmentCompetitionListDto>();
        Page page = new Page();
        page.setCurrent(appointmentCompetitionListVo.getPageIndex().longValue());
        page.setSize(appointmentCompetitionListVo.getPageSize().longValue());
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.in((Object)"status", new Object[]{AppointmentStatusEnum.APPOINTMENT_STATUS_DSH.getValue(), AppointmentStatusEnum.APPOINTMENT_STATUS_DFW.getValue()});
        queryWrapper.isNull((Object)"doctor_id");
        queryWrapper.orderByDesc((Object)"create_time");
        Page appointmentPage = (Page)this.appointmentMapper.selectPage((IPage)page, (Wrapper)queryWrapper);
        List appointmentList = appointmentPage.getRecords();
        for (Appointment appointment : appointmentList) {
            AppointmentCompetitionListDto appointmentCompetitionListDto = new AppointmentCompetitionListDto();
            appointmentCompetitionListDto.setAppointmentStatus(appointment.getStatus());
            appointmentCompetitionListDto.setAppointmentTime(appointment.getAppointmentTime());
            appointmentCompetitionListDto.setAppointmentViewId(appointment.getViewId());
            Orders order = (Orders)this.orderMapper.selectById((Serializable)appointment.getServiceOrderId());
            if (Objects.isNull(order) || Integer.valueOf(1).equals(order.getDeleted())) continue;
            appointmentCompetitionListDto.setPatientName(DesensitizationUtil.nameDesensitization((String)order.getPatientName()));
            appointmentCompetitionListDto.setPatientSex(order.getPatientSex());
            appointmentCompetitionListDto.setPatientAge(order.getPatientAge());
            appointmentCompetitionListDto.setPatientRelation(order.getPatientRelation());
            Product product = this.productMapper.queryById(order.getProductId());
            if (Objects.isNull(product) || Integer.valueOf(1).equals(product.getDeleted())) {
                appointmentCompetitionListDto.setProductName("");
            } else {
                appointmentCompetitionListDto.setProductName(product.getName());
            }
            ProductSubitem productSubitem = this.productSubitemMapper.queryById(order.getProductSubitemId());
            appointmentCompetitionListDto.setMaterialName(productSubitem.getMaterialName());
            appointmentCompetitionListDto.setSpecificationValueName(productSubitem.getSpecificationValueName());
            UserAddress userAddress = (UserAddress)this.userAddressMapper.selectById((Serializable)order.getUserAddressId());
            appointmentCompetitionListDto.setAddress(userAddress.getAddress());
            appointmentCompetitionListDto.setCustomAddress(userAddress.getCustomAddress());
            try {
                double distance = DistanceUtil.distance((double)userAddress.getLongitude(), (double)userAddress.getLatitude(), (double)appointmentCompetitionListVo.getLongitude(), (double)appointmentCompetitionListVo.getLatitude());
                appointmentCompetitionListDto.setDistance(Double.valueOf(distance / 1000.0));
            }
            catch (Exception e) {
                log.error("\u8ba1\u7b97\u8ddd\u79bb\u51fa\u9519");
            }
            list.add(appointmentCompetitionListDto);
        }
        if (CollectionUtils.isNotEmpty(list)) {
            return list;
        }
        return new ArrayList<AppointmentCompetitionListDto>();
    }

    public AppointmentServerDto appointmentServerList(AppointmentServerListVo appointmentServerListVo) {
        AppointmentServerDto appointmentServerDto = new AppointmentServerDto();
        ArrayList<AppointmentServerListDto> list = new ArrayList<AppointmentServerListDto>();
        Page page = new Page();
        page.setCurrent(appointmentServerListVo.getPageIndex().longValue());
        page.setSize(appointmentServerListVo.getPageSize().longValue());
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.in((Object)"status", new Object[]{AppointmentStatusEnum.APPOINTMENT_STATUS_DSH.getValue(), AppointmentStatusEnum.APPOINTMENT_STATUS_DFW.getValue(), AppointmentStatusEnum.APPOINTMENT_STATUS_FWZ.getValue(), AppointmentStatusEnum.APPOINTMENT_STATUS_FWJS.getValue(), AppointmentStatusEnum.APPOINTMENT_STATUS_YQX.getValue()});
        queryWrapper.eq((Object)"doctor_id", (Object)appointmentServerListVo.getDoctorId());
        queryWrapper.like((Object)"appointment_time", (Object)appointmentServerListVo.getAppointmentTime());
        queryWrapper.orderByDesc((Object)"create_time");
        Page appointmentPage = (Page)this.appointmentMapper.selectPage((IPage)page, (Wrapper)queryWrapper);
        List appointmentList = appointmentPage.getRecords();
        for (Appointment appointment : appointmentList) {
            AppointmentServerListDto appointmentServerListDto = new AppointmentServerListDto();
            appointmentServerListDto.setAppointmentStatus(appointment.getStatus());
            String[] split = appointment.getAppointmentTime().split(" ");
            appointmentServerListDto.setAppointmentTime(split[1]);
            String[] split1 = split[1].split("-");
            appointmentServerListDto.setAppointmentStartTime(split[0] + " " + split1[0] + ":00");
            appointmentServerListDto.setAppointmentViewId(appointment.getViewId());
            appointmentServerListDto.setAppointmentCommunicate(appointment.getCommunicate());
            Orders order = (Orders)this.orderMapper.selectById((Serializable)appointment.getServiceOrderId());
            appointmentServerListDto.setPatientName(DesensitizationUtil.nameDesensitization((String)order.getPatientName()));
            appointmentServerListDto.setPatientSex(order.getPatientSex());
            appointmentServerListDto.setPatientAge(order.getPatientAge());
            appointmentServerListDto.setPatientRelation(order.getPatientRelation());
            appointmentServerListDto.setPatientPhone(order.getPatientPhone());
            Product product = this.productMapper.queryById(order.getProductId());
            appointmentServerListDto.setProductName(product.getName());
            ProductSubitem productSubitem = this.productSubitemMapper.queryById(order.getProductSubitemId());
            appointmentServerListDto.setMaterialName(productSubitem.getMaterialName());
            appointmentServerListDto.setSpecificationValueName(productSubitem.getSpecificationValueName());
            UserAddress userAddress = (UserAddress)this.userAddressMapper.selectById((Serializable)order.getUserAddressId());
            appointmentServerListDto.setAddress(userAddress.getAddress());
            appointmentServerListDto.setCustomAddress(userAddress.getCustomAddress());
            appointmentServerListDto.setLongitude(userAddress.getLongitude());
            appointmentServerListDto.setLatitude(userAddress.getLatitude());
            try {
                double distance = DistanceUtil.distance((double)userAddress.getLongitude(), (double)userAddress.getLatitude(), (double)appointmentServerListVo.getLongitude(), (double)appointmentServerListVo.getLatitude());
                appointmentServerListDto.setDistance(Double.valueOf(distance / 1000.0));
            }
            catch (Exception e) {
                log.error("\u8ba1\u7b97\u8ddd\u79bb\u51fa\u9519");
            }
            list.add(appointmentServerListDto);
        }
        appointmentServerDto.setAppointmentServerListDtoList(list);
        QueryWrapper appointmentQueryWrapper = new QueryWrapper();
        appointmentQueryWrapper.eq((Object)"status", (Object)AppointmentStatusEnum.APPOINTMENT_STATUS_DSH.getValue());
        appointmentQueryWrapper.eq((Object)"doctor_id", (Object)appointmentServerListVo.getDoctorId());
        Integer appointmentAuditNum = this.appointmentMapper.selectList((Wrapper)appointmentQueryWrapper).size();
        appointmentServerDto.setAppointmentAuditNum(appointmentAuditNum);
        QueryWrapper appointmentQueryWrapper1 = new QueryWrapper();
        appointmentQueryWrapper1.eq((Object)"status", (Object)AppointmentStatusEnum.APPOINTMENT_STATUS_DFW.getValue());
        appointmentQueryWrapper1.eq((Object)"doctor_id", (Object)appointmentServerListVo.getDoctorId());
        Integer appointmentServerNum = this.appointmentMapper.selectList((Wrapper)appointmentQueryWrapper1).size();
        appointmentServerDto.setAppointmentServerNum(appointmentServerNum);
        return appointmentServerDto;
    }

    public AppointmentDetailDto appointmentDetail(AppointmentDetailVo appointmentDetailVo) {
        AppointmentDetailDto appointmentDetailDto = new AppointmentDetailDto();
        QueryWrapper wrapper = (QueryWrapper)new QueryWrapper().eq((Object)"view_id", (Object)appointmentDetailVo.getViewId());
        Appointment appointment = (Appointment)this.appointmentMapper.selectOne((Wrapper)wrapper);
        appointmentDetailDto.setAppointmentStatus(appointment.getStatus());
        appointmentDetailDto.setAppointmentTime(appointment.getAppointmentTime());
        appointmentDetailDto.setAppointmentViewId(appointment.getViewId());
        appointmentDetailDto.setAppointmentCommunicate(appointment.getCommunicate());
        appointmentDetailDto.setAppointmentArchivesBefore(appointment.getArchivesBefore() == null ? "" : appointment.getArchivesBefore());
        appointmentDetailDto.setAppointmentArchivesAfter(appointment.getArchivesAfter() == null ? "" : appointment.getArchivesAfter());
        appointmentDetailDto.setAppointmentNursingSummary(appointment.getNursingSummary() == null ? "" : appointment.getNursingSummary());
        appointmentDetailDto.setAppointmentRemark(appointment.getRemark());
        appointmentDetailDto.setAppointmentStatusDescribe(appointment.getStatusDescribe());
        if (AppointmentStatusEnum.APPOINTMENT_STATUS_YQX.getValue().equals(appointment.getStatus())) {
            appointmentDetailDto.setAppointmentStatusDescribe(AppointmentStatusDescribeDoctorEnum.getAppointmentStatusDescribeDoctorEnum((Integer)AppointmentStatusEnum.APPOINTMENT_STATUS_YQX.getValue()).getDisplay());
        }
        appointmentDetailDto.setAppointmentStatusDescribe(appointment.getRemark());
        appointmentDetailDto.setAppointmentServerBeginTime(appointment.getServerBeginTime() == null ? "" : appointment.getServerBeginTime());
        appointmentDetailDto.setAppointmentServerEndTime(appointment.getServerEndTime() == null ? "" : appointment.getServerEndTime());
        QueryWrapper wrapperJunk = (QueryWrapper)new QueryWrapper().eq((Object)"appointment_id", (Object)appointment.getViewId());
        Integer junkCount = this.appointmentJunkMapper.selectCount((Wrapper)wrapperJunk);
        appointmentDetailDto.setIsJunk(Integer.valueOf(junkCount > 0 ? 1 : 0));
        Orders order = (Orders)this.orderMapper.selectById((Serializable)appointment.getServiceOrderId());
        appointmentDetailDto.setPatientName(DesensitizationUtil.nameDesensitization((String)order.getPatientName()));
        appointmentDetailDto.setPatientSex(order.getPatientSex());
        appointmentDetailDto.setPatientAge(order.getPatientAge());
        appointmentDetailDto.setPatientRelation(order.getPatientRelation());
        appointmentDetailDto.setPatientPhone(order.getPatientPhone());
        appointmentDetailDto.setMedicalCertificate(order.getMedicalCertificate());
        UserAddress userAddress = (UserAddress)this.userAddressMapper.selectById((Serializable)order.getUserAddressId());
        appointmentDetailDto.setAddress(userAddress.getAddress());
        appointmentDetailDto.setCustomAddress(userAddress.getCustomAddress());
        try {
            double distance = DistanceUtil.distance((double)userAddress.getLongitude(), (double)userAddress.getLatitude(), (double)appointmentDetailVo.getLongitude(), (double)appointmentDetailVo.getLatitude());
            appointmentDetailDto.setDistance(Double.valueOf(distance / 1000.0));
        }
        catch (Exception e) {
            log.error("\u8ba1\u7b97\u8ddd\u79bb\u51fa\u9519");
        }
        Product product = this.productMapper.queryById(order.getProductId());
        appointmentDetailDto.setProductName(product.getName());
        ProductSubitem productSubitem = this.productSubitemMapper.queryById(order.getProductSubitemId());
        appointmentDetailDto.setMaterialName(productSubitem.getMaterialName());
        MaterialPackage materialPackage = this.materialPackageMapper.queryById(productSubitem.getMaterialId());
        appointmentDetailDto.setMaterialName(materialPackage.getName());
        Boolean hasSurvey = Objects.nonNull(product.getFormServiceId());
        appointmentDetailDto.setHasSurvey(hasSurvey);
        ArrayList<AppointmentDetailMaterialDto> appointmentDetailMaterialDtos = new ArrayList<AppointmentDetailMaterialDto>();
        MaterialItem param = new MaterialItem();
        param.setMaterialPackageId(materialPackage.getId());
        List materialItems = this.materialItemMapper.queryList(param);
        for (MaterialItem materialItem : materialItems) {
            AppointmentDetailMaterialDto appointmentDetailMaterialDto = new AppointmentDetailMaterialDto();
            appointmentDetailMaterialDto.setName(materialItem.getName());
            appointmentDetailMaterialDto.setQuantity(materialItem.getQuantity());
            appointmentDetailMaterialDtos.add(appointmentDetailMaterialDto);
        }
        appointmentDetailDto.setAppointmentDetailMaterialList(appointmentDetailMaterialDtos);
        List appointmentHistoryList = this.appointmentMapper.selectListByPatientIdStatus(order.getPatientId(), AppointmentStatusEnum.APPOINTMENT_STATUS_FWJS.getValue(), appointmentDetailVo.getViewId());
        ArrayList<PatientHistoryNursingDto> patientHistoryNursingDtoList = new ArrayList<PatientHistoryNursingDto>();
        if (CollectionUtils.isNotEmpty((Collection)appointmentHistoryList)) {
            for (Appointment appointmentHistory : appointmentHistoryList) {
                PatientHistoryNursingDto patientHistoryNursingDto = new PatientHistoryNursingDto();
                patientHistoryNursingDto.setAppointmentViewId(appointmentHistory.getViewId());
                patientHistoryNursingDto.setDoctorName(appointmentHistory.getDoctorName());
                patientHistoryNursingDto.setServerBeginTime(appointmentHistory.getServerBeginTime());
                Orders orderHistory = (Orders)this.orderMapper.selectById((Serializable)appointmentHistory.getServiceOrderId());
                Product productHistory = this.productMapper.queryById(orderHistory.getProductId());
                patientHistoryNursingDto.setProductName(productHistory.getName());
                patientHistoryNursingDtoList.add(patientHistoryNursingDto);
            }
        }
        appointmentDetailDto.setPatientHistoryNursingDtoList(patientHistoryNursingDtoList);
        return appointmentDetailDto;
    }

    public QueryAppointmentToUserDto getAppointmentToUser(String appointmentViewId) {
        QueryAppointmentToUserDto queryAppointmentToUserDto = new QueryAppointmentToUserDto();
        Appointment appointment = (Appointment)this.appointmentMapper.selectOne((Wrapper)new QueryWrapper().eq((Object)"view_id", (Object)appointmentViewId));
        BeanUtils.copyProperties((Object)appointment, (Object)queryAppointmentToUserDto);
        queryAppointmentToUserDto.setAppointmentId(appointment.getId());
        Orders order = (Orders)this.orderMapper.selectById((Serializable)appointment.getServiceOrderId());
        BeanUtils.copyProperties((Object)order, (Object)queryAppointmentToUserDto);
        UserAddress userAddress = (UserAddress)this.userAddressMapper.selectById((Serializable)order.getUserAddressId());
        BeanUtils.copyProperties((Object)userAddress, (Object)queryAppointmentToUserDto);
        queryAppointmentToUserDto.setViewId(appointment.getViewId());
        queryAppointmentToUserDto.setCreateTime(appointment.getCreateTime());
        queryAppointmentToUserDto.setUpdateTime(appointment.getUpdateTime());
        queryAppointmentToUserDto.setStatus(appointment.getStatus());
        queryAppointmentToUserDto.setStatusDescribe(appointment.getStatusDescribe());
        BaseResponse baseResponse = this.evaluationFeignClient.getDoctorEvaluationMsg("", ServerCodeEnum.hlzh.name(), appointment.getViewId(), null);
        if (null != baseResponse && null != baseResponse.getData() && ((List)baseResponse.getData()).size() > 0) {
            UcUserEvaluationVO ucUserEvaluationVO = (UcUserEvaluationVO)((List)baseResponse.getData()).get(0);
            UserEvaluationVO userEvaluationVO = new UserEvaluationVO();
            BeanUtils.copyProperties((Object)ucUserEvaluationVO, (Object)userEvaluationVO);
            queryAppointmentToUserDto.setUserEvaluationVO(userEvaluationVO);
        }
        return queryAppointmentToUserDto;
    }

    public List<String> appointmentServerDate(AppointmentServerDateVo appointmentServerDate) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.in((Object)"status", new Object[]{AppointmentStatusEnum.APPOINTMENT_STATUS_DSH.getValue(), AppointmentStatusEnum.APPOINTMENT_STATUS_DFW.getValue(), AppointmentStatusEnum.APPOINTMENT_STATUS_FWZ.getValue(), AppointmentStatusEnum.APPOINTMENT_STATUS_FWJS.getValue(), AppointmentStatusEnum.APPOINTMENT_STATUS_YQX.getValue()});
        queryWrapper.eq((Object)"doctor_id", (Object)appointmentServerDate.getDoctorId());
        List appointmentList = this.appointmentMapper.selectList((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty((Collection)appointmentList)) {
            return new ArrayList<String>();
        }
        List collect = appointmentList.stream().map(Appointment::getId).collect(Collectors.toList());
        String[] res = appointmentServerDate.getAppointmentYearMonth().split("-");
        String appointmentYear = res[0];
        String appointmentMonth = res[1];
        List list = this.appointmentMapper.appointmentServerDate(appointmentServerDate.getAppCode(), collect, appointmentYear, appointmentMonth);
        return list;
    }

    public List<AppointmentConditionDto> appointmentConditionList(AppointmentConditionVo appointmentConditionVo) {
        ArrayList<AppointmentConditionDto> list = new ArrayList<AppointmentConditionDto>();
        Page page = new Page();
        page.setCurrent(appointmentConditionVo.getPageIndex().longValue());
        page.setSize(appointmentConditionVo.getPageSize().longValue());
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.in((Object)"status", new Object[]{appointmentConditionVo.getAppointmentStatus()});
        queryWrapper.eq((Object)"doctor_id", (Object)appointmentConditionVo.getDoctorId());
        queryWrapper.orderByDesc((Object)"create_time");
        Page appointmentPage = (Page)this.appointmentMapper.selectPage((IPage)page, (Wrapper)queryWrapper);
        List appointmentList = appointmentPage.getRecords();
        for (Appointment appointment : appointmentList) {
            AppointmentConditionDto appointmentConditionDto = new AppointmentConditionDto();
            appointmentConditionDto.setAppointmentStatus(appointment.getStatus());
            appointmentConditionDto.setAppointmentTime(appointment.getAppointmentTime());
            appointmentConditionDto.setAppointmentViewId(appointment.getViewId());
            appointmentConditionDto.setAppointmentCommunicate(appointment.getCommunicate());
            Orders order = (Orders)this.orderMapper.selectById((Serializable)appointment.getServiceOrderId());
            appointmentConditionDto.setPatientName(DesensitizationUtil.nameDesensitization((String)order.getPatientName()));
            appointmentConditionDto.setPatientSex(order.getPatientSex());
            appointmentConditionDto.setPatientAge(order.getPatientAge());
            appointmentConditionDto.setPatientRelation(order.getPatientRelation());
            appointmentConditionDto.setPatientPhone(order.getPatientPhone());
            Product product = this.productMapper.queryById(order.getProductId());
            appointmentConditionDto.setProductName(product.getName());
            ProductSubitem productSubitem = this.productSubitemMapper.queryById(order.getProductSubitemId());
            appointmentConditionDto.setMaterialName(productSubitem.getMaterialName());
            appointmentConditionDto.setSpecificationValueName(productSubitem.getSpecificationValueName());
            UserAddress userAddress = (UserAddress)this.userAddressMapper.selectById((Serializable)order.getUserAddressId());
            appointmentConditionDto.setAddress(userAddress.getAddress());
            appointmentConditionDto.setCustomAddress(userAddress.getCustomAddress());
            appointmentConditionDto.setLongitude(userAddress.getLongitude());
            appointmentConditionDto.setLatitude(userAddress.getLatitude());
            try {
                double distance = DistanceUtil.distance((double)userAddress.getLongitude(), (double)userAddress.getLatitude(), (double)appointmentConditionVo.getLongitude(), (double)appointmentConditionVo.getLatitude());
                appointmentConditionDto.setDistance(Double.valueOf(distance / 1000.0));
            }
            catch (Exception e) {
                log.error("\u8ba1\u7b97\u8ddd\u79bb\u51fa\u9519");
            }
            list.add(appointmentConditionDto);
        }
        if (CollectionUtils.isNotEmpty(list)) {
            return list;
        }
        return new ArrayList<AppointmentConditionDto>();
    }

    public String manageAuditAppointment(String appointmentViewId) {
        Appointment appointment = (Appointment)this.appointmentMapper.selectOne((Wrapper)new QueryWrapper().eq((Object)"view_id", (Object)appointmentViewId));
        if (Objects.isNull(appointment)) {
            return "\u8981\u5ba1\u6838\u7684\u8ba2\u5355\u4e0d\u5b58\u5728";
        }
        appointment.setStatus(AppointmentStatusEnum.APPOINTMENT_STATUS_DFW.getValue());
        appointment.setStatusDescribe(AppointmentStatusDescribeUserEnum.STATUS_USER_DFW.getDisplay());
        this.appointmentMapper.update((Object)appointment, (Wrapper)new QueryWrapper().eq((Object)"view_id", (Object)appointmentViewId));
        return "\u8ba2\u5355\u5ba1\u6838\u901a\u8fc7\u5b8c\u6210";
    }

    public String manageNotAuditAppointment(ManageNotAuditAppointmentVo manageNotAuditAppointmentVo) {
        Appointment appointment = (Appointment)this.appointmentMapper.selectOne((Wrapper)new QueryWrapper().eq((Object)"view_id", (Object)manageNotAuditAppointmentVo.getAppointmentViewId()));
        if (Objects.isNull(appointment)) {
            return "\u8981\u9000\u6b3e\u7684\u8ba2\u5355\u4e0d\u5b58\u5728";
        }
        appointment.setStatus(AppointmentStatusEnum.APPOINTMENT_STATUS_YQX.getValue());
        appointment.setStatusDescribe("\u62a4\u58eb\u5df2\u4e3a\u60a8\u9000\u6b3e\uff0c\u672c\u6b21\u670d\u52a1\u5c06\u4e3a\u60a8\u5168\u989d\u9000\u6b3e");
        appointment.setReason(manageNotAuditAppointmentVo.getReason());
        this.appointmentMapper.update((Object)appointment, (Wrapper)new QueryWrapper().eq((Object)"view_id", (Object)manageNotAuditAppointmentVo.getAppointmentViewId()));
        Orders order = (Orders)this.orderMapper.selectById((Serializable)appointment.getServiceOrderId());
        Orders orderDb = new Orders();
        orderDb.setId(order.getId());
        orderDb.setStatus(OrderStatusEnum.ORDER_STATUS_YTK.getValue());
        orderDb.setStatusDescribe(OrderStatusDescribeEnum.STATUS_DOCTOR_YTK.getDisplay());
        orderDb.setServerResidueNum(Integer.valueOf(0));
        orderDb.setRefundPrice(order.getPrice());
        this.orderMapper.updateById((Object)orderDb);
        RefundVo refundVo = new RefundVo();
        refundVo.setAppCode(manageNotAuditAppointmentVo.getAppCode());
        refundVo.setPrice(order.getPrice());
        refundVo.setOrderViewId(order.getViewId());
        Boolean refund = this.payService.refund(refundVo);
        if (!refund.booleanValue()) {
            throw new RuntimeException("\u9000\u6b3e\u5931\u8d25");
        }
        return "\u8ba2\u5355\u5ba1\u6838\u4e0d\u901a\u8fc7";
    }

    public String manageDistributionNurse(ManageDistributionNurseVo manageDistributionNurseVo) {
        Appointment appointment = (Appointment)this.appointmentMapper.selectOne((Wrapper)new QueryWrapper().eq((Object)"view_id", (Object)manageDistributionNurseVo.getAppointmentViewId()));
        if (Objects.isNull(appointment)) {
            return "\u8981\u5206\u914d\u7684\u8ba2\u5355\u4e0d\u5b58\u5728";
        }
        if (AppointmentStatusEnum.APPOINTMENT_STATUS_DFW.getValue() < appointment.getStatus()) {
            return "\u8ba2\u5355\u65e0\u6cd5\u88ab\u5206\u914d";
        }
        Long oldDocId = appointment.getDoctorId();
        Long oldDocHosId = appointment.getDoctorOrganId();
        BeanUtils.copyProperties((Object)manageDistributionNurseVo, (Object)appointment);
        int update = this.appointmentMapper.update((Object)appointment, (Wrapper)new QueryWrapper().eq((Object)"view_id", (Object)manageDistributionNurseVo.getAppointmentViewId()));
        if (update == 1) {
            try {
                String userId;
                if (oldDocId != null && oldDocId.intValue() != 0 && oldDocId.intValue() != manageDistributionNurseVo.getDoctorId().intValue()) {
                    log.info("\u5df2\u5728\u670d\u52a1\u533a\u7684\u5355\u5b50\u88ab\u5206\u914d\u8d70");
                    userId = PushParamUtil.getUserIdByDoctorId((Long)oldDocId, (String)oldDocHosId.toString());
                    this.appWebPushService.manageDistributionWalk(userId, ComponentConstant.APP_CODE, appointment.getAppointmentTime(), manageDistributionNurseVo.getDoctorName());
                }
                log.info("\u7ba1\u7406\u5458\u65b0\u5206\u914d\u4e86\u4e00\u4e2a\u5355\u5b50");
                userId = PushParamUtil.getUserIdByDoctorId((Long)manageDistributionNurseVo.getDoctorId(), (String)manageDistributionNurseVo.getDoctorOrganId().toString());
                this.appWebPushService.manageDistribution(userId, ComponentConstant.APP_CODE, appointment.getAppointmentTime());
            }
            catch (Exception e) {
                log.info("\u7ba1\u7406\u5458\u5206\u914d\u8ba2\u5355APP\u63a8\u9001\u9519\u8bef");
            }
            return "\u5206\u914d\u6210\u529f";
        }
        return "\u8ba2\u5355\u5df2\u5206\u914d\u5931\u8d25";
    }

    public HistoryNursingDetailDto patientHistoryNursing(HistoryNursingDetailVo historyNursingDetailVo) {
        HistoryNursingDetailDto historyNursingDetailDto = new HistoryNursingDetailDto();
        QueryWrapper wrapper = (QueryWrapper)new QueryWrapper().eq((Object)"view_id", (Object)historyNursingDetailVo.getAppointmentViewId());
        Appointment appointment = (Appointment)this.appointmentMapper.selectOne((Wrapper)wrapper);
        historyNursingDetailDto.setAppointmentStatus(appointment.getStatus());
        historyNursingDetailDto.setAppointmentTime(appointment.getAppointmentTime());
        historyNursingDetailDto.setAppointmentViewId(appointment.getViewId());
        historyNursingDetailDto.setAppointmentCommunicate(appointment.getCommunicate());
        historyNursingDetailDto.setAppointmentArchivesBefore(appointment.getArchivesBefore() == null ? "" : appointment.getArchivesBefore());
        historyNursingDetailDto.setAppointmentArchivesAfter(appointment.getArchivesAfter() == null ? "" : appointment.getArchivesAfter());
        historyNursingDetailDto.setAppointmentNursingSummary(appointment.getNursingSummary() == null ? "" : appointment.getNursingSummary());
        historyNursingDetailDto.setAppointmentRemark(appointment.getRemark());
        historyNursingDetailDto.setAppointmentStatusDescribe(appointment.getStatusDescribe());
        if (AppointmentStatusEnum.APPOINTMENT_STATUS_YQX.getValue().equals(appointment.getStatus())) {
            historyNursingDetailDto.setAppointmentStatusDescribe(AppointmentStatusDescribeDoctorEnum.getAppointmentStatusDescribeDoctorEnum((Integer)AppointmentStatusEnum.APPOINTMENT_STATUS_YQX.getValue()).getDisplay());
        }
        historyNursingDetailDto.setAppointmentStatusDescribe(appointment.getRemark());
        historyNursingDetailDto.setAppointmentServerBeginTime(appointment.getServerBeginTime() == null ? "" : appointment.getServerBeginTime());
        historyNursingDetailDto.setAppointmentServerEndTime(appointment.getServerEndTime() == null ? "" : appointment.getServerEndTime());
        Orders order = (Orders)this.orderMapper.selectById((Serializable)appointment.getServiceOrderId());
        historyNursingDetailDto.setPatientName(DesensitizationUtil.nameDesensitization((String)order.getPatientName()));
        historyNursingDetailDto.setPatientSex(order.getPatientSex());
        historyNursingDetailDto.setPatientAge(order.getPatientAge());
        historyNursingDetailDto.setPatientRelation(order.getPatientRelation());
        historyNursingDetailDto.setPatientPhone(order.getPatientPhone());
        historyNursingDetailDto.setMedicalCertificate(order.getMedicalCertificate());
        UserAddress userAddress = (UserAddress)this.userAddressMapper.selectById((Serializable)order.getUserAddressId());
        historyNursingDetailDto.setAddress(userAddress.getAddress());
        historyNursingDetailDto.setCustomAddress(userAddress.getCustomAddress());
        try {
            double distance = DistanceUtil.distance((double)userAddress.getLongitude(), (double)userAddress.getLatitude(), (double)historyNursingDetailVo.getLongitude(), (double)historyNursingDetailVo.getLatitude());
            historyNursingDetailDto.setDistance(Double.valueOf(distance / 1000.0));
        }
        catch (Exception e) {
            log.error("\u8ba1\u7b97\u8ddd\u79bb\u51fa\u9519");
        }
        Product product = this.productMapper.queryById(order.getProductId());
        historyNursingDetailDto.setProductName(product.getName());
        ProductSubitem productSubitem = this.productSubitemMapper.queryById(order.getProductSubitemId());
        historyNursingDetailDto.setMaterialName(productSubitem.getMaterialName());
        MaterialPackage materialPackage = this.materialPackageMapper.queryById(productSubitem.getMaterialId());
        historyNursingDetailDto.setMaterialName(materialPackage.getName());
        ArrayList<AppointmentDetailMaterialDto> appointmentDetailMaterialDtos = new ArrayList<AppointmentDetailMaterialDto>();
        MaterialItem param = new MaterialItem();
        param.setMaterialPackageId(materialPackage.getId());
        List materialItems = this.materialItemMapper.queryList(param);
        for (MaterialItem materialItem : materialItems) {
            AppointmentDetailMaterialDto appointmentDetailMaterialDto = new AppointmentDetailMaterialDto();
            appointmentDetailMaterialDto.setName(materialItem.getName());
            appointmentDetailMaterialDto.setQuantity(materialItem.getQuantity());
            appointmentDetailMaterialDtos.add(appointmentDetailMaterialDto);
        }
        historyNursingDetailDto.setAppointmentDetailMaterialList(appointmentDetailMaterialDtos);
        return historyNursingDetailDto;
    }

    private String getDate() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return simpleDateFormat.format(new Date());
    }

    @Transactional(rollbackFor={Exception.class})
    public void refundAppointment(String appointmentViewId, String statusDisplay, BigDecimal refundPrice, int refundCount) {
        Appointment appointment = (Appointment)this.appointmentMapper.selectOne((Wrapper)new QueryWrapper().eq((Object)"view_id", (Object)appointmentViewId));
        appointment.setStatus(AppointmentStatusEnum.APPOINTMENT_STATUS_YQX.getValue());
        appointment.setStatusDescribe(statusDisplay);
        this.appointmentMapper.update((Object)appointment, (Wrapper)new QueryWrapper().eq((Object)"view_id", (Object)appointmentViewId));
        Orders order = (Orders)this.orderMapper.selectById((Serializable)appointment.getServiceOrderId());
        order.setRefundPrice(order.getRefundPrice().add(refundPrice));
        order.setServerResidueNum(Integer.valueOf(order.getServerResidueNum() + refundCount));
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        arrayList.add(AppointmentStatusEnum.APPOINTMENT_STATUS_DFW.getValue());
        arrayList.add(AppointmentStatusEnum.APPOINTMENT_STATUS_FWZ.getValue());
        List appointmentList = this.appointmentMapper.selectList((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"service_order_id", (Object)order.getId())).in((Object)"status", arrayList));
        if (0 == refundCount && 0 == order.getServerResidueNum() && appointmentList.size() < 1) {
            order.setStatus(OrderStatusEnum.ORDER_STATUS_YWC.getValue());
            order.setStatusDescribe(OrderStatusDescribeEnum.STATUS_YWC.getDisplay());
        }
        if (0 == refundCount && 1 == order.getServerTotalNum()) {
            order.setStatus(OrderStatusEnum.ORDER_STATUS_YTK.getValue());
            order.setStatusDescribe(OrderStatusDescribeEnum.STATUS_USER_YTK.getDisplay());
        }
        if (0 != refundCount && OrderStatusEnum.ORDER_STATUS_YGQ.getValue().equals(order.getStatus())) {
            order.setServerResidueNum(Integer.valueOf(0));
        }
        this.orderMapper.updateById((Object)order);
    }

    static /* synthetic */ DoctorPoolMapper access$000(AppointmentServiceImpl x0) {
        return x0.doctorPoolMapper;
    }

    static /* synthetic */ AppWebPushService access$100(AppointmentServiceImpl x0) {
        return x0.appWebPushService;
    }
}

