/*
 * Decompiled with CFR 0.152.
 */
package com.byh.nursingcarenewserver.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.byh.nursingcarenewserver.config.GlobalConfig;
import com.byh.nursingcarenewserver.config.HospitalConfig;
import com.byh.nursingcarenewserver.mapper.CartItemMapper;
import com.byh.nursingcarenewserver.mapper.ProductSubitemMapper;
import com.byh.nursingcarenewserver.pojo.dto.QueryCartDto;
import com.byh.nursingcarenewserver.pojo.dto.QueryCartItemDto;
import com.byh.nursingcarenewserver.pojo.entity.Cart;
import com.byh.nursingcarenewserver.pojo.entity.CartItem;
import com.byh.nursingcarenewserver.pojo.entity.ProductSubitem;
import com.byh.nursingcarenewserver.pojo.vo.QueryCartItemVo;
import com.byh.nursingcarenewserver.pojo.vo.SaveCartItemVo;
import com.byh.nursingcarenewserver.service.CartItemService;
import com.byh.nursingcarenewserver.service.CartService;
import com.byh.nursingcarenewserver.utils.DistanceUtil;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class CartItemServiceImpl
extends ServiceImpl<CartItemMapper, CartItem>
implements CartItemService {
    private static final Logger log = LoggerFactory.getLogger(CartItemServiceImpl.class);
    @Autowired
    private CartService cartService;
    @Autowired
    private CartItemMapper cartItemMapper;
    @Autowired
    private ProductSubitemMapper productSubitemMapper;

    public QueryCartDto selectCartItemByUser(QueryCartItemVo queryCartItemVo) {
        QueryCartDto queryCartDto = new QueryCartDto();
        Cart cart = this.cartService.saveCart(queryCartItemVo.getUserId());
        List cartItemList = this.cartItemMapper.selectList((Wrapper)new QueryWrapper().eq((Object)"cart_id", (Object)cart.getId()));
        if (CollectionUtils.isEmpty((Collection)cartItemList)) {
            return queryCartDto;
        }
        double distance = 0.0;
        if (queryCartItemVo.getLat() != null && queryCartItemVo.getLng() != null) {
            distance = DistanceUtil.distance((double)queryCartItemVo.getLat(), (double)queryCartItemVo.getLng(), (double)HospitalConfig.HOS_LAT, (double)HospitalConfig.HOS_LNG);
        }
        Object[] objects = CartItemServiceImpl.getDisTypeAndPrice((double)distance);
        queryCartDto.setIsDistribution(Integer.valueOf(Integer.parseInt(String.valueOf(objects[0]))));
        BigDecimal tripPrice = new BigDecimal(String.valueOf(objects[1]));
        ArrayList<QueryCartItemDto> queryCartItemDtoList = new ArrayList<QueryCartItemDto>();
        for (CartItem cartItem : cartItemList) {
            QueryCartItemDto queryCartItemDto = new QueryCartItemDto();
            ProductSubitem productSubitem = (ProductSubitem)this.productSubitemMapper.selectById((Serializable)cartItem.getProductSubitemId());
            BeanUtils.copyProperties((Object)cartItem, (Object)queryCartItemDto);
            BeanUtils.copyProperties((Object)productSubitem, (Object)queryCartItemDto);
            queryCartItemDto.setCartItemId(cartItem.getId());
            queryCartItemDto.setTotalPrice(productSubitem.getPrice().multiply(new BigDecimal(cartItem.getQuantity())));
            queryCartItemDto.setTripPrice(tripPrice.multiply(new BigDecimal(cartItem.getQuantity())));
            queryCartItemDtoList.add(queryCartItemDto);
        }
        queryCartDto.setQueryCartItemDtoList(queryCartItemDtoList);
        return queryCartDto;
    }

    public static Object[] getDisTypeAndPrice(double distance) {
        Object[] objects = new Object[2];
        BigDecimal tripPrice = new BigDecimal("0");
        if (distance != 0.0) {
            if (distance > HospitalConfig.TEN_KM) {
                objects[0] = 3;
            } else if (distance < HospitalConfig.FIVE_KM) {
                objects[0] = 1;
            } else {
                objects[0] = 2;
                if ("YCRMYY".equalsIgnoreCase(GlobalConfig.configAppCodeStatic)) {
                    if (distance < 5000.0) {
                        tripPrice = new BigDecimal("24.00");
                    } else if (distance >= 5000.0 && distance < 15000.0) {
                        tripPrice = new BigDecimal("75.00");
                    } else if (distance >= 15000.0 && distance < 40000.0) {
                        tripPrice = new BigDecimal("210.00");
                    }
                } else {
                    BigDecimal subtract = BigDecimal.valueOf(distance).subtract(new BigDecimal(HospitalConfig.FIVE_KM)).divide(new BigDecimal("1000"), 0, RoundingMode.HALF_UP);
                    tripPrice = tripPrice.add(subtract.multiply(new BigDecimal(HospitalConfig.BAS_TRIP)));
                }
            }
        }
        objects[1] = tripPrice;
        return objects;
    }

    @Transactional(rollbackFor={Exception.class})
    public String saveCartItem(SaveCartItemVo saveCartItemVo) {
        Cart cart = this.cartService.saveCart(saveCartItemVo.getUserId());
        CartItem cartItem = new CartItem();
        cartItem.setCartId(cart.getId().toString());
        cartItem.setQuantity(saveCartItemVo.getQuantity());
        cartItem.setProductSubitemId(saveCartItemVo.getProductSubitemId());
        cartItem.setProductId(saveCartItemVo.getProductId());
        int insert = this.cartItemMapper.insert((Object)cartItem);
        return "\u5546\u54c1\u6dfb\u52a0\u6210\u529f";
    }

    public String deleteCartItem(List<Long> cartItemIdList) {
        this.cartItemMapper.deleteBatchIds(cartItemIdList);
        return "\u5546\u54c1\u5220\u9664\u6210\u529f";
    }

    public void updateCartItemCount(Long cartItemId, int count) {
        CartItem cartItem = new CartItem();
        cartItem.setQuantity(Integer.valueOf(count));
        this.cartItemMapper.update((Object)cartItem, (Wrapper)new UpdateWrapper().eq((Object)"id", (Object)cartItemId));
    }
}

