/*
 * Decompiled with CFR 0.152.
 */
package com.byh.nursingcarenewserver.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.byh.nursingcarenewserver.common.execption.BusinessException;
import com.byh.nursingcarenewserver.config.GlobalConfig;
import com.byh.nursingcarenewserver.config.HospitalConfig;
import com.byh.nursingcarenewserver.mapper.AppointmentMapper;
import com.byh.nursingcarenewserver.mapper.CartItemMapper;
import com.byh.nursingcarenewserver.mapper.MaterialItemMapper;
import com.byh.nursingcarenewserver.mapper.OrderAppointmentMapper;
import com.byh.nursingcarenewserver.mapper.OrderMapper;
import com.byh.nursingcarenewserver.mapper.ProductMapper;
import com.byh.nursingcarenewserver.mapper.ProductSubitemMapper;
import com.byh.nursingcarenewserver.mapper.UserAddressMapper;
import com.byh.nursingcarenewserver.pojo.dto.DetailOrderAddressDto;
import com.byh.nursingcarenewserver.pojo.dto.DetailOrderDto;
import com.byh.nursingcarenewserver.pojo.dto.DetailOrderInfoDto;
import com.byh.nursingcarenewserver.pojo.dto.DetailOrderProducMaterialDto;
import com.byh.nursingcarenewserver.pojo.dto.DetailOrderProductDto;
import com.byh.nursingcarenewserver.pojo.dto.DetailOrderUseRecordDto;
import com.byh.nursingcarenewserver.pojo.dto.OrderListDto;
import com.byh.nursingcarenewserver.pojo.dto.OrderListPageDto;
import com.byh.nursingcarenewserver.pojo.dto.QueryAppointmentToUserDto;
import com.byh.nursingcarenewserver.pojo.dto.QueryOrderToUserDto;
import com.byh.nursingcarenewserver.pojo.entity.Appointment;
import com.byh.nursingcarenewserver.pojo.entity.MaterialItem;
import com.byh.nursingcarenewserver.pojo.entity.OrderAppointment;
import com.byh.nursingcarenewserver.pojo.entity.Orders;
import com.byh.nursingcarenewserver.pojo.entity.Product;
import com.byh.nursingcarenewserver.pojo.entity.ProductSubitem;
import com.byh.nursingcarenewserver.pojo.entity.UserAddress;
import com.byh.nursingcarenewserver.pojo.enums.AppointmentStatusDescribeUserEnum;
import com.byh.nursingcarenewserver.pojo.enums.AppointmentStatusEnum;
import com.byh.nursingcarenewserver.pojo.enums.OrderStatusDescribeEnum;
import com.byh.nursingcarenewserver.pojo.enums.OrderStatusEnum;
import com.byh.nursingcarenewserver.pojo.vo.DeleteOrderVo;
import com.byh.nursingcarenewserver.pojo.vo.DoctorRefundOrderVo;
import com.byh.nursingcarenewserver.pojo.vo.OrderListVo;
import com.byh.nursingcarenewserver.pojo.vo.QueryOrderToUserVo;
import com.byh.nursingcarenewserver.pojo.vo.RefundVo;
import com.byh.nursingcarenewserver.pojo.vo.SaveOrderProductVo;
import com.byh.nursingcarenewserver.pojo.vo.SaveOrderVo;
import com.byh.nursingcarenewserver.service.OrderService;
import com.byh.nursingcarenewserver.service.PayService;
import com.byh.nursingcarenewserver.service.impl.CartItemServiceImpl;
import com.byh.nursingcarenewserver.utils.DateUtils;
import com.byh.nursingcarenewserver.utils.DistanceUtil;
import com.byh.nursingcarenewserver.utils.IDCardUtil;
import com.byh.nursingcarenewserver.utils.UniqueKeyGenerator;
import com.ebaiyihui.framework.response.BaseResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OrderServiceImpl
extends ServiceImpl<OrderMapper, Orders>
implements OrderService {
    private static final Logger log = LoggerFactory.getLogger(OrderServiceImpl.class);
    @Autowired
    private OrderMapper orderMapper;
    @Autowired
    private ProductSubitemMapper productSubitemMapper;
    @Autowired
    private AppointmentMapper appointmentMapper;
    @Autowired
    private UserAddressMapper userAddressMapper;
    @Autowired
    private CartItemMapper cartItemMapper;
    @Autowired
    private ProductMapper productMapper;
    @Autowired
    private PayService payService;
    @Autowired
    private MaterialItemMapper materialItemMapper;
    @Autowired
    private OrderAppointmentMapper orderAppointmentMapper;
    @Autowired
    private GlobalConfig globalConfig;

    @Transactional(rollbackFor={Exception.class})
    public String saveOrder(SaveOrderVo saveOrderVo) {
        log.info("\u8fdb\u5165\u4e0b\u5355");
        String uuid = UniqueKeyGenerator.generateUUID();
        UserAddress userAddress = (UserAddress)this.userAddressMapper.selectById((Serializable)saveOrderVo.getUserAddressId());
        String orderViewId = "";
        for (SaveOrderProductVo saveOrderProductVo : saveOrderVo.getSaveOrderProductVoList()) {
            ProductSubitem productSubitem = (ProductSubitem)this.productSubitemMapper.selectById((Serializable)saveOrderProductVo.getProductSubitemId());
            Orders order = new Orders();
            BeanUtils.copyProperties((Object)saveOrderVo, (Object)order);
            BeanUtils.copyProperties((Object)saveOrderProductVo, (Object)order);
            order.setPatientSex(Integer.valueOf(IDCardUtil.gender((String)saveOrderVo.getPatientIdCard())));
            double distance = 0.0;
            if (userAddress.getLatitude() != null && userAddress.getLongitude() != null) {
                distance = DistanceUtil.distance((double)userAddress.getLatitude(), (double)userAddress.getLongitude(), (double)HospitalConfig.HOS_LAT, (double)HospitalConfig.HOS_LNG);
                log.info("\u8ddd\u79bb\u4e3a\uff1a{}", (Object)distance);
            }
            BigDecimal tripPrice = new BigDecimal("0");
            if (distance != 0.0) {
                Object[] objects = CartItemServiceImpl.getDisTypeAndPrice((double)distance);
                if (Integer.valueOf(3).equals(objects[0])) {
                    throw new BusinessException("\u5730\u5740\u8d85\u51fa\u914d\u9001\u8ddd\u79bb,\u8bf7\u91cd\u65b0\u9009\u62e9");
                }
                tripPrice = new BigDecimal(String.valueOf(objects[1]));
            }
            order.setRoadPrice(tripPrice.multiply(new BigDecimal(saveOrderProductVo.getQuantity())));
            log.info("\u8d2d\u4e70{}\u6b21\uff0c\u8def\u8d39\u4e3a{}", (Object)saveOrderProductVo.getQuantity(), (Object)order.getRoadPrice());
            order.setPackagePrice(productSubitem.getPrice().multiply(new BigDecimal(saveOrderProductVo.getQuantity())));
            log.info("\u8d2d\u4e70{}\u6b21\uff0c\u670d\u52a1\u5305\u4ef7\u683c\u4e3a{}", (Object)saveOrderProductVo.getQuantity(), (Object)order.getPackagePrice());
            order.setPrice(order.getRoadPrice().add(order.getPackagePrice()));
            log.info("\u603b\u4ef7\u683c\u4e3a{}", (Object)order.getPrice());
            int totalNum = saveOrderProductVo.getQuantity() * productSubitem.getServiceTimes();
            order.setServerTotalNum(Integer.valueOf(totalNum));
            order.setServerResidueNum(Integer.valueOf(totalNum - 1));
            order.setRefundPrice(new BigDecimal("0"));
            order.setSame(uuid);
            order.setViewId(UniqueKeyGenerator.generateViewId().toString());
            order.setStatus(OrderStatusEnum.ORDER_STATUS_SYZ.getValue());
            order.setStatusDescribe(OrderStatusDescribeEnum.getOrderStatusDescribeEnum((Integer)OrderStatusEnum.ORDER_STATUS_SYZ.getValue()).getDisplay());
            this.orderMapper.insertOrder(order);
            orderViewId = order.getViewId();
            OrderAppointment orderAppointment = new OrderAppointment();
            orderAppointment.setOrderId(order.getId());
            orderAppointment.setAppointmentTime(saveOrderProductVo.getAppointmentTime());
            orderAppointment.setRemark(saveOrderProductVo.getRemark());
            this.orderAppointmentMapper.insert((Object)orderAppointment);
        }
        return orderViewId;
    }

    public OrderListPageDto getListOrder(OrderListVo orderListVo) {
        OrderListPageDto result = new OrderListPageDto();
        Page orderPage = new Page();
        orderPage.setSize(orderListVo.getPageSize().longValue());
        orderPage.setCurrent(orderListVo.getPageIndex().longValue());
        QueryWrapper orderQueryWrapper = new QueryWrapper();
        if (StringUtils.isNotEmpty((CharSequence)orderListVo.getSearch())) {
            orderQueryWrapper.like((Object)"patient_name", (Object)orderListVo.getSearch());
        }
        if (orderListVo.getOrderStatus() != null && orderListVo.getOrderStatus() != 0) {
            orderQueryWrapper.eq((Object)"status", (Object)orderListVo.getOrderStatus());
        }
        if (StringUtils.isNotEmpty((CharSequence)orderListVo.getCreateTimeBegin()) && StringUtils.isNotEmpty((CharSequence)orderListVo.getCreateTimeEnd())) {
            orderQueryWrapper.between((Object)"create_time", (Object)orderListVo.getCreateTimeBegin(), (Object)orderListVo.getCreateTimeEnd());
        }
        orderQueryWrapper.orderByDesc((Object)"create_time");
        Page orderPageResult = (Page)this.orderMapper.selectPage((IPage)orderPage, (Wrapper)orderQueryWrapper);
        List orderList = orderPageResult.getRecords();
        ArrayList<OrderListDto> orders = new ArrayList<OrderListDto>();
        for (Orders order : orderList) {
            OrderListDto orderListDto2 = new OrderListDto();
            orderListDto2.setOrderId(order.getId());
            orderListDto2.setOrderViewId(order.getViewId());
            orderListDto2.setCreateTime(order.getCreateTime());
            orderListDto2.setPatientName(order.getPatientName());
            orderListDto2.setPatientPhone(order.getPatientPhone());
            orderListDto2.setOrderStatus(order.getStatus());
            orders.add(orderListDto2);
        }
        Integer useNum = orders.stream().filter(orderListDto -> orderListDto.getOrderStatus().intValue() == OrderStatusEnum.ORDER_STATUS_SYZ.getValue().intValue()).collect(Collectors.toList()).size();
        result.setUseNum(useNum);
        result.setOrderListDtoList(orders);
        result.setPageIndex(orderListVo.getPageIndex());
        result.setPageSize(orderListVo.getPageSize());
        result.setPageNum(Long.valueOf(orderPage.getPages()));
        result.setTotal(Long.valueOf(orderPage.getTotal()));
        return result;
    }

    public DetailOrderDto detailOrder(String orderViewId) {
        DetailOrderDto detailOrderDto = new DetailOrderDto();
        QueryWrapper orderQueryWrapper = (QueryWrapper)new QueryWrapper().eq((Object)"view_id", (Object)orderViewId);
        Orders order = (Orders)this.orderMapper.selectOne((Wrapper)orderQueryWrapper);
        DetailOrderInfoDto detailOrderInfoDto = new DetailOrderInfoDto();
        detailOrderInfoDto.setCreateTime(order.getCreateTime());
        detailOrderInfoDto.setOrderViewId(order.getViewId());
        detailOrderInfoDto.setOrderStatus(order.getStatus());
        detailOrderInfoDto.setMedicalCertificate(order.getMedicalCertificate());
        detailOrderInfoDto.setServerResidueNum(order.getServerResidueNum());
        detailOrderInfoDto.setServerTotalNum(order.getServerTotalNum());
        detailOrderInfoDto.setPatientId(order.getPatientId());
        detailOrderInfoDto.setPatientName(order.getPatientName());
        detailOrderInfoDto.setPatientAge(order.getPatientAge());
        detailOrderInfoDto.setPatientSex(order.getPatientSex());
        detailOrderInfoDto.setPatientPhone(order.getPatientPhone());
        detailOrderInfoDto.setOrderPrice(order.getPrice());
        Product product = this.productMapper.queryById(order.getProductId());
        ProductSubitem productSubitem = this.productSubitemMapper.queryById(order.getProductSubitemId());
        Boolean hasSurvey = Objects.nonNull(product.getFormServiceId());
        detailOrderInfoDto.setHasSurvey(hasSurvey);
        detailOrderInfoDto.setFormServiceId(product.getFormServiceId());
        detailOrderDto.setDetailOrderInfoDto(detailOrderInfoDto);
        DetailOrderProductDto detailOrderProductDto = new DetailOrderProductDto();
        detailOrderProductDto.setProductId(product.getId());
        detailOrderProductDto.setProductName(product.getName());
        detailOrderProductDto.setProductImage(product.getImage());
        detailOrderProductDto.setMaterialName(productSubitem.getMaterialName());
        detailOrderProductDto.setSpecificationValueName(productSubitem.getSpecificationValueName());
        detailOrderProductDto.setUsefulLife(productSubitem.getUsefulLife());
        String date = DateUtils.dateToString((Date)order.getCreateTime());
        String plusDay = "";
        try {
            plusDay = DateUtils.plusDay((int)productSubitem.getUsefulLife(), (String)date);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        detailOrderProductDto.setExpireTime(plusDay);
        MaterialItem param = new MaterialItem();
        param.setMaterialPackageId(productSubitem.getMaterialId());
        List materialItems = this.materialItemMapper.queryList(param);
        ArrayList<DetailOrderProducMaterialDto> materialDtos = new ArrayList<DetailOrderProducMaterialDto>();
        if (CollectionUtils.isNotEmpty((Collection)materialItems)) {
            for (MaterialItem materialItem : materialItems) {
                DetailOrderProducMaterialDto detailOrderProducMaterialDto = new DetailOrderProducMaterialDto();
                detailOrderProducMaterialDto.setMaterialName(materialItem.getName());
                detailOrderProducMaterialDto.setMaterialQuantity(materialItem.getQuantity());
                materialDtos.add(detailOrderProducMaterialDto);
            }
        }
        detailOrderProductDto.setDetailOrderProducMaterialDtoList(materialDtos);
        detailOrderDto.setDetailOrderProductDto(detailOrderProductDto);
        UserAddress userAddress = (UserAddress)this.userAddressMapper.selectById((Serializable)order.getUserAddressId());
        DetailOrderAddressDto detailOrderAddressDto = new DetailOrderAddressDto();
        detailOrderAddressDto.setAddress(userAddress.getAddress());
        detailOrderAddressDto.setCustomAddress(userAddress.getCustomAddress());
        detailOrderDto.setDetailOrderAddressDto(detailOrderAddressDto);
        QueryWrapper appointmentQueryWrapper = (QueryWrapper)new QueryWrapper().eq((Object)"service_order_id", (Object)order.getId());
        List appointmentS = this.appointmentMapper.selectList((Wrapper)appointmentQueryWrapper);
        ArrayList<DetailOrderUseRecordDto> list = new ArrayList<DetailOrderUseRecordDto>();
        for (Appointment appointment : appointmentS) {
            DetailOrderUseRecordDto detailOrderUseRecordDto = new DetailOrderUseRecordDto();
            detailOrderUseRecordDto.setUseRecordViewId(appointment.getViewId());
            detailOrderUseRecordDto.setUseRecordStatus(appointment.getStatus());
            detailOrderUseRecordDto.setUseRecordAppointmentTime(appointment.getAppointmentTime());
            detailOrderUseRecordDto.setUseRecordDoctorId(appointment.getDoctorId());
            detailOrderUseRecordDto.setUseRecordDoctorName(appointment.getDoctorName());
            list.add(detailOrderUseRecordDto);
        }
        detailOrderDto.setDetailOrderUseRecordDto(list);
        return detailOrderDto;
    }

    public List<QueryOrderToUserDto> getListOrderToUser(QueryOrderToUserVo queryOrderToUserVo) {
        SimpleDateFormat sdf = new SimpleDateFormat("YYYY-MM-dd HH:mm:ss");
        ArrayList<QueryOrderToUserDto> queryOrderToUserDtoList = new ArrayList<QueryOrderToUserDto>();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"user_id", (Object)queryOrderToUserVo.getUserId());
        if (Objects.nonNull(queryOrderToUserVo.getOrderStatus())) {
            queryWrapper.eq((Object)"status", (Object)queryOrderToUserVo.getOrderStatus());
        }
        queryWrapper.orderByDesc((Object)"create_time");
        Page page = new Page(queryOrderToUserVo.getPageNum().longValue(), queryOrderToUserVo.getPageSize().longValue());
        IPage orderIPage = this.orderMapper.selectPage((IPage)page, (Wrapper)queryWrapper);
        for (Orders order : orderIPage.getRecords()) {
            QueryOrderToUserDto queryOrderToUserDto = new QueryOrderToUserDto();
            BeanUtils.copyProperties((Object)order, (Object)queryOrderToUserDto);
            queryOrderToUserDto.setOrderId(order.getId());
            ProductSubitem productSubitem = this.productSubitemMapper.queryById(order.getProductSubitemId());
            Product product = this.productMapper.queryById(productSubitem.getProductId());
            int day = new BigDecimal(productSubitem.getUsefulLife().toString()).multiply(new BigDecimal(order.getQuantity().toString())).intValue();
            String afterDate = DateUtils.getAfterDate((String)sdf.format(order.getCreateTime()), (int)day);
            queryOrderToUserDto.setValidityDate(afterDate);
            queryOrderToUserDto.setProductName(product.getName());
            queryOrderToUserDto.setProductImage(product.getImage());
            queryOrderToUserDto.setSpecificationValueName(productSubitem.getSpecificationValueName());
            queryOrderToUserDto.setMaterialName(productSubitem.getMaterialName());
            queryOrderToUserDtoList.add(queryOrderToUserDto);
        }
        return queryOrderToUserDtoList;
    }

    public QueryOrderToUserDto getOrderToUser(String orderViewId) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        QueryOrderToUserDto queryOrderToUserDto = new QueryOrderToUserDto();
        Orders order = (Orders)this.orderMapper.selectOne((Wrapper)new QueryWrapper().eq((Object)"view_id", (Object)orderViewId));
        BeanUtils.copyProperties((Object)order, (Object)queryOrderToUserDto);
        queryOrderToUserDto.setOrderId(order.getId());
        ProductSubitem productSubitem = this.productSubitemMapper.queryById(order.getProductSubitemId());
        Product product = this.productMapper.queryById(productSubitem.getProductId());
        Boolean hasSurvey = Objects.nonNull(product.getFormServiceId());
        queryOrderToUserDto.setHasSurvey(hasSurvey);
        int day = new BigDecimal(productSubitem.getUsefulLife().toString()).multiply(new BigDecimal(order.getQuantity().toString())).intValue();
        String afterDate = DateUtils.getAfterDate((String)sdf.format(order.getCreateTime()), (int)day);
        queryOrderToUserDto.setValidityDate(afterDate);
        UserAddress userAddress = (UserAddress)this.userAddressMapper.selectById((Serializable)order.getUserAddressId());
        BeanUtils.copyProperties((Object)userAddress, (Object)queryOrderToUserDto);
        queryOrderToUserDto.setViewId(order.getViewId());
        queryOrderToUserDto.setCreateTime(order.getCreateTime());
        queryOrderToUserDto.setUpdateTime(order.getUpdateTime());
        queryOrderToUserDto.setProductName(product.getName());
        queryOrderToUserDto.setProductImage(product.getImage());
        queryOrderToUserDto.setSpecificationValueName(productSubitem.getSpecificationValueName());
        queryOrderToUserDto.setMaterialName(productSubitem.getMaterialName());
        List appointmentList = this.appointmentMapper.selectList((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"service_order_id", (Object)order.getId())).orderByAsc((Object)"appointment_time"));
        for (Appointment appointment : appointmentList) {
            QueryAppointmentToUserDto queryAppointmentToUserDto = new QueryAppointmentToUserDto();
            BeanUtils.copyProperties((Object)appointment, (Object)queryAppointmentToUserDto);
            queryAppointmentToUserDto.setAppointmentId(appointment.getId());
            queryAppointmentToUserDto.setStatusDescribe(AppointmentStatusDescribeUserEnum.getAppointmentStatusDescribeUserEnum((Integer)appointment.getStatus()).getDisplay());
            if (StringUtils.isEmpty((CharSequence)queryOrderToUserDto.getRefundReason())) {
                queryOrderToUserDto.setRefundReason(appointment.getReason());
            }
            queryOrderToUserDto.getQueryAppointmentToUserDtoList().add(queryAppointmentToUserDto);
        }
        return queryOrderToUserDto;
    }

    @Transactional(rollbackFor={Exception.class})
    public BaseResponse<String> doctorRefundOrder(DoctorRefundOrderVo doctorRefundOrderVo) {
        Orders order = (Orders)this.orderMapper.selectOne((Wrapper)new QueryWrapper().eq((Object)"view_id", (Object)doctorRefundOrderVo.getOrderViewId()));
        if (order.getPrice().compareTo(doctorRefundOrderVo.getRefundPrice()) < 0) {
            return BaseResponse.error((String)"\u9000\u6b3e\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u5f53\u524d\u8ba2\u5355\u91d1\u989d");
        }
        RefundVo refundVo = new RefundVo();
        refundVo.setAppCode(doctorRefundOrderVo.getAppCode());
        refundVo.setOrderViewId(doctorRefundOrderVo.getOrderViewId());
        refundVo.setPrice(doctorRefundOrderVo.getRefundPrice());
        Boolean refund = this.payService.refund(refundVo);
        if (refund.booleanValue()) {
            List appointmentList = this.appointmentMapper.selectList((Wrapper)new QueryWrapper().eq((Object)"service_order_id", (Object)order.getId()));
            for (Appointment appointment : appointmentList) {
                if (!AppointmentStatusEnum.APPOINTMENT_STATUS_DFW.getValue().equals(appointment.getStatus()) && !AppointmentStatusEnum.APPOINTMENT_STATUS_FWZ.getValue().equals(appointment.getStatus()) && !AppointmentStatusEnum.APPOINTMENT_STATUS_DSH.getValue().equals(appointment.getStatus())) continue;
                appointment.setStatus(AppointmentStatusEnum.APPOINTMENT_STATUS_YQX.getValue());
                appointment.setStatusDescribe(AppointmentStatusDescribeUserEnum.STATUS_USER_YQX.getDisplay());
                this.appointmentMapper.update((Object)appointment, (Wrapper)new QueryWrapper().eq((Object)"view_id", (Object)appointment.getViewId()));
            }
        } else {
            return BaseResponse.error((String)"\u8ba2\u5355\u9000\u6b3e\u5931\u8d25");
        }
        order.setStatus(OrderStatusEnum.ORDER_STATUS_YTK.getValue());
        order.setStatusDescribe(OrderStatusDescribeEnum.STATUS_DOCTOR_YTK.getDisplay());
        order.setRefundPrice(order.getRefundPrice().add(doctorRefundOrderVo.getRefundPrice()));
        order.setServerResidueNum(Integer.valueOf("0"));
        order.setRefundReason(doctorRefundOrderVo.getRefundReason());
        this.orderMapper.update((Object)order, (Wrapper)new QueryWrapper().eq((Object)"view_id", (Object)doctorRefundOrderVo.getOrderViewId()));
        return BaseResponse.success((Object)"\u8ba2\u5355\u9000\u6b3e\u6210\u529f");
    }

    public String userRefundOrder(String orderViewId, String appCode) {
        int appointmentCount;
        Orders order = (Orders)this.orderMapper.selectOne((Wrapper)new QueryWrapper().eq((Object)"view_id", (Object)orderViewId));
        List appointmentList = this.appointmentMapper.selectList((Wrapper)new QueryWrapper().eq((Object)"service_order_id", (Object)order.getId()));
        BigDecimal refundPrice = new BigDecimal("0.00");
        BigDecimal refundPriceDb = new BigDecimal("0.00");
        ArrayList<Appointment> appointmentDbList = new ArrayList<Appointment>();
        int n = appointmentCount = CollectionUtils.isNotEmpty((Collection)appointmentList) ? Integer.parseInt(String.valueOf(appointmentList.stream().filter(s -> !AppointmentStatusEnum.APPOINTMENT_STATUS_YQX.getValue().equals(s.getStatus())).count())) : 0;
        if (Integer.valueOf(1).equals(order.getServerTotalNum())) {
            BigDecimal price;
            Object statusDisplay;
            Appointment appointment = (Appointment)appointmentList.get(0);
            boolean communicate = Integer.valueOf(1).equals((int)appointment.getCommunicate());
            if (AppointmentStatusEnum.APPOINTMENT_STATUS_FWZ.getValue().equals(appointment.getStatus())) {
                throw new BusinessException("\u9884\u7ea6\u670d\u52a1\u5df2\u5f00\u59cb,\u65e0\u6cd5\u53d6\u6d88");
            }
            if (AppointmentStatusEnum.APPOINTMENT_STATUS_YQX.getValue().equals(appointment.getStatus()) || AppointmentStatusEnum.APPOINTMENT_STATUS_YTK.getValue().equals(appointment.getStatus()) || AppointmentStatusEnum.APPOINTMENT_STATUS_FWJS.getValue().equals(appointment.getStatus())) {
                throw new BusinessException("\u8ba2\u5355\u6b21\u6570\u5df2\u7528\u5b8c,\u65e0\u6cd5\u9000\u6b3e");
            }
            if (AppointmentStatusEnum.APPOINTMENT_STATUS_DSH.getValue().equals(appointment.getStatus())) {
                log.info("===\u5355\u6b21\u5f85\u5ba1\u6838===");
                statusDisplay = "\u60a8\u5df2\u81ea\u884c\u9000\u6b3e\uff0c\u672c\u6b21\u670d\u52a1\u5c06\u4e3a\u60a8\u5168\u989d\u9000\u6b3e";
                refundPrice = refundPrice.add(order.getPrice());
                appointment.setStatus(AppointmentStatusEnum.APPOINTMENT_STATUS_YQX.getValue());
                appointment.setStatusDescribe((String)statusDisplay);
                appointmentDbList.add(appointment);
            } else if (Objects.isNull(appointment.getDoctorId())) {
                log.info("===\u8fd8\u6ca1\u6709\u533b\u751f\u63a5\u5355,\u9000\u5355\u6b21\u670d\u52a1\u5168\u6b3e===");
                statusDisplay = "\u60a8\u5df2\u81ea\u884c\u9000\u6b3e\uff0c\u672c\u6b21\u670d\u52a1\u5c06\u4e3a\u60a8\u5168\u989d\u9000\u6b3e";
                price = order.getPrice().divide(new BigDecimal(order.getServerTotalNum().toString()), 3, 4);
                refundPrice = refundPrice.add(price);
                appointment.setStatus(AppointmentStatusEnum.APPOINTMENT_STATUS_YQX.getValue());
                appointment.setStatusDescribe((String)statusDisplay);
                appointmentDbList.add(appointment);
            } else {
                log.info("===\u5df2\u6c9f\u901a,\u9000\u6b3e50%===");
                if (communicate) {
                    statusDisplay = "\u60a8\u5df2\u81ea\u884c\u9000\u6b3e\uff0c\u672c\u6b21\u670d\u52a1\u5c06\u6309\u6bd4\u4f8b\u4e3a\u60a8\u9000\u6b3e50%";
                    price = order.getPrice().divide(new BigDecimal(order.getServerTotalNum().toString()), 3, 4).multiply(new BigDecimal("0.5"));
                    refundPrice = refundPrice.add(price);
                    appointment.setStatus(AppointmentStatusEnum.APPOINTMENT_STATUS_YQX.getValue());
                    appointment.setStatusDescribe((String)statusDisplay);
                    appointmentDbList.add(appointment);
                } else {
                    log.info("===\u672a\u6c9f\u901a,\u9000\u6b3e80%===");
                    statusDisplay = "\u60a8\u5df2\u81ea\u884c\u9000\u6b3e\uff0c\u672c\u6b21\u670d\u52a1\u5c06\u6309\u6bd4\u4f8b\u4e3a\u60a8\u9000\u6b3e80%";
                    price = order.getPrice().divide(new BigDecimal(order.getServerTotalNum().toString()), 3, 4).multiply(new BigDecimal("0.8"));
                    refundPrice = refundPrice.add(price);
                    appointment.setStatus(AppointmentStatusEnum.APPOINTMENT_STATUS_YQX.getValue());
                    appointment.setStatusDescribe((String)statusDisplay);
                    appointmentDbList.add(appointment);
                }
            }
        } else {
            Integer statusFWJS = appointmentList.stream().filter(e -> e.getStatus().intValue() == AppointmentStatusEnum.APPOINTMENT_STATUS_FWJS.getValue().intValue()).collect(Collectors.toList()).size();
            log.info("\u627e\u5230\u7ed3\u675f\u670d\u52a1\u7684\u603b\u6570\u4e3a{}", (Object)statusFWJS);
            Integer useCount = order.getServerTotalNum() - order.getServerResidueNum();
            log.info("\u8ba2\u5355\u603b\u6570{}\uff0c\u5269\u4f59\u6b21\u6570{}\uff0c\u7528\u6237\u5269\u4f59\u7684\u603b\u6570{}", new Object[]{order.getServerTotalNum(), order.getServerResidueNum(), useCount});
            if (order.getServerResidueNum() <= 0 && statusFWJS.equals(order.getServerTotalNum())) {
                log.info("===\u73b0\u6709\u9884\u7ea6\u5355\u5168\u90e8\u5b8c\u6210===");
                throw new BusinessException("\u5f53\u524d\u9884\u7ea6\u5355\u5df2\u7ecf\u5168\u90e8\u7ed3\u675f\u4e0d\u53ef\u4ee5\u9000\u6b3e\u3002");
            }
            log.info("===\u73b0\u6709\u9884\u7ea6\u5355\u5b58\u5728\u672a\u5b8c\u6210===");
            for (Appointment appointment : appointmentList) {
                BigDecimal price;
                String statusDisplay;
                boolean communicate = Integer.valueOf(1).equals(appointment.getCommunicate());
                if (AppointmentStatusEnum.APPOINTMENT_STATUS_FWZ.getValue().equals(appointment.getStatus()) || AppointmentStatusEnum.APPOINTMENT_STATUS_YQX.getValue().equals(appointment.getStatus()) || AppointmentStatusEnum.APPOINTMENT_STATUS_YTK.getValue().equals(appointment.getStatus()) || AppointmentStatusEnum.APPOINTMENT_STATUS_FWJS.getValue().equals(appointment.getStatus())) continue;
                if (AppointmentStatusEnum.APPOINTMENT_STATUS_DSH.getValue().equals(appointment.getStatus())) {
                    log.info(appointment.getId() + "===\u591a\u6b21\u5f85\u5ba1\u6838 \u9000\u5168\u6b3e===");
                    statusDisplay = "\u60a8\u5df2\u81ea\u884c\u9000\u6b3e\uff0c\u672c\u6b21\u670d\u52a1\u5c06\u4e3a\u60a8\u5168\u989d\u9000\u6b3e";
                    price = order.getPrice().divide(new BigDecimal(order.getServerTotalNum().toString()), 3, 4);
                    log.info("\u5355\u6b21\u9884\u7ea6\u5355\u5168\u6b3e==={}", (Object)price);
                    refundPrice = refundPrice.add(price);
                    appointment.setStatus(AppointmentStatusEnum.APPOINTMENT_STATUS_YQX.getValue());
                    appointment.setStatusDescribe(statusDisplay);
                    appointmentDbList.add(appointment);
                    continue;
                }
                if (Objects.isNull(appointment.getDoctorId())) {
                    log.info(appointment.getId() + "===\u591a\u6b21\u5f85\u670d\u52a1 \u8fd8\u6ca1\u6709\u533b\u751f\u63a5\u5355,\u9000\u5355\u6b21\u670d\u52a1\u5168\u6b3e===");
                    statusDisplay = "\u60a8\u5df2\u81ea\u884c\u9000\u6b3e\uff0c\u672c\u6b21\u670d\u52a1\u5c06\u4e3a\u60a8\u5168\u989d\u9000\u6b3e";
                    price = order.getPrice().divide(new BigDecimal(order.getServerTotalNum().toString()), 3, 4);
                    log.info("\u5355\u6b21\u9884\u7ea6\u5355\u5168\u6b3e==={}", (Object)price);
                    refundPrice = refundPrice.add(price);
                    appointment.setStatus(AppointmentStatusEnum.APPOINTMENT_STATUS_YQX.getValue());
                    appointment.setStatusDescribe(statusDisplay);
                    appointmentDbList.add(appointment);
                    continue;
                }
                if (communicate) {
                    log.info(appointment.getId() + "===\u591a\u6b21\u5f85\u670d\u52a1 \u5df2\u6c9f\u901a,\u9000\u6b3e50%===");
                    statusDisplay = "\u60a8\u5df2\u81ea\u884c\u9000\u6b3e\uff0c\u672c\u6b21\u670d\u52a1\u5c06\u6309\u6bd4\u4f8b\u4e3a\u60a8\u9000\u6b3e50%";
                    price = order.getPrice().divide(new BigDecimal(order.getServerTotalNum().toString()), 3, 4).multiply(new BigDecimal("0.5"));
                    log.info("50%===={}", (Object)price);
                    refundPrice = refundPrice.add(price);
                    appointment.setStatus(AppointmentStatusEnum.APPOINTMENT_STATUS_YQX.getValue());
                    appointment.setStatusDescribe(statusDisplay);
                    appointmentDbList.add(appointment);
                    continue;
                }
                log.info(appointment.getId() + "===\u591a\u6b21\u5f85\u670d\u52a1 \u672a\u6c9f\u901a,\u9000\u6b3e80%===");
                statusDisplay = "\u60a8\u5df2\u81ea\u884c\u9000\u6b3e\uff0c\u672c\u6b21\u670d\u52a1\u5c06\u6309\u6bd4\u4f8b\u4e3a\u60a8\u9000\u6b3e80%";
                price = order.getPrice().divide(new BigDecimal(order.getServerTotalNum().toString()), 3, 4).multiply(new BigDecimal("0.8"));
                log.info("80%===={}", (Object)price);
                refundPrice = refundPrice.add(price);
                appointment.setStatus(AppointmentStatusEnum.APPOINTMENT_STATUS_YQX.getValue());
                appointment.setStatusDescribe(statusDisplay);
                appointmentDbList.add(appointment);
            }
        }
        log.info("\u9884\u7ea6\u5355\u7b97\u51fa\u7684\u91d1\u989d,{}", (Object)refundPrice);
        log.info("\u4e0d\u662f\u9000\u5168\u6b3e\u6240\u4ee5\u8ba1\u7b97\u5269\u4e0b\u6ca1\u6709\u751f\u6210\u9884\u7ea6\u5355\u7684\u6b21\u6570\u8be5\u9000\u591a\u5c11\u91d1\u989d");
        int totalCount = order.getServerTotalNum();
        BigDecimal yuE = order.getPrice().divide(new BigDecimal(order.getServerTotalNum().toString()), 3, 4).multiply(new BigDecimal(totalCount).subtract(new BigDecimal(appointmentCount))).setScale(3, 4);
        log.info("\u8fd8\u5269{}\u6b21\u6570\uff0c\u7b97\u51fa\u6765\u8fd8\u80fd\u9000{}", (Object)(totalCount - appointmentCount), (Object)yuE);
        refundPriceDb = refundPriceDb.add(refundPrice).add(yuE).setScale(2, 4);
        log.info("\u7b97\u51fa\u6765\uff0c\u8be5\u9000{}", (Object)refundPriceDb);
        log.info("\u8ba1\u7b97\u9700\u8981\u9000\u6b3e\u91d1\u989d:{}", (Object)refundPriceDb);
        if (refundPriceDb.doubleValue() > order.getPrice().doubleValue()) {
            throw new BusinessException("\u9000\u6b3e\u91d1\u989d\u8ba1\u7b97\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u9000\u6b3e");
        }
        if (refundPriceDb.compareTo(new BigDecimal("0")) == 0) {
            log.info("====\u9000\u6b3e\u91d1\u989d\u4e3a\u96f6===");
            throw new BusinessException("\u6ca1\u6709\u53ef\u9000\u7684\u9884\u7ea6\u5355\uff0c\u9000\u6b3e\u91d1\u989d\u4e3a0\u5143\uff0c\u4e0d\u53ef\u9000\u6b3e\uff01");
        }
        RefundVo refundVo = new RefundVo();
        refundVo.setAppCode(appCode);
        refundVo.setOrderViewId(orderViewId);
        refundVo.setPrice(refundPriceDb);
        Boolean refund = this.payService.refund(refundVo);
        if (refund.booleanValue()) {
            for (Appointment appointment : appointmentDbList) {
                this.appointmentMapper.update((Object)appointment, (Wrapper)new QueryWrapper().eq((Object)"view_id", (Object)appointment.getViewId()));
            }
            order.setStatus(OrderStatusEnum.ORDER_STATUS_YTK.getValue());
            order.setStatusDescribe(OrderStatusDescribeEnum.STATUS_USER_YTK.getDisplay());
            order.setRefundPrice(order.getRefundPrice().add(refundPriceDb));
            order.setServerResidueNum(Integer.valueOf("0"));
            this.orderMapper.update((Object)order, (Wrapper)new QueryWrapper().eq((Object)"view_id", (Object)orderViewId));
            return "\u8ba2\u5355\u9000\u6b3e\u6210\u529f";
        }
        return "\u8ba2\u5355\u9000\u6b3e\u5931\u8d25";
    }

    public String deleteOrder(DeleteOrderVo deleteOrderVo) {
        int delete = this.orderMapper.delete((Wrapper)new QueryWrapper().eq((Object)"view_id", (Object)deleteOrderVo.getOrderViewId()));
        if (delete != 0) {
            return "YES";
        }
        return "NO";
    }

    @Scheduled(fixedDelay=600000L)
    @Transactional(rollbackFor={Exception.class})
    public void endDshOrder() {
        log.info("========\u5b9a\u65f6:\u9884\u7ea6\u65f6\u95f4\u524d12\u5c0f\u65f6\u9884\u7ea6\u5355\u672a\u5ba1\u6838=========");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        List dshAppointmentList = this.appointmentMapper.selectList((Wrapper)new QueryWrapper().eq((Object)"status", (Object)AppointmentStatusEnum.APPOINTMENT_STATUS_DSH.getValue()));
        for (Appointment appointment : dshAppointmentList) {
            try {
                String appointmentTime = appointment.getAppointmentTime().substring(0, 16) + ":00";
                String beforeTwentyFourHours = DateUtils.getBeforeTwentyFourHours((String)appointmentTime);
                if (System.currentTimeMillis() < sdf.parse(beforeTwentyFourHours).getTime()) continue;
                log.info("========\u5b9a\u65f6:\u5230\u65f6\u65f6\u95f4\u672a\u5ba1\u6838\u7684\u9884\u7ea6\u5355id:{}", (Object)appointment.getId());
                Orders orders = (Orders)this.orderMapper.selectById((Serializable)appointment.getServiceOrderId());
                RefundVo refundVo = new RefundVo();
                refundVo.setAppCode(GlobalConfig.configAppCodeStatic);
                refundVo.setOrderViewId(orders.getViewId());
                refundVo.setPrice(orders.getPrice());
                Boolean refund = this.payService.refund(refundVo);
                if (refund.booleanValue()) {
                    appointment.setStatus(AppointmentStatusEnum.APPOINTMENT_STATUS_YQX.getValue());
                    appointment.setStatusDescribe("\u56e0\u6682\u65f6\u6ca1\u6709\u62a4\u58eb\u63a5\u5355\uff0c\u672c\u6b21\u670d\u52a1\u5c06\u4e3a\u60a8\u5168\u989d\u9000\u6b3e");
                    this.appointmentMapper.updateById((Object)appointment);
                    orders.setStatus(OrderStatusEnum.ORDER_STATUS_YTK.getValue());
                    orders.setStatusDescribe(OrderStatusDescribeEnum.STATUS_DOCTOR_YTK.getDisplay());
                    orders.setRefundPrice(orders.getPrice());
                    orders.setServerResidueNum(Integer.valueOf(0));
                    this.orderMapper.updateById((Object)orders);
                    continue;
                }
                throw new RuntimeException("\u9000\u6b3e\u8c03\u7528\u5931\u8d25");
            }
            catch (Exception e) {
                log.error("\u5b9a\u65f6\u66f4\u65b0\u5f85\u5ba1\u6838\u6570\u636e\u72b6\u6001\u5931\u8d25id:{}\uff0c\u9519\u8bef\u4fe1\u606f{}", (Object)appointment.getId(), (Object)e.getMessage());
            }
        }
    }

    @Scheduled(fixedDelay=600000L)
    @Transactional(rollbackFor={Exception.class})
    public void endDfwNotHaveDoctorOrder() {
        log.info("========\u5b9a\u65f6:\u9884\u7ea6\u65f6\u95f412\u5c0f\u65f6\u524d\u672a\u670d\u52a1 \u533b\u751f\u672a\u63a5\u5355=========");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        List dfwNotHaveDoctorAppointmentList = this.appointmentMapper.selectList((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"status", (Object)AppointmentStatusEnum.APPOINTMENT_STATUS_DFW.getValue())).isNull((Object)"doctor_id"));
        for (Appointment appointment : dfwNotHaveDoctorAppointmentList) {
            try {
                String appointmentTime = appointment.getAppointmentTime().substring(0, 16) + ":00";
                String beforeTwentyFourHours = DateUtils.getBeforeTwentyFourHours((String)appointmentTime);
                if (System.currentTimeMillis() < sdf.parse(beforeTwentyFourHours).getTime()) continue;
                log.info("\u5b9a\u65f6:\u9884\u7ea6\u65f6\u95f412\u5c0f\u65f6\u524d\u672a\u670d\u52a1 \u533b\u751f\u672a\u63a5\u5355id:{}", (Object)appointment.getId());
                Orders order = (Orders)this.orderMapper.selectById((Serializable)appointment.getServiceOrderId());
                if (Objects.isNull(order)) {
                    log.info("\u5f53\u524d\u9884\u7ea6\u5355\u5b50\u6ca1\u6709\u627e\u5230\u76f8\u5e94\u8ba2\u5355\uff0c\u4e0d\u505a\u4efb\u4f55\u5904\u7406\u3002\u8ba2\u5355id:{}", (Object)appointment.getServiceOrderId());
                    continue;
                }
                if (Integer.valueOf(1).equals(order.getServerTotalNum())) {
                    RefundVo refundVo = new RefundVo();
                    refundVo.setAppCode(GlobalConfig.configAppCodeStatic);
                    refundVo.setOrderViewId(order.getViewId());
                    refundVo.setPrice(order.getPrice());
                    Boolean refund = this.payService.refund(refundVo);
                    if (refund.booleanValue()) {
                        appointment.setStatus(AppointmentStatusEnum.APPOINTMENT_STATUS_YQX.getValue());
                        appointment.setStatusDescribe("\u56e0\u6682\u65f6\u6ca1\u6709\u62a4\u58eb\u63a5\u5355\uff0c\u5e76\u4e14\u670d\u52a1\u6b21\u6570\u4e3a1\u6b21\u65f6\u5019\u8fdb\u884c\u9000\u6b3e\u5904\u7406");
                        order.setServerResidueNum(Integer.valueOf(order.getServerResidueNum() + 1));
                        order.setStatus(OrderStatusEnum.ORDER_STATUS_YTK.getValue());
                        order.setStatusDescribe(OrderStatusDescribeEnum.STATUS_DOCTOR_YTK.getDisplay());
                        order.setRefundPrice(order.getPrice());
                        order.setServerResidueNum(Integer.valueOf(0));
                    }
                } else if (order.getServerTotalNum() > 1) {
                    appointment.setStatus(AppointmentStatusEnum.APPOINTMENT_STATUS_YQX.getValue());
                    appointment.setStatusDescribe("\u56e0\u6682\u65f6\u6ca1\u6709\u62a4\u58eb\u63a5\u5355\uff0c\u5e76\u4e14\u670d\u52a1\u6b21\u6570\u5927\u4e8e1\u672c\u6b21\u670d\u52a1\u5df2\u4e3a\u60a8\u8fd4\u8fd8\u6b21\u6570");
                    order.setServerResidueNum(Integer.valueOf(order.getServerResidueNum() + 1));
                } else {
                    appointment.setStatus(AppointmentStatusEnum.APPOINTMENT_STATUS_YQX.getValue());
                    appointment.setStatusDescribe("\u56e0\u6682\u65f6\u6ca1\u6709\u62a4\u58eb\u63a5\u5355\uff0c\u5df2\u5c06\u8ba2\u5355\u72b6\u6001\u4fee\u6539\u4e3a\u5df2\u53d6\u6d88");
                    this.appointmentMapper.updateById((Object)appointment);
                    continue;
                }
                this.appointmentMapper.updateById((Object)appointment);
                this.orderMapper.updateById((Object)order);
            }
            catch (Exception e) {
                log.error("\u5b9a\u65f6\u66f4\u65b0\u5f85\u670d\u52a1\u6ca1\u6709\u533b\u751f\u63a5\u5355\u6570\u636e\u72b6\u6001\u5931\u8d25id:{},\u9519\u8bef\u4fe1\u606f:{}", (Object)appointment.getId(), (Object)e.getMessage());
            }
        }
    }

    @Scheduled(fixedDelay=600000L)
    @Transactional(rollbackFor={Exception.class})
    public void endDfwHaveDoctorOrder() {
        log.info("========\u5b9a\u65f6:\u9884\u7ea6\u65f6\u95f412\u5c0f\u65f6\u540e\u672a\u670d\u52a1 \u533b\u751f\u63a5\u5355=========");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        List dfwHaveDoctorAppointmentList = this.appointmentMapper.selectList((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"status", (Object)AppointmentStatusEnum.APPOINTMENT_STATUS_DFW.getValue())).isNotNull((Object)"doctor_id"));
        for (Appointment appointment : dfwHaveDoctorAppointmentList) {
            Orders order = (Orders)this.orderMapper.selectById((Serializable)appointment.getServiceOrderId());
            try {
                String appointmentTime = appointment.getAppointmentTime().substring(0, 16) + ":00";
                String beforeTwentyFourHours = DateUtils.getAfterTwentyFourHours((String)appointmentTime);
                if (System.currentTimeMillis() >= sdf.parse(beforeTwentyFourHours).getTime()) {
                    log.info("\u5b9a\u65f6:\u9884\u7ea6\u65f6\u95f412\u5c0f\u65f6\u540e\u672a\u670d\u52a1 \u533b\u751f\u63a5\u5355id:{}", (Object)appointment.getId());
                    appointment.setStatus(AppointmentStatusEnum.APPOINTMENT_STATUS_YQX.getValue());
                    appointment.setStatusDescribe("\u672c\u6b21\u670d\u52a1\u5df2\u5931\u6548");
                    this.appointmentMapper.updateById((Object)appointment);
                }
                ArrayList<Integer> arrayList = new ArrayList<Integer>();
                arrayList.add(AppointmentStatusEnum.APPOINTMENT_STATUS_DFW.getValue());
                arrayList.add(AppointmentStatusEnum.APPOINTMENT_STATUS_FWZ.getValue());
                List appointmentList = this.appointmentMapper.selectList((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"service_order_id", (Object)order.getId())).in((Object)"status", arrayList));
                if (1 <= order.getServerResidueNum() || !CollectionUtils.isEmpty((Collection)appointmentList)) continue;
                Orders orderDb = new Orders();
                orderDb.setStatus(OrderStatusEnum.ORDER_STATUS_YWC.getValue());
                orderDb.setStatusDescribe(OrderStatusDescribeEnum.STATUS_YWC.getDisplay());
                this.orderMapper.update((Object)orderDb, (Wrapper)new QueryWrapper().eq((Object)"view_id", (Object)order.getViewId()));
            }
            catch (Exception e) {
                log.error("\u5b9a\u65f6\u66f4\u65b0\u5f85\u670d\u52a1\u533b\u751f\u5df2\u63a5\u5355\u6570\u636e\u72b6\u6001\u5931\u8d25id:    {},\u9519\u8bef\u4fe1\u606f:{}", (Object)appointment.getId(), (Object)e.getMessage());
            }
        }
    }
}

