/*
 * Decompiled with CFR 0.152.
 */
package com.byh.nursingcarenewserver.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.byh.nursingcarenewserver.config.GlobalConfig;
import com.byh.nursingcarenewserver.mapper.AppointmentMapper;
import com.byh.nursingcarenewserver.mapper.OrderMapper;
import com.byh.nursingcarenewserver.mapper.ProductSubitemMapper;
import com.byh.nursingcarenewserver.pojo.entity.Appointment;
import com.byh.nursingcarenewserver.pojo.entity.Orders;
import com.byh.nursingcarenewserver.pojo.entity.ProductSubitem;
import com.byh.nursingcarenewserver.pojo.enums.AppointmentStatusEnum;
import com.byh.nursingcarenewserver.pojo.enums.OrderStatusDescribeEnum;
import com.byh.nursingcarenewserver.pojo.enums.OrderStatusEnum;
import com.byh.nursingcarenewserver.service.AppWebPushService;
import com.byh.nursingcarenewserver.utils.DateUtils;
import com.byh.nursingcarenewserver.utils.PushParamUtil;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class ScheduledService {
    private static final Logger log = LoggerFactory.getLogger(ScheduledService.class);
    @Autowired
    private AppointmentMapper appointmentMapper;
    @Autowired
    private OrderMapper orderMapper;
    @Autowired
    private ProductSubitemMapper productSubitemMapper;
    @Autowired
    private AppWebPushService appWebPushService;
    @Autowired
    private GlobalConfig globalConfig;

    @Scheduled(cron="0 0 23 * * ?")
    @Transactional(rollbackFor={Exception.class})
    public void overdueOrders() {
        List ordersList = this.orderMapper.selectList((Wrapper)new QueryWrapper().eq((Object)"status", (Object)OrderStatusEnum.ORDER_STATUS_SYZ.getValue()));
        for (Orders orders : ordersList) {
            try {
                ProductSubitem productSubitem = this.productSubitemMapper.queryById(orders.getProductSubitemId());
                if (Objects.isNull(productSubitem)) {
                    log.info("\u672a\u627e\u5230\u8ba2\u5355,{}", (Object)orders.getId());
                    continue;
                }
                log.info("\u627e\u5230\u8ba2\u5355:{}", (Object)JSON.toJSONString((Object)productSubitem));
                Date plusDay = null;
                plusDay = DateUtils.plusDay1((int)productSubitem.getUsefulLife(), (String)DateUtils.dateToString((Date)orders.getCreateTime()));
                log.info("\u8ba2\u5355\uff1a{},\u7684\u8fc7\u671f\u65e5\u671f\u662f\uff1a{}", (Object)orders.getId(), (Object)DateUtils.dateFormat((Date)plusDay));
                Date date = new Date();
                int compareTo = date.compareTo(plusDay);
                if (compareTo <= 0) continue;
                orders.setStatus(OrderStatusEnum.ORDER_STATUS_YGQ.getValue());
                orders.setStatusDescribe(OrderStatusDescribeEnum.STATUS_YGQ.getDisplay());
                orders.setServerResidueNum(Integer.valueOf(0));
                this.orderMapper.update((Object)orders, (Wrapper)new UpdateWrapper().eq((Object)"id", (Object)orders.getId()));
            }
            catch (Exception e) {
                log.error("\u5b9a\u65f6\u4efb\u52a1\u8fc7\u671f\u8ba2\u5355\u5904\u7406\uff0c\u51fa\u9519\u8ba2\u5355\uff1a{}\uff0c\u9519\u8bef\u4fe1\u606f\uff1a{}", (Object)orders.getId(), (Object)e.getMessage());
            }
        }
    }

    @Scheduled(cron="0 0 * * * ?")
    public void todayBeforeTwoPush() {
        log.info("===========\u5f53\u5929\u9884\u7ea6\u5355\u9884\u7ea6\u524d2\u5c0f\u65f6\u63a8\u9001\u5f00\u59cb=========");
        String date = "";
        try {
            date = DateUtils.getDate((Date)new Date());
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u5f53\u524d\u65e5\u671f\u9519\u8bef");
        }
        Integer dateTime = DateUtils.dateToTimeStamp((String)DateUtils.javaDateParseStringByPattern((Date)new Date(), (String)"yyyy-MM-dd HH"), (String)"yyyy-MM-dd HH");
        log.info("\u83b7\u53d6\u5f53\u524d\u65f6\u95f4\u6574\u5c0f\u65f6\u7684\u65f6\u95f4\u6233\u4e3a:{}", (Object)dateTime);
        Integer dateBeforeTime = dateTime + 7200;
        log.info("\u83b7\u53d6\u4e24\u4e2a\u5c0f\u65f6\u5019\u540e\u7684\u65f6\u95f4\u6233\u4e3a:{}", (Object)dateBeforeTime);
        Integer dateAfterTime = dateBeforeTime + 3600;
        log.info("\u83b7\u53d6\u4e24\u4e2a\u5c0f\u65f6\u5019\u540e\u7684\u65f6\u95f4\u6233\u4e3a:{}", (Object)dateBeforeTime);
        List appointmentList = this.appointmentMapper.selectList((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"status", (Object)AppointmentStatusEnum.APPOINTMENT_STATUS_DFW.getValue())).like((Object)"appointment_time", (Object)date));
        if (CollectionUtils.isNotEmpty((Collection)appointmentList)) {
            for (Appointment appointment : appointmentList) {
                Integer appointmentTimeInteger = null;
                String appointmentTime = null;
                String[] split1 = null;
                try {
                    String[] split = appointment.getAppointmentTime().split(" ");
                    split1 = split[1].split("-");
                    appointmentTime = split[0] + " " + split1[0] + ":00";
                    appointmentTimeInteger = DateUtils.dateToTimeStamp((String)appointmentTime, (String)"yyyy-MM-dd HH:mm:ss");
                }
                catch (Exception e) {
                    log.error("\u9884\u7ea6\u65f6\u95f4\u683c\u5f0f\u51fa\u73b0\u9519\u8bef\uff0c\u65e0\u6cd5\u6b63\u786e\u5206\u89e3\uff0c\u76f4\u63a5\u8df3\u8fc7\u3002\u9519\u8bef\u5982\u4e0b\uff1a", (Throwable)e);
                    continue;
                }
                log.info("appointmentTime:{},appTimeInteger:{}", (Object)appointmentTime, (Object)appointmentTimeInteger);
                log.info("appointmentTimeBefore:{}", (Object)dateBeforeTime);
                log.info("appointmentTimeAfter:{}", (Object)dateAfterTime);
                try {
                    if (appointmentTimeInteger < dateBeforeTime || appointmentTimeInteger >= dateAfterTime) continue;
                    log.info("\u5f53\u5929\u9884\u7ea6\u5355\u9884\u7ea6\u524d2\u5c0f\u65f6\u63a8\u9001id:{}", (Object)appointment.getId());
                    String userId = PushParamUtil.getUserIdByDoctorId((Long)appointment.getDoctorId(), (String)appointment.getDoctorOrganId().toString());
                    this.appWebPushService.todayBeforeTwoPush(GlobalConfig.configAppCodeStatic, userId, split1[0]);
                }
                catch (Exception e) {
                    log.info("\u5f53\u5929\u9884\u7ea6\u5355\u9884\u7ea6\u524d2\u5c0f\u65f6\u63a8\u9001\u5f02\u5e38id\uff1a{}", (Object)appointment.getId());
                }
            }
        } else {
            log.info("===========\u5f53\u5929\u9884\u7ea6\u5355\u9884\u7ea6\u524d2\u5c0f\u65f6\u63a8  \u65e0\u8ba2\u5355=========");
        }
    }
}

