/*
 * Decompiled with CFR 0.152.
 */
package com.byh.nursingcarenewserver.config;

import java.util.HashMap;
import org.springframework.amqp.core.Binding;
import org.springframework.amqp.core.BindingBuilder;
import org.springframework.amqp.core.CustomExchange;
import org.springframework.amqp.core.Exchange;
import org.springframework.amqp.core.Queue;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class MQConfig {
    public static final String DEFAULT_EXCHANGE = "default_exchange_hlzh_not_doctor";
    public static final String UNBACK_EXCHANGE = "unback_exchange_hlzh_unback";
    public static final String DOCTOR_NOT_OPERATION_QUEUE_NAME = "doctor.not.operation.queue";
    public static final String DOCTOR_NOT_BACK_QUEUE_NAME = "doctor.not.back.queue";
    public static final String DOCTOR_NOT_SERVICE_QUEUE_NAME = "doctor.not.service.queue";
    public static final String DOCTOR_NOT_OPERATION_ROUTING_KEY = "doctor.not.operation.queue.routing_key";
    public static final String DOCTOR_NOT_BACK_ROUTING_KEY = "doctor.not.back.queue.routing_key";
    public static final String DOCTOR_NOT_SERVICE_ROUTING_KEY = "doctor.not.service.queue.routing_key";

    @Bean
    public Queue doctorNotServiceQueue() {
        return new Queue(DOCTOR_NOT_SERVICE_QUEUE_NAME);
    }

    @Bean
    Binding doctorNotService() {
        return BindingBuilder.bind((Queue)this.doctorNotServiceQueue()).to((Exchange)this.customExchange()).with(DOCTOR_NOT_SERVICE_ROUTING_KEY).noargs();
    }

    @Bean
    Binding doctorNotOperation() {
        return BindingBuilder.bind((Queue)this.doctorNotOperationQueue()).to((Exchange)this.customExchange()).with(DOCTOR_NOT_OPERATION_ROUTING_KEY).noargs();
    }

    @Bean
    public Queue doctorNotOperationQueue() {
        return new Queue(DOCTOR_NOT_OPERATION_QUEUE_NAME);
    }

    @Bean
    CustomExchange customExchange() {
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("x-delayed-type", "direct");
        return new CustomExchange(DEFAULT_EXCHANGE, "x-delayed-message", true, false, args);
    }

    @Bean
    CustomExchange unbackExchange() {
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("x-delayed-type", "direct");
        return new CustomExchange(UNBACK_EXCHANGE, "x-delayed-message", true, false, args);
    }

    @Bean
    public Queue doctorNotBackQueue() {
        return new Queue(DOCTOR_NOT_BACK_QUEUE_NAME);
    }

    @Bean
    Binding doctorNotBack() {
        return BindingBuilder.bind((Queue)this.doctorNotBackQueue()).to((Exchange)this.unbackExchange()).with(DOCTOR_NOT_BACK_ROUTING_KEY).noargs();
    }
}

