/*
 * Decompiled with CFR 0.152.
 */
package com.byh.nursingcarenewserver.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.byh.nursingcarenewserver.mapper.CancelReasonMapper;
import com.byh.nursingcarenewserver.mapper.OrderMapper;
import com.byh.nursingcarenewserver.pojo.dto.CancelReasonDto;
import com.byh.nursingcarenewserver.pojo.entity.CancelReason;
import com.byh.nursingcarenewserver.pojo.entity.Orders;
import com.byh.nursingcarenewserver.pojo.vo.CancelReasonVo;
import com.byh.nursingcarenewserver.service.CancelReasonService;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class CancelReasonServiceImpl
extends ServiceImpl<CancelReasonMapper, CancelReason>
implements CancelReasonService {
    private static final Logger log = LoggerFactory.getLogger(CancelReasonServiceImpl.class);
    @Resource
    private CancelReasonMapper cancelReasonMapper;
    @Resource
    private OrderMapper orderMapper;

    public String addReason(CancelReasonVo cancelReasonVo) {
        CancelReason cancelReasonEntity = (CancelReason)this.getOne((Wrapper)new QueryWrapper().eq((Object)"appointment_id", (Object)cancelReasonVo.getAppointmentId()));
        if (ObjectUtils.isEmpty((Object)cancelReasonEntity)) {
            CancelReason cancelReason = new CancelReason();
            BeanUtils.copyProperties((Object)cancelReasonVo, (Object)cancelReason);
            boolean save = this.save((Object)cancelReason);
            if (!save) {
                throw new RuntimeException("\u53d6\u6d88\u539f\u56e0\u8868\u4fe1\u606f\u4fdd\u5b58\u5931\u8d25");
            }
        } else {
            BeanUtils.copyProperties((Object)cancelReasonVo, (Object)cancelReasonEntity);
            this.updateById((Object)cancelReasonEntity);
        }
        log.info("\u53d6\u6d88\u539f\u56e0\u8868\u4fe1\u606f\u4fdd\u5b58\u6210\u529f");
        return "\u53d6\u6d88\u539f\u56e0\u8868\u4fe1\u606f\u4fdd\u5b58\u6210\u529f";
    }

    public CancelReasonDto selectAppointmentReason(String appointmentViewId) {
        CancelReasonDto cancelReasonDto = new CancelReasonDto();
        CancelReason cancelReason = (CancelReason)this.getOne((Wrapper)new QueryWrapper().eq((Object)"appointment_id", (Object)appointmentViewId));
        if (ObjectUtils.isEmpty((Object)cancelReason)) {
            return cancelReasonDto;
        }
        BeanUtils.copyProperties((Object)cancelReason, (Object)cancelReasonDto);
        return cancelReasonDto;
    }

    public CancelReasonDto selectOderReason(String orderViewId) {
        CancelReasonDto cancelReasonDto = new CancelReasonDto();
        QueryWrapper queryWrapper = (QueryWrapper)new QueryWrapper().eq((Object)"order_id", (Object)orderViewId);
        List orderReasonList = this.cancelReasonMapper.selectList((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty((Collection)orderReasonList)) {
            return cancelReasonDto;
        }
        if (orderReasonList.size() == 1) {
            BeanUtils.copyProperties(orderReasonList.get(0), (Object)cancelReasonDto);
            return cancelReasonDto;
        }
        Orders order = this.orderMapper.queryByViewId(orderViewId);
        String auditReason = ((CancelReason)orderReasonList.stream().filter(cancelReason -> cancelReason.getFlag() == 1).collect(Collectors.toList()).get(0)).getAuditReason();
        List reasonList = orderReasonList.stream().filter(cancelReason -> StringUtils.isNotEmpty((CharSequence)cancelReason.getRefundReason())).sorted(Comparator.comparing(CancelReason::getUpdateTime).reversed()).limit(1L).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(reasonList)) {
            BeanUtils.copyProperties(reasonList.get(0), (Object)cancelReasonDto);
        }
        cancelReasonDto.setFlag(Integer.valueOf(1));
        cancelReasonDto.setAuditReason(auditReason);
        return cancelReasonDto;
    }
}

