/*
 * Decompiled with CFR 0.152.
 */
package com.byh.nursingcarenewserver.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.byh.nursingcarenewserver.mapper.MaterialItemMapper;
import com.byh.nursingcarenewserver.mapper.OrderMapper;
import com.byh.nursingcarenewserver.mapper.ProductCategoryMapper;
import com.byh.nursingcarenewserver.mapper.ProductMapper;
import com.byh.nursingcarenewserver.mapper.ProductSubitemMapper;
import com.byh.nursingcarenewserver.pojo.dto.DetailProductDataDto;
import com.byh.nursingcarenewserver.pojo.dto.DetailProductDto;
import com.byh.nursingcarenewserver.pojo.dto.DetailProductMaterialPackageDto;
import com.byh.nursingcarenewserver.pojo.dto.DetailProductSpecificationDto;
import com.byh.nursingcarenewserver.pojo.dto.DetailProductSpecificationValueDto;
import com.byh.nursingcarenewserver.pojo.dto.DetailProductSubitemDto;
import com.byh.nursingcarenewserver.pojo.dto.SelectListProductDto;
import com.byh.nursingcarenewserver.pojo.dto.SmallProgramMaterialDto;
import com.byh.nursingcarenewserver.pojo.dto.SmallProgramMaterialItemDto;
import com.byh.nursingcarenewserver.pojo.dto.SmallProgramProductDetailDto;
import com.byh.nursingcarenewserver.pojo.dto.SmallProgramProductListChildDto;
import com.byh.nursingcarenewserver.pojo.dto.SmallProgramProductListDto;
import com.byh.nursingcarenewserver.pojo.dto.SmallProgramProductSubitemDto;
import com.byh.nursingcarenewserver.pojo.dto.SmallProgramTitleDto;
import com.byh.nursingcarenewserver.pojo.entity.HospitalConfig;
import com.byh.nursingcarenewserver.pojo.entity.MaterialItem;
import com.byh.nursingcarenewserver.pojo.entity.Orders;
import com.byh.nursingcarenewserver.pojo.entity.Product;
import com.byh.nursingcarenewserver.pojo.entity.ProductCategory;
import com.byh.nursingcarenewserver.pojo.entity.ProductSubitem;
import com.byh.nursingcarenewserver.pojo.enums.OrderStatusEnum;
import com.byh.nursingcarenewserver.pojo.vo.DeleteVo;
import com.byh.nursingcarenewserver.pojo.vo.MarketableProductVo;
import com.byh.nursingcarenewserver.pojo.vo.SaveProductDataVo;
import com.byh.nursingcarenewserver.pojo.vo.SaveProductSubitemVo;
import com.byh.nursingcarenewserver.pojo.vo.SaveProductVo;
import com.byh.nursingcarenewserver.pojo.vo.SelectListProductVo;
import com.byh.nursingcarenewserver.pojo.vo.SmallProgramProductListVo;
import com.byh.nursingcarenewserver.pojo.vo.TopProductVo;
import com.byh.nursingcarenewserver.pojo.vo.UpdateProductDataVo;
import com.byh.nursingcarenewserver.pojo.vo.UpdateProductSubitemVo;
import com.byh.nursingcarenewserver.pojo.vo.UpdateProductVo;
import com.byh.nursingcarenewserver.service.ProductService;
import com.byh.nursingcarenewserver.service.impl.HospitalConfigServiceImpl;
import com.byh.nursingcarenewserver.utils.UniqueKeyGenerator;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ProductServiceImpl
extends ServiceImpl<ProductMapper, Product>
implements ProductService {
    @Autowired
    private ProductMapper productMapper;
    @Autowired
    private ProductSubitemMapper productSubitemMapper;
    @Autowired
    private ProductCategoryMapper productCategoryMapper;
    @Autowired
    private OrderMapper orderMapper;
    @Autowired
    private MaterialItemMapper materialItemMapper;
    @Resource
    private HospitalConfigServiceImpl hospitalConfigService;

    @Transactional
    public String saveProduct(SaveProductVo saveProductVo) {
        SaveProductDataVo saveProductDataVo = saveProductVo.getSaveProductDataVo();
        List productList = this.productMapper.selectList((Wrapper)new QueryWrapper().eq((Object)"name", (Object)saveProductDataVo.getProductName()));
        if (CollectionUtils.isNotEmpty((Collection)productList)) {
            return "\u5957\u9910\u540d\u5df2\u5b58\u5728,\u8bf7\u91cd\u65b0\u8f93\u5165";
        }
        Product product = new Product();
        product.setProductCategoryId(saveProductDataVo.getProductCategoryId());
        product.setViewId(UniqueKeyGenerator.generateUUID());
        product.setName(saveProductDataVo.getProductName());
        product.setImage(saveProductDataVo.getProductImage());
        product.setProductCategoryId(saveProductDataVo.getProductCategoryId());
        product.setFormServiceId(saveProductDataVo.getFormServiceId());
        product.setFormServiceName(saveProductDataVo.getFormServiceName());
        int insert = this.productMapper.insert((Object)product);
        if (insert != 1) {
            return "NO";
        }
        QueryWrapper productQueryWrapper = new QueryWrapper();
        productQueryWrapper.eq((Object)"view_id", (Object)product.getViewId());
        Product productEntity = (Product)this.productMapper.selectOne((Wrapper)productQueryWrapper);
        List saveProductSubitemVoList = saveProductVo.getSaveProductSubitemVoList();
        BigDecimal decimal = BigDecimal.valueOf(0.0);
        for (SaveProductSubitemVo saveProductSubitemVo : saveProductSubitemVoList) {
            ProductSubitem productSubitem = new ProductSubitem();
            productSubitem.setViewId(UniqueKeyGenerator.generateUUID());
            productSubitem.setProductId(productEntity.getId());
            productSubitem.setMaterialId(saveProductSubitemVo.getMaterialId());
            productSubitem.setMaterialName(saveProductSubitemVo.getMaterialName());
            productSubitem.setSpecificationId(saveProductSubitemVo.getSpecificationId());
            productSubitem.setSpecificationName(saveProductSubitemVo.getSpecificationName());
            productSubitem.setSpecificationValueId(saveProductSubitemVo.getSpecificationValueId());
            productSubitem.setSpecificationValueName(saveProductSubitemVo.getSpecificationValueName());
            productSubitem.setUsefulLife(saveProductSubitemVo.getUsefulLife());
            productSubitem.setServiceTimes(saveProductSubitemVo.getServiceTimes());
            productSubitem.setPrice(saveProductSubitemVo.getPrice());
            productSubitem.setIntroduce(saveProductSubitemVo.getIntroduce());
            decimal = decimal.add(saveProductSubitemVo.getPrice());
            int save = this.productSubitemMapper.insert((Object)productSubitem);
            if (save == 1) continue;
            return "NO";
        }
        UpdateWrapper productUpdateWrapper = new UpdateWrapper();
        productUpdateWrapper.eq((Object)"view_id", (Object)product.getViewId());
        productEntity.setPrice(decimal);
        int update = this.productMapper.update((Object)productEntity, (Wrapper)productUpdateWrapper);
        if (update != 1) {
            return "NO";
        }
        return "YES";
    }

    public Boolean topProduct(TopProductVo topProductVo) {
        QueryWrapper productQueryWrapper = new QueryWrapper();
        productQueryWrapper.eq((Object)"view_id", (Object)topProductVo.getProductViewId());
        Product product = (Product)this.productMapper.selectOne((Wrapper)productQueryWrapper);
        UpdateWrapper productUpdateWrapper = new UpdateWrapper();
        productUpdateWrapper.eq((Object)"view_id", (Object)topProductVo.getProductViewId());
        product.setIsTop(topProductVo.getTop());
        int update = this.productMapper.update((Object)product, (Wrapper)productUpdateWrapper);
        if (update != 1) {
            return false;
        }
        return true;
    }

    @Transactional
    public Boolean marketableProduct(MarketableProductVo marketableProductVo) {
        List productViewIds = marketableProductVo.getProductViewIds();
        for (String viewId : productViewIds) {
            QueryWrapper productQueryWrapper = new QueryWrapper();
            productQueryWrapper.eq((Object)"view_id", (Object)viewId);
            Product product = (Product)this.productMapper.selectOne((Wrapper)productQueryWrapper);
            if (null == product) continue;
            UpdateWrapper productUpdateWrapper = new UpdateWrapper();
            productUpdateWrapper.eq((Object)"view_id", (Object)viewId);
            product.setIsMarketable(marketableProductVo.getMarketable());
            int update = this.productMapper.update((Object)product, (Wrapper)productUpdateWrapper);
            if (update == 1) continue;
            return false;
        }
        return true;
    }

    public List<SelectListProductDto> selectListProduct(SelectListProductVo selectListProductVo) {
        ProductCategory productCategory = (ProductCategory)this.productCategoryMapper.selectOne((Wrapper)new QueryWrapper().eq((Object)"view_id", (Object)selectListProductVo.getProductCategoryViewId()));
        QueryWrapper productQueryWrapper = new QueryWrapper();
        if (StringUtils.isNotEmpty((CharSequence)selectListProductVo.getSearch())) {
            productQueryWrapper.like((Object)"name", (Object)selectListProductVo.getSearch());
        }
        productQueryWrapper.eq((Object)"product_category_id", (Object)productCategory.getId());
        productQueryWrapper.orderByDesc((Object[])new String[]{"is_top", "create_time"});
        List productList = this.productMapper.selectList((Wrapper)productQueryWrapper);
        ArrayList<SelectListProductDto> list = new ArrayList<SelectListProductDto>();
        for (Product product : productList) {
            Optional<ProductSubitem> optional;
            SelectListProductDto selectListProductDto = new SelectListProductDto();
            selectListProductDto.setProductId(product.getId());
            selectListProductDto.setProductViewId(product.getViewId());
            selectListProductDto.setProductName(product.getName());
            selectListProductDto.setProductImage(product.getImage());
            selectListProductDto.setMarketable(product.getIsMarketable());
            selectListProductDto.setTop(product.getIsTop());
            selectListProductDto.setProductCategoryId(product.getProductCategoryId());
            List productSubitemList = this.productSubitemMapper.selectList((Wrapper)new QueryWrapper().eq((Object)"product_id", (Object)product.getId()));
            if (CollectionUtils.isNotEmpty((Collection)productSubitemList) && (optional = productSubitemList.stream().min(Comparator.comparing(ProductSubitem::getPrice))).isPresent()) {
                ProductSubitem productSubitem = optional.get();
                selectListProductDto.setPrice(productSubitem.getPrice());
            }
            if (productSubitemList != null && productSubitemList.size() > 1) {
                selectListProductDto.setIsMore(Integer.valueOf(1));
            } else {
                selectListProductDto.setIsMore(Integer.valueOf(0));
            }
            List ordersList = this.orderMapper.selectList((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"product_id", (Object)product.getId())).ne((Object)"status", (Object)OrderStatusEnum.ORDER_STATUS_YTK.getValue()));
            if (CollectionUtils.isNotEmpty((Collection)ordersList)) {
                selectListProductDto.setSalesVolume(Integer.valueOf(ordersList.size()));
                BigDecimal bigDecimal = BigDecimal.valueOf(0.0);
                for (Orders orders : ordersList) {
                    BigDecimal price = this.productSubitemMapper.queryById(orders.getProductSubitemId()).getPrice();
                    bigDecimal = bigDecimal.add(price);
                }
                selectListProductDto.setProceeds(bigDecimal);
            } else {
                selectListProductDto.setSalesVolume(Integer.valueOf(0));
                selectListProductDto.setProceeds(BigDecimal.ZERO);
            }
            list.add(selectListProductDto);
        }
        return list;
    }

    @Transactional
    public Boolean deleteProduct(DeleteVo deleteVo) {
        QueryWrapper productQueryWrapper = new QueryWrapper();
        productQueryWrapper.eq((Object)"view_id", (Object)deleteVo.getViewId());
        Product product = (Product)this.productMapper.selectOne((Wrapper)productQueryWrapper);
        int delete = this.productMapper.delete((Wrapper)productQueryWrapper);
        if (delete != 1) {
            return false;
        }
        QueryWrapper subitemQueryWrapper = new QueryWrapper();
        subitemQueryWrapper.eq((Object)"product_id", (Object)product.getId());
        int subitemDelete = this.productSubitemMapper.delete((Wrapper)subitemQueryWrapper);
        if (subitemDelete == 0) {
            return false;
        }
        return true;
    }

    public DetailProductDto detailProduct(String viewId) {
        DetailProductDto detailProductDto = new DetailProductDto();
        QueryWrapper productQueryWrapper = (QueryWrapper)new QueryWrapper().eq((Object)"view_id", (Object)viewId);
        Product product = (Product)this.productMapper.selectOne((Wrapper)productQueryWrapper);
        ProductCategory productCategory = (ProductCategory)this.productCategoryMapper.selectById((Serializable)product.getProductCategoryId());
        DetailProductDataDto detailProductDataDto = new DetailProductDataDto();
        detailProductDataDto.setProductId(product.getId());
        detailProductDataDto.setProductName(product.getName());
        detailProductDataDto.setProductImage(product.getImage());
        detailProductDataDto.setProductCategoryId(productCategory.getId());
        detailProductDataDto.setProductCategoryName(productCategory.getName());
        detailProductDataDto.setIsMarketable(product.getIsMarketable());
        detailProductDataDto.setFormServiceId(product.getFormServiceId());
        detailProductDataDto.setFormServiceName(product.getFormServiceName());
        detailProductDto.setDetailProductDataDto(detailProductDataDto);
        QueryWrapper subitemQueryWrapper = (QueryWrapper)new QueryWrapper().eq((Object)"product_id", (Object)product.getId());
        List productSubitems = this.productSubitemMapper.selectList((Wrapper)subitemQueryWrapper);
        ArrayList<DetailProductMaterialPackageDto> materialList = new ArrayList<DetailProductMaterialPackageDto>();
        ArrayList<DetailProductSubitemDto> subitemList = new ArrayList<DetailProductSubitemDto>();
        ArrayList<DetailProductSpecificationValueDto> specificationValueList = new ArrayList<DetailProductSpecificationValueDto>();
        DetailProductSpecificationDto detailProductSpecificationDto = new DetailProductSpecificationDto();
        for (ProductSubitem productSubitem : productSubitems) {
            DetailProductMaterialPackageDto detailProductMaterialPackageDto = new DetailProductMaterialPackageDto();
            detailProductMaterialPackageDto.setMaterialPackageId(productSubitem.getMaterialId());
            detailProductMaterialPackageDto.setMaterialPackageName(productSubitem.getMaterialName());
            materialList.add(detailProductMaterialPackageDto);
            detailProductSpecificationDto.setSpecificationId(productSubitem.getSpecificationId());
            detailProductSpecificationDto.setSpecificationName(productSubitem.getSpecificationName());
            DetailProductSpecificationValueDto detailProductSpecificationValueDto = new DetailProductSpecificationValueDto();
            detailProductSpecificationValueDto.setSpecificationValueId(productSubitem.getSpecificationValueId());
            detailProductSpecificationValueDto.setSpecificationValueName(productSubitem.getSpecificationValueName());
            specificationValueList.add(detailProductSpecificationValueDto);
            DetailProductSubitemDto detailProductSubitemDto = new DetailProductSubitemDto();
            detailProductSubitemDto.setProductId(productSubitem.getProductId());
            detailProductSubitemDto.setMaterialId(productSubitem.getMaterialId());
            detailProductSubitemDto.setMaterialName(productSubitem.getMaterialName());
            detailProductSubitemDto.setSpecificationId(productSubitem.getSpecificationId());
            detailProductSubitemDto.setSpecificationName(productSubitem.getSpecificationName());
            detailProductSubitemDto.setSpecificationValueId(productSubitem.getSpecificationValueId());
            detailProductSubitemDto.setSpecificationValueName(productSubitem.getSpecificationValueName());
            detailProductSubitemDto.setUsefulLife(productSubitem.getUsefulLife());
            detailProductSubitemDto.setServiceTimes(productSubitem.getServiceTimes());
            detailProductSubitemDto.setPrice(productSubitem.getPrice());
            detailProductSubitemDto.setIntroduce(productSubitem.getIntroduce());
            subitemList.add(detailProductSubitemDto);
        }
        detailProductDto.setDetailProductMaterialPackageDtoList(materialList.stream().distinct().collect(Collectors.toList()));
        detailProductSpecificationDto.setDetailProductSpecificationValueDtoList(specificationValueList.stream().distinct().collect(Collectors.toList()));
        detailProductDto.setDetailProductSpecificationDto(detailProductSpecificationDto);
        detailProductDto.setDetailProductSubitemDtoList(subitemList.stream().distinct().collect(Collectors.toList()));
        return detailProductDto;
    }

    @Transactional
    public String updateProduct(UpdateProductVo updateProductVo) {
        UpdateProductDataVo updateProductDataVo = updateProductVo.getUpdateProductDataVo();
        QueryWrapper productQueryWrapper = (QueryWrapper)new QueryWrapper().eq((Object)"view_id", (Object)updateProductDataVo.getProductViewId());
        Product product = (Product)this.productMapper.selectOne((Wrapper)productQueryWrapper);
        List productList = this.productMapper.selectList((Wrapper)new QueryWrapper().eq((Object)"name", (Object)updateProductDataVo.getProductName()));
        if (!product.getName().equals(updateProductDataVo.getProductName()) && CollectionUtils.isNotEmpty((Collection)productList)) {
            return "\u5957\u9910\u540d\u5df2\u5b58\u5728,\u8bf7\u91cd\u65b0\u8f93\u5165";
        }
        if (StringUtils.isNotEmpty((CharSequence)updateProductDataVo.getProductName())) {
            product.setName(updateProductDataVo.getProductName());
        }
        if (StringUtils.isNotEmpty((CharSequence)updateProductDataVo.getProductImage())) {
            product.setImage(updateProductDataVo.getProductImage());
        }
        if (updateProductDataVo.getProductCategoryId() != null && updateProductDataVo.getProductCategoryId().intValue() != 0) {
            product.setProductCategoryId(updateProductDataVo.getProductCategoryId());
        }
        product.setFormServiceId(updateProductVo.getUpdateProductDataVo().getFormServiceId());
        product.setFormServiceName(updateProductVo.getUpdateProductDataVo().getFormServiceName());
        QueryWrapper subitemQueryWrapper = (QueryWrapper)new QueryWrapper().eq((Object)"product_id", (Object)product.getId());
        int delete = this.productSubitemMapper.delete((Wrapper)subitemQueryWrapper);
        List updateProductSubitemVoList = updateProductVo.getUpdateProductSubitemVoList();
        BigDecimal decimal = BigDecimal.valueOf(0.0);
        for (UpdateProductSubitemVo updateProductSubitemVo : updateProductSubitemVoList) {
            ProductSubitem productSubitem = new ProductSubitem();
            productSubitem.setViewId(UniqueKeyGenerator.generateUUID());
            productSubitem.setProductId(product.getId());
            productSubitem.setMaterialId(updateProductSubitemVo.getMaterialId());
            productSubitem.setMaterialName(updateProductSubitemVo.getMaterialName());
            productSubitem.setSpecificationId(updateProductSubitemVo.getSpecificationId());
            productSubitem.setSpecificationName(updateProductSubitemVo.getSpecificationName());
            productSubitem.setSpecificationValueId(updateProductSubitemVo.getSpecificationValueId());
            productSubitem.setSpecificationValueName(updateProductSubitemVo.getSpecificationValueName());
            productSubitem.setUsefulLife(updateProductSubitemVo.getUsefulLife());
            productSubitem.setServiceTimes(updateProductSubitemVo.getServiceTimes());
            productSubitem.setPrice(updateProductSubitemVo.getPrice());
            productSubitem.setIntroduce(updateProductSubitemVo.getIntroduce());
            decimal = decimal.multiply(updateProductSubitemVo.getPrice());
            int save = this.productSubitemMapper.insert((Object)productSubitem);
            if (save == 1) continue;
            return "NO";
        }
        product.setPrice(decimal);
        product.setIsMarketable(Integer.valueOf(1));
        int update = this.productMapper.updateById((Object)product);
        if (update != 1) {
            return "NO";
        }
        return "YES";
    }

    public List<SmallProgramProductListDto> smallProgramHomeProductList() {
        ArrayList<SmallProgramProductListDto> list = new ArrayList<SmallProgramProductListDto>();
        List productCategoryList = this.productCategoryMapper.selectList((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"is_displayed_home", (Object)1)).orderByAsc((Object)"sequence"));
        for (ProductCategory productCategory : productCategoryList) {
            SmallProgramProductListDto smallProgramProductListDto = new SmallProgramProductListDto();
            smallProgramProductListDto.setProductCategoryId(productCategory.getId());
            smallProgramProductListDto.setProductCategoryViewId(productCategory.getViewId());
            smallProgramProductListDto.setProductCategoryName(productCategory.getName());
            smallProgramProductListDto.setProductCategoryIcon(productCategory.getIcon());
            List productList = this.productMapper.selectList((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"product_category_id", (Object)productCategory.getId())).eq((Object)"is_marketable", (Object)1)).orderByDesc((Object[])new String[]{"is_top", "create_time"}));
            if (CollectionUtils.isNotEmpty((Collection)productList)) {
                ArrayList<SmallProgramProductListChildDto> childDtos = new ArrayList<SmallProgramProductListChildDto>();
                for (Product product : productList) {
                    SmallProgramProductListChildDto smallProgramProductListChildDto = new SmallProgramProductListChildDto();
                    smallProgramProductListChildDto.setProductName(product.getName());
                    smallProgramProductListChildDto.setProductUrl(product.getImage());
                    smallProgramProductListChildDto.setProductViewId(product.getViewId());
                    smallProgramProductListChildDto.setProductId(product.getId());
                    List productSubitemList = this.productSubitemMapper.selectList((Wrapper)new QueryWrapper().eq((Object)"product_id", (Object)product.getId()));
                    if (CollectionUtils.isNotEmpty((Collection)productSubitemList)) {
                        Optional<ProductSubitem> optional = productSubitemList.stream().min(Comparator.comparing(ProductSubitem::getPrice));
                        if (optional.isPresent()) {
                            ProductSubitem productSubitem = optional.get();
                            smallProgramProductListChildDto.setPrice(productSubitem.getPrice());
                            smallProgramProductListChildDto.setServiceTimes(productSubitem.getServiceTimes());
                            smallProgramProductListChildDto.setUsefulLife(productSubitem.getUsefulLife());
                            smallProgramProductListChildDto.setIntroduce(productSubitem.getIntroduce());
                        }
                        if (productSubitemList.size() > 1) {
                            smallProgramProductListChildDto.setIsMore(Integer.valueOf(1));
                        } else {
                            smallProgramProductListChildDto.setIsMore(Integer.valueOf(0));
                        }
                    }
                    childDtos.add(smallProgramProductListChildDto);
                }
                smallProgramProductListDto.setSmallProgramProductListChildDtoList(childDtos);
            }
            list.add(smallProgramProductListDto);
        }
        return list;
    }

    public List<SmallProgramProductListChildDto> smallProgramProductList(SmallProgramProductListVo smallProgramProductListVo) {
        QueryWrapper categoryQueryWrapper = (QueryWrapper)new QueryWrapper().eq((Object)"view_id", (Object)smallProgramProductListVo.getProductCategoryViewId());
        ProductCategory productCategory = (ProductCategory)this.productCategoryMapper.selectOne((Wrapper)categoryQueryWrapper);
        List productList = this.productMapper.selectList((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"product_category_id", (Object)productCategory.getId())).eq((Object)"is_marketable", (Object)1)).orderByDesc((Object[])new String[]{"is_top", "create_time"}));
        List<Object> childDtos = new ArrayList();
        for (Product product : productList) {
            SmallProgramProductListChildDto smallProgramProductListChildDto = new SmallProgramProductListChildDto();
            smallProgramProductListChildDto.setProductName(product.getName());
            smallProgramProductListChildDto.setProductUrl(product.getImage());
            smallProgramProductListChildDto.setProductViewId(product.getViewId());
            smallProgramProductListChildDto.setProductId(product.getId());
            List productSubitemList = this.productSubitemMapper.selectList((Wrapper)new QueryWrapper().eq((Object)"product_id", (Object)product.getId()));
            Optional<ProductSubitem> optional = productSubitemList.stream().min(Comparator.comparing(ProductSubitem::getPrice));
            if (productSubitemList != null && productSubitemList.size() > 1) {
                smallProgramProductListChildDto.setIsMore(Integer.valueOf(1));
            } else {
                smallProgramProductListChildDto.setIsMore(Integer.valueOf(0));
            }
            if (optional.isPresent()) {
                ProductSubitem productSubitem = optional.get();
                smallProgramProductListChildDto.setPrice(productSubitem.getPrice());
                smallProgramProductListChildDto.setServiceTimes(productSubitem.getServiceTimes());
                smallProgramProductListChildDto.setUsefulLife(productSubitem.getUsefulLife());
                smallProgramProductListChildDto.setIntroduce(productSubitem.getIntroduce());
            }
            childDtos.add(smallProgramProductListChildDto);
        }
        if (CollectionUtils.isEmpty(childDtos)) {
            return new ArrayList<SmallProgramProductListChildDto>();
        }
        if (smallProgramProductListVo.getSortPrice() != null && smallProgramProductListVo.getSortPrice() == 2) {
            childDtos = childDtos.stream().sorted(Comparator.comparing(SmallProgramProductListChildDto::getPrice)).collect(Collectors.toList());
        } else if (smallProgramProductListVo.getSortPrice() != null && smallProgramProductListVo.getSortPrice() == 1) {
            childDtos = childDtos.stream().sorted(Comparator.comparing(SmallProgramProductListChildDto::getPrice).reversed()).collect(Collectors.toList());
        }
        List<SmallProgramProductListChildDto> list = childDtos.stream().skip((long)smallProgramProductListVo.getPageSize().intValue() * (long)(smallProgramProductListVo.getPageIndex() - 1)).limit(smallProgramProductListVo.getPageSize().intValue()).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(list)) {
            return new ArrayList<SmallProgramProductListChildDto>();
        }
        return list;
    }

    public List<SmallProgramTitleDto> smallProgramTitle(String viewId) {
        QueryWrapper productQueryWrapper = (QueryWrapper)new QueryWrapper().eq((Object)"view_id", (Object)viewId);
        Product product = (Product)this.productMapper.selectOne((Wrapper)productQueryWrapper);
        QueryWrapper subitemQueryWrapper = (QueryWrapper)new QueryWrapper().eq((Object)"product_id", (Object)product.getId());
        List productSubitems = this.productSubitemMapper.selectList((Wrapper)subitemQueryWrapper);
        ArrayList<SmallProgramTitleDto> list = new ArrayList<SmallProgramTitleDto>();
        for (ProductSubitem productSubitem : productSubitems) {
            SmallProgramTitleDto smallProgramTitleDto = new SmallProgramTitleDto();
            smallProgramTitleDto.setSpecificationId(productSubitem.getSpecificationValueId());
            smallProgramTitleDto.setSpecificationName(productSubitem.getSpecificationValueName());
            list.add(smallProgramTitleDto);
        }
        if (CollectionUtils.isNotEmpty(list)) {
            return list.stream().distinct().collect(Collectors.toList());
        }
        return new ArrayList<SmallProgramTitleDto>();
    }

    public List<SmallProgramMaterialDto> smallProgramMaterialItem(String viewId) {
        QueryWrapper productQueryWrapper = (QueryWrapper)new QueryWrapper().eq((Object)"view_id", (Object)viewId);
        Product product = (Product)this.productMapper.selectOne((Wrapper)productQueryWrapper);
        QueryWrapper subitemQueryWrapper = (QueryWrapper)new QueryWrapper().eq((Object)"product_id", (Object)product.getId());
        List productSubitems = this.productSubitemMapper.selectList((Wrapper)subitemQueryWrapper);
        ArrayList<SmallProgramMaterialDto> list = new ArrayList<SmallProgramMaterialDto>();
        for (ProductSubitem productSubitem : productSubitems) {
            SmallProgramMaterialDto smallProgramMaterialDto = new SmallProgramMaterialDto();
            smallProgramMaterialDto.setMaterialId(productSubitem.getMaterialId());
            smallProgramMaterialDto.setMaterialName(productSubitem.getMaterialName());
            List materialItems = this.materialItemMapper.selectList((Wrapper)new QueryWrapper().eq((Object)"material_package_id", (Object)productSubitem.getMaterialId()));
            ArrayList<SmallProgramMaterialItemDto> itemDtos = new ArrayList<SmallProgramMaterialItemDto>();
            if (CollectionUtils.isNotEmpty((Collection)materialItems)) {
                for (MaterialItem materialItem : materialItems) {
                    SmallProgramMaterialItemDto smallProgramMaterialItemDto = new SmallProgramMaterialItemDto();
                    smallProgramMaterialItemDto.setId(materialItem.getId());
                    smallProgramMaterialItemDto.setName(materialItem.getName());
                    smallProgramMaterialItemDto.setQuantity(materialItem.getQuantity());
                    itemDtos.add(smallProgramMaterialItemDto);
                }
            }
            smallProgramMaterialDto.setSmallProgramMaterialItemDtoList(itemDtos);
            list.add(smallProgramMaterialDto);
        }
        return list.stream().distinct().collect(Collectors.toList());
    }

    public SmallProgramProductDetailDto smallProgramProductDetail(String viewId, Integer organId) {
        SmallProgramProductDetailDto smallProgramProductDetailDto = new SmallProgramProductDetailDto();
        QueryWrapper productQueryWrapper = (QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"view_id", (Object)viewId)).eq((Object)"is_marketable", (Object)1);
        Product product = (Product)this.productMapper.selectOne((Wrapper)productQueryWrapper);
        smallProgramProductDetailDto.setFormServiceId(product.getFormServiceId());
        smallProgramProductDetailDto.setFormServiceName(product.getFormServiceName());
        QueryWrapper subitemQueryWrapper = (QueryWrapper)new QueryWrapper().eq((Object)"product_id", (Object)product.getId());
        List productSubitems = this.productSubitemMapper.selectList((Wrapper)subitemQueryWrapper);
        ArrayList<SmallProgramTitleDto> smallProgramTitleDtoList = new ArrayList<SmallProgramTitleDto>();
        ArrayList<SmallProgramMaterialDto> smallProgramMaterialDtoList = new ArrayList<SmallProgramMaterialDto>();
        ArrayList<SmallProgramProductSubitemDto> smallProgramProductSubitemDtoList = new ArrayList<SmallProgramProductSubitemDto>();
        for (ProductSubitem productSubitem : productSubitems) {
            SmallProgramProductSubitemDto smallProgramProductSubitemDto = new SmallProgramProductSubitemDto();
            smallProgramProductSubitemDto.setId(productSubitem.getId());
            smallProgramProductSubitemDto.setMaterialId(productSubitem.getMaterialId());
            smallProgramProductSubitemDto.setMaterialName(productSubitem.getMaterialName());
            smallProgramProductSubitemDto.setSpecificationValueId(productSubitem.getSpecificationValueId());
            smallProgramProductSubitemDto.setSpecificationValueName(productSubitem.getSpecificationValueName());
            smallProgramProductSubitemDto.setPrice(productSubitem.getPrice());
            smallProgramProductSubitemDto.setServiceTimes(productSubitem.getServiceTimes());
            smallProgramProductSubitemDto.setUsefulLife(productSubitem.getUsefulLife());
            smallProgramProductSubitemDtoList.add(smallProgramProductSubitemDto);
            SmallProgramTitleDto smallProgramTitleDto = new SmallProgramTitleDto();
            smallProgramTitleDto.setSpecificationId(productSubitem.getSpecificationValueId());
            smallProgramTitleDto.setSpecificationName(productSubitem.getSpecificationValueName());
            smallProgramTitleDtoList.add(smallProgramTitleDto);
            SmallProgramMaterialDto smallProgramMaterialDto = new SmallProgramMaterialDto();
            smallProgramMaterialDto.setMaterialId(productSubitem.getMaterialId());
            smallProgramMaterialDto.setMaterialName(productSubitem.getMaterialName());
            List materialItems = this.materialItemMapper.selectList((Wrapper)new QueryWrapper().eq((Object)"material_package_id", (Object)productSubitem.getMaterialId()));
            ArrayList<SmallProgramMaterialItemDto> itemDtos = new ArrayList<SmallProgramMaterialItemDto>();
            if (CollectionUtils.isNotEmpty((Collection)materialItems)) {
                for (MaterialItem materialItem : materialItems) {
                    SmallProgramMaterialItemDto smallProgramMaterialItemDto = new SmallProgramMaterialItemDto();
                    smallProgramMaterialItemDto.setId(materialItem.getId());
                    smallProgramMaterialItemDto.setName(materialItem.getName());
                    smallProgramMaterialItemDto.setQuantity(materialItem.getQuantity());
                    itemDtos.add(smallProgramMaterialItemDto);
                }
            }
            smallProgramMaterialDto.setSmallProgramMaterialItemDtoList(itemDtos);
            smallProgramMaterialDtoList.add(smallProgramMaterialDto);
        }
        smallProgramProductDetailDto.setSmallProgramMaterialDtoList(smallProgramMaterialDtoList.stream().distinct().collect(Collectors.toList()));
        smallProgramProductDetailDto.setSmallProgramTitleDtoList(smallProgramTitleDtoList.stream().distinct().collect(Collectors.toList()));
        smallProgramProductDetailDto.setSmallProgramProductSubitemDtoList(smallProgramProductSubitemDtoList.stream().distinct().collect(Collectors.toList()));
        HospitalConfig hospitalConfig = (HospitalConfig)this.hospitalConfigService.getOne((Wrapper)new LambdaQueryWrapper().eq(HospitalConfig::getOrganId, (Object)organId));
        smallProgramProductDetailDto.setOverKm(hospitalConfig.getOverKm());
        return smallProgramProductDetailDto;
    }
}

