/*
 * Decompiled with CFR 0.152.
 */
package com.byh.nursingcarenewserver.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.byh.nursingcarenewserver.constant.ComponentConstant;
import com.byh.nursingcarenewserver.manage.DoctorUserEvaluationFeignClient;
import com.byh.nursingcarenewserver.mapper.AppointmentMapper;
import com.byh.nursingcarenewserver.mapper.OrderMapper;
import com.byh.nursingcarenewserver.mapper.ProductSubitemMapper;
import com.byh.nursingcarenewserver.pojo.entity.Appointment;
import com.byh.nursingcarenewserver.pojo.entity.Orders;
import com.byh.nursingcarenewserver.pojo.entity.ProductSubitem;
import com.byh.nursingcarenewserver.pojo.enums.AppointmentStatusEnum;
import com.byh.nursingcarenewserver.pojo.enums.OrderStatusDescribeEnum;
import com.byh.nursingcarenewserver.pojo.enums.OrderStatusEnum;
import com.byh.nursingcarenewserver.pojo.enums.ServerCodeEnum;
import com.byh.nursingcarenewserver.pojo.vo.AddCommentVO;
import com.byh.nursingcarenewserver.service.AppWebPushService;
import com.byh.nursingcarenewserver.service.AppointmentService;
import com.byh.nursingcarenewserver.utils.DateUtils;
import com.byh.nursingcarenewserver.utils.PushParamUtil;
import com.ebaiyihui.framework.response.BaseResponse;
import java.io.Serializable;
import java.text.ParseException;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class ScheduledService {
    private static final Logger log = LoggerFactory.getLogger(ScheduledService.class);
    @Autowired
    private AppointmentMapper appointmentMapper;
    @Autowired
    private OrderMapper orderMapper;
    @Autowired
    private ProductSubitemMapper productSubitemMapper;
    @Autowired
    private AppWebPushService appWebPushService;
    @Resource
    private PushParamUtil pushParamUtil;
    @Resource
    private ComponentConstant componentConstant;
    @Resource
    private DoctorUserEvaluationFeignClient evaluationFeignClient;
    @Resource
    private AppointmentService appointmentService;

    @Scheduled(cron="0 0 1 * * ?")
    public void patientDefaultCommentScheduler() {
        log.info("=====\u8fdb\u5165\u5b9a\u65f6\u4efb\u52a1>>>\u60a3\u8005\u8d85\u8fc77\u5929\u672a\u8bc4\u4ef7\u9ed8\u8ba4\u4e94\u661f\u597d\u8bc4");
        List appointmentList = this.appointmentMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(Appointment::getStatus, (Object)AppointmentStatusEnum.APPOINTMENT_STATUS_FWJS.getValue())).eq(Appointment::getCommentFlag, (Object)0));
        if (CollectionUtils.isEmpty((Collection)appointmentList)) {
            log.info("\u5df2\u5b8c\u6210\u9884\u7ea6\u5355\u5168\u90e8\u5df2\u8bc4\u4ef7\uff0c\u5b9a\u65f6\u4efb\u52a1\u9000\u51fa");
            return;
        }
        appointmentList.forEach(appointment -> {
            BaseResponse baseResponse = this.evaluationFeignClient.getDoctorEvaluationMsg("", ServerCodeEnum.HLZH.name(), appointment.getViewId(), null);
            if (null != baseResponse && null != baseResponse.getData() && ((List)baseResponse.getData()).size() > 0) {
                log.info("\u5f53\u524d\u9884\u7ea6\u5355{}\u5df2\u8bc4\u4ef7", (Object)appointment.getViewId());
                appointment.setCommentFlag(Integer.valueOf(1));
                this.appointmentMapper.updateById(appointment);
            } else {
                String serverEndTimeStr = appointment.getServerEndTime();
                if (StringUtils.isBlank((CharSequence)serverEndTimeStr)) {
                    return;
                }
                try {
                    String plusDay = DateUtils.plusDayByPattern((int)7, (String)serverEndTimeStr, (String)"yyyy-MM-dd");
                    log.info("\u9884\u7ea6\u5355{}\u670d\u52a1\u5b8c\u6210\u65f6\u95f4{},\u8bc4\u4ef7\u8fc7\u671f\u65e5\u671f{}", new Object[]{appointment.getViewId(), serverEndTimeStr, plusDay});
                    String currentDay = DateUtils.getDate((Date)new Date());
                    log.info("\u5f53\u524d\u65e5\u671f{}", (Object)currentDay);
                    if (currentDay.compareTo(plusDay) > 0) {
                        log.info("\u9884\u7ea6\u5355{}\u60a3\u8005\u8d85\u8fc77\u5929\u672a\u8bc4\u4ef7\uff0c\u8fdb\u5165\u9ed8\u8ba4\u8bc4\u4ef7\u65b9\u6cd5", (Object)appointment.getViewId());
                        this.addDefalutComment(appointment);
                    }
                }
                catch (ParseException e) {
                    log.error("\u65e5\u671f\u89e3\u6790\u5f02\u5e38", (Throwable)e);
                }
            }
        });
    }

    private void addDefalutComment(Appointment appointment) {
        Orders order = (Orders)this.orderMapper.selectById((Serializable)appointment.getServiceOrderId());
        AddCommentVO addCommentVO = new AddCommentVO();
        addCommentVO.setAppCode(this.componentConstant.getAppCode());
        addCommentVO.setOrganId(String.valueOf(appointment.getDoctorOrganId()));
        addCommentVO.setDoctorId(String.valueOf(appointment.getDoctorId()));
        addCommentVO.setDoctorName(appointment.getDoctorName());
        addCommentVO.setPaitientId(String.valueOf(order.getPatientId()));
        addCommentVO.setPatientName(order.getPatientName());
        addCommentVO.setDoctorScore(Byte.valueOf((byte)5));
        addCommentVO.setViewId(appointment.getViewId());
        addCommentVO.setRemark(order.getPatientPhone());
        this.appointmentService.insertOrderComment(addCommentVO);
        log.info("\u9884\u7ea6\u5355{}\u9ed8\u8ba45\u661f\u597d\u8bc4\u6210\u529f", (Object)appointment.getViewId());
    }

    @Scheduled(cron="0 0/30 * * * ?")
    public void deleteUnpaidOrder() {
        log.info("\u8fdb\u5165\u5b9a\u65f6\u4efb\u52a1====\u5220\u9664\u672a\u652f\u4ed8\u8ba2\u5355===");
        List idList = this.orderMapper.selectUnpaidOrder();
        if (CollectionUtils.isEmpty((Collection)idList)) {
            log.info("\u65e0\u672a\u652f\u4ed8\u8ba2\u5355\uff0c\u5b9a\u65f6\u4efb\u52a1\u9000\u51fa");
            return;
        }
        log.info("\u5220\u9664\u672a\u652f\u4ed8\u8ba2\u5355id\u96c6\u5408\u4e3a{}", (Object)JSONObject.toJSONString((Object)idList));
        int i = this.orderMapper.deleteBatchIds((Collection)idList);
        log.info("\u5220\u9664\u672a\u652f\u4ed8\u8ba2\u5355\uff0c\u5f71\u54cd\u884c\u6570\u4e3a{}", (Object)i);
    }

    @Scheduled(cron="0 0 23 * * ?")
    @Transactional(rollbackFor={Exception.class})
    public void overdueOrders() {
        List ordersList = this.orderMapper.selectList((Wrapper)new QueryWrapper().eq((Object)"status", (Object)OrderStatusEnum.ORDER_STATUS_SYZ.getValue()));
        for (Orders orders : ordersList) {
            try {
                ProductSubitem productSubitem = this.productSubitemMapper.queryById(orders.getProductSubitemId());
                if (Objects.isNull(productSubitem)) {
                    log.info("\u672a\u627e\u5230\u8ba2\u5355,{}", (Object)orders.getId());
                    continue;
                }
                log.info("\u627e\u5230\u8ba2\u5355:{}", (Object)JSON.toJSONString((Object)productSubitem));
                Date plusDay = null;
                plusDay = DateUtils.plusDay1((int)productSubitem.getUsefulLife(), (String)DateUtils.dateToString((Date)orders.getCreateTime()));
                log.info("\u8ba2\u5355\uff1a{},\u7684\u8fc7\u671f\u65e5\u671f\u662f\uff1a{}", (Object)orders.getId(), (Object)DateUtils.dateFormat((Date)plusDay));
                Date date = new Date();
                int compareTo = date.compareTo(plusDay);
                if (compareTo <= 0) continue;
                orders.setStatus(OrderStatusEnum.ORDER_STATUS_YGQ.getValue());
                orders.setStatusDescribe(OrderStatusDescribeEnum.STATUS_YGQ.getDisplay());
                orders.setServerResidueNum(Integer.valueOf(0));
                this.orderMapper.update((Object)orders, (Wrapper)new UpdateWrapper().eq((Object)"id", (Object)orders.getId()));
            }
            catch (Exception e) {
                log.error("\u5b9a\u65f6\u4efb\u52a1\u8fc7\u671f\u8ba2\u5355\u5904\u7406\uff0c\u51fa\u9519\u8ba2\u5355\uff1a{}\uff0c\u9519\u8bef\u4fe1\u606f\uff1a{}", (Object)orders.getId(), (Object)e.getMessage());
            }
        }
    }

    @Scheduled(cron="0 0 * * * ?")
    public void todayBeforeTwoPush() {
        log.info("===========\u5f53\u5929\u9884\u7ea6\u5355\u9884\u7ea6\u524d2\u5c0f\u65f6\u63a8\u9001\u5f00\u59cb=========");
        String date = "";
        try {
            date = DateUtils.getDate((Date)new Date());
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u5f53\u524d\u65e5\u671f\u9519\u8bef");
        }
        Integer dateTime = DateUtils.dateToTimeStamp((String)DateUtils.javaDateParseStringByPattern((Date)new Date(), (String)"yyyy-MM-dd HH"), (String)"yyyy-MM-dd HH");
        log.info("\u83b7\u53d6\u5f53\u524d\u65f6\u95f4\u6574\u5c0f\u65f6\u7684\u65f6\u95f4\u6233\u4e3a:{}", (Object)dateTime);
        Integer dateBeforeTime = dateTime + 7200;
        log.info("\u83b7\u53d6\u4e24\u4e2a\u5c0f\u65f6\u5019\u540e\u7684\u65f6\u95f4\u6233\u4e3a:{}", (Object)dateBeforeTime);
        Integer dateAfterTime = dateBeforeTime + 3600;
        log.info("\u83b7\u53d6\u4e24\u4e2a\u5c0f\u65f6\u5019\u540e\u7684\u65f6\u95f4\u6233\u4e3a:{}", (Object)dateBeforeTime);
        List appointmentList = this.appointmentMapper.selectList((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"status", (Object)AppointmentStatusEnum.APPOINTMENT_STATUS_DFW.getValue())).like((Object)"appointment_time", (Object)date));
        if (CollectionUtils.isNotEmpty((Collection)appointmentList)) {
            for (Appointment appointment : appointmentList) {
                Integer appointmentTimeInteger = null;
                String appointmentTime = null;
                String[] split1 = null;
                try {
                    String[] split = appointment.getAppointmentTime().split(" ");
                    split1 = split[1].split("-");
                    appointmentTime = split[0] + " " + split1[0] + ":00";
                    appointmentTimeInteger = DateUtils.dateToTimeStamp((String)appointmentTime, (String)"yyyy-MM-dd HH:mm:ss");
                }
                catch (Exception e) {
                    log.error("\u9884\u7ea6\u65f6\u95f4\u683c\u5f0f\u51fa\u73b0\u9519\u8bef\uff0c\u65e0\u6cd5\u6b63\u786e\u5206\u89e3\uff0c\u76f4\u63a5\u8df3\u8fc7\u3002\u9519\u8bef\u5982\u4e0b\uff1a", (Throwable)e);
                    continue;
                }
                log.info("appointmentTime:{},appTimeInteger:{}", (Object)appointmentTime, (Object)appointmentTimeInteger);
                log.info("appointmentTimeBefore:{}", (Object)dateBeforeTime);
                log.info("appointmentTimeAfter:{}", (Object)dateAfterTime);
                try {
                    if (appointmentTimeInteger < dateBeforeTime || appointmentTimeInteger >= dateAfterTime) continue;
                    log.info("\u5f53\u5929\u9884\u7ea6\u5355\u9884\u7ea6\u524d2\u5c0f\u65f6\u63a8\u9001id:{}", (Object)appointment.getId());
                    String userId = this.pushParamUtil.getUserIdByDoctorId(appointment.getDoctorId(), appointment.getDoctorOrganId().toString());
                    this.appWebPushService.todayBeforeTwoPush(this.componentConstant.getAppCode(), userId, split1[0]);
                }
                catch (Exception e) {
                    log.info("\u5f53\u5929\u9884\u7ea6\u5355\u9884\u7ea6\u524d2\u5c0f\u65f6\u63a8\u9001\u5f02\u5e38id\uff1a{}", (Object)appointment.getId());
                }
            }
        } else {
            log.info("===========\u5f53\u5929\u9884\u7ea6\u5355\u9884\u7ea6\u524d2\u5c0f\u65f6\u63a8  \u65e0\u8ba2\u5355=========");
        }
    }
}

