/*
 * Decompiled with CFR 0.152.
 */
package com.byh.nursingcarenewserver.constant;

import com.byh.nursingcarenewserver.pojo.entity.HospitalConfig;
import com.byh.nursingcarenewserver.service.HospitalConfigService;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class HospitalConfigConstant {
    private static final Logger log = LoggerFactory.getLogger(HospitalConfigConstant.class);
    public static String ORGAN_NAME;
    public static Double HOS_LAT;
    public static Double HOS_LNG;
    public static Double BAS_TRIP;
    public static Double OVER_KIM;
    public static Double FREE_KIM;
    public static Double ADD_FEE;
    @Resource
    private HospitalConfigService hospitalConfigService;

    @PostConstruct
    public void init() {
        HospitalConfig hospitalConfig = (HospitalConfig)this.hospitalConfigService.list().get(0);
        HOS_LAT = Double.valueOf(hospitalConfig.getHosLat());
        HOS_LNG = Double.valueOf(hospitalConfig.getHosLng());
        BAS_TRIP = Double.parseDouble(hospitalConfig.getBasTrip());
        OVER_KIM = Double.parseDouble(hospitalConfig.getOverKm());
        FREE_KIM = Double.parseDouble(hospitalConfig.getFreeKm());
        ORGAN_NAME = hospitalConfig.getOrganName();
        ADD_FEE = Double.valueOf(hospitalConfig.getAddFee());
        log.info("\u521d\u59cb\u5316\u533b\u9662\u914d\u7f6e\uff0c\u5982\u4e0b\uff1aHos_lat = {},hos_lng = {}", (Object)HOS_LAT, (Object)HOS_LNG);
    }

    public HospitalConfigService getHospitalConfigService() {
        return this.hospitalConfigService;
    }

    public void setHospitalConfigService(HospitalConfigService hospitalConfigService) {
        this.hospitalConfigService = hospitalConfigService;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HospitalConfigConstant)) {
            return false;
        }
        HospitalConfigConstant other = (HospitalConfigConstant)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        HospitalConfigService this$hospitalConfigService = this.getHospitalConfigService();
        HospitalConfigService other$hospitalConfigService = other.getHospitalConfigService();
        return !(this$hospitalConfigService == null ? other$hospitalConfigService != null : !this$hospitalConfigService.equals(other$hospitalConfigService));
    }

    protected boolean canEqual(Object other) {
        return other instanceof HospitalConfigConstant;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        HospitalConfigService $hospitalConfigService = this.getHospitalConfigService();
        result = result * 59 + ($hospitalConfigService == null ? 43 : $hospitalConfigService.hashCode());
        return result;
    }

    public String toString() {
        return "HospitalConfigConstant(hospitalConfigService=" + this.getHospitalConfigService() + ")";
    }
}

