/*
 * Decompiled with CFR 0.152.
 */
package com.byh.nursingcarenewserver.controller;

import com.byh.nursingcarenewserver.pojo.dto.DetailOrderDto;
import com.byh.nursingcarenewserver.pojo.dto.OrderExcelListDto;
import com.byh.nursingcarenewserver.pojo.dto.OrderListPageDto;
import com.byh.nursingcarenewserver.pojo.dto.QueryOrderToUserDto;
import com.byh.nursingcarenewserver.pojo.vo.DeleteOrderVo;
import com.byh.nursingcarenewserver.pojo.vo.DoctorRefundOrderVo;
import com.byh.nursingcarenewserver.pojo.vo.DownOrderExcelVo;
import com.byh.nursingcarenewserver.pojo.vo.OrderListVo;
import com.byh.nursingcarenewserver.pojo.vo.QueryOrderToUserVo;
import com.byh.nursingcarenewserver.pojo.vo.SaveOrderVo;
import com.byh.nursingcarenewserver.service.OrderService;
import com.byh.nursingcarenewserver.utils.ExcelUtils;
import com.ebaiyihui.framework.response.BaseResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
@RequestMapping(value={"/api/v1/order"})
@Api(tags={"\u8ba2\u5355\u7ba1\u7406API"})
public class OrderController
extends BaseResponse {
    private static final Logger log = LoggerFactory.getLogger(OrderController.class);
    @Autowired
    private OrderService orderService;

    @PostMapping(value={"/download/excel"}, produces={"application/vnd.ms-excel"})
    @ApiOperation(value="\u5bfc\u51fa\u8ba2\u5355")
    public BaseResponse<String> downloadOrderExcel(@RequestBody DownOrderExcelVo downOrderExcelVo, HttpServletResponse response) {
        OrderListVo orderListVo = new OrderListVo();
        orderListVo.setCreateTimeBegin(downOrderExcelVo.getCreateTimeBegin());
        orderListVo.setCreateTimeEnd(downOrderExcelVo.getCreateTimeEnd());
        orderListVo.setOrderStatus(downOrderExcelVo.getOrderStatus());
        orderListVo.setSearch(downOrderExcelVo.getSearch());
        List orderExcelListDtos = this.orderService.getExportExcelOrderList(orderListVo);
        try {
            ExcelUtils.exportExcel((List)orderExcelListDtos, (String)"\u8ba2    \u5355    \u6570    \u636e    \u5bfc    \u51fa    \u8868    \u683c", (String)"\u8ba2\u5355\u6570\u636e\u5bfc\u51fa", OrderExcelListDto.class, (String)"\u8ba2\u5355\u6570\u636e\u5bfc\u51fa\u8868\u683c", (HttpServletResponse)response);
        }
        catch (IOException e) {
            log.info("\u4e0b\u8f7d\u6587\u4ef6\u51fa\u73b0\u62a5\u9519\u5982\u4e0b\uff1a", (Throwable)e);
        }
        return null;
    }

    @PostMapping(value={"/save/order"})
    @ApiOperation(value="\u7528\u6237\u65b0\u7533\u8bf7\u8ba2\u5355")
    public BaseResponse<String> saveOrder(@RequestBody @Validated SaveOrderVo saveOrderVo) {
        String str = this.orderService.saveOrder(saveOrderVo);
        return OrderController.success((Object)str);
    }

    @ApiOperation(value="\u8ba2\u5355\u5217\u8868")
    @PostMapping(value={"/getList"})
    public BaseResponse<OrderListPageDto> getListOrder(@RequestBody @Validated OrderListVo orderListVo) {
        OrderListPageDto result = this.orderService.getListOrder(orderListVo);
        return OrderController.success((Object)result);
    }

    @ApiOperation(value="\u7efc\u7ba1\u7aef\u8ba2\u5355\u8be6\u60c5")
    @GetMapping(value={"/detail"})
    public BaseResponse<DetailOrderDto> detailOrder(@RequestParam(value="orderViewId") String orderViewId) {
        DetailOrderDto result = this.orderService.detailOrder(orderViewId);
        return OrderController.success((Object)result);
    }

    @PostMapping(value={"/get/list/order/to/user"})
    @ApiOperation(value="\u60a3\u8005\u7aef\u83b7\u53d6\u8ba2\u5355\u5217\u8868")
    public BaseResponse<List<QueryOrderToUserDto>> getListOrderToUser(@RequestBody @Validated QueryOrderToUserVo queryOrderToUserVo) {
        List listOrderToUser = this.orderService.getListOrderToUser(queryOrderToUserVo);
        return OrderController.success((Object)listOrderToUser);
    }

    @GetMapping(value={"/get/order/to/user"})
    @ApiOperation(value="\u60a3\u8005\u7aef\u83b7\u53d6\u8ba2\u5355\u8be6\u60c5")
    public BaseResponse<QueryOrderToUserDto> getOrderToUser(@RequestParam(value="orderViewId") String orderViewId) {
        QueryOrderToUserDto orderToUser = this.orderService.getOrderToUser(orderViewId);
        return OrderController.success((Object)orderToUser);
    }

    @PostMapping(value={"/doctor/refund/order"})
    @ApiOperation(value="\u7ba1\u7406\u5458\u9000\u6b3e\u8ba2\u5355")
    public BaseResponse<String> doctorRefundOrder(@RequestBody @Validated DoctorRefundOrderVo doctorRefundOrderVo) {
        return this.orderService.doctorRefundOrder(doctorRefundOrderVo);
    }

    @GetMapping(value={"/user/refund/order"})
    @ApiOperation(value="\u7528\u6237\u9000\u6b3e\u8ba2\u5355")
    public BaseResponse<String> userRefundOrder(@RequestParam(value="orderViewId") String orderViewId, @RequestParam(value="appCode") String appCode) {
        String str = this.orderService.userRefundOrder(orderViewId, appCode);
        return OrderController.success((Object)str);
    }

    @PostMapping(value={"/deleteOrder"})
    @ApiOperation(value="\u8ba2\u5355\u672a\u4ed8\u6b3e \u5220\u9664\u8ba2\u5355")
    public BaseResponse<String> deleteOrder(@RequestBody @Validated DeleteOrderVo deleteOrderVo) {
        String str = this.orderService.deleteOrder(deleteOrderVo);
        if ("YES".equals(str)) {
            return OrderController.success();
        }
        return OrderController.error((String)str);
    }
}

