/*
 * Decompiled with CFR 0.152.
 */
package com.byh.nursingcarenewserver.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.byh.nursingcarenewserver.mapper.DoctorPoolMapper;
import com.byh.nursingcarenewserver.pojo.dto.DoctorPoolListDto;
import com.byh.nursingcarenewserver.pojo.entity.DoctorPool;
import com.byh.nursingcarenewserver.pojo.vo.AddDoctorPoolVo;
import com.byh.nursingcarenewserver.pojo.vo.UpdateDoctorPoolVo;
import com.byh.nursingcarenewserver.service.DoctorPoolService;
import com.byh.nursingcarenewserver.utils.DateUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DoctorPoolServiceImpl
extends ServiceImpl<DoctorPoolMapper, DoctorPool>
implements DoctorPoolService {
    private static final Logger log = LoggerFactory.getLogger(DoctorPoolServiceImpl.class);
    @Autowired
    private DoctorPoolMapper doctorPoolMapper;

    @Transactional(rollbackFor={Exception.class})
    public String addDoctorPool(List<AddDoctorPoolVo> addDoctorPoolVoList) {
        String date = "";
        try {
            date = DateUtils.getDate((Date)new Date());
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u5f53\u524d\u65e5\u671f\u9519\u8bef");
        }
        if (CollectionUtils.isNotEmpty(addDoctorPoolVoList)) {
            for (AddDoctorPoolVo addDoctorPoolVo : addDoctorPoolVoList) {
                DoctorPool doctorPool = new DoctorPool();
                doctorPool.setDoctorId(addDoctorPoolVo.getDoctorId());
                doctorPool.setDoctorName(addDoctorPoolVo.getDoctorName());
                doctorPool.setDoctorDeptId(addDoctorPoolVo.getDoctorDeptId());
                doctorPool.setDoctorDeptName(addDoctorPoolVo.getDoctorDeptName());
                doctorPool.setDoctorOrganId(addDoctorPoolVo.getDoctorOrganId());
                doctorPool.setDoctorOrganName(addDoctorPoolVo.getDoctorOrganName());
                doctorPool.setProfession(addDoctorPoolVo.getProfession());
                doctorPool.setAppCode(addDoctorPoolVo.getAppCode());
                doctorPool.setDateTime(date);
                this.doctorPoolMapper.insert((Object)doctorPool);
            }
        }
        return "YES";
    }

    public String updateDoctorPool(List<UpdateDoctorPoolVo> updateDoctorPoolVoList) {
        String date = "";
        try {
            date = DateUtils.getDate((Date)new Date());
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u5f53\u524d\u65e5\u671f\u9519\u8bef");
        }
        List doctorPoolList = this.doctorPoolMapper.selectList(null);
        if (CollectionUtils.isNotEmpty((Collection)doctorPoolList)) {
            this.doctorPoolMapper.delete(null);
        }
        if (CollectionUtils.isNotEmpty(updateDoctorPoolVoList)) {
            for (UpdateDoctorPoolVo updateDoctorPoolVo : updateDoctorPoolVoList) {
                DoctorPool doctorPool = new DoctorPool();
                doctorPool.setDoctorId(updateDoctorPoolVo.getDoctorId());
                doctorPool.setDoctorName(updateDoctorPoolVo.getDoctorName());
                doctorPool.setDoctorDeptId(updateDoctorPoolVo.getDoctorDeptId());
                doctorPool.setDoctorDeptName(updateDoctorPoolVo.getDoctorDeptName());
                doctorPool.setDoctorOrganId(updateDoctorPoolVo.getDoctorOrganId());
                doctorPool.setDoctorOrganName(updateDoctorPoolVo.getDoctorOrganName());
                doctorPool.setProfession(updateDoctorPoolVo.getProfession());
                doctorPool.setAppCode(updateDoctorPoolVo.getAppCode());
                doctorPool.setDateTime(date);
                this.doctorPoolMapper.insert((Object)doctorPool);
            }
        }
        return "YES";
    }

    public List<DoctorPoolListDto> getDoctorPoolList() {
        ArrayList<DoctorPoolListDto> list = new ArrayList<DoctorPoolListDto>();
        List doctorPoolList = this.doctorPoolMapper.selectList(null);
        if (CollectionUtils.isNotEmpty((Collection)doctorPoolList)) {
            for (DoctorPool doctorPool : doctorPoolList) {
                DoctorPoolListDto doctorPoolListDto = new DoctorPoolListDto();
                doctorPoolListDto.setDoctorId(doctorPool.getDoctorId());
                doctorPoolListDto.setDoctorName(doctorPool.getDoctorName());
                doctorPoolListDto.setDoctorDeptId(doctorPool.getDoctorDeptId());
                doctorPoolListDto.setDoctorDeptName(doctorPool.getDoctorDeptName());
                doctorPoolListDto.setDoctorOrganId(doctorPool.getDoctorOrganId());
                doctorPoolListDto.setDoctorOrganName(doctorPool.getDoctorOrganName());
                doctorPoolListDto.setProfession(doctorPool.getProfession());
                doctorPoolListDto.setAppCode(doctorPool.getAppCode());
                list.add(doctorPoolListDto);
            }
        }
        return list;
    }

    public DoctorPool selectByDoctorId(Long doctorId) {
        DoctorPool doctorPool = (DoctorPool)this.doctorPoolMapper.selectOne((Wrapper)new QueryWrapper().eq((Object)"doctor_id", (Object)doctorId));
        if (null != doctorPool) {
            return doctorPool;
        }
        return null;
    }
}

