/*
 * Decompiled with CFR 0.152.
 */
package com.byh.nursingcarenewserver.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.byh.nursingcarenewserver.mapper.ProductCategoryMapper;
import com.byh.nursingcarenewserver.mapper.ProductMapper;
import com.byh.nursingcarenewserver.pojo.dto.ProductCategoryManagementDto;
import com.byh.nursingcarenewserver.pojo.entity.ProductCategory;
import com.byh.nursingcarenewserver.pojo.vo.DeleteVo;
import com.byh.nursingcarenewserver.pojo.vo.SequenceProductCategoryVo;
import com.byh.nursingcarenewserver.pojo.vo.UpdateProductCategoryVo;
import com.byh.nursingcarenewserver.service.ProductCategoryService;
import com.ebaiyihui.framework.response.BaseResponse;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ProductCategoryServiceImpl
extends ServiceImpl<ProductCategoryMapper, ProductCategory>
implements ProductCategoryService {
    @Autowired
    private ProductCategoryMapper productCategoryMapper;
    @Autowired
    private ProductMapper productMapper;

    public BaseResponse<String> updateProductCategory(UpdateProductCategoryVo updateProductCategoryVo) {
        ProductCategory category = (ProductCategory)this.productCategoryMapper.selectOne((Wrapper)new QueryWrapper().eq((Object)"name", (Object)updateProductCategoryVo.getName()));
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"view_id", (Object)updateProductCategoryVo.getViewId());
        ProductCategory productCategory = (ProductCategory)this.productCategoryMapper.selectOne((Wrapper)queryWrapper);
        if (!productCategory.getName().equals(updateProductCategoryVo.getName()) && category != null) {
            return BaseResponse.error((String)"\u5206\u7c7b\u540d\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165");
        }
        Integer updateBoolean = 0;
        if (productCategory != null) {
            productCategory.setIcon(updateProductCategoryVo.getUrl());
            productCategory.setName(updateProductCategoryVo.getName());
            productCategory.setIsDisplayedHome(updateProductCategoryVo.getIsDisplayedHome());
            UpdateWrapper updateWrapper = new UpdateWrapper();
            updateWrapper.eq((Object)"view_id", (Object)updateProductCategoryVo.getViewId());
            updateBoolean = this.productCategoryMapper.update((Object)productCategory, (Wrapper)updateWrapper);
        }
        if (updateBoolean != 0) {
            return BaseResponse.success();
        }
        return BaseResponse.error((String)"\u5931\u8d25");
    }

    public BaseResponse<String> deleteProductCategory(DeleteVo deleteVo) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"view_id", (Object)deleteVo.getViewId());
        ProductCategory productCategory = (ProductCategory)this.productCategoryMapper.selectOne((Wrapper)queryWrapper);
        QueryWrapper queryProductWrapper = new QueryWrapper();
        queryProductWrapper.eq((Object)"product_category_id", (Object)productCategory.getId());
        List products = this.productMapper.selectList((Wrapper)queryProductWrapper);
        if (CollectionUtils.isEmpty((Collection)products)) {
            int delete = this.productCategoryMapper.delete((Wrapper)queryWrapper);
            if (delete != 1) {
                return BaseResponse.error((String)"\u5931\u8d25");
            }
        } else {
            return BaseResponse.error((String)"\u8bf7\u5148\u79fb\u9664\u5206\u7c7b\u4e2d\u7684\u5957\u9910\u518d\u5220\u9664\u5206\u7c7b");
        }
        return BaseResponse.success();
    }

    public ProductCategory selectMaxSequence() {
        ProductCategory productCategory = this.productCategoryMapper.selectMaxSequence();
        return productCategory;
    }

    @Transactional
    public Boolean sequenceProductCategory(SequenceProductCategoryVo sequenceProductCategoryVo) {
        List productCategoryIds = sequenceProductCategoryVo.getProductCategoryIds();
        int index = 0;
        for (Long productCategoryId : productCategoryIds) {
            ProductCategory productCategory = (ProductCategory)this.productCategoryMapper.selectById((Serializable)productCategoryId);
            productCategory.setSequence(Integer.valueOf(index));
            UpdateWrapper updateWrapper = new UpdateWrapper();
            updateWrapper.eq((Object)"id", (Object)productCategoryId);
            int update = this.productCategoryMapper.update((Object)productCategory, (Wrapper)updateWrapper);
            if (update != 1) {
                return false;
            }
            ++index;
        }
        return true;
    }

    public List<ProductCategoryManagementDto> getListProductCategoryManagement() {
        ArrayList<ProductCategoryManagementDto> list = new ArrayList<ProductCategoryManagementDto>();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.orderByAsc((Object)"sequence");
        List productCategories = this.productCategoryMapper.selectList((Wrapper)queryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)productCategories)) {
            for (ProductCategory productCategory : productCategories) {
                ProductCategoryManagementDto productCategoryManagementDto = new ProductCategoryManagementDto();
                productCategoryManagementDto.setId(productCategory.getId());
                productCategoryManagementDto.setViewId(productCategory.getViewId());
                productCategoryManagementDto.setName(productCategory.getName());
                productCategoryManagementDto.setIcon(productCategory.getIcon());
                productCategoryManagementDto.setIsDisplayedHome(productCategory.getIsDisplayedHome());
                productCategoryManagementDto.setSequence(productCategory.getSequence());
                List productList = this.productMapper.selectList((Wrapper)new QueryWrapper().eq((Object)"product_category_id", (Object)productCategory.getId()));
                if (CollectionUtils.isNotEmpty((Collection)productList)) {
                    productCategoryManagementDto.setProductNum(Integer.valueOf(productList.size()));
                } else {
                    productCategoryManagementDto.setProductNum(Integer.valueOf(0));
                }
                list.add(productCategoryManagementDto);
            }
        }
        return list;
    }

    public List<ProductCategory> getListProductCategoryPatient() {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.orderByAsc((Object)"sequence");
        List productCategories = this.productCategoryMapper.selectList((Wrapper)queryWrapper);
        return productCategories;
    }
}

