/*
 * Decompiled with CFR 0.152.
 */
package com.byh.nursingcarenewserver.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.byh.nursingcarenewserver.constant.HospitalConfigConstant;
import com.byh.nursingcarenewserver.mapper.UserAddressMapper;
import com.byh.nursingcarenewserver.pojo.dto.DistanceDto;
import com.byh.nursingcarenewserver.pojo.dto.QueryUserAddressDto;
import com.byh.nursingcarenewserver.pojo.entity.UserAddress;
import com.byh.nursingcarenewserver.pojo.vo.SaveUserAddressVo;
import com.byh.nursingcarenewserver.pojo.vo.UpdateUserAddressVo;
import com.byh.nursingcarenewserver.service.UserAddressService;
import com.byh.nursingcarenewserver.service.impl.CartItemServiceImpl;
import com.byh.nursingcarenewserver.utils.DistanceUtil;
import com.byh.nursingcarenewserver.utils.UniqueKeyGenerator;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class UserAddressServiceImpl
extends ServiceImpl<UserAddressMapper, UserAddress>
implements UserAddressService {
    @Autowired
    private UserAddressMapper userAddressMapper;
    private static final String USER_ID = "user_id";
    private static final String IS_DEFAULT = "is_default";

    @Transactional(rollbackFor={Exception.class})
    public String saveUserAddress(SaveUserAddressVo saveUserAddressVo) {
        UserAddress userAddress;
        Integer noDefault = 0;
        UserAddress isDefault = (UserAddress)this.userAddressMapper.selectOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)IS_DEFAULT, (Object)1)).eq((Object)USER_ID, (Object)saveUserAddressVo.getUserId()));
        if (Objects.nonNull(isDefault) && Integer.valueOf(1).equals(saveUserAddressVo.getIsDefault())) {
            userAddress = new UserAddress();
            userAddress.setId(isDefault.getId());
            userAddress.setIsDefault(noDefault);
            this.userAddressMapper.updateById((Object)userAddress);
        }
        userAddress = new UserAddress();
        BeanUtils.copyProperties((Object)saveUserAddressVo, (Object)userAddress);
        userAddress.setViewId(UniqueKeyGenerator.generateViewId().toString());
        this.userAddressMapper.insert((Object)userAddress);
        return "\u5730\u5740\u6dfb\u52a0\u6210\u529f";
    }

    public List<QueryUserAddressDto> selectUserAddressByUserId(Long userId) {
        ArrayList<QueryUserAddressDto> queryUserAddressDtoList = new ArrayList<QueryUserAddressDto>();
        List userAddressList = this.userAddressMapper.selectList((Wrapper)new QueryWrapper().eq((Object)USER_ID, (Object)userId));
        for (UserAddress userAddress : userAddressList) {
            QueryUserAddressDto queryUserAddressDto = new QueryUserAddressDto();
            BeanUtils.copyProperties((Object)userAddress, (Object)queryUserAddressDto);
            double distance = DistanceUtil.distance((double)userAddress.getLatitude(), (double)userAddress.getLongitude(), (double)HospitalConfigConstant.HOS_LAT, (double)HospitalConfigConstant.HOS_LNG);
            this.getIsDistributionAndAddrPrice(distance, queryUserAddressDto);
            queryUserAddressDtoList.add(queryUserAddressDto);
        }
        return queryUserAddressDtoList;
    }

    public QueryUserAddressDto selectUserAddressByAddrId(Long addrId) {
        UserAddress userAddress = (UserAddress)this.userAddressMapper.selectById((Serializable)addrId);
        if (Objects.isNull(userAddress)) {
            return null;
        }
        QueryUserAddressDto queryUserAddressDto = new QueryUserAddressDto();
        BeanUtils.copyProperties((Object)userAddress, (Object)queryUserAddressDto);
        double distance = DistanceUtil.distance((double)userAddress.getLatitude(), (double)userAddress.getLongitude(), (double)HospitalConfigConstant.HOS_LAT, (double)HospitalConfigConstant.HOS_LNG);
        this.getIsDistributionAndAddrPrice(distance, queryUserAddressDto);
        return queryUserAddressDto;
    }

    public String deleteUserAddress(Long addrId) {
        this.userAddressMapper.delete((Wrapper)new QueryWrapper().eq((Object)"id", (Object)addrId));
        return "\u5730\u5740\u5220\u9664\u6210\u529f";
    }

    @Transactional(rollbackFor={Exception.class})
    public String updateUserAddressIsDefault(Long addrId, Long userId, Integer isDefault) {
        UserAddress address;
        int noDefault = 0;
        if (Integer.valueOf(1).equals(isDefault) && Objects.nonNull(address = (UserAddress)this.userAddressMapper.selectOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)IS_DEFAULT, (Object)1)).eq((Object)USER_ID, (Object)userId)))) {
            UserAddress userAddress = new UserAddress();
            userAddress.setId(address.getId());
            userAddress.setIsDefault(Integer.valueOf(noDefault));
            this.userAddressMapper.updateById((Object)userAddress);
        }
        UserAddress userAddress = new UserAddress();
        userAddress.setId(Integer.valueOf(addrId.intValue()));
        userAddress.setIsDefault(isDefault);
        this.userAddressMapper.updateById((Object)userAddress);
        return "\u5730\u5740\u4fee\u6539\u6210\u529f";
    }

    public String updateUserAddress(UpdateUserAddressVo updateUserAddressVo) {
        UserAddress address;
        int noDefault = 0;
        if (Integer.valueOf(1).equals(updateUserAddressVo.getIsDefault()) && Objects.nonNull(address = (UserAddress)this.userAddressMapper.selectOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)IS_DEFAULT, (Object)1)).eq((Object)USER_ID, (Object)updateUserAddressVo.getUserId())))) {
            UserAddress userAddress = new UserAddress();
            userAddress.setId(address.getId());
            userAddress.setIsDefault(Integer.valueOf(noDefault));
            this.userAddressMapper.updateById((Object)userAddress);
        }
        UserAddress userAddress = new UserAddress();
        BeanUtils.copyProperties((Object)updateUserAddressVo, (Object)userAddress);
        userAddress.setId(Integer.valueOf(updateUserAddressVo.getAddressId().intValue()));
        this.userAddressMapper.updateById((Object)userAddress);
        return "\u5730\u5740\u4fee\u6539\u6210\u529f";
    }

    public DistanceDto getDistancePrice(double lat, double log) {
        DistanceDto distanceDto = new DistanceDto();
        double distance = DistanceUtil.distance((double)lat, (double)log, (double)HospitalConfigConstant.HOS_LAT, (double)HospitalConfigConstant.HOS_LNG);
        BigDecimal addrPrice = new BigDecimal("0");
        if (distance != 0.0) {
            Object[] objects = CartItemServiceImpl.getDisTypeAndPrice((double)distance);
            distanceDto.setStatus(Integer.valueOf(String.valueOf(objects[0])));
            BigDecimal priceStr = new BigDecimal(String.valueOf(objects[1]));
            BigDecimal distancePrice = priceStr.setScale(2, 4);
            distanceDto.setDistancePrice(distancePrice);
        }
        return distanceDto;
    }

    private void getIsDistributionAndAddrPrice(double distance, QueryUserAddressDto queryUserAddressDto) {
        Object[] objects = CartItemServiceImpl.getDisTypeAndPrice((double)distance);
        queryUserAddressDto.setIsDistribution(Integer.valueOf(String.valueOf(objects[0])));
        BigDecimal priceStr = new BigDecimal(String.valueOf(objects[1]));
        BigDecimal distancePrice = priceStr.setScale(2, 4);
        queryUserAddressDto.setAddrPrice(distancePrice);
    }
}

