/*
 * Decompiled with CFR 0.152.
 */
package com.byh.nursingcarenewserver.utils;

import com.byh.nursingcarenewserver.utils.DateUtils;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;

public class RabbitUtils {
    private static final Logger log = LoggerFactory.getLogger(RabbitUtils.class);
    public static final int ONE_THOUSAND = 1000;
    public static final int plusDay = 14;
    public static final String notifyTime = " 10:00:00";

    public static int getTargetTime() {
        try {
            String today = DateUtils.getDate((Date)new Date());
            log.info("\u5f53\u524d\u65e5\u671f\u5e74\u6708\u65e5{}", (Object)today);
            String todayJoin = StringUtils.join((Object[])new String[]{today, notifyTime});
            log.info("\u5f53\u524d\u65e5\u671f\u4e0a\u5348\u5341\u70b9{}", (Object)todayJoin);
            String plusDay = DateUtils.plusDay((int)14, (String)todayJoin);
            log.info("\u5f53\u524d\u65e5\u671f15\u5929\u540e\u7684\u4e0a\u5348\u5341\u70b9{}", (Object)plusDay);
            int currentTime = DateUtils.currentTimeStamp();
            int msgTime = DateUtils.dateToTimeStamp((String)plusDay, (String)"yyyy-MM-dd HH:mm:ss");
            return msgTime - currentTime;
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u76ee\u6807\u65e5\u671f\u5f02\u5e38", (Throwable)e);
            return 0;
        }
    }

    public static void returnVisitNotify(RabbitTemplate rabbitTemplate, String info, Integer orderExpireTime) {
        log.info("\u5df2\u5b8c\u6210\u8ba2\u535515\u5929\u540e\u590d\u8d2d\u63d0\u9192\uff0ckey\u4e3a\uff1a{}", (Object)info);
        rabbitTemplate.convertAndSend("default_exchange_hlzh_not_doctor", "return.visit.notify.queue.routing_key", (Object)info, message -> {
            message.getMessageProperties().setHeader("x-delay", (Object)(orderExpireTime * 1000));
            log.info("send message to rabbitmq: " + info);
            return message;
        });
    }

    public static void doctorNotService(RabbitTemplate rabbitTemplate, String info, Integer orderExpireTime) {
        log.info("\u62a4\u58eb\u63a5\u5355\u8d85\u8fc712\u5c0f\u65f6\u672a\u670d\u52a1\uff0ckey\u4e3a\uff1a{}", (Object)info);
        rabbitTemplate.convertAndSend("default_exchange_hlzh_not_doctor", "doctor.not.service.queue.routing_key", (Object)info, message -> {
            message.getMessageProperties().setHeader("x-delay", (Object)(orderExpireTime * 1000));
            log.info("send message to rabbitmq: " + info);
            return message;
        });
    }

    public static void doctorNotOperation(RabbitTemplate rabbitTemplate, String info, Integer orderExpireTime) {
        log.info("1\u4e2a\u5c0f\u65f6\u672a\u505a\u51fa\u53cd\u5e94\u7684\u62a4\u58eb\u8fdb\u884c\u63a8\u9001\uff0ckey\u4e3a\uff1a{}", (Object)info);
        rabbitTemplate.convertAndSend("default_exchange_hlzh_not_doctor", "doctor.not.operation.queue.routing_key", (Object)info, message -> {
            message.getMessageProperties().setHeader("x-delay", (Object)(orderExpireTime * 1000));
            log.info("send message to rabbitmq: " + info);
            return message;
        });
    }

    public static void doctorNotBack(RabbitTemplate rabbitTemplate, String info, Integer appointExpireTime) {
        log.info("==\u9884\u63a8\u9001\u6d88\u606f==\u7ed9\u8d85\u51fa\u9884\u7ea6\u65f6\u95f4\u6bb51\u5c0f\u65f6\u672a\u8fd4\u56de\u7684\u62a4\u58eb\uff0ckey\u4e3a\uff1a{}", (Object)info);
        rabbitTemplate.convertAndSend("unback_exchange_hlzh_unback", "doctor.not.back.queue.routing_key", (Object)info, message -> {
            message.getMessageProperties().setHeader("x-delay", (Object)(appointExpireTime * 1000));
            log.info("send message to rabbitmq: " + info);
            return message;
        });
    }
}

